/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileHover;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmMacroOccurrencesUpdater
implements ISelectionChangedListener {
    private static final String ANNOTATION_TYPE = "org.eclipse.linuxtools.rpm.ui.editor.highlightannotation";
    private final SpecfileEditor fEditor;
    private final List<Annotation> fOldAnnotations = new LinkedList<Annotation>();

    public RpmMacroOccurrencesUpdater(SpecfileEditor specfileEditor) {
        ((IPostSelectionProvider)specfileEditor.getSelectionProvider()).addPostSelectionChangedListener((ISelectionChangedListener)this);
        this.fEditor = specfileEditor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update((ISourceViewer)event.getSource());
    }

    public void update(ISourceViewer viewer) {
        try {
            IDocument document = viewer.getDocument();
            IAnnotationModel model = viewer.getAnnotationModel();
            if (document == null || model == null) {
                return;
            }
            this.removeOldAnnotations(model);
            String currentSelectedWord = this.getWordAtSelection(this.fEditor.getSelectionProvider().getSelection(), document);
            if (this.isMacro(currentSelectedWord)) {
                Specfile spec = this.fEditor.getSpecfile();
                SpecfileDefine define = spec.getDefine(currentSelectedWord);
                String word = String.valueOf(currentSelectedWord) + ": ";
                if (define != null) {
                    word = String.valueOf(word) + define.getStringValue();
                } else {
                    String retrivedValue = SpecfileHover.getSourceOrPatchValue(spec, currentSelectedWord.toLowerCase());
                    if (retrivedValue != null) {
                        word = String.valueOf(word) + retrivedValue;
                    } else {
                        retrivedValue = SpecfileHover.getMacroValueFromMacroList(currentSelectedWord);
                        if (retrivedValue != null) {
                            word = String.valueOf(word) + retrivedValue;
                        }
                    }
                }
                this.createNewAnnotations(currentSelectedWord, word, document, model);
            }
        }
        catch (BadLocationException e) {
            SpecfileLog.logError(e);
        }
    }

    private void removeOldAnnotations(IAnnotationModel model) {
        for (Annotation annotation : this.fOldAnnotations) {
            model.removeAnnotation(annotation);
        }
        this.fOldAnnotations.clear();
    }

    private boolean isMacro(String word) {
        List<SpecfileDefine> defines = this.getMacros();
        if (word.length() > 0) {
            for (SpecfileDefine define : defines) {
                if (!this.containsWord(define, word)) continue;
                return true;
            }
            if (Activator.getDefault().getRpmMacroList().getProposals("%" + word).size() > 0) {
                return true;
            }
        }
        return false;
    }

    private List<SpecfileDefine> getMacros() {
        List<SpecfileDefine> macros;
        Specfile specfile = this.fEditor.getSpecfile();
        if (specfile != null && (macros = specfile.getDefines()) != null) {
            return macros;
        }
        return new ArrayList<SpecfileDefine>();
    }

    private boolean containsWord(SpecfileDefine macro, String current) {
        return macro.getName().equalsIgnoreCase(current);
    }

    /*
     * Unable to fully structure code
     */
    private String getWordAtSelection(ISelection selection, IDocument document) throws BadLocationException {
        block3: {
            block2: {
                if (!(selection instanceof ITextSelection)) break block2;
                ts = (ITextSelection)selection;
                offset = ts.getOffset();
                end = offset + ts.getLength();
                if (end == offset) ** GOTO lbl9
                word = ts.getText();
                break block3;
lbl-1000:
                // 1 sources

                {
                    --offset;
lbl9:
                    // 2 sources

                    ** while (offset > 0 && this.isDefineChar((char)document.getChar((int)(offset - 1))))
                }
lbl10:
                // 2 sources

                while (end < document.getLength() && this.isDefineChar(document.getChar(end))) {
                    ++end;
                }
                word = document.get(offset, end - offset);
                break block3;
            }
            word = "";
        }
        return word.toLowerCase();
    }

    private boolean isDefineChar(char c) {
        return c != '{' && c != '}' && c != '?' && !Character.isWhitespace(c);
    }

    private void createNewAnnotations(String macro, String hoverContent, IDocument document, IAnnotationModel model) {
        String content = document.get().toLowerCase();
        int idx = content.indexOf(macro.toLowerCase());
        while (idx != -1) {
            Annotation annotation = new Annotation(ANNOTATION_TYPE, false, hoverContent);
            Position position = new Position(idx, macro.length());
            model.addAnnotation(annotation, position);
            this.fOldAnnotations.add(annotation);
            idx = content.indexOf(macro, idx + 1);
        }
    }

    public void dispose() {
        ((IPostSelectionProvider)this.fEditor.getSelectionProvider()).removePostSelectionChangedListener((ISelectionChangedListener)this);
    }
}

