/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageBuildProposalsJob;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.core.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmPackageProposalsList {
    private HashSet<String> list = new HashSet();

    public RpmPackageProposalsList() {
        this.setPackagesList();
    }

    private void setPackagesList() {
        block15: {
            String rpmpkgsFile = Activator.getDefault().getPreferenceStore().getString("rpmListFilePath");
            BufferedReader reader = null;
            try {
                try {
                    if (Utils.fileExist((String)rpmpkgsFile)) {
                        reader = new BufferedReader(new InputStreamReader(new FileInputStream(rpmpkgsFile)));
                        String line = reader.readLine();
                        while (line != null) {
                            this.list.add(line.trim());
                            line = reader.readLine();
                        }
                    } else {
                        RpmPackageBuildProposalsJob.update();
                    }
                }
                catch (IOException e) {
                    RpmPackageBuildProposalsJob.update();
                    SpecfileLog.logError(e);
                    if (reader == null) break block15;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public List<String[]> getProposals(String prefix) {
        this.waitForUpdates();
        int rpmpkgsMaxProposals = Activator.getDefault().getPreferenceStore().getInt("rpmListMaxProposalsInfo");
        ArrayList<String[]> proposalsList = new ArrayList<String[]>(this.list.size());
        for (String listValue : this.list) {
            String message = String.valueOf(Messages.RpmPackageProposalsList_0) + rpmpkgsMaxProposals + Messages.RpmPackageProposalsList_1;
            String[] item = new String[]{listValue, message};
            if (!item[0].startsWith(prefix)) continue;
            proposalsList.add(item);
        }
        if (proposalsList.size() < rpmpkgsMaxProposals) {
            ArrayList<String[]> proposalsListWithInfo = new ArrayList<String[]>(proposalsList.size());
            for (String[] proposals : proposalsList) {
                proposals[1] = this.getRpmInfo(proposals[0]);
                proposalsListWithInfo.add(proposals);
            }
            return proposalsListWithInfo;
        }
        return proposalsList;
    }

    public String getValue(String key) {
        for (String item : this.list) {
            if (!item.equals(key.trim())) continue;
            return this.getRpmInfo(item);
        }
        return null;
    }

    public String getRpmInfo(String pkgName) {
        String ret = "";
        try {
            ret = Utils.runCommandToString((String[])new String[]{"rpm", "-q", pkgName, "--qf", this.getformattedRpmInformations()});
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
            return String.valueOf(Messages.RpmPackageProposalsList_2) + Messages.RpmPackageProposalsList_3;
        }
        CharsetDecoder decoder = Charset.forName(System.getProperty("file.encoding")).newDecoder();
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(ret));
            CharBuffer cbuf = decoder.decode(bbuf);
            ret = cbuf.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return ret;
    }

    private String getformattedRpmInformations() {
        StringBuilder formatedInfoString = new StringBuilder();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean("RpmInfoName")) {
            formatedInfoString.append("<b>Name: </b>%{NAME}<br>");
        }
        if (store.getBoolean("RpmInfoVersion")) {
            formatedInfoString.append("<b>Version: </b>%{VERSION}<br>");
        }
        if (store.getBoolean("RpmInfoRelease")) {
            formatedInfoString.append("<b>Release: </b>%{Release}<br>");
        }
        if (store.getBoolean("RpmInfoSummary")) {
            formatedInfoString.append("<b>Summary: </b>%{SUMMARY}<br>");
        }
        if (store.getBoolean("RpmInfoLicense")) {
            formatedInfoString.append("<b>License: </b>%{LICENSE}<br>");
        }
        if (store.getBoolean("RpmInfoName")) {
            formatedInfoString.append("<b>Group: </b>%{GROUP}<br>");
        }
        if (store.getBoolean("RpmInfoUrl")) {
            formatedInfoString.append("<b>URL: </b>%{URL}<br>");
        }
        if (store.getBoolean("RpmInfoInstallDate")) {
            formatedInfoString.append("<b>Installation Date: </b>%{INSTALLTIME:date}<br>");
        }
        if (store.getBoolean("RpmInfoDescription")) {
            formatedInfoString.append("<b>Description: </b>%{DESCRIPTION}<br>");
        }
        if (store.getBoolean("RpmInfoPackager")) {
            formatedInfoString.append("<b>Packager: </b>%{PACKAGER}<br>");
        }
        if (store.getBoolean("RpmInfoVendor")) {
            formatedInfoString.append("<b>Vendor: </b>%{VENDOR}<br>");
        }
        if (store.getBoolean("RpmInfoSize")) {
            formatedInfoString.append("<b>Size: </b>%{SIZE} bytes<br>");
        }
        if (store.getBoolean("RpmInfoBuildDate")) {
            formatedInfoString.append("<b>Build Date: </b>%{BUILDTIME:date}<br>");
        }
        if (store.getBoolean("RpmInfoSourceRpm")) {
            formatedInfoString.append("<b>SRPM: </b>%{SOURCERPM}<br>");
        }
        return formatedInfoString.toString();
    }

    private void waitForUpdates() {
        RpmPackageBuildProposalsJob.waitForUpdates();
    }
}

