/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmMacroProposalsList;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class SpecfileHover
implements ITextHover,
ITextHoverExtension {
    private static final String EMPTY_STRING = "";
    private SpecfileEditor editor;

    public SpecfileHover(SpecfileEditor editor) {
        this.editor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String currentSelection;
        if (hoverRegion == null || hoverRegion.getLength() == 0) {
            return null;
        }
        Specfile spec = this.editor.getSpecfile();
        if (spec == null) {
            return null;
        }
        try {
            currentSelection = textViewer.getDocument().get(hoverRegion.getOffset() + 1, hoverRegion.getLength() - 1);
        }
        catch (BadLocationException e) {
            return null;
        }
        SpecfileDefine define = spec.getDefine(currentSelection);
        String value = String.valueOf(currentSelection) + ": ";
        if (define != null) {
            value = String.valueOf(value) + define.getStringValue();
            return value;
        }
        String macroLower = currentSelection.toLowerCase();
        String retrivedValue = SpecfileHover.getSourceOrPatchValue(spec, macroLower);
        if (retrivedValue != null) {
            value = String.valueOf(value) + retrivedValue;
            return value;
        }
        retrivedValue = SpecfileHover.getMacroValueFromMacroList(currentSelection);
        if (retrivedValue != null) {
            value = String.valueOf(value) + retrivedValue;
            return value;
        }
        retrivedValue = Activator.getDefault().getRpmPackageList().getValue(currentSelection.replaceFirst(":", EMPTY_STRING));
        if (retrivedValue != null) {
            return retrivedValue;
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            Point selectedRange = textViewer.getSelectedRange();
            if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
                return new Region(selectedRange.x, selectedRange.y);
            }
            IRegion region = SpecfileHover.findWord(textViewer.getDocument(), offset);
            if (region.equals(new Region(offset, 0))) {
                region = SpecfileHover.findPackages(textViewer.getDocument(), offset);
            }
            return region;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        boolean beginsWithBrace = false;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c == '%') {
                    if (document.getChar(pos + 1) != '{') break;
                    beginsWithBrace = true;
                    break;
                }
                if (c == '\n' || c == '}') {
                    return new Region(offset, 0);
                }
                --pos;
            }
            if (!beginsWithBrace) {
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (beginsWithBrace && c == '}' || c == '\n' || c == '%' || c == '(' || !beginsWithBrace && c == ' ') break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static IRegion findPackages(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        boolean beginsWithSpace = false;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c == ' ' || c == '\t' || c == ':') {
                    if (Character.isLetter(document.getChar(pos + 1))) {
                        beginsWithSpace = true;
                        break;
                    }
                    if (c == '\n') {
                        return new Region(offset, 0);
                    }
                }
                --pos;
            }
            start = --pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (beginsWithSpace && !Character.isLetter(c) && !Character.isDigit(c) && c != '-') break;
                if (c == '\n') {
                    return new Region(offset, 0);
                }
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start > -1 && end > -1) {
            return new Region(start, end - start);
        }
        return null;
    }

    public static String getSourceOrPatchValue(Specfile spec, String patchOrSourceName) {
        String value = null;
        Pattern p = Pattern.compile("(source|patch)(\\d*)");
        Matcher m = p.matcher(patchOrSourceName);
        if (m.matches()) {
            String digits = m.group(2);
            SpecfileSource source = null;
            int number = -1;
            if (digits != null && digits.equals(EMPTY_STRING)) {
                number = 0;
            } else if (digits != null && !digits.equals(EMPTY_STRING)) {
                number = Integer.parseInt(digits);
            }
            if (number != -1) {
                if (m.group(1).equals("source")) {
                    source = spec.getSource(number);
                } else if (m.group(1).equals("patch")) {
                    source = spec.getPatch(number);
                }
                if (source != null) {
                    value = source.getFileName();
                }
            }
        }
        return value;
    }

    public static String getMacroValueFromMacroList(String macroName) {
        String value = null;
        if (Activator.getDefault().getRpmMacroList().findKey("%" + macroName)) {
            String currentConfig = Activator.getDefault().getPreferenceStore().getString("macroHoverViewContent");
            value = currentConfig.equals("macroHoverViewDescription") ? Activator.getDefault().getRpmMacroList().getValue(macroName) : RpmMacroProposalsList.getMacroEval("%" + macroName);
        }
        return value;
    }
}

