/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureRootNode;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.compare.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfilePartitionScanner;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;
import org.eclipse.swt.graphics.Image;

public class SpecStructureCreator
extends StructureCreator {
    public String getName() {
        return Messages.SpecStructureCreator_0;
    }

    public IStructureComparator locate(Object path, Object input) {
        return null;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return SpecStructureCreator.readString(sca);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private void parseSpecfile(DocumentRangeNode root, IDocument doc, IProgressMonitor monitor) {
        try {
            SpecfileParser parser = new SpecfileParser();
            Specfile specfile = parser.parse(doc);
            String id = specfile.getName();
            SpecNode parent = new SpecNode(root, 0, id, doc, 0, doc.getLength());
            monitor = this.beginWork(monitor);
            for (SpecfileSection sec : specfile.getSections()) {
                try {
                    this.addNode(parent, doc, sec.getName(), doc.getLineOffset(sec.getLineNumber()), doc.getLineOffset(sec.getSectionEndLine()) - doc.getLineOffset(sec.getLineNumber()));
                }
                catch (BadLocationException e) {
                    SpecfileLog.logError(e);
                }
            }
            SpecfilePackage[] specfilePackageArray = specfile.getPackages().getPackages();
            int n = specfilePackageArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpecfilePackage sPackage = specfilePackageArray[n2];
                try {
                    SpecNode pNode = this.addNode(parent, doc, sPackage.getPackageName(), doc.getLineOffset(sPackage.getLineNumber()), doc.getLineOffset(sPackage.getSectionEndLine()) - doc.getLineOffset(sPackage.getLineNumber()));
                    SpecfileSection[] specfileSectionArray = sPackage.getSections();
                    int n3 = specfileSectionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SpecfileSection section = specfileSectionArray[n4];
                        this.addNode(pNode, doc, section.getName(), doc.getLineOffset(section.getLineNumber()), doc.getLineOffset(section.getSectionEndLine()) - doc.getLineOffset(section.getLineNumber()));
                        ++n4;
                    }
                }
                catch (BadLocationException e) {
                    SpecfileLog.logError(e);
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProgressMonitor beginWork(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return new SubProgressMonitor(monitor, -1);
    }

    private SpecNode addNode(DocumentRangeNode root, IDocument doc, String name, int start, int end) {
        return new SpecNode(root, 1, name, doc, start, end);
    }

    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return SpecStructureCreator.readString(is, encoding);
        }
        return null;
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new SpecfilePartitionScanner(), SpecfilePartitionScanner.SPEC_PARTITION_TYPES);
    }

    protected String getDocumentPartitioning() {
        return "___spec_partitioning";
    }

    protected IStructureComparator createStructureComparator(Object input, IDocument document, ISharedDocumentAdapter adapter, IProgressMonitor monitor) throws CoreException {
        final boolean isEditable = input instanceof IEditableContent ? ((IEditableContent)input).isEditable() : false;
        StructureRootNode rootNode = new StructureRootNode(document, input, this, adapter){

            public boolean isEditable() {
                return isEditable;
            }
        };
        this.parseSpecfile((DocumentRangeNode)rootNode, document, monitor);
        return rootNode;
    }

    static class SpecNode
    extends DocumentRangeNode
    implements ITypedElement {
        public SpecNode(DocumentRangeNode parent, int type, String id, IDocument doc, int start, int length) {
            super(parent, type, id, doc, start, length);
            if (parent != null) {
                parent.addChild((DocumentRangeNode)this);
            }
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "spec";
        }

        public Image getImage() {
            return CompareUI.getImage((String)this.getType());
        }
    }
}

