/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.Messages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SourcesFileCreateHyperlink
implements IHyperlink {
    String fileName;
    IFile original;
    IRegion region;

    public SourcesFileCreateHyperlink(IFile original, String fileName, IRegion region) {
        this.fileName = fileName;
        this.original = original;
        this.region = region;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return String.valueOf(Messages.SourcesFileHyperlink_2) + ' ' + this.fileName;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IContainer container = this.original.getParent();
        IResource resourceToOpen = container.findMember(this.fileName);
        ByteArrayInputStream source = new ByteArrayInputStream("".getBytes());
        IFile file = null;
        if (resourceToOpen == null) {
            IResource sourcesFolder = container.getProject().findMember("SOURCES");
            file = container.getFile((IPath)new Path(this.fileName));
            if (sourcesFolder != null) {
                file = ((IFolder)sourcesFolder).getFile((IPath)new Path(this.fileName));
            }
            if (!file.exists()) {
                try {
                    file.create((InputStream)source, 0, null);
                }
                catch (CoreException e) {
                    SpecfileLog.logError(e);
                }
            }
            resourceToOpen = file;
        }
        if (resourceToOpen != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                if (resourceToOpen.getType() == 1) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resourceToOpen));
                }
            }
            catch (PartInitException e) {
                SpecfileLog.logError(e);
            }
        }
    }
}

