/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileCreateHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileDownloadHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileHyperlink;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.ui.part.FileEditorInput;

public class SourcesFileHyperlinkDetector
extends AbstractHyperlinkDetector {
    SpecfileEditor editor;
    private static final String PATCH_IDENTIFIER = "Patch";
    private static final String SOURCE_IDENTIFIER = "Source";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        boolean patchExists = false;
        if (region == null || textViewer == null) {
            return null;
        }
        if (this.editor == null) {
            this.editor = (SpecfileEditor)((Object)this.getAdapter(SpecfileEditor.class));
            if (this.editor == null) {
                return null;
            }
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        if (this.editor.getEditorInput() instanceof FileEditorInput) {
            IFile original = ((FileEditorInput)this.editor.getEditorInput()).getFile();
            if (line.startsWith(SOURCE_IDENTIFIER) || line.startsWith(PATCH_IDENTIFIER)) {
                int delimiterIndex = line.indexOf(58) + 1;
                String fileName = line.substring(delimiterIndex).trim();
                patchExists = this.patchExists(original, fileName);
                if (region.getOffset() > lineInfo.getOffset() + line.indexOf(fileName)) {
                    Region fileNameRegion = new Region(lineInfo.getOffset() + line.indexOf(fileName), fileName.length());
                    if (line.startsWith(PATCH_IDENTIFIER) && !patchExists) {
                        return new IHyperlink[]{new SourcesFileCreateHyperlink(original, UiUtils.resolveDefines(this.editor.getSpecfile(), fileName), (IRegion)fileNameRegion)};
                    }
                    return new IHyperlink[]{new SourcesFileHyperlink(original, UiUtils.resolveDefines(this.editor.getSpecfile(), fileName), (IRegion)fileNameRegion), new SourcesFileDownloadHyperlink(original, UiUtils.resolveDefines(this.editor.getSpecfile(), fileName), (IRegion)fileNameRegion)};
                }
            }
        }
        return null;
    }

    public void setEditor(SpecfileEditor editor) {
        this.editor = editor;
    }

    private boolean patchExists(IFile original, String patchName) {
        boolean rc = true;
        IContainer container = original.getParent();
        IResource resourceToOpen = container.findMember(patchName);
        IFile file = null;
        if (resourceToOpen == null) {
            IResource sourcesFolder = container.getProject().findMember("SOURCES");
            file = container.getFile((IPath)new Path(patchName));
            if (sourcesFolder != null) {
                file = ((IFolder)sourcesFolder).getFile((IPath)new Path(patchName));
            }
            if (!file.exists()) {
                rc = false;
            }
        }
        return rc;
    }
}

