/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view.annotatedsource;

import java.util.ArrayList;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.ISTAnnotationColumn;
import org.eclipse.linuxtools.internal.gcov.parser.Line;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.Messages;
import org.eclipse.osgi.util.NLS;

public class CoverageAnnotationColumn
implements ISTAnnotationColumn {
    private final ArrayList<Line> lines;

    public CoverageAnnotationColumn(SourceFile sourceFile) {
        this.lines = sourceFile.getLines();
    }

    public String getAnnotation(int index) {
        try {
            Line l = this.lines.get(index + 1);
            if (l.exists()) {
                return Long.toString(l.getCount());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return "";
    }

    public String getTooltip(int index) {
        try {
            Line l = this.lines.get(index + 1);
            if (!l.exists()) {
                return Messages.CoverageAnnotationColumn_non_exec_line;
            }
            long count = l.getCount();
            if (count == 0L) {
                return Messages.CoverageAnnotationColumn_line_never_exec;
            }
            if (count == 1L) {
                return Messages.CoverageAnnotationColumn_line_exec_once;
            }
            return NLS.bind((String)Messages.CoverageAnnotationColumn_line_mulitiple_exec, (Object)Long.toString(count));
        }
        catch (IndexOutOfBoundsException _) {
            return Messages.CoverageAnnotationColumn_non_exec_line;
        }
    }
}

