/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.ICreateSessionDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionGroup;
import org.eclipse.ui.IWorkbenchPage;

public class CreateSessionHandler
extends BaseControlViewHandler {
    private TraceSessionGroup fSessionGroup = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fLock.lock();
        try {
            final TraceSessionGroup sessionGroup = this.fSessionGroup;
            final ICreateSessionDialog dialog = TraceControlDialogFactory.getInstance().getCreateSessionDialog();
            dialog.initialize(sessionGroup);
            if (dialog.open() != 0) {
                return null;
            }
            Job job = new Job(Messages.TraceControl_CreateSessionJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (dialog.isStreamedTrace()) {
                            sessionGroup.createSession(dialog.getSessionName(), dialog.getNetworkUrl(), dialog.getControlUrl(), dialog.getDataUrl(), monitor);
                        } else {
                            String sessionPath = dialog.isDefaultSessionPath() ? null : dialog.getSessionPath();
                            sessionGroup.createSession(dialog.getSessionName(), sessionPath, monitor);
                        }
                    }
                    catch (ExecutionException e) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_CreateSessionFailure, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceSessionGroup sessionGroup = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            sessionGroup = element instanceof TraceSessionGroup ? (TraceSessionGroup)element : null;
        }
        boolean isEnabled = sessionGroup != null;
        this.fLock.lock();
        try {
            this.fSessionGroup = null;
            if (isEnabled) {
                this.fSessionGroup = sessionGroup;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

