/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl;

import org.eclipse.linuxtools.internal.lttng2.core.control.model.IBaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IUstProviderInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.UstProviderInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.BaseEventComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.property.UstProviderPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class UstProviderComponent
extends TraceControlComponent {
    public static final String USTL_PROVIDER_ICON_FILE = "icons/obj16/targets.gif";
    private IUstProviderInfo fProviderInfo = null;

    public UstProviderComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(USTL_PROVIDER_ICON_FILE);
        this.setToolTip(Messages.TraceControl_ProviderDisplayName);
        this.fProviderInfo = new UstProviderInfo(name);
    }

    public void setUstProvider(IUstProviderInfo providerInfo) {
        this.fProviderInfo = providerInfo;
        IBaseEventInfo[] events = providerInfo.getEvents();
        int i = 0;
        while (i < events.length) {
            BaseEventComponent component = new BaseEventComponent(events[i].getName(), this);
            component.setEventInfo(events[i]);
            this.addChild(component);
            ++i;
        }
        this.setName(String.valueOf(this.getName()) + " [PID=" + this.fProviderInfo.getPid() + "]");
    }

    public int getPid() {
        return this.fProviderInfo.getPid();
    }

    public void setPid(int pid) {
        this.fProviderInfo.setPid(pid);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new UstProviderPropertySource(this);
        }
        return null;
    }
}

