/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataListRegisterNamesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataListRegisterValuesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIRegisterValue;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIRegisters
extends AbstractDsfService
implements IRegisters,
ICachingService {
    private static final String BLANK_STRING = "";
    private CommandFactory fCommandFactory;
    private MIRegisterGroupDMC fGeneralRegistersGroupDMC;
    private CommandCache fRegisterNameCache;
    private CommandCache fRegisterValueCache;

    public MIRegisters(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                MIRegisters.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)commandControl, this.getExecutor(), 2);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fRegisterValueCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fRegisterValueCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fRegisterNameCache = new CommandCache(this.getSession(), (ICommandControl)commandControl);
        this.fRegisterNameCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IRegisters.class.getName(), MIRegisters.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    public boolean isValid() {
        return true;
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        if (dmc.getParents().length == 1 && dmc.getParents()[0] instanceof MIRegisterDMC) {
            this.getRegisterDataValue((MIRegisterDMC)dmc.getParents()[0], dmc.getFormatID(), rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void getRegisterGroupData(IRegisters.IRegisterGroupDMContext regGroupDmc, DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
        class RegisterGroupData
        implements IRegisters.IRegisterGroupDMData {
            RegisterGroupData() {
            }

            public String getName() {
                return "General Registers";
            }

            public String getDescription() {
                return "General Purpose and FPU Register Group";
            }
        }
        rm.setData((Object)new RegisterGroupData());
        rm.done();
    }

    public void getBitFieldData(IRegisters.IBitFieldDMContext dmc, DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Bit fields not yet supported", null));
        rm.done();
    }

    public void getRegisterData(IRegisters.IRegisterDMContext regDmc, final DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
        if (regDmc instanceof MIRegisterDMC) {
            final MIRegisterDMC miRegDmc = (MIRegisterDMC)regDmc;
            IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)regDmc, IMIExecutionDMContext.class);
            if (execDmc == null) {
                rm.setData((Object)new RegisterData(miRegDmc.getName(), BLANK_STRING, false));
                rm.done();
                return;
            }
            int[] regnos = new int[]{miRegDmc.getRegNo()};
            this.fRegisterValueCache.execute(this.fCommandFactory.createMIDataListRegisterValues(execDmc, 0, regnos), (DataRequestMonitor)new DataRequestMonitor<MIDataListRegisterValuesInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIRegisterValue[] regValue = ((MIDataListRegisterValuesInfo)this.getData()).getMIRegisterValues();
                    if (regValue.length == 0) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Backend protocol error");
                        }
                        rm.done();
                        return;
                    }
                    if (!$assertionsDisabled && regValue.length != 1) {
                        throw new AssertionError();
                    }
                    MIRegisterValue reg = regValue[0];
                    boolean isFloat = false;
                    if (reg.getValue().contains("float")) {
                        isFloat = true;
                    }
                    rm.setData((Object)new RegisterData(miRegDmc.getName(), MIRegisters.BLANK_STRING, isFloat));
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown DMC type", null));
            rm.done();
        }
    }

    private void getRegisterDataValue(MIRegisterDMC regDmc, String formatId, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        IMIExecutionDMContext miExecDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)regDmc, IMIExecutionDMContext.class);
        if (miExecDmc == null) {
            rm.setData((Object)new IFormattedValues.FormattedValueDMData(BLANK_STRING));
            rm.done();
            return;
        }
        int NumberFormat = 0;
        if ("HEX.Format".equals(formatId)) {
            NumberFormat = 0;
        }
        if ("OCTAL.Format".equals(formatId)) {
            NumberFormat = 1;
        }
        if ("NATURAL.Format".equals(formatId)) {
            NumberFormat = 5;
        }
        if ("BINARY.Format".equals(formatId)) {
            NumberFormat = 2;
        }
        if ("DECIMAL.Format".equals(formatId)) {
            NumberFormat = 3;
        }
        int[] regnos = new int[]{regDmc.getRegNo()};
        this.fRegisterValueCache.execute(this.fCommandFactory.createMIDataListRegisterValues(miExecDmc, NumberFormat, regnos), (DataRequestMonitor)new DataRequestMonitor<MIDataListRegisterValuesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIRegisterValue[] regValue = ((MIDataListRegisterValuesInfo)this.getData()).getMIRegisterValues();
                if (regValue.length == 0) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Backend protocol error");
                    }
                    rm.done();
                    return;
                }
                MIRegisterValue reg = regValue[0];
                rm.setData((Object)new IFormattedValues.FormattedValueDMData(reg.getValue()));
                rm.done();
            }
        });
    }

    private MIRegisterDMC[] makeRegisterDMCs(MIRegisterGroupDMC groupDmc, String[] regNames) {
        return this.makeRegisterDMCs(groupDmc, null, regNames);
    }

    private MIRegisterDMC[] makeRegisterDMCs(MIRegisterGroupDMC groupDmc, IMIExecutionDMContext execDmc, String[] regNames) {
        ArrayList<MIRegisterDMC> regDmcList = new ArrayList<MIRegisterDMC>(regNames.length);
        int regNo = 0;
        String[] stringArray = regNames;
        int n = regNames.length;
        int n2 = 0;
        while (n2 < n) {
            String regName = stringArray[n2];
            if (regName != null && regName.length() > 0) {
                if (execDmc != null) {
                    regDmcList.add(new MIRegisterDMC(this, groupDmc, execDmc, regNo, regName));
                } else {
                    regDmcList.add(new MIRegisterDMC(this, groupDmc, regNo, regName));
                }
            }
            ++regNo;
            ++n2;
        }
        return regDmcList.toArray(new MIRegisterDMC[regDmcList.size()]);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fRegisterValueCache.setContextAvailable(e.getDMContext(), false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fRegisterValueCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fRegisterValueCache.setContextAvailable(e.getDMContext(), true);
        this.fRegisterValueCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRegisters.IRegisterChangedDMEvent e) {
        this.fRegisterValueCache.reset();
    }

    private void generateRegisterChangedEvent(IRegisters.IRegisterDMContext dmc) {
        this.getSession().dispatchEvent((Object)new RegisterChangedDMEvent(dmc), this.getProperties());
        final IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterGroupDMContext.class);
        if (groupDmc != null) {
            IRegisters.IRegistersChangedDMEvent event = new IRegisters.IRegistersChangedDMEvent(){

                public IRegisters.IRegisterGroupDMContext getDMContext() {
                    return groupDmc;
                }
            };
            this.getSession().dispatchEvent((Object)event, this.getProperties());
        }
    }

    public void getRegisterGroups(IDMContext ctx, DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> rm) {
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IRunControl.IContainerDMContext.class);
        if (contDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Container context not found", null));
            rm.done();
            return;
        }
        if (this.fGeneralRegistersGroupDMC == null) {
            this.fGeneralRegistersGroupDMC = new MIRegisterGroupDMC(this, contDmc, 0, "General Registers");
        }
        MIRegisterGroupDMC[] groupDMCs = new MIRegisterGroupDMC[]{this.fGeneralRegistersGroupDMC};
        rm.setData((Object)groupDMCs);
        rm.done();
    }

    public void getRegisters(IDMContext dmc, final DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        final MIRegisterGroupDMC groupDmc = (MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)dmc, MIRegisterGroupDMC.class);
        if (groupDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "RegisterGroup context not found", null));
            rm.done();
            return;
        }
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
        if (containerDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Container context not found", null));
            rm.done();
            return;
        }
        if (groupDmc.getGroupNo() == 0) {
            final IMIExecutionDMContext executionDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIExecutionDMContext.class);
            this.fRegisterNameCache.execute(this.fCommandFactory.createMIDataListRegisterNames(containerDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataListRegisterNamesInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    String[] regNames = ((MIDataListRegisterNamesInfo)this.getData()).getRegisterNames();
                    if (regNames.length == 0) {
                        rm.done();
                        return;
                    }
                    if (executionDmc == null) {
                        rm.setData((Object)MIRegisters.this.makeRegisterDMCs(groupDmc, regNames));
                    } else {
                        rm.setData((Object)MIRegisters.this.makeRegisterDMCs(groupDmc, executionDmc, regNames));
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid group = " + (Object)((Object)groupDmc), null));
            rm.done();
        }
    }

    public void getBitFields(IDMContext regDmc, DataRequestMonitor<IRegisters.IBitFieldDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "BitField not supported", null));
        rm.done();
    }

    public void writeRegister(IRegisters.IRegisterDMContext regCtx, final String regValue, final String formatId, final RequestMonitor rm) {
        MIRegisterGroupDMC grpDmc = (MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)regCtx, MIRegisterGroupDMC.class);
        if (grpDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "RegisterGroup context not found", null));
            rm.done();
            return;
        }
        final MIRegisterDMC regDmc = (MIRegisterDMC)regCtx;
        if (grpDmc.getGroupNo() == 0) {
            final IExpressions exprService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            String regName = regDmc.getName();
            final IExpressions.IExpressionDMContext exprCtxt = exprService.createExpression((IDMContext)regCtx, "$" + regName);
            final IFormattedValues.FormattedValueDMContext valueDmc = exprService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprCtxt, formatId);
            exprService.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (!regValue.equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()) || !valueDmc.getFormatID().equals(formatId)) {
                        exprService.writeExpression(exprCtxt, regValue, formatId, (RequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIRegisters.this.getExecutor(), rm){

                            protected void handleSuccess() {
                                MIRegisters.this.generateRegisterChangedEvent(regDmc);
                                rm.done();
                            }
                        });
                    } else {
                        rm.done();
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Invalid group = " + (Object)((Object)grpDmc), null));
            rm.done();
        }
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, String bitFieldValue, String formatId, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Writing bit field not supported", null));
        rm.done();
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, IRegisters.IMnemonic mnemonic, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Writing bit field not supported", null));
        rm.done();
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"HEX.Format", "DECIMAL.Format", "OCTAL.Format", "BINARY.Format", "NATURAL.Format"});
        rm.done();
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        if (dmc instanceof MIRegisterDMC) {
            MIRegisterDMC regDmc = (MIRegisterDMC)dmc;
            return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)regDmc, formatId);
        }
        return null;
    }

    public void findRegisterGroup(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IRegisterGroupDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Finding a Register Group context not supported", null));
        rm.done();
    }

    public void findRegister(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IRegisterDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Finding a Register context not supported", null));
        rm.done();
    }

    public void findBitField(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IBitFieldDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Finding a Register Group context not supported", null));
        rm.done();
    }

    public void flushCache(IDMContext context) {
        this.fRegisterNameCache.reset(context);
        this.fRegisterValueCache.reset(context);
    }

    public static class MIRegisterDMC
    extends AbstractDMContext
    implements IRegisters.IRegisterDMContext {
        private int fRegNo;
        private String fRegName;

        public MIRegisterDMC(MIRegisters service, MIRegisterGroupDMC group, int regNo, String regName) {
            super(service.getSession().getId(), new IDMContext[]{group});
            this.fRegNo = regNo;
            this.fRegName = regName;
        }

        public MIRegisterDMC(MIRegisters service, MIRegisterGroupDMC group, IMIExecutionDMContext execDmc, int regNo, String regName) {
            super(service.getSession().getId(), new IDMContext[]{execDmc, group});
            this.fRegNo = regNo;
            this.fRegName = regName;
        }

        public int getRegNo() {
            return this.fRegNo;
        }

        public String getName() {
            return this.fRegName;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIRegisterDMC)((Object)other)).fRegNo == this.fRegNo && ((MIRegisterDMC)((Object)other)).fRegName.equals(this.fRegName);
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fRegNo;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".register[" + this.fRegNo + "]";
        }
    }

    public static class MIRegisterGroupDMC
    extends AbstractDMContext
    implements IRegisters.IRegisterGroupDMContext {
        private int fGroupNo;
        private String fGroupName;

        public MIRegisterGroupDMC(MIRegisters service, IRunControl.IContainerDMContext contDmc, int groupNo, String groupName) {
            super(service.getSession().getId(), new IDMContext[]{contDmc});
            this.fGroupNo = groupNo;
            this.fGroupName = groupName;
        }

        public int getGroupNo() {
            return this.fGroupNo;
        }

        public String getName() {
            return this.fGroupName;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIRegisterGroupDMC)((Object)other)).fGroupNo == this.fGroupNo && ((MIRegisterGroupDMC)((Object)other)).fGroupName.equals(this.fGroupName);
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fGroupNo;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".group[" + this.fGroupNo + "]";
        }
    }

    public static class RegisterChangedDMEvent
    implements IRegisters.IRegisterChangedDMEvent {
        private final IRegisters.IRegisterDMContext fRegisterDmc;

        RegisterChangedDMEvent(IRegisters.IRegisterDMContext registerDMC) {
            this.fRegisterDmc = registerDMC;
        }

        public IRegisters.IRegisterDMContext getDMContext() {
            return this.fRegisterDmc;
        }
    }

    static class RegisterData
    implements IRegisters.IRegisterDMData {
        private final String fRegName;
        private final String fRegDesc;
        private final boolean fIsFloat;

        public RegisterData(String regName, String regDesc, boolean isFloat) {
            this.fRegName = regName;
            this.fRegDesc = regDesc;
            this.fIsFloat = isFloat;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isReadOnce() {
            return false;
        }

        public boolean isWriteable() {
            return true;
        }

        public boolean isWriteOnce() {
            return false;
        }

        public boolean hasSideEffects() {
            return false;
        }

        public boolean isVolatile() {
            return true;
        }

        public boolean isFloat() {
            return this.fIsFloat;
        }

        public String getName() {
            return this.fRegName;
        }

        public String getDescription() {
            return this.fRegDesc;
        }
    }
}

