/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MITraceStatusInfo
extends MIInfo {
    private int fFreeBufferSize = 0;
    private int fTotalBufferSize = 0;
    private int fNumberOfCollectedFrames = 0;
    private boolean fIsTracingActive = false;
    private boolean fIsTracingSupported = false;
    private IGDBTraceControl.STOP_REASON_ENUM fStopReason = null;
    private Integer fStoppingTracepoint = null;

    public MITraceStatusInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public int getFreeBufferSize() {
        return this.fFreeBufferSize;
    }

    public int getNumberOfCollectedFrame() {
        return this.fNumberOfCollectedFrames;
    }

    public int getTotalBufferSize() {
        return this.fTotalBufferSize;
    }

    public boolean isTracingActive() {
        return this.fIsTracingActive;
    }

    public boolean isTracingSupported() {
        return this.fIsTracingSupported;
    }

    public IGDBTraceControl.STOP_REASON_ENUM getStopReason() {
        return this.fStopReason;
    }

    public Integer getStopTracepoint() {
        return this.fStoppingTracepoint;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue val;
                String var = results[i].getVariable();
                if (var.equals("supported")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        this.fIsTracingSupported = !((MIConst)val).getString().equals("0");
                    }
                } else if (var.equals("running")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        this.fIsTracingActive = !((MIConst)val).getString().equals("0");
                    }
                } else if (var.equals("frames")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        try {
                            this.fNumberOfCollectedFrames = Integer.parseInt(((MIConst)val).getString());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("buffer-size")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        try {
                            this.fTotalBufferSize = Integer.parseInt(((MIConst)val).getString());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("buffer-free")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        try {
                            this.fFreeBufferSize = Integer.parseInt(((MIConst)val).getString());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("stop-reason")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        String reason = ((MIConst)val).getString().trim();
                        this.fStopReason = reason.equalsIgnoreCase("request") ? IGDBTraceControl.STOP_REASON_ENUM.REQUEST : (reason.equalsIgnoreCase("overflow") ? IGDBTraceControl.STOP_REASON_ENUM.OVERFLOW : (reason.equalsIgnoreCase("disconnection") ? IGDBTraceControl.STOP_REASON_ENUM.DISCONNECTION : (reason.equalsIgnoreCase("passcount") ? IGDBTraceControl.STOP_REASON_ENUM.PASSCOUNT : (reason.equalsIgnoreCase("error") ? IGDBTraceControl.STOP_REASON_ENUM.ERROR : IGDBTraceControl.STOP_REASON_ENUM.UNKNOWN))));
                    }
                } else if (var.equals("stopping-tracepoint") && (val = results[i].getMIValue()) instanceof MIConst) {
                    try {
                        this.fStoppingTracepoint = Integer.parseInt(((MIConst)val).getString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
    }
}

