/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.component;

import java.util.concurrent.CountDownLatch;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.tmf.core.component.ITmfDataProvider;
import org.eclipse.linuxtools.tmf.core.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;

public class TmfEventThread
implements Runnable {
    private final TmfDataProvider fProvider;
    private final ITmfDataRequest fRequest;
    private final ITmfDataRequest.ExecutionType fExecType;
    private final TmfEventThread fThread;
    private volatile boolean isCompleted = false;
    private CountDownLatch pausedLatch = new CountDownLatch(0);

    public TmfEventThread(TmfDataProvider provider, ITmfDataRequest request) {
        assert (provider != null);
        assert (request != null);
        this.fProvider = provider;
        this.fRequest = request;
        this.fExecType = request.getExecType();
        this.fThread = null;
    }

    public TmfEventThread(TmfEventThread thread) {
        this.fProvider = thread.fProvider;
        this.fRequest = thread.fRequest;
        this.fExecType = thread.fExecType;
        this.fThread = thread;
    }

    public TmfEventThread getThread() {
        return this.fThread;
    }

    public ITmfDataProvider getProvider() {
        return this.fProvider;
    }

    public ITmfDataRequest getRequest() {
        return this.fRequest;
    }

    public ITmfDataRequest.ExecutionType getExecType() {
        return this.fExecType;
    }

    public boolean isRunning() {
        return this.fRequest.isRunning() && !this.isPaused();
    }

    public synchronized boolean isPaused() {
        return this.pausedLatch.getCount() > 0L;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public void run() {
        TmfCoreTracer.traceRequest(this.fRequest, "is being serviced by " + this.fProvider.getName());
        this.fRequest.start();
        int nbRequested = this.fRequest.getNbRequested();
        int nbRead = 0;
        this.isCompleted = false;
        ITmfContext context = this.fProvider.armRequest(this.fRequest);
        if (context == null) {
            this.fRequest.cancel();
            return;
        }
        try {
            ITmfEvent event = this.fProvider.getNext(context);
            TmfCoreTracer.traceRequest(this.fRequest, "read first event");
            while (event != null && !this.fProvider.isCompleted(this.fRequest, event, nbRead)) {
                this.pausedLatch.await();
                TmfCoreTracer.traceEvent(this.fProvider, this.fRequest, event);
                if (this.fRequest.getDataType().isInstance(event)) {
                    this.fRequest.handleData(event);
                }
                if (++nbRead >= nbRequested) continue;
                event = this.fProvider.getNext(context);
            }
            this.isCompleted = true;
            if (this.fRequest.isCancelled()) {
                this.fRequest.cancel();
            } else {
                this.fRequest.done();
            }
        }
        catch (Exception e) {
            Activator.logError("Error in " + this.fProvider.getName() + " handling " + this.fRequest, e);
            this.fRequest.fail();
        }
        context.dispose();
    }

    public synchronized void suspend() {
        this.pausedLatch = new CountDownLatch(1);
        TmfCoreTracer.traceRequest(this.fRequest, "SUSPENDED");
    }

    public synchronized void resume() {
        this.pausedLatch.countDown();
        TmfCoreTracer.traceRequest(this.fRequest, "RESUMED");
    }

    public void cancel() {
        if (!this.fRequest.isCompleted()) {
            this.fRequest.cancel();
        }
    }
}

