/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.request;

import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.internal.tmf.core.component.TmfEventThread;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;

public class TmfRequestExecutor
implements Executor {
    private static final long REQUEST_TIME = 100L;
    private static final int FOREGROUND_SLOT = 4;
    private final ExecutorService fExecutor = Executors.newCachedThreadPool();
    private final String fExecutorName;
    private final Queue<TmfEventThread> fForegroundTasks = new ArrayBlockingQueue<TmfEventThread>(100);
    private final Queue<TmfEventThread> fBackgroundTasks = new ArrayBlockingQueue<TmfEventThread>(100);
    private TmfEventThread fActiveTask;
    private final Timer fTimer = new Timer(true);
    private TimerTask fTimerTask;
    private int fForegroundCycle = 0;

    public TmfRequestExecutor() {
        String canonicalName = this.fExecutor.getClass().getCanonicalName();
        this.fExecutorName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
        if (TmfCoreTracer.isComponentTraced()) {
            TmfCoreTracer.trace(this.fExecutor + " created");
        }
        this.fTimerTask = new SchedSwitch();
        this.fTimer.schedule(this.fTimerTask, 0L, 100L);
    }

    @Deprecated
    public TmfRequestExecutor(ExecutorService executor) {
        this();
    }

    @Deprecated
    public synchronized int getNbPendingRequests() {
        return this.fForegroundTasks.size() + this.fBackgroundTasks.size();
    }

    public synchronized boolean isShutdown() {
        return this.fExecutor.isShutdown();
    }

    public synchronized boolean isTerminated() {
        return this.fExecutor.isTerminated();
    }

    @Override
    public synchronized void execute(final Runnable command) {
        if (!(command instanceof TmfEventThread)) {
            return;
        }
        TmfEventThread thread = (TmfEventThread)command;
        TmfEventThread wrapper = new TmfEventThread(thread){

            @Override
            public void run() {
                try {
                    command.run();
                }
                finally {
                    TmfRequestExecutor.this.scheduleNext();
                }
            }
        };
        ITmfDataRequest.ExecutionType priority = thread.getExecType();
        if (priority == ITmfDataRequest.ExecutionType.FOREGROUND) {
            this.fForegroundTasks.add(wrapper);
        } else {
            this.fBackgroundTasks.add(wrapper);
        }
    }

    protected synchronized void scheduleNext() {
        if (!this.isShutdown()) {
            if (this.fActiveTask == null) {
                this.schedule();
            } else if (this.fActiveTask.getExecType() == ITmfDataRequest.ExecutionType.FOREGROUND) {
                if (this.fActiveTask.getThread().isCompleted()) {
                    this.schedule();
                } else if (this.hasTasks()) {
                    this.fActiveTask.getThread().suspend();
                    this.fForegroundTasks.add(this.fActiveTask);
                    this.schedule();
                }
            } else if (this.fActiveTask.getExecType() == ITmfDataRequest.ExecutionType.BACKGROUND) {
                if (this.fActiveTask.getThread().isCompleted()) {
                    this.schedule();
                } else if (this.hasTasks()) {
                    this.fActiveTask.getThread().suspend();
                    this.fBackgroundTasks.add(this.fActiveTask);
                    this.schedule();
                }
            }
        }
    }

    public synchronized void stop() {
        this.fTimerTask.cancel();
        this.fTimer.cancel();
        if (this.fActiveTask != null) {
            this.fActiveTask.cancel();
        }
        while ((this.fActiveTask = this.fForegroundTasks.poll()) != null) {
            this.fActiveTask.cancel();
        }
        while ((this.fActiveTask = this.fBackgroundTasks.poll()) != null) {
            this.fActiveTask.cancel();
        }
        this.fExecutor.shutdown();
        if (TmfCoreTracer.isComponentTraced()) {
            TmfCoreTracer.trace(this.fExecutor + " terminated");
        }
    }

    private void schedule() {
        if (!this.fForegroundTasks.isEmpty()) {
            this.scheduleNextForeground();
        } else {
            this.scheduleNextBackground();
        }
    }

    private void scheduleNextForeground() {
        if (this.fForegroundCycle < 4 || this.fBackgroundTasks.isEmpty()) {
            ++this.fForegroundCycle;
            this.fActiveTask = this.fForegroundTasks.poll();
            this.executefActiveTask();
        } else {
            this.fActiveTask = null;
            this.scheduleNextBackground();
        }
    }

    private void scheduleNextBackground() {
        this.fForegroundCycle = 0;
        if (!this.fBackgroundTasks.isEmpty()) {
            this.fActiveTask = this.fBackgroundTasks.poll();
            this.executefActiveTask();
        }
    }

    private void executefActiveTask() {
        if (this.fActiveTask.getThread().isPaused()) {
            this.fActiveTask.getThread().resume();
        } else {
            this.fExecutor.execute(this.fActiveTask);
        }
    }

    private boolean hasTasks() {
        return !this.fForegroundTasks.isEmpty() || !this.fBackgroundTasks.isEmpty();
    }

    public String toString() {
        return "[TmfRequestExecutor(" + this.fExecutorName + ")]";
    }

    private class SchedSwitch
    extends TimerTask {
        SchedSwitch() {
        }

        @Override
        public void run() {
            TmfRequestExecutor.this.scheduleNext();
        }
    }
}

