/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfEvent
extends PlatformObject
implements ITmfEvent {
    private final ITmfTrace fTrace;
    private final long fRank;
    private final ITmfTimestamp fTimestamp;
    private final String fSource;
    private final ITmfEventType fType;
    private final ITmfEventField fContent;
    private final String fReference;

    public TmfEvent() {
        this(null, -1L, null, null, null, null, null);
    }

    public TmfEvent(ITmfTrace trace, ITmfTimestamp timestamp, String source, ITmfEventType type, ITmfEventField content, String reference) {
        this(trace, -1L, timestamp, source, type, content, reference);
    }

    public TmfEvent(ITmfTrace trace, long rank, ITmfTimestamp timestamp, String source, ITmfEventType type, ITmfEventField content, String reference) {
        this.fTrace = trace;
        this.fRank = rank;
        this.fTimestamp = timestamp;
        this.fSource = source;
        this.fType = type;
        this.fContent = content;
        this.fReference = reference;
    }

    public TmfEvent(ITmfEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        this.fTrace = event.getTrace();
        this.fRank = event.getRank();
        this.fTimestamp = event.getTimestamp();
        this.fSource = event.getSource();
        this.fType = event.getType();
        this.fContent = event.getContent();
        this.fReference = event.getReference();
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getRank() {
        return this.fRank;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public String getSource() {
        return this.fSource;
    }

    @Override
    public ITmfEventType getType() {
        return this.fType;
    }

    @Override
    public ITmfEventField getContent() {
        return this.fContent;
    }

    @Override
    public String getReference() {
        return this.fReference;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fTrace == null ? 0 : this.fTrace.hashCode());
        result = 31 * result + (int)(this.fRank ^ this.fRank >>> 32);
        result = 31 * result + (this.fTimestamp == null ? 0 : this.fTimestamp.hashCode());
        result = 31 * result + (this.fSource == null ? 0 : this.fSource.hashCode());
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        result = 31 * result + (this.fContent == null ? 0 : this.fContent.hashCode());
        result = 31 * result + (this.fReference == null ? 0 : this.fReference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEvent)) {
            return false;
        }
        TmfEvent other = (TmfEvent)obj;
        if (this.fTrace == null ? other.fTrace != null : !this.fTrace.equals(other.fTrace)) {
            return false;
        }
        if (this.fRank != other.fRank) {
            return false;
        }
        if (this.fTimestamp == null ? other.fTimestamp != null : !this.fTimestamp.equals(other.fTimestamp)) {
            return false;
        }
        if (this.fSource == null ? other.fSource != null : !this.fSource.equals(other.fSource)) {
            return false;
        }
        if (this.fType == null ? other.fType != null : !this.fType.equals(other.fType)) {
            return false;
        }
        if (this.fContent == null ? other.fContent != null : !this.fContent.equals(other.fContent)) {
            return false;
        }
        return !(this.fReference == null ? other.fReference != null : !this.fReference.equals(other.fReference));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [fTimestamp=" + this.getTimestamp() + ", fTrace=" + this.getTrace() + ", fRank=" + this.getRank() + ", fSource=" + this.getSource() + ", fType=" + this.getType() + ", fContent=" + this.getContent() + ", fReference=" + this.getReference() + "]";
    }
}

