/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;

public class TmfEventField
implements ITmfEventField {
    private final String fName;
    private final Object fValue;
    private final ITmfEventField[] fFields;
    private final String[] fFieldNames;
    private final Map<String, ITmfEventField> fNameMapping;

    public TmfEventField(String name, Object value, ITmfEventField[] fields) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.fName = name;
        this.fValue = value;
        this.fFields = fields;
        int nbFields = this.fFields != null ? this.fFields.length : 0;
        this.fFieldNames = new String[nbFields];
        this.fNameMapping = new HashMap<String, ITmfEventField>();
        int i = 0;
        while (i < nbFields) {
            String curName;
            this.fFieldNames[i] = curName = this.fFields[i].getName();
            this.fNameMapping.put(curName, this.fFields[i]);
            ++i;
        }
    }

    public TmfEventField(TmfEventField field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.fName = field.fName;
        this.fValue = field.fValue;
        this.fFields = field.fFields;
        this.fFieldNames = field.fFieldNames;
        this.fNameMapping = field.fNameMapping;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Object getValue() {
        return this.fValue;
    }

    @Override
    public String[] getFieldNames() {
        return this.fFieldNames;
    }

    @Override
    public String getFieldName(int index) {
        ITmfEventField field = this.getField(index);
        if (field != null) {
            return field.getName();
        }
        return null;
    }

    @Override
    public ITmfEventField[] getFields() {
        return this.fFields != null ? this.fFields : new ITmfEventField[]{};
    }

    @Override
    public ITmfEventField getField(String name) {
        return this.fNameMapping.get(name);
    }

    @Override
    public ITmfEventField getField(int index) {
        if (this.fFields != null && index >= 0 && index < this.fFields.length) {
            return this.fFields[index];
        }
        return null;
    }

    public static final ITmfEventField makeRoot(String[] labels) {
        ITmfEventField[] fields = new ITmfEventField[labels.length];
        int i = 0;
        while (i < labels.length) {
            fields[i] = new TmfEventField(labels[i], null, null);
            ++i;
        }
        return new TmfEventField(":root:", null, fields);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fName.hashCode();
        result = 31 * result + (this.fValue == null ? 0 : this.fValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventField)) {
            return false;
        }
        TmfEventField other = (TmfEventField)obj;
        if (!this.fName.equals(other.fName)) {
            return false;
        }
        return !(this.fValue == null ? other.fValue != null : !this.fValue.equals(other.fValue));
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.fName.equals(":root:")) {
            this.appendSubFields(ret);
        } else {
            ret.append(this.fName);
            ret.append('=');
            ret.append(this.fValue);
            if (this.fFields != null && this.fFields.length > 0) {
                ret.append(" [");
                this.appendSubFields(ret);
                ret.append(']');
            }
        }
        return ret.toString();
    }

    private void appendSubFields(StringBuilder sb) {
        int i = 0;
        while (i < this.getFields().length) {
            ITmfEventField field = this.getFields()[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(field.toString());
            ++i;
        }
    }

    @Override
    public String getFormattedValue() {
        return this.getValue().toString();
    }
}

