/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.timestamp;

import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampDelta;

public class TmfSimpleTimestamp
extends TmfTimestamp {
    public TmfSimpleTimestamp() {
        this(0L);
    }

    public TmfSimpleTimestamp(long value) {
        super(value, 0, 0);
    }

    public TmfSimpleTimestamp(ITmfTimestamp timestamp) {
        super(timestamp.normalize(0L, 0).getValue(), 0, 0);
    }

    @Override
    public ITmfTimestamp normalize(long offset, int scale) {
        if (scale == 0) {
            return new TmfSimpleTimestamp(this.getValue() + offset);
        }
        return super.normalize(offset, scale);
    }

    @Override
    public int compareTo(ITmfTimestamp ts, boolean withinPrecision) {
        if (ts instanceof TmfSimpleTimestamp) {
            long delta = this.getValue() - ts.getValue();
            return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
        }
        return super.compareTo(ts, withinPrecision);
    }

    @Override
    public ITmfTimestamp getDelta(ITmfTimestamp ts) {
        if (ts instanceof TmfSimpleTimestamp) {
            return new TmfTimestampDelta(this.getValue() - ts.getValue());
        }
        return super.getDelta(ts);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TmfSimpleTimestamp)) {
            return super.equals(other);
        }
        TmfSimpleTimestamp ts = (TmfSimpleTimestamp)other;
        return this.compareTo(ts, false) == 0;
    }
}

