/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;

final class TmfTraceContext {
    static final TmfTraceContext NULL_CONTEXT = new TmfTraceContext(TmfTimestamp.BIG_CRUNCH, TmfTimestamp.BIG_CRUNCH, TmfTimeRange.NULL_RANGE);
    private final TmfTimeRange fSelection;
    private final TmfTimeRange fWindowRange;

    public TmfTraceContext(ITmfTimestamp beginTs, ITmfTimestamp endTs, TmfTimeRange tr) {
        this.fSelection = new TmfTimeRange(beginTs, endTs);
        this.fWindowRange = tr;
    }

    public TmfTraceContext(TmfTraceContext prevCtx, ITmfTimestamp beginTs, ITmfTimestamp endTs) {
        this.fSelection = new TmfTimeRange(beginTs, endTs);
        this.fWindowRange = prevCtx.fWindowRange;
    }

    public TmfTraceContext(TmfTraceContext prevCtx, TmfTimeRange tr) {
        this.fSelection = prevCtx.fSelection;
        this.fWindowRange = tr;
    }

    public ITmfTimestamp getSelectionBegin() {
        return this.fSelection.getStartTime();
    }

    public ITmfTimestamp getSelectionEnd() {
        return this.fSelection.getEndTime();
    }

    public TmfTimeRange getWindowRange() {
        return this.fWindowRange;
    }

    public boolean isValid() {
        return this.fSelection.getStartTime().compareTo(TmfTimestamp.ZERO) > 0 && this.fSelection.getEndTime().compareTo(TmfTimestamp.ZERO) > 0 && this.fWindowRange.getEndTime().compareTo(this.fWindowRange.getStartTime()) > 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[fSelection=" + this.fSelection + ", fWindowRange=" + this.fWindowRange + ']';
    }
}

