/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.rpm.core.utils.Utils;

public class RPMQuery {
    private static final String QF = "--qf";
    private static final String QP = "-qp";

    private RPMQuery() {
    }

    public static String getHeaderInfo(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, "-qip");
    }

    public static String getChangelog(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, "--changelog", QP);
    }

    public static String getArch(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{ARCH}", QP);
    }

    public static String getPlatform(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{PLATFORM}", QP);
    }

    public static String getOS(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{OS}", QP);
    }

    public static String getBuildHost(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{BUILDHOST}", QP);
    }

    public static String getBuildTime(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{BUILDTIME:date}", QP);
    }

    public static String getPreInstallScript(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{PREIN}", QP);
    }

    public static String getPostInstallScript(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{POSTIN}", QP);
    }

    public static String getPreUninstallScript(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{PREUN}", QP);
    }

    public static String getPostUninstallScript(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, QF, "%{POSTUN}", QP);
    }

    public static String getProvides(IFile rpmFile) throws CoreException {
        return RPMQuery.query(rpmFile, "-qlp");
    }

    private static String query(IFile rpmFile, String ... args) throws CoreException {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.core");
        String rpmCmd = node.get("RPM_CMD", "");
        ArrayList<String> command = new ArrayList<String>();
        command.add(rpmCmd);
        command.addAll(Arrays.asList(args));
        command.add(rpmFile.getLocation().toOSString());
        try {
            return Utils.runCommandToString(command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }

    public static String eval(String toEval) throws CoreException {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.core");
        String rpmCmd = node.get("RPM_CMD", "");
        ArrayList<String> command = new ArrayList<String>();
        command.add(rpmCmd);
        command.add("--eval");
        command.add(toEval);
        try {
            return Utils.runCommandToString(command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }
}

