/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class RenameBranchOperation
implements IEGitOperation {
    private final Repository repository;
    private final Ref branch;
    private final String newName;

    public RenameBranchOperation(Repository repository, Ref branch, String newName) {
        this.repository = repository;
        this.branch = branch;
        this.newName = newName;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                String taskName = NLS.bind((String)CoreText.RenameBranchOperation_TaskName, (Object)RenameBranchOperation.this.branch.getName(), (Object)RenameBranchOperation.this.newName);
                actMonitor.beginTask(taskName, 1);
                try {
                    new Git(RenameBranchOperation.this.repository).branchRename().setOldName(RenameBranchOperation.this.branch.getName()).setNewName(RenameBranchOperation.this.newName).call();
                }
                catch (JGitInternalException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                catch (GitAPIException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                actMonitor.worked(1);
                actMonitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

