/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractLocalEditorPart
extends AbstractFormPart {
    private static final String FLAG_DIRTY = "LocalEditor.dirty";
    private Control control;
    private TaskRepository repository;
    private Section section;
    private final String sectionName;
    private final int sectionStyle;
    private AbstractTask task;

    public AbstractLocalEditorPart(int sectionStyle, String sectionName) {
        this.sectionStyle = sectionStyle;
        this.sectionName = sectionName;
    }

    public AbstractLocalEditorPart(String sectionName) {
        this.sectionStyle = 2;
        this.sectionName = sectionName;
    }

    public abstract Control createControl(Composite var1, FormToolkit var2);

    protected Section createSection(Composite parent, FormToolkit toolkit, boolean expandedState) {
        int style = 0x100 | this.getSectionStyle();
        if (expandedState && this.isTwistie(style)) {
            style |= 0x40;
        }
        return this.createSection(parent, toolkit, style);
    }

    protected Section createSection(Composite parent, FormToolkit toolkit, int style) {
        Section section = toolkit.createSection(parent, style);
        section.setText(this.getSectionName());
        section.clientVerticalSpacing = 0;
        section.descriptionVerticalSpacing = 0;
        section.marginHeight = 0;
        return section;
    }

    public Control getControl() {
        return this.control;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public Section getSection() {
        return this.section;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    private int getSectionStyle() {
        return this.sectionStyle;
    }

    public AbstractTask getTask() {
        return this.task;
    }

    public void initialize(IManagedForm managedForm, TaskRepository repository, AbstractTask task) {
        super.initialize(managedForm);
        this.task = task;
        this.repository = repository;
    }

    private boolean isTwistie(int style) {
        return (style & 2) != 0;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    protected void setSection(FormToolkit toolkit, Section section) {
        this.section = section;
        this.setControl((Control)section);
    }

    public void refresh() {
        this.refresh(true);
        super.refresh();
    }

    protected void refresh(boolean discardChanges) {
    }

    protected void markDirty(Control control) {
        control.setData(FLAG_DIRTY, (Object)Boolean.TRUE);
        this.markDirty();
    }

    protected boolean shouldRefresh(Control control, boolean discardChanges) {
        if (discardChanges) {
            this.clearState(control);
            return true;
        }
        return control.getData(FLAG_DIRTY) == null;
    }

    protected void clearState(Control control) {
        control.setData(FLAG_DIRTY, null);
    }
}

