/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExpandStackEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.ILaunch;

public abstract class AbstractExecutionContextVMNode
extends AbstractDMVMNode {
    protected ArrayList<Class<?>> leafEventTypes = new ArrayList();
    protected ArrayList<Class<?>> containerEventTypes = new ArrayList();

    public AbstractExecutionContextVMNode(AbstractDMVMProvider provider, DsfSession session, Class<? extends IDMContext> dmcClassType) {
        super(provider, session, dmcClassType);
    }

    protected void addCommonEventTypes() {
        this.addEventType(IRunControl.ISuspendedDMEvent.class, false);
        this.addEventType(IRunControl.IResumedDMEvent.class, false);
        this.addEventType(FullStackRefreshEvent.class, false);
        this.addEventType(SteppingController.SteppingTimedOutEvent.class, false);
        this.addEventType(ExpandStackEvent.class, false);
        this.addEventType(IRunControl.IContainerSuspendedDMEvent.class, true);
        this.addEventType(IRunControl.IContainerResumedDMEvent.class, true);
    }

    protected void addEventType(Class<? extends IDMEvent<?>> eventClass, boolean containerEvent) {
        if (containerEvent) {
            this.containerEventTypes.add(eventClass);
        } else {
            this.leafEventTypes.add(eventClass);
        }
    }

    protected void removeEventType(Class<?> eventClass, boolean containerEvent) {
        if (containerEvent) {
            this.containerEventTypes.remove(eventClass);
        } else {
            this.leafEventTypes.remove(eventClass);
        }
    }

    protected boolean getContextsForRecursiveVMNode(VMDelta parentDelta, Object e, DataRequestMonitor<IVMContext[]> rm) {
        IRunControl.IExecutionDMContext leafContext = null;
        if (this.isExecutionContainerEvent(e)) {
            leafContext = this.getLeafContextForContainerEvent(e);
        } else if (this.isExecutionLeafEvent(e)) {
            leafContext = this.getLeafContextForLeafEvent(e);
        }
        if (leafContext != null) {
            this.setImmediateParentAsContexts(leafContext, parentDelta, rm);
            return true;
        }
        return false;
    }

    protected boolean buildDeltaForRecursiveVMNode(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        IRunControl.IExecutionDMContext leafContext = null;
        if (this.isExecutionContainerEvent(e)) {
            leafContext = this.getLeafContextForContainerEvent(e);
        } else if (this.isExecutionLeafEvent(e)) {
            leafContext = this.getLeafContextForLeafEvent(e);
        }
        if (leafContext != null) {
            this.addOneLevelToDelta(leafContext, parentDelta, requestMonitor);
            return true;
        }
        return false;
    }

    protected IRunControl.IExecutionDMContext getLeafContextForContainerEvent(Object event) {
        IRunControl.IExecutionDMContext leafEC = null;
        IRunControl.IExecutionDMContext[] triggeringContext = null;
        if (this.isExecutionContainerEvent(event)) {
            IRunControl.IContainerSuspendedDMEvent typedEvent;
            if (event instanceof IRunControl.IContainerSuspendedDMEvent) {
                typedEvent = (IRunControl.IContainerSuspendedDMEvent)event;
                triggeringContext = typedEvent.getTriggeringContexts();
            }
            if (event instanceof IRunControl.IContainerResumedDMEvent) {
                typedEvent = (IRunControl.IContainerResumedDMEvent)event;
                triggeringContext = typedEvent.getTriggeringContexts();
            }
        }
        if (triggeringContext != null && triggeringContext.length > 0) {
            leafEC = triggeringContext[0];
        }
        return leafEC;
    }

    protected IRunControl.IExecutionDMContext getLeafContextForLeafEvent(Object event) {
        IDMEvent typedEvent;
        IDMContext dmContext;
        IRunControl.IExecutionDMContext leafEC = null;
        if (event instanceof IDMEvent && this.isExecutionLeafEvent(event) && (dmContext = (typedEvent = (IDMEvent)event).getDMContext()) instanceof IRunControl.IExecutionDMContext) {
            leafEC = (IRunControl.IExecutionDMContext)dmContext;
        }
        return leafEC;
    }

    protected void addOneLevelToDelta(IRunControl.IExecutionDMContext leafContext, VMDelta parentDelta, RequestMonitor requestMonitor) {
        assert (leafContext != null);
        if (parentDelta.getElement() instanceof ILaunch) {
            IRunControl.IContainerDMContext topContainer = (IRunControl.IContainerDMContext)DMContexts.getTopMostAncestorOfType((IDMContext)leafContext, IRunControl.IContainerDMContext.class);
            if (topContainer != null) {
                parentDelta.addNode((Object)this.createVMContext((IDMContext)topContainer), 0, 0);
            }
        } else if (parentDelta.getElement() instanceof IDMVMContext) {
            IDMVMContext vmContext = (IDMVMContext)parentDelta.getElement();
            IDMContext dmContext = vmContext.getDMContext();
            IRunControl.IExecutionDMContext current = (IRunControl.IExecutionDMContext)DMContexts.getParentOfType((IDMContext)leafContext, IRunControl.IContainerDMContext.class);
            while (current != null) {
                IRunControl.IContainerDMContext parent = (IRunControl.IContainerDMContext)DMContexts.getParentOfType((IDMContext)current, IRunControl.IContainerDMContext.class);
                if (dmContext.equals(parent)) {
                    parentDelta.addNode((Object)this.createVMContext((IDMContext)current), 0, 0);
                    break;
                }
                current = parent;
            }
        }
        requestMonitor.done();
    }

    protected void setImmediateParentAsContexts(IRunControl.IExecutionDMContext leafContext, VMDelta parentDelta, DataRequestMonitor<IVMContext[]> rm) {
        assert (leafContext != null);
        IVMContext[] all = null;
        if (parentDelta.getElement() instanceof ILaunch) {
            IRunControl.IContainerDMContext topContainer = (IRunControl.IContainerDMContext)DMContexts.getTopMostAncestorOfType((IDMContext)leafContext, IRunControl.IContainerDMContext.class);
            all = topContainer != null ? new IVMContext[]{this.createVMContext((IDMContext)topContainer)} : new IVMContext[]{this.createVMContext((IDMContext)leafContext)};
        } else if (parentDelta.getElement() instanceof IDMVMContext) {
            IDMVMContext vmContext = (IDMVMContext)parentDelta.getElement();
            IDMContext dmContext = vmContext.getDMContext();
            IRunControl.IExecutionDMContext current = leafContext;
            while (current != null) {
                IRunControl.IContainerDMContext parent = (IRunControl.IContainerDMContext)DMContexts.getParentOfType((IDMContext)current, IRunControl.IContainerDMContext.class);
                if (dmContext.equals(parent)) {
                    all = new IVMContext[]{this.createVMContext((IDMContext)current)};
                    break;
                }
                current = parent;
            }
        }
        if (all == null) {
            all = new IVMContext[]{};
        }
        rm.setData((Object)all);
        rm.done();
    }

    protected boolean isExecutionContainerEvent(Object event) {
        if (event != null) {
            for (Class<?> clazz : this.containerEventTypes) {
                if (!clazz.isAssignableFrom(event.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExecutionLeafEvent(Object event) {
        if (event != null) {
            for (Class<?> clazz : this.leafEventTypes) {
                if (!clazz.isAssignableFrom(event.getClass())) continue;
                return true;
            }
        }
        return false;
    }
}

