/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.SelectSupplementaryResourcesDialog;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteTraceSupplementaryFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfTraceElement) {
            TmfTraceElement trace = (TmfTraceElement)element;
            trace = trace.getElementUnderTraceFolder();
            IResource[] resources = trace.getSupplementaryResources();
            SelectSupplementaryResourcesDialog dialog = new SelectSupplementaryResourcesDialog(window.getShell(), resources);
            if (dialog.open() != 0) {
                return null;
            }
            trace.closeEditors();
            trace.deleteSupplementaryResources(dialog.getResources());
            IProject resource = trace.getProject().getResource();
            if (resource != null) {
                try {
                    resource.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error refreshing resource " + resource, e);
                }
            }
        }
        return null;
    }
}

