/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtEvent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlEvent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceProperties;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfWithFolderElement;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfTraceElement
extends TmfWithFolderElement
implements IActionFilter,
IPropertySource2 {
    public static final String BUNDLE = "bundle";
    public static final String IS_LINKED = "isLinked";
    private static final String sfResourcePropertiesCategory = Messages.TmfTraceElement_ResourceProperties;
    private static final String sfName = Messages.TmfTraceElement_Name;
    private static final String sfPath = Messages.TmfTraceElement_Path;
    private static final String sfLocation = Messages.TmfTraceElement_Location;
    private static final String sfEventType = Messages.TmfTraceElement_EventType;
    private static final String sfIsLinked = Messages.TmfTraceElement_IsLinked;
    private static final String sfTracePropertiesCategory = Messages.TmfTraceElement_TraceProperties;
    private static final ReadOnlyTextPropertyDescriptor sfNameDescriptor = new ReadOnlyTextPropertyDescriptor(sfName, sfName);
    private static final ReadOnlyTextPropertyDescriptor sfPathDescriptor = new ReadOnlyTextPropertyDescriptor(sfPath, sfPath);
    private static final ReadOnlyTextPropertyDescriptor sfLocationDescriptor = new ReadOnlyTextPropertyDescriptor(sfLocation, sfLocation);
    private static final ReadOnlyTextPropertyDescriptor sfTypeDescriptor = new ReadOnlyTextPropertyDescriptor(sfEventType, sfEventType);
    private static final ReadOnlyTextPropertyDescriptor sfIsLinkedDescriptor = new ReadOnlyTextPropertyDescriptor(sfIsLinked, sfIsLinked);
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor, sfTypeDescriptor, sfIsLinkedDescriptor};
    private static final String BOOKMARKS_HIDDEN_FILE = ".bookmarks";
    private String fTraceTypeId = null;
    private static final Map<String, IConfigurationElement> sfTraceTypeAttributes;
    private static final Map<String, IConfigurationElement> sfTraceCategories;

    static {
        sfNameDescriptor.setCategory(sfResourcePropertiesCategory);
        sfPathDescriptor.setCategory(sfResourcePropertiesCategory);
        sfLocationDescriptor.setCategory(sfResourcePropertiesCategory);
        sfTypeDescriptor.setCategory(sfResourcePropertiesCategory);
        sfIsLinkedDescriptor.setCategory(sfResourcePropertiesCategory);
        sfTraceTypeAttributes = new HashMap<String, IConfigurationElement>();
        sfTraceCategories = new HashMap<String, IConfigurationElement>();
    }

    public static void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals("type")) {
                String traceTypeId = ce.getAttribute("id");
                sfTraceTypeAttributes.put(traceTypeId, ce);
            } else if (elementName.equals("category")) {
                String categoryId = ce.getAttribute("id");
                sfTraceCategories.put(categoryId, ce);
            }
            ++n2;
        }
    }

    public TmfTraceElement(String name, IResource trace, TmfTraceFolder parent) {
        this(name, trace, (TmfProjectModelElement)parent);
    }

    public TmfTraceElement(String name, IResource trace, TmfExperimentElement parent) {
        this(name, trace, (TmfProjectModelElement)parent);
    }

    private TmfTraceElement(String name, IResource trace, TmfProjectModelElement parent) {
        super(name, trace, parent);
        parent.addChild(this);
        this.refreshTraceType();
    }

    public String getTraceType() {
        return this.fTraceTypeId;
    }

    public void refreshTraceType() {
        try {
            this.fTraceTypeId = this.getResource().getPersistentProperty(TmfCommonConstants.TRACETYPE);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error refreshing trace type pesistent property for trace " + this.getName(), e);
        }
    }

    public ITmfTrace instantiateTrace() {
        block9: {
            IConfigurationElement ce;
            block10: {
                CustomTraceDefinition def;
                int n;
                int n2;
                CustomTraceDefinition[] customTraceDefinitionArray;
                this.refreshSupplementaryFolder();
                if (this.fTraceTypeId == null) break block9;
                if (this.fTraceTypeId.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + ((CustomTxtTraceDefinition)def).definitionName)) {
                            return new CustomTxtTrace((CustomTxtTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if (this.fTraceTypeId.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + ((CustomXmlTraceDefinition)def).definitionName)) {
                            return new CustomXmlTrace((CustomXmlTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if ((ce = sfTraceTypeAttributes.get(this.fTraceTypeId)) != null) break block10;
                return null;
            }
            try {
                ITmfTrace trace = (ITmfTrace)ce.createExecutableExtension("trace_type");
                return trace;
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error instantiating ITmfTrace object for trace " + this.getName(), e);
            }
        }
        return null;
    }

    public ITmfEvent instantiateEvent() {
        block9: {
            IConfigurationElement ce;
            block10: {
                CustomTraceDefinition def;
                int n;
                int n2;
                CustomTraceDefinition[] customTraceDefinitionArray;
                if (this.fTraceTypeId == null) break block9;
                if (this.fTraceTypeId.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + ((CustomTxtTraceDefinition)def).definitionName)) {
                            return new CustomTxtEvent((CustomTxtTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if (this.fTraceTypeId.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + ((CustomXmlTraceDefinition)def).definitionName)) {
                            return new CustomXmlEvent((CustomXmlTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if ((ce = sfTraceTypeAttributes.get(this.fTraceTypeId)) != null) break block10;
                return null;
            }
            try {
                ITmfEvent event = (ITmfEvent)ce.createExecutableExtension("event_type");
                return event;
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error instantiating ITmfEvent object for trace " + this.getName(), e);
            }
        }
        return null;
    }

    public String getEditorId() {
        if (this.fTraceTypeId != null) {
            if (this.fTraceTypeId.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                return "org.eclipse.linuxtools.tmf.ui.editors.events";
            }
            if (this.fTraceTypeId.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                return "org.eclipse.linuxtools.tmf.ui.editors.events";
            }
            IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
            IConfigurationElement[] defaultEditorCE = ce.getChildren("defaultEditor");
            if (defaultEditorCE.length == 1) {
                return defaultEditorCE[0].getAttribute("id");
            }
        }
        return null;
    }

    public IFile createBookmarksFile() throws CoreException {
        IFile file = this.getBookmarksFile();
        if (this.fResource instanceof IFolder && !file.exists()) {
            IFile bookmarksFile = this.getProject().getTracesFolder().getResource().getFile(BOOKMARKS_HIDDEN_FILE);
            if (!bookmarksFile.exists()) {
                ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                bookmarksFile.create((InputStream)source, true, null);
            }
            bookmarksFile.setHidden(true);
            file.createLink(bookmarksFile.getLocation(), 256, null);
            file.setHidden(true);
            file.setPersistentProperty(TmfCommonConstants.TRACETYPE, TmfTrace.class.getCanonicalName());
        }
        return file;
    }

    public IFile getBookmarksFile() {
        IFile file = null;
        if (this.fResource instanceof IFile) {
            file = (IFile)this.fResource;
        } else if (this.fResource instanceof IFolder) {
            IFolder folder = (IFolder)this.fResource;
            file = folder.getFile(String.valueOf(this.getName()) + '_');
        }
        return file;
    }

    public TmfTraceElement getElementUnderTraceFolder() {
        if (this.getParent() instanceof TmfExperimentElement) {
            for (TmfTraceElement aTrace : this.getProject().getTracesFolder().getTraces()) {
                if (!aTrace.getName().equals(this.getName())) continue;
                return aTrace;
            }
        }
        return this;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(IS_LINKED)) {
            boolean isLinked = this.getResource().isLinked();
            return Boolean.toString(isLinked).equals(value);
        }
        return false;
    }

    @Override
    public TmfProjectElement getProject() {
        if (this.getParent() instanceof TmfTraceFolder) {
            TmfTraceFolder folder = (TmfTraceFolder)this.getParent();
            TmfProjectElement project = (TmfProjectElement)folder.getParent();
            return project;
        }
        if (this.getParent() instanceof TmfExperimentElement) {
            TmfExperimentElement experiment = (TmfExperimentElement)this.getParent();
            TmfExperimentFolder folder = (TmfExperimentFolder)experiment.getParent();
            TmfProjectElement project = (TmfProjectElement)folder.getParent();
            return project;
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    private Map<String, String> getTraceProperties() {
        for (ITmfTrace openedTrace : TmfTraceManager.getInstance().getOpenedTraces()) {
            ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)openedTrace);
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace singleTrace = iTmfTraceArray[n2];
                if (this.getLocation().toString().endsWith(singleTrace.getPath()) && singleTrace instanceof ITmfTraceProperties) {
                    ITmfTraceProperties traceProperties = (ITmfTraceProperties)singleTrace;
                    return traceProperties.getTraceProperties();
                }
                ++n2;
            }
        }
        return new HashMap<String, String>();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Map<String, String> traceProperties = this.getTraceProperties();
        if (!traceProperties.isEmpty()) {
            IPropertyDescriptor[] propertyDescriptorArray = new IPropertyDescriptor[traceProperties.size() + sfDescriptors.length];
            int index = 0;
            for (Map.Entry<String, String> varName : traceProperties.entrySet()) {
                ReadOnlyTextPropertyDescriptor descriptor = new ReadOnlyTextPropertyDescriptor(String.valueOf(this.getName()) + "_" + varName.getKey(), varName.getKey());
                descriptor.setCategory(sfTracePropertiesCategory);
                propertyDescriptorArray[index] = descriptor;
                ++index;
            }
            int i = 0;
            while (i < sfDescriptors.length) {
                propertyDescriptorArray[index] = sfDescriptors[i];
                ++index;
                ++i;
            }
            return propertyDescriptorArray;
        }
        return Arrays.copyOf(sfDescriptors, sfDescriptors.length);
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        if (sfIsLinked.equals(id)) {
            return Boolean.valueOf(this.getResource().isLinked()).toString();
        }
        if (sfEventType.equals(id) && this.fTraceTypeId != null) {
            IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
            return ce != null ? String.valueOf(TmfTraceElement.getCategory(ce)) + " : " + ce.getAttribute("name") : "";
        }
        Map<String, String> traceProperties = this.getTraceProperties();
        if (id != null && !traceProperties.isEmpty()) {
            String key = (String)id;
            key = key.replaceFirst(String.valueOf(this.getName()) + "_", "");
            String value = traceProperties.get(key);
            return value;
        }
        return null;
    }

    private static String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = sfTraceCategories.get(categoryId)) != null) {
            return category.getAttribute("name");
        }
        return "[no category]";
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public TmfTraceElement copy(String string) {
        TmfTraceFolder folder = this.getProject().getTracesFolder();
        IResource res = super.copy(string, false);
        return new TmfTraceElement(string, res, folder);
    }

    public void closeEditors() {
        IFile file = this.getBookmarksFile();
        FileEditorInput input = new FileEditorInput(file);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    try {
                        if (editorReference.getEditorInput().equals(input)) {
                            wbPage.closeEditor(editorReference.getEditor(false), false);
                        }
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().logError("Error closing editor for trace " + this.getName(), e);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        if (this.getParent() instanceof TmfTraceFolder) {
            TmfExperimentFolder experimentFolder = this.getProject().getExperimentsFolder();
            block5: for (ITmfProjectModelElement experiment : experimentFolder.getChildren()) {
                for (ITmfProjectModelElement child : experiment.getChildren()) {
                    if (!child.getName().equals(this.getName())) continue;
                    ((TmfExperimentElement)experiment).closeEditors();
                    continue block5;
                }
            }
        } else if (this.getParent() instanceof TmfExperimentElement) {
            TmfExperimentElement experiment = (TmfExperimentElement)this.getParent();
            experiment.closeEditors();
        }
    }

    public ITmfTrace getTrace() {
        for (ITmfTrace trace : TmfTraceManager.getInstance().getOpenedTraces()) {
            if (!trace.getResource().equals((Object)this.getResource())) continue;
            return trace;
        }
        return null;
    }
}

