/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class NewExperimentDialog
extends SelectionStatusDialog {
    private Text fExperimentName;
    private final IContainer fExperimentFolder;
    private TmfProjectElement fProject;

    public NewExperimentDialog(Shell shell, TmfExperimentFolder experimentFolder) {
        super(shell);
        this.fExperimentFolder = experimentFolder.getResource();
        this.fProject = experimentFolder.getProject();
        this.setTitle(Messages.NewExperimentDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createExperimentNameGroup(composite);
        return composite;
    }

    private void createExperimentNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label experimentLabel = new Label(folderGroup, 0);
        experimentLabel.setFont(font);
        experimentLabel.setText(Messages.NewExperimentDialog_ExperimentName);
        this.fExperimentName = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fExperimentName.setLayoutData((Object)data);
        this.fExperimentName.setFont(font);
        this.fExperimentName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewExperimentDialog.this.validateNewExperimentName();
            }
        });
    }

    private void validateNewExperimentName() {
        String name = this.fExperimentName.getText();
        IWorkspace workspace = this.fExperimentFolder.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 2);
        if ("".equals(name)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        Path path = new Path(name);
        if (this.fExperimentFolder.getFolder((IPath)path).exists() || this.fExperimentFolder.getFile((IPath)path).exists()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.linuxtools.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        IFolder folder = this.createNewExperiment(this.fExperimentName.getText());
        if (folder == null) {
            return;
        }
        this.setSelectionResult(new IFolder[]{folder});
        super.okPressed();
        if (this.fProject != null) {
            this.fProject.refresh();
        }
    }

    private IFolder createNewExperiment(String experimentName) {
        final IFolder experimentFolder = this.createExperiment(experimentName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 1000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    experimentFolder.create(false, true, monitor);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException exception) {
            return null;
        }
        catch (InvocationTargetException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"", (String)NLS.bind((String)"", (Object)exception.getTargetException().getMessage()));
            return null;
        }
        catch (RuntimeException exception) {
            return null;
        }
        return experimentFolder;
    }

    private IFolder createExperiment(String experimentName) {
        IWorkspaceRoot workspaceRoot = this.fExperimentFolder.getWorkspace().getRoot();
        IPath folderPath = this.fExperimentFolder.getFullPath().append(experimentName);
        IFolder folder = workspaceRoot.getFolder(folderPath);
        return folder;
    }
}

