/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.FileAndName;

class ImportTraceContentProvider
implements ITreeContentProvider {
    private final Map<String, String> fTraceTypes = new HashMap<String, String>();
    private final Map<String, Set<FileAndName>> fTraceFiles = new HashMap<String, Set<FileAndName>>();
    private final List<String> fTraceTypesToScan;
    private final Set<String> fParentFilesToScan;

    public ImportTraceContentProvider(List<String> traceTypesToScan, Set<String> parentFilesToScan) {
        this.fTraceTypesToScan = traceTypesToScan;
        this.fParentFilesToScan = parentFilesToScan;
    }

    public synchronized void addCandidate(String category, File traceToOpen) {
        this.fTraceTypes.put(TmfTraceType.getInstance().getTraceType(category).getName(), category);
        if (!this.fTraceFiles.containsKey(category)) {
            this.fTraceFiles.put(category, new TreeSet());
        }
        FileAndName traceFile = new FileAndName(traceToOpen, traceToOpen.getName());
        traceFile.setTraceTypeId(category);
        Set<FileAndName> categorySet = this.fTraceFiles.get(category);
        categorySet.add(traceFile);
    }

    public synchronized void clearCandidates() {
        this.fTraceTypes.clear();
        this.fTraceFiles.clear();
    }

    public void dispose() {
        this.fTraceFiles.clear();
        this.fTraceTypes.clear();
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != newInput && newInput != null) {
            ImportTraceContentProvider input = (ImportTraceContentProvider)newInput;
            this.clearCandidates();
            this.fTraceTypes.putAll(input.fTraceTypes);
            this.fTraceFiles.putAll(this.fTraceFiles);
        }
    }

    public synchronized Object[] getElements(Object inputElement) {
        ArrayList<String> candidates = new ArrayList<String>();
        block0: for (String candidate : this.fTraceTypesToScan) {
            for (Map.Entry<String, String> entry : this.fTraceTypes.entrySet()) {
                if (!entry.getValue().equals(candidate)) continue;
                candidates.add(entry.getKey());
                continue block0;
            }
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    public synchronized Object[] getChildren(Object parentElement) {
        Set<FileAndName> children;
        if (parentElement instanceof String && (children = this.fTraceFiles.get(this.fTraceTypes.get(parentElement))) != null) {
            TreeSet<FileAndName> candidates = new TreeSet<FileAndName>();
            for (FileAndName child : children) {
                for (String parent : this.fParentFilesToScan) {
                    if (!child.getFile().getAbsolutePath().startsWith(parent)) continue;
                    candidates.add(child);
                }
            }
            return candidates.toArray(new FileAndName[0]);
        }
        return null;
    }

    public synchronized FileAndName[] getSiblings(FileAndName element) {
        String key = (String)this.getParent(element);
        return (FileAndName[])this.getChildren(key);
    }

    public synchronized Object getParent(Object element) {
        if (element instanceof FileAndName) {
            for (String key : this.fTraceFiles.keySet()) {
                Set<FileAndName> fanSet = this.fTraceFiles.get(key);
                if (!fanSet.contains(element)) continue;
                return key;
            }
        }
        return null;
    }

    public synchronized boolean hasChildren(Object element) {
        if (element instanceof String) {
            String key = (String)element;
            return this.fTraceFiles.containsKey(this.fTraceTypes.get(key));
        }
        return false;
    }

    public synchronized int getSize() {
        int tot = 0;
        for (String s : this.fTraceFiles.keySet()) {
            tot += this.fTraceFiles.get(s).size();
        }
        return tot;
    }
}

