/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.AbstractImportTraceWizardPage;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.BatchImportTraceWizard;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.TraceTypeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;

public class ImportTraceWizardSelectTraceTypePage
extends AbstractImportTraceWizardPage {
    private CheckboxTreeViewer fTreeView;
    private final TraceTypeContentProvider fProvider = new TraceTypeContentProvider();

    protected ImportTraceWizardSelectTraceTypePage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public ImportTraceWizardSelectTraceTypePage(IWorkbench workbench, IStructuredSelection selection) {
        super(workbench, selection);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        TraceTypeCheckListener listener = new TraceTypeCheckListener();
        this.setTitle(Messages.ImportTraceWizardSelectTraceTypePageTitle);
        this.fTreeView = new CheckboxTreeViewer(control, 2048);
        this.fTreeView.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTreeView.setContentProvider((IContentProvider)this.fProvider);
        this.fTreeView.setInput((Object)this.fProvider);
        this.fTreeView.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.fTreeView.addCheckStateListener((ICheckStateListener)listener);
        Composite buttonArea = new Composite(control, 0);
        buttonArea.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonArea.setLayout((Layout)new GridLayout(2, false));
        Button selectAll = new Button(buttonArea, 0);
        selectAll.setText(Messages.ImportTraceWizardSelectAll);
        selectAll.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String[] elements;
                String[] stringArray = elements = (String[])((ITreeContentProvider)ImportTraceWizardSelectTraceTypePage.this.fTreeView.getContentProvider()).getElements(null);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    ImportTraceWizardSelectTraceTypePage.this.fTreeView.setSubtreeChecked((Object)key, true);
                    ++n2;
                }
                ImportTraceWizardSelectTraceTypePage.this.getWizard().getContainer().updateButtons();
            }
        });
        Button selectNone = new Button(buttonArea, 0);
        selectNone.setText(Messages.ImportTraceWizardPageSelectNone);
        selectNone.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        selectNone.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String[] elements;
                String[] stringArray = elements = (String[])((ITreeContentProvider)ImportTraceWizardSelectTraceTypePage.this.fTreeView.getContentProvider()).getElements(null);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    ImportTraceWizardSelectTraceTypePage.this.fTreeView.setSubtreeChecked((Object)key, false);
                    ++n2;
                }
                ImportTraceWizardSelectTraceTypePage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.fTreeView.expandAll();
    }

    public boolean canFlipToNextPage() {
        String[] elements;
        ArrayList<String> tracesToScan = new ArrayList<String>();
        String[] stringArray = elements = (String[])this.fProvider.getElements(null);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String traceFamily = stringArray[n2];
            TraceTypeHelper[] children = (TraceTypeHelper[])this.fProvider.getChildren(traceFamily);
            if (children != null) {
                TraceTypeHelper[] traceTypeHelperArray = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    TraceTypeHelper traceType = traceTypeHelperArray[n4];
                    if (this.fTreeView.getChecked((Object)traceType)) {
                        tracesToScan.add(traceType.getCanonicalName());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        ((BatchImportTraceWizard)this.getWizard()).setTraceTypesToScan(tracesToScan);
        if (tracesToScan.isEmpty()) {
            this.setErrorMessage(Messages.ImportTraceWizardPageSelectHint);
        } else {
            this.setErrorMessage(null);
        }
        return super.canFlipToNextPage() && !tracesToScan.isEmpty();
    }

    private final class TraceTypeCheckListener
    implements ICheckStateListener {
        private TraceTypeCheckListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean checkStatus = event.getChecked();
            Object element = event.getElement();
            ImportTraceWizardSelectTraceTypePage.this.fTreeView.setGrayed(element, false);
            ImportTraceWizardSelectTraceTypePage.this.fTreeView.setSubtreeChecked(element, checkStatus);
            ITreeContentProvider tcp = (ITreeContentProvider)ImportTraceWizardSelectTraceTypePage.this.fTreeView.getContentProvider();
            String parentElement = (String)tcp.getParent(element);
            if (parentElement != null) {
                TraceTypeHelper[] siblings = (TraceTypeHelper[])tcp.getChildren((Object)parentElement);
                TraceTypeHelper first = siblings[0];
                boolean isFirstChecked = ImportTraceWizardSelectTraceTypePage.this.fTreeView.getChecked((Object)first);
                boolean allSame = true;
                TraceTypeHelper[] traceTypeHelperArray = siblings;
                int n = siblings.length;
                int n2 = 0;
                while (n2 < n) {
                    TraceTypeHelper peer = traceTypeHelperArray[n2];
                    boolean peerChecked = ImportTraceWizardSelectTraceTypePage.this.fTreeView.getChecked((Object)peer);
                    if (peerChecked != isFirstChecked) {
                        allSame = false;
                    }
                    ++n2;
                }
                if (allSame) {
                    ImportTraceWizardSelectTraceTypePage.this.fTreeView.setGrayed((Object)parentElement, false);
                    ImportTraceWizardSelectTraceTypePage.this.fTreeView.setChecked((Object)parentElement, checkStatus);
                } else {
                    ImportTraceWizardSelectTraceTypePage.this.fTreeView.setChecked((Object)parentElement, false);
                    ImportTraceWizardSelectTraceTypePage.this.fTreeView.setGrayed((Object)parentElement, true);
                }
            }
            ImportTraceWizardSelectTraceTypePage.this.getWizard().getContainer().updateButtons();
        }
    }
}

