/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import java.util.Arrays;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.linuxtools.tmf.ui.views.histogram.IHistogramDataModel;
import org.eclipse.linuxtools.tmf.ui.views.histogram.IHistogramModelListener;

public class HistogramDataModel
implements IHistogramDataModel {
    public static final int DEFAULT_NUMBER_OF_BUCKETS = 16000;
    public static final int REFRESH_FREQUENCY = 16000;
    private final int fNbBuckets;
    private final long[] fBuckets;
    private long fBucketDuration;
    private long fNbEvents;
    private int fLastBucket;
    private long fFirstBucketTime;
    private long fFirstEventTime;
    private long fLastEventTime;
    private long fSelectionBegin;
    private long fSelectionEnd;
    private long fTimeLimit;
    private final ListenerList fModelListeners;

    public HistogramDataModel() {
        this(0L, 16000);
    }

    public HistogramDataModel(long startTime) {
        this(startTime, 16000);
    }

    public HistogramDataModel(int nbBuckets) {
        this(0L, nbBuckets);
    }

    public HistogramDataModel(long startTime, int nbBuckets) {
        this.fFirstEventTime = this.fLastEventTime = startTime;
        this.fFirstBucketTime = this.fLastEventTime;
        this.fNbBuckets = nbBuckets;
        this.fBuckets = new long[nbBuckets];
        this.fModelListeners = new ListenerList();
        this.clear();
    }

    public HistogramDataModel(HistogramDataModel other) {
        Object[] listeners;
        this.fNbBuckets = other.fNbBuckets;
        this.fBuckets = Arrays.copyOf(other.fBuckets, this.fNbBuckets);
        this.fBucketDuration = Math.max(other.fBucketDuration, 1L);
        this.fNbEvents = other.fNbEvents;
        this.fLastBucket = other.fLastBucket;
        this.fFirstBucketTime = other.fFirstBucketTime;
        this.fFirstEventTime = other.fFirstEventTime;
        this.fLastEventTime = other.fLastEventTime;
        this.fSelectionBegin = other.fSelectionBegin;
        this.fSelectionEnd = other.fSelectionEnd;
        this.fTimeLimit = other.fTimeLimit;
        this.fModelListeners = new ListenerList();
        Object[] objectArray = listeners = other.fModelListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            this.fModelListeners.add(listener);
            ++n2;
        }
    }

    public long getNbEvents() {
        return this.fNbEvents;
    }

    public int getNbBuckets() {
        return this.fNbBuckets;
    }

    public long getBucketDuration() {
        return this.fBucketDuration;
    }

    public long getFirstBucketTime() {
        return this.fFirstBucketTime;
    }

    public long getStartTime() {
        return this.fFirstEventTime;
    }

    public void setTimeRange(long startTime, long endTime) {
        this.fFirstEventTime = this.fLastEventTime = startTime;
        this.fFirstBucketTime = this.fLastEventTime;
        this.fBucketDuration = 1L;
        this.updateEndTime();
        while (endTime >= this.fTimeLimit) {
            this.mergeBuckets();
        }
    }

    public long getEndTime() {
        return this.fLastEventTime;
    }

    @Deprecated
    public long getCurrentEventTime() {
        return this.fSelectionBegin;
    }

    public long getSelectionBegin() {
        return this.fSelectionBegin;
    }

    public long getSelectionEnd() {
        return this.fSelectionEnd;
    }

    public long getTimeLimit() {
        return this.fTimeLimit;
    }

    public void addHistogramListener(IHistogramModelListener listener) {
        this.fModelListeners.add((Object)listener);
    }

    public void removeHistogramListener(IHistogramModelListener listener) {
        this.fModelListeners.remove((Object)listener);
    }

    private void fireModelUpdateNotification() {
        this.fireModelUpdateNotification(0L);
    }

    private void fireModelUpdateNotification(long count) {
        if (count % 16000L == 0L) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fModelListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener2 = objectArray[n2];
                IHistogramModelListener listener = (IHistogramModelListener)listener2;
                listener.modelUpdated();
                ++n2;
            }
        }
    }

    @Override
    public void complete() {
        this.fireModelUpdateNotification();
    }

    @Override
    public void clear() {
        Arrays.fill(this.fBuckets, 0L);
        this.fNbEvents = 0L;
        this.fFirstBucketTime = 0L;
        this.fLastEventTime = 0L;
        this.fSelectionBegin = 0L;
        this.fSelectionEnd = 0L;
        this.fLastBucket = 0;
        this.fBucketDuration = 1L;
        this.updateEndTime();
        this.fireModelUpdateNotification();
    }

    @Deprecated
    public void setCurrentEvent(long timestamp) {
        this.fSelectionBegin = timestamp;
        this.fSelectionEnd = timestamp;
    }

    @Deprecated
    public void setCurrentEventNotifyListeners(long timestamp) {
        this.fSelectionBegin = timestamp;
        this.fSelectionEnd = timestamp;
        this.fireModelUpdateNotification();
    }

    public void setSelection(long beginTime, long endTime) {
        this.fSelectionBegin = beginTime;
        this.fSelectionEnd = endTime;
    }

    public void setSelectionNotifyListeners(long beginTime, long endTime) {
        this.fSelectionBegin = beginTime;
        this.fSelectionEnd = endTime;
        this.fireModelUpdateNotification();
    }

    @Override
    public void countEvent(long eventCount, long timestamp) {
        int index;
        if (timestamp < 0L) {
            return;
        }
        if (this.fFirstBucketTime == 0L && this.fLastBucket == 0 && this.fBuckets[0] == 0L && timestamp > 0L) {
            this.fFirstBucketTime = timestamp;
            this.fFirstEventTime = timestamp;
            this.updateEndTime();
        }
        if (timestamp < this.fFirstEventTime) {
            this.fFirstEventTime = timestamp;
        }
        if (this.fLastEventTime < timestamp) {
            this.fLastEventTime = timestamp;
        }
        if (timestamp >= this.fFirstBucketTime) {
            while (timestamp >= this.fTimeLimit) {
                this.mergeBuckets();
            }
        } else {
            int offset = this.getOffset(timestamp);
            while (this.fLastBucket + offset >= this.fNbBuckets) {
                this.mergeBuckets();
                offset = this.getOffset(timestamp);
            }
            this.moveBuckets(offset);
            this.fLastBucket += offset;
            this.fFirstBucketTime -= (long)offset * this.fBucketDuration;
            this.updateEndTime();
        }
        int n = index = (int)((timestamp - this.fFirstBucketTime) / this.fBucketDuration);
        this.fBuckets[n] = this.fBuckets[n] + 1L;
        ++this.fNbEvents;
        if (this.fLastBucket < index) {
            this.fLastBucket = index;
        }
        this.fireModelUpdateNotification(eventCount);
    }

    @Override
    public HistogramScaledData scaleTo(int width, int height, int barWidth) {
        if (width <= 0 || height <= 0 || barWidth <= 0) {
            throw new AssertionError((Object)("Invalid histogram dimensions (" + width + "x" + height + ", barWidth=" + barWidth + ")"));
        }
        HistogramScaledData result = new HistogramScaledData(width, height, barWidth);
        result.fMaxValue = 0L;
        int nbBars = width / barWidth;
        int bucketsPerBar = this.fLastBucket / nbBars + 1;
        result.fBucketDuration = Math.max((long)bucketsPerBar * this.fBucketDuration, 1L);
        int i = 0;
        while (i < nbBars) {
            int count = 0;
            int j = i * bucketsPerBar;
            while (j < (i + 1) * bucketsPerBar) {
                if (this.fNbBuckets <= j) break;
                count = (int)((long)count + this.fBuckets[j]);
                ++j;
            }
            result.fData[i] = count;
            result.fLastBucket = i;
            if (result.fMaxValue < (long)count) {
                result.fMaxValue = count;
            }
            ++i;
        }
        if (result.fMaxValue > 0L) {
            result.fScalingFactor = (double)height / (double)result.fMaxValue;
        }
        this.fBucketDuration = Math.max(this.fBucketDuration, 1L);
        result.fSelectionBeginBucket = this.fSelectionBegin < this.fFirstBucketTime ? -1 : (this.fSelectionBegin > this.fLastEventTime ? this.fLastBucket : (int)((this.fSelectionBegin - this.fFirstBucketTime) / this.fBucketDuration) / bucketsPerBar);
        result.fSelectionEndBucket = this.fSelectionEnd < this.fFirstBucketTime ? -1 : (this.fSelectionEnd > this.fLastEventTime ? this.fLastBucket : (int)((this.fSelectionEnd - this.fFirstBucketTime) / this.fBucketDuration) / bucketsPerBar);
        result.fFirstBucketTime = this.fFirstBucketTime;
        result.fFirstEventTime = this.fFirstEventTime;
        return result;
    }

    private void updateEndTime() {
        this.fTimeLimit = this.fFirstBucketTime + (long)this.fNbBuckets * this.fBucketDuration;
    }

    private void mergeBuckets() {
        int i = 0;
        while (i < this.fNbBuckets / 2) {
            this.fBuckets[i] = this.fBuckets[2 * i] + this.fBuckets[2 * i + 1];
            ++i;
        }
        Arrays.fill(this.fBuckets, this.fNbBuckets / 2, this.fNbBuckets, 0L);
        this.fBucketDuration *= 2L;
        this.updateEndTime();
        this.fLastBucket = this.fNbBuckets / 2 - 1;
    }

    private void moveBuckets(int offset) {
        int i = this.fNbBuckets - 1;
        while (i >= offset) {
            this.fBuckets[i] = this.fBuckets[i - offset];
            --i;
        }
        i = 0;
        while (i < offset) {
            this.fBuckets[i] = 0L;
            ++i;
        }
    }

    private int getOffset(long timestamp) {
        int offset = (int)((this.fFirstBucketTime - timestamp) / this.fBucketDuration);
        if ((this.fFirstBucketTime - timestamp) % this.fBucketDuration != 0L) {
            ++offset;
        }
        return offset;
    }
}

