/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.core.component.ITmfComponent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalThrottler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.histogram.FullTraceHistogram;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramCurrentTimeControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramRequest;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramTextControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramTimeRangeControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramZoom;
import org.eclipse.linuxtools.tmf.ui.views.histogram.Messages;
import org.eclipse.linuxtools.tmf.ui.views.histogram.TimeRangeHistogram;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class HistogramView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.histogram";
    private Composite fParent;
    private ITmfTrace fTrace;
    private long fTraceStartTime;
    private long fTraceEndTime;
    private long fWindowStartTime;
    private long fWindowEndTime;
    private long fWindowSpan;
    private long fSelectionBeginTime;
    private long fSelectionEndTime;
    private HistogramTextControl fCurrentEventTimeControl;
    private HistogramTextControl fTimeSpanControl;
    private static FullTraceHistogram fFullTraceHistogram;
    private HistogramRequest fFullTraceRequest;
    private static TimeRangeHistogram fTimeRangeHistogram;
    private HistogramRequest fTimeRangeRequest;
    private final TmfSignalThrottler fTimeSyncThrottle = new TmfSignalThrottler((ITmfComponent)this, 200L);
    private final TmfSignalThrottler fTimeRangeSyncThrottle = new TmfSignalThrottler((ITmfComponent)this, 200L);

    public HistogramView() {
        super(ID);
    }

    @Override
    public void dispose() {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        fFullTraceHistogram.dispose();
        fTimeRangeHistogram.dispose();
        this.fCurrentEventTimeControl.dispose();
        this.fTimeSpanControl.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        String currentEventLabel = Messages.HistogramView_currentEventLabel;
        String windowSpanLabel = Messages.HistogramView_windowSpanLabel;
        Composite viewComposite = new Composite(this.fParent, 4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        viewComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        viewComposite.setLayoutData((Object)gridData);
        Composite controlsComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        controlsComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        this.fCurrentEventTimeControl = new HistogramCurrentTimeControl(this, controlsComposite, currentEventLabel, 0L);
        this.fCurrentEventTimeControl.setLayoutData(gridData);
        this.fCurrentEventTimeControl.setValue(Long.MIN_VALUE);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        this.fTimeSpanControl = new HistogramTimeRangeControl(this, controlsComposite, windowSpanLabel, 0L);
        this.fTimeSpanControl.setLayoutData(gridData);
        this.fTimeSpanControl.setValue(Long.MIN_VALUE);
        Composite timeRangeComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        timeRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        timeRangeComposite.setLayoutData((Object)gridData);
        fTimeRangeHistogram = new TimeRangeHistogram(this, timeRangeComposite);
        Composite fullRangeComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        fullRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        fullRangeComposite.setLayoutData((Object)gridData);
        fFullTraceHistogram = new FullTraceHistogram(this, fullRangeComposite);
        HistogramZoom listener = fFullTraceHistogram.getZoom();
        this.fTimeSpanControl.addMouseWheelListener(listener);
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    public void setFocus() {
        HistogramView.fFullTraceHistogram.fCanvas.setFocus();
    }

    void refresh() {
        this.fParent.layout(true);
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(this.fWindowStartTime, -9), (ITmfTimestamp)new TmfTimestamp(this.fWindowEndTime, -9));
    }

    void updateSelectionTime(long beginTime, long endTime) {
        this.updateDisplayedSelectionTime(beginTime, endTime);
        TmfTimestamp beginTs = new TmfTimestamp(beginTime, -9);
        TmfTimestamp endTs = new TmfTimestamp(endTime, -9);
        TmfTimeSynchSignal signal = new TmfTimeSynchSignal((Object)this, (ITmfTimestamp)beginTs, (ITmfTimestamp)endTs);
        this.fTimeSyncThrottle.queue((TmfSignal)signal);
    }

    void updateTimeRange(long startTime, long endTime) {
        if (this.fTrace != null) {
            TmfTimeRange timeRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(startTime, -9), (ITmfTimestamp)new TmfTimestamp(endTime, -9));
            this.fTimeSpanControl.setValue(endTime - startTime);
            this.updateDisplayedTimeRange(startTime, endTime);
            TmfRangeSynchSignal signal = new TmfRangeSynchSignal((Object)this, timeRange);
            this.fTimeRangeSyncThrottle.queue((TmfSignal)signal);
        }
    }

    public synchronized void updateTimeRange(long newDuration) {
        if (this.fTrace != null) {
            long delta = newDuration - this.fWindowSpan;
            long newStartTime = this.fWindowStartTime - delta / 2L;
            this.setNewRange(newStartTime, newDuration);
        }
    }

    private void setNewRange(long startTime, long duration) {
        long endTime;
        long realStart = startTime;
        if (realStart < this.fTraceStartTime) {
            realStart = this.fTraceStartTime;
        }
        if ((endTime = realStart + duration) > this.fTraceEndTime) {
            endTime = this.fTraceEndTime;
            realStart = endTime - duration > this.fTraceStartTime ? endTime - duration : this.fTraceStartTime;
        }
        this.updateTimeRange(realStart, endTime);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        assert (signal != null);
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        assert (signal != null);
        if (this.fTrace != signal.getTrace()) {
            this.fTrace = signal.getTrace();
            this.loadTrace();
        }
    }

    private void loadTrace() {
        this.initializeHistograms();
        this.fParent.redraw();
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        this.fTrace = null;
        this.fTraceStartTime = 0L;
        this.fTraceEndTime = 0L;
        this.fWindowStartTime = 0L;
        this.fWindowEndTime = 0L;
        this.fWindowSpan = 0L;
        this.fSelectionBeginTime = 0L;
        this.fSelectionEndTime = 0L;
        fFullTraceHistogram.clear();
        fTimeRangeHistogram.clear();
        this.fCurrentEventTimeControl.setValue(Long.MIN_VALUE);
        this.fTimeSpanControl.setValue(Long.MIN_VALUE);
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getRange();
        this.fTraceStartTime = fullRange.getStartTime().normalize(0L, -9).getValue();
        this.fTraceEndTime = fullRange.getEndTime().normalize(0L, -9).getValue();
        fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.sendFullRangeRequest(fullRange);
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getTrace().getTimeRange();
        this.fTraceStartTime = fullRange.getStartTime().normalize(0L, -9).getValue();
        this.fTraceEndTime = fullRange.getEndTime().normalize(0L, -9).getValue();
        fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fFullTraceHistogram.setTimeRange(fTimeRangeHistogram.getStartTime(), this.fWindowSpan);
        fTimeRangeHistogram.setTimeRange(fTimeRangeHistogram.getStartTime(), this.fWindowSpan);
        if (this.fFullTraceRequest != null && this.fFullTraceRequest.getRange().getEndTime().compareTo(signal.getRange().getEndTime()) < 0) {
            this.sendFullRangeRequest(fullRange);
        }
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
        assert (signal != null);
        ITmfTimestamp beginTime = signal.getBeginTime().normalize(0L, -9);
        ITmfTimestamp endTime = signal.getEndTime().normalize(0L, -9);
        this.updateDisplayedSelectionTime(beginTime.getValue(), endTime.getValue());
    }

    @TmfSignalHandler
    public void timeRangeUpdated(TmfRangeSynchSignal signal) {
        assert (signal != null);
        if (this.fTrace != null) {
            TmfTimeRange range = signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange());
            if (range == null) {
                return;
            }
            this.updateDisplayedTimeRange(range.getStartTime().normalize(0L, -9).getValue(), range.getEndTime().normalize(0L, -9).getValue());
            this.sendTimeRangeRequest(this.fWindowStartTime, this.fWindowEndTime);
            this.fTimeSpanControl.setValue(this.fWindowSpan);
        }
    }

    private void initializeHistograms() {
        TmfTimeRange fullRange = this.updateTraceTimeRange();
        long selectionBeginTime = this.fTraceManager.getSelectionBeginTime().normalize(0L, -9).getValue();
        long selectionEndTime = this.fTraceManager.getSelectionEndTime().normalize(0L, -9).getValue();
        long startTime = this.fTraceManager.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        long duration = this.fTraceManager.getCurrentRange().getEndTime().normalize(0L, -9).getValue() - startTime;
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        fTimeRangeHistogram.clear();
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setTimeRange(startTime, duration);
        fTimeRangeHistogram.setSelection(selectionBeginTime, selectionEndTime);
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        fFullTraceHistogram.clear();
        fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fFullTraceHistogram.setTimeRange(startTime, duration);
        fFullTraceHistogram.setSelection(selectionBeginTime, selectionEndTime);
        this.fWindowStartTime = startTime;
        this.fWindowSpan = duration;
        this.fWindowEndTime = startTime + duration;
        this.fSelectionBeginTime = selectionBeginTime;
        this.fSelectionEndTime = selectionEndTime;
        this.fCurrentEventTimeControl.setValue(this.fSelectionBeginTime);
        this.fTimeSpanControl.setValue(duration);
        if (!fullRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
            this.sendTimeRangeRequest(startTime, startTime + duration);
            this.sendFullRangeRequest(fullRange);
        }
    }

    private void updateDisplayedSelectionTime(long beginTime, long endTime) {
        this.fSelectionBeginTime = beginTime;
        this.fSelectionEndTime = endTime;
        fFullTraceHistogram.setSelection(this.fSelectionBeginTime, this.fSelectionEndTime);
        fTimeRangeHistogram.setSelection(this.fSelectionBeginTime, this.fSelectionEndTime);
        this.fCurrentEventTimeControl.setValue(this.fSelectionBeginTime);
    }

    private void updateDisplayedTimeRange(long start, long end) {
        this.fWindowStartTime = start;
        this.fWindowEndTime = end;
        this.fWindowSpan = this.fWindowEndTime - this.fWindowStartTime;
        fFullTraceHistogram.setTimeRange(this.fWindowStartTime, this.fWindowSpan);
    }

    private TmfTimeRange updateTraceTimeRange() {
        this.fTraceStartTime = 0L;
        this.fTraceEndTime = 0L;
        TmfTimeRange timeRange = this.fTrace.getTimeRange();
        if (!timeRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
            this.fTraceStartTime = timeRange.getStartTime().normalize(0L, -9).getValue();
            this.fTraceEndTime = timeRange.getEndTime().normalize(0L, -9).getValue();
        }
        return timeRange;
    }

    private void sendTimeRangeRequest(long startTime, long endTime) {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        TmfTimestamp startTS = new TmfTimestamp(startTime, -9);
        TmfTimestamp endTS = new TmfTimestamp(endTime, -9);
        TmfTimeRange timeRange = new TmfTimeRange((ITmfTimestamp)startTS, (ITmfTimestamp)endTS);
        fTimeRangeHistogram.clear();
        fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        fTimeRangeHistogram.setTimeRange(startTime, endTime - startTime);
        int cacheSize = this.fTrace.getCacheSize();
        this.fTimeRangeRequest = new HistogramRequest(fTimeRangeHistogram.getDataModel(), timeRange, 0, Integer.MAX_VALUE, cacheSize, ITmfDataRequest.ExecutionType.FOREGROUND);
        this.fTrace.sendRequest((ITmfDataRequest)this.fTimeRangeRequest);
    }

    private void sendFullRangeRequest(TmfTimeRange fullRange) {
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        int cacheSize = this.fTrace.getCacheSize();
        this.fFullTraceRequest = new HistogramRequest(fFullTraceHistogram.getDataModel(), fullRange, (int)HistogramView.fFullTraceHistogram.fDataModel.getNbEvents(), Integer.MAX_VALUE, cacheSize, ITmfDataRequest.ExecutionType.BACKGROUND);
        this.fTrace.sendRequest((ITmfDataRequest)this.fFullTraceRequest);
    }
}

