/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.timegraph.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphCombo;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;

public abstract class AbstractTimeGraphView
extends TmfView {
    private ITimeGraphWrapper fTimeGraphWrapper;
    private ITmfTrace fTrace;
    private List<TimeGraphEntry> fEntryList;
    private final Map<ITmfTrace, List<TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private final Map<ITmfTrace, BuildThread> fBuildThreadMap = new HashMap<ITmfTrace, BuildThread>();
    private long fStartTime;
    private long fEndTime;
    private final int fDisplayWidth;
    private ZoomThread fZoomThread;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private Comparator<ITimeGraphEntry> fEntryComparator = null;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private final TimeGraphPresentationProvider fPresentation;
    private String[] fColumns;
    private TreeLabelProvider fLabelProvider = null;
    private int[] fWeight = new int[]{1, 1};
    private String[] fFilterColumns;

    public AbstractTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id);
        this.fPresentation = pres;
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    protected TimeGraphCombo getTimeGraphCombo() {
        if (this.fTimeGraphWrapper instanceof TimeGraphComboWrapper) {
            return ((TimeGraphComboWrapper)this.fTimeGraphWrapper).getTimeGraphCombo();
        }
        return null;
    }

    protected TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphWrapper.getTimeGraphViewer();
    }

    protected void setTreeColumns(String[] columns) {
        this.fColumns = columns;
    }

    protected void setTreeLabelProvider(TreeLabelProvider tlp) {
        this.fLabelProvider = tlp;
    }

    protected void setWeight(int[] weights) {
        this.fWeight = weights;
    }

    protected void setFilterColumns(String[] filterColumns) {
        this.fFilterColumns = filterColumns;
    }

    protected int getDisplayWidth() {
        return this.fDisplayWidth;
    }

    protected Comparator<ITimeGraphEntry> getEntryComparator() {
        return this.fEntryComparator;
    }

    protected void setEntryComparator(Comparator<ITimeGraphEntry> comparator) {
        this.fEntryComparator = comparator;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected long getStartTime() {
        return this.fStartTime;
    }

    protected void setStartTime(long time) {
        this.fStartTime = time;
    }

    protected long getEndTime() {
        return this.fEndTime;
    }

    protected void setEndTime(long time) {
        this.fEndTime = time;
    }

    protected Map<ITmfTrace, List<TimeGraphEntry>> getEntryListMap() {
        return Collections.unmodifiableMap(this.fEntryListMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.put(trace, list);
        }
    }

    protected String getNextText() {
        return Messages.AbstractTimeGraphtView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.AbstractTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.AbstractTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.AbstractTimeGraphView_PreviousTooltip;
    }

    public void createPartControl(Composite parent) {
        if (this.fColumns == null || this.fLabelProvider == null) {
            this.fTimeGraphWrapper = new TimeGraphViewerWrapper(parent, 0);
        } else {
            TimeGraphComboWrapper wrapper = new TimeGraphComboWrapper(parent, 0);
            this.fTimeGraphWrapper = wrapper;
            TimeGraphCombo combo = wrapper.getTimeGraphCombo();
            combo.setTreeContentProvider(new TreeContentProvider());
            combo.setTreeLabelProvider(this.fLabelProvider);
            combo.setTreeColumns(this.fColumns);
            combo.setFilterContentProvider(new TreeContentProvider());
            combo.setFilterLabelProvider(new TreeLabelProvider());
            combo.setFilterColumns(this.fFilterColumns);
        }
        this.fTimeGraphWrapper.setTimeGraphProvider(this.fPresentation);
        this.fTimeGraphWrapper.getTimeGraphViewer().addRangeListener(new ITimeGraphRangeListener(){

            @Override
            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(startTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime));
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)AbstractTimeGraphView.this, range));
                if (AbstractTimeGraphView.this.fZoomThread != null) {
                    AbstractTimeGraphView.this.fZoomThread.cancel();
                }
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphWrapper.getTimeGraphViewer().addTimeListener(new ITimeGraphTimeListener(){

            @Override
            public void timeSelected(TimeGraphTimeEvent event) {
                TmfNanoTimestamp startTime = new TmfNanoTimestamp(event.getBeginTime());
                TmfNanoTimestamp endTime = new TmfNanoTimestamp(event.getEndTime());
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)AbstractTimeGraphView.this, (ITmfTimestamp)startTime, (ITmfTimestamp)endTime));
            }
        });
        this.fTimeGraphWrapper.addSelectionListener(new ITimeGraphSelectionListener(){

            @Override
            public void selectionChanged(TimeGraphSelectionEvent event) {
            }
        });
        this.fTimeGraphWrapper.getTimeGraphViewer().setTimeFormat(Utils.TimeFormat.CALENDAR);
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fTimeGraphWrapper.getTimeGraphViewer().getTimeGraphControl().setStatusLineManager(statusLineManager);
        this.makeActions();
        this.contributeToActionBars();
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.getSite().setSelectionProvider(this.fTimeGraphWrapper.getSelectionProvider());
    }

    public void setFocus() {
        this.fTimeGraphWrapper.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        Map<ITmfTrace, Object> map = this.fBuildThreadMap;
        synchronized (map) {
            BuildThread buildThread = this.fBuildThreadMap.remove(signal.getTrace());
            if (buildThread != null) {
                buildThread.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(signal.getTrace());
        }
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fStartTime = 0L;
            this.fEndTime = 0L;
            if (this.fZoomThread != null) {
                this.fZoomThread.cancel();
            }
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        final long beginTime = signal.getBeginTime().normalize(0L, -9).getValue();
        final long endTime = signal.getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                if (beginTime == endTime) {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectedTime(beginTime, true);
                } else {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectionRange(beginTime, endTime);
                }
                AbstractTimeGraphView.this.startZoomThread(AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().getTime0(), AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().getTime1());
                AbstractTimeGraphView.this.synchingToTime(beginTime);
            }
        });
    }

    @TmfSignalHandler
    public void synchToRange(TmfRangeSynchSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        if (signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange()) == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    @TmfSignalHandler
    public void updateTimeFormat(TmfTimestampFormatUpdateSignal signal) {
        this.fTimeGraphWrapper.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace() {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            if (this.fEntryList == null) {
                Map<ITmfTrace, BuildThread> map2 = this.fBuildThreadMap;
                synchronized (map2) {
                    BuildThread buildThread = new BuildThread(this.fTrace, this.getName());
                    this.fBuildThreadMap.put(this.fTrace, buildThread);
                    buildThread.start();
                }
            } else {
                this.fStartTime = this.fTrace.getStartTime().normalize(0L, -9).getValue();
                this.fEndTime = this.fTrace.getEndTime().normalize(0L, -9).getValue();
                this.refresh();
            }
        }
    }

    protected void synchingToTime(long time) {
    }

    protected abstract void buildEventList(ITmfTrace var1, IProgressMonitor var2);

    protected abstract List<ITimeEvent> getEventList(TimeGraphEntry var1, long var2, long var4, long var6, IProgressMonitor var8);

    protected List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                ITimeGraphEntry[] entries = null;
                Map map = AbstractTimeGraphView.this.fEntryListMap;
                synchronized (map) {
                    AbstractTimeGraphView.this.fEntryList = (List)AbstractTimeGraphView.this.fEntryListMap.get(AbstractTimeGraphView.this.fTrace);
                    if (AbstractTimeGraphView.this.fEntryList == null) {
                        AbstractTimeGraphView.this.fEntryList = new ArrayList();
                    }
                    entries = AbstractTimeGraphView.this.fEntryList.toArray(new ITimeGraphEntry[0]);
                }
                if (AbstractTimeGraphView.this.fEntryComparator != null) {
                    Arrays.sort(entries, AbstractTimeGraphView.this.fEntryComparator);
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.setInput(entries);
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setTimeBounds(AbstractTimeGraphView.this.fStartTime, AbstractTimeGraphView.this.fEndTime);
                long selectionBeginTime = AbstractTimeGraphView.this.fTrace == null ? 0L : AbstractTimeGraphView.this.fTraceManager.getSelectionBeginTime().normalize(0L, -9).getValue();
                long selectionEndTime = AbstractTimeGraphView.this.fTrace == null ? 0L : AbstractTimeGraphView.this.fTraceManager.getSelectionEndTime().normalize(0L, -9).getValue();
                long startTime = AbstractTimeGraphView.this.fTrace == null ? 0L : AbstractTimeGraphView.this.fTraceManager.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
                long endTime = AbstractTimeGraphView.this.fTrace == null ? 0L : AbstractTimeGraphView.this.fTraceManager.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
                startTime = Math.max(startTime, AbstractTimeGraphView.this.fStartTime);
                endTime = Math.min(endTime, AbstractTimeGraphView.this.fEndTime);
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectionRange(selectionBeginTime, selectionEndTime);
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                if (AbstractTimeGraphView.this.fTimeGraphWrapper instanceof TimeGraphComboWrapper) {
                    TreeColumn[] treeColumnArray = ((TimeGraphComboWrapper)AbstractTimeGraphView.this.fTimeGraphWrapper).getTreeViewer().getTree().getColumns();
                    int n = treeColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn column = treeColumnArray[n2];
                        column.pack();
                        ++n2;
                    }
                }
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.redraw();
                AbstractTimeGraphView.this.fTimeGraphWrapper.update();
                Object object = AbstractTimeGraphView.this.fSyncObj;
                synchronized (object) {
                    if (AbstractTimeGraphView.this.fRedrawState == State.PENDING) {
                        AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                        AbstractTimeGraphView.this.redraw();
                    } else {
                        AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                    }
                }
            }
        });
    }

    private void startZoomThread(long startTime, long endTime) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.fZoomThread = new ZoomThread(this.fEntryList, startTime, endTime, this.getName());
        this.fZoomThread.start();
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphWrapper.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousResourceAction.setText(this.getPrevText());
        this.fPreviousResourceAction.setToolTipText(this.getPrevTooltip());
        this.fNextResourceAction = this.fTimeGraphWrapper.getTimeGraphViewer().getNextItemAction();
        this.fNextResourceAction.setText(this.getNextText());
        this.fNextResourceAction.setToolTipText(this.getNextTooltip());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.fTimeGraphWrapper instanceof TimeGraphComboWrapper && this.fFilterColumns.length > 0) {
            manager.add(((TimeGraphComboWrapper)this.fTimeGraphWrapper).getShowFilterAction());
        }
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getShowLegendAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getResetScaleAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getPreviousEventAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getNextEventAction());
        manager.add((IAction)this.fPreviousResourceAction);
        manager.add((IAction)this.fNextResourceAction);
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getZoomInAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    private class BuildThread
    extends Thread {
        private final ITmfTrace fBuildTrace;
        private final IProgressMonitor fMonitor;

        public BuildThread(ITmfTrace trace, String name) {
            super(String.valueOf(name) + " build");
            this.fBuildTrace = trace;
            this.fMonitor = new NullProgressMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractTimeGraphView.this.buildEventList(this.fBuildTrace, this.fMonitor);
            Map map = AbstractTimeGraphView.this.fBuildThreadMap;
            synchronized (map) {
                AbstractTimeGraphView.this.fBuildThreadMap.remove(this);
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }

    private static interface ITimeGraphWrapper {
        public void setTimeGraphProvider(TimeGraphPresentationProvider var1);

        public TimeGraphViewer getTimeGraphViewer();

        public void addSelectionListener(ITimeGraphSelectionListener var1);

        public ISelectionProvider getSelectionProvider();

        public void setFocus();

        public boolean isDisposed();

        public void refresh();

        public void setInput(ITimeGraphEntry[] var1);

        public void redraw();

        public void update();
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    private class TimeGraphComboWrapper
    implements ITimeGraphWrapper {
        private TimeGraphCombo combo;

        private TimeGraphComboWrapper(Composite parent, int style) {
            this.combo = new TimeGraphCombo(parent, style, AbstractTimeGraphView.this.fWeight);
        }

        @Override
        public void setTimeGraphProvider(TimeGraphPresentationProvider timeGraphProvider) {
            this.combo.setTimeGraphProvider(timeGraphProvider);
        }

        @Override
        public TimeGraphViewer getTimeGraphViewer() {
            return this.combo.getTimeGraphViewer();
        }

        @Override
        public void addSelectionListener(ITimeGraphSelectionListener listener) {
            this.combo.addSelectionListener(listener);
        }

        @Override
        public ISelectionProvider getSelectionProvider() {
            return this.combo.getTreeViewer();
        }

        @Override
        public void setFocus() {
            this.combo.setFocus();
        }

        @Override
        public boolean isDisposed() {
            return this.combo.isDisposed();
        }

        @Override
        public void setInput(ITimeGraphEntry[] input) {
            this.combo.setInput(input);
        }

        @Override
        public void refresh() {
            this.combo.refresh();
        }

        @Override
        public void redraw() {
            this.combo.redraw();
        }

        @Override
        public void update() {
            this.combo.update();
        }

        TimeGraphCombo getTimeGraphCombo() {
            return this.combo;
        }

        TreeViewer getTreeViewer() {
            return this.combo.getTreeViewer();
        }

        IAction getShowFilterAction() {
            return this.combo.getShowFilterAction();
        }
    }

    private class TimeGraphViewerWrapper
    implements ITimeGraphWrapper {
        private TimeGraphViewer viewer;

        private TimeGraphViewerWrapper(Composite parent, int style) {
            this.viewer = new TimeGraphViewer(parent, style);
        }

        @Override
        public void setTimeGraphProvider(TimeGraphPresentationProvider timeGraphProvider) {
            this.viewer.setTimeGraphProvider(timeGraphProvider);
        }

        @Override
        public TimeGraphViewer getTimeGraphViewer() {
            return this.viewer;
        }

        @Override
        public void addSelectionListener(ITimeGraphSelectionListener listener) {
            this.viewer.addSelectionListener(listener);
        }

        @Override
        public ISelectionProvider getSelectionProvider() {
            return this.viewer.getSelectionProvider();
        }

        @Override
        public void setFocus() {
            this.viewer.setFocus();
        }

        @Override
        public boolean isDisposed() {
            return this.viewer.getControl().isDisposed();
        }

        @Override
        public void setInput(ITimeGraphEntry[] input) {
            this.viewer.setInput(input);
        }

        @Override
        public void refresh() {
            this.viewer.refresh();
        }

        @Override
        public void redraw() {
            this.viewer.getControl().redraw();
        }

        @Override
        public void update() {
            this.viewer.getControl().update();
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (ITimeGraphEntry[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            ITimeGraphEntry entry = (ITimeGraphEntry)parentElement;
            List<? extends ITimeGraphEntry> children = entry.getChildren();
            return children.toArray(new ITimeGraphEntry[children.size()]);
        }

        public Object getParent(Object element) {
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            return entry.getParent();
        }

        public boolean hasChildren(Object element) {
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            return entry.hasChildren();
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return new String();
        }
    }

    private class ZoomThread
    extends Thread {
        private final List<TimeGraphEntry> fZoomEntryList;
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private final IProgressMonitor fMonitor;

        public ZoomThread(List<TimeGraphEntry> entryList, long startTime, long endTime, String name) {
            super(String.valueOf(name) + " zoom");
            this.fZoomEntryList = entryList;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = Math.max(1L, (this.fZoomEndTime - this.fZoomStartTime) / (long)AbstractTimeGraphView.this.fDisplayWidth);
            this.fMonitor = new NullProgressMonitor();
        }

        @Override
        public void run() {
            if (this.fZoomEntryList == null) {
                return;
            }
            for (TimeGraphEntry entry : this.fZoomEntryList) {
                if (this.fMonitor.isCanceled()) {
                    return;
                }
                this.zoom(entry, this.fMonitor);
            }
            List<ILinkEvent> events = AbstractTimeGraphView.this.getLinkList(this.fZoomStartTime, this.fZoomEndTime, this.fResolution, this.fMonitor);
            if (events != null) {
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setLinks(events);
                AbstractTimeGraphView.this.redraw();
            }
        }

        private void zoom(TimeGraphEntry entry, IProgressMonitor monitor) {
            if (this.fZoomStartTime <= AbstractTimeGraphView.this.fStartTime && this.fZoomEndTime >= AbstractTimeGraphView.this.fEndTime) {
                entry.setZoomedEventList(null);
            } else {
                List<ITimeEvent> zoomedEventList = AbstractTimeGraphView.this.getEventList(entry, this.fZoomStartTime, this.fZoomEndTime, this.fResolution, monitor);
                if (zoomedEventList != null) {
                    entry.setZoomedEventList(zoomedEventList);
                }
            }
            AbstractTimeGraphView.this.redraw();
            for (TimeGraphEntry child : entry.getChildren()) {
                if (this.fMonitor.isCanceled()) {
                    return;
                }
                this.zoom(child, monitor);
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }
}

