/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tools.launch.core.factory;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.profiling.launch.RemoteEnvProxyManager;
import org.eclipse.linuxtools.tools.launch.core.properties.LinuxtoolsPathProperty;

public abstract class LinuxtoolsProcessFactory {
    private static final String PATH = "PATH";
    private static final String PATH_EQUAL = "PATH=";
    private static final String SEPARATOR = ":";

    private String getEnvpPath(String[] envp) {
        String[] stringArray = envp;
        int n = envp.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            if (env.startsWith(PATH_EQUAL)) {
                return env.substring(PATH_EQUAL.length());
            }
            ++n2;
        }
        return null;
    }

    protected String[] updateEnvironment(String[] envp, IProject project) {
        if (project == null) {
            return envp;
        }
        if (envp == null) {
            envp = new String[]{};
        }
        String ltPath = LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project);
        String envpPath = this.getEnvpPath(envp);
        String systemPath = null;
        Map systemEnvMap = null;
        try {
            systemEnvMap = ((RemoteEnvProxyManager)RemoteEnvProxyManager.class.newInstance()).getEnv(project);
            systemPath = (String)systemEnvMap.get(PATH);
            if (systemPath == null) {
                systemPath = System.getenv(PATH);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        StringBuffer newPath = new StringBuffer();
        newPath.append(PATH_EQUAL);
        if (ltPath != null && ltPath.length() > 0) {
            newPath.append(ltPath);
            newPath.append(SEPARATOR);
        }
        if (envpPath != null && envpPath.length() > 0) {
            newPath.append(envpPath);
            newPath.append(SEPARATOR);
        }
        if (systemPath != null && systemPath.length() > 0) {
            newPath.append(systemPath);
            newPath.append(SEPARATOR);
        }
        if (newPath.length() == PATH_EQUAL.length()) {
            return envp;
        }
        String[] newEnvp = new String[]{};
        if (envpPath != null) {
            newEnvp = new String[envp.length];
            int i = 0;
            while (i < envp.length) {
                newEnvp[i] = envp[i].startsWith(PATH_EQUAL) ? newPath.toString() : envp[i];
                ++i;
            }
        } else if (systemEnvMap != null) {
            Map envVars = systemEnvMap;
            Set keySet = envVars.keySet();
            newEnvp = new String[envVars.size()];
            int i = 0;
            for (String key : keySet) {
                newEnvp[i] = key.startsWith(PATH) ? (ltPath != null ? String.valueOf(key) + "=" + ltPath + SEPARATOR + (String)envVars.get(key) : String.valueOf(key) + "=" + (String)envVars.get(key)) : String.valueOf(key) + "=" + (String)envVars.get(key);
                ++i;
            }
        } else {
            newEnvp = new String[]{};
        }
        return newEnvp;
    }
}

