/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.trace;

import java.util.HashMap;
import java.util.Map;

public class StreamInputPacketIndexEntry {
    private final long offsetBytes;
    private int dataOffsetBits = 0;
    private int packetSizeBits = 0;
    private int contentSizeBits = 0;
    private long timestampBegin = 0L;
    private long timestampEnd = 0L;
    private long lostEvents = 0L;
    private String target;
    private long targetID;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public StreamInputPacketIndexEntry(long offset) {
        this.offsetBytes = offset;
    }

    boolean includes(long ts) {
        return ts >= this.timestampBegin && ts <= this.timestampEnd;
    }

    public String toString() {
        return "StreamInputPacketIndexEntry [offsetBytes=" + this.offsetBytes + ", timestampBegin=" + this.timestampBegin + ", timestampEnd=" + this.timestampEnd + "]";
    }

    public long getOffsetBytes() {
        return this.offsetBytes;
    }

    public int getDataOffsetBits() {
        return this.dataOffsetBits;
    }

    public void setDataOffsetBits(int dataOffsetBits) {
        this.dataOffsetBits = dataOffsetBits;
    }

    public int getPacketSizeBits() {
        return this.packetSizeBits;
    }

    public void setPacketSizeBits(int packetSizeBits) {
        this.packetSizeBits = packetSizeBits;
    }

    public int getContentSizeBits() {
        return this.contentSizeBits;
    }

    public void setContentSizeBits(int contentSizeBits) {
        this.contentSizeBits = contentSizeBits;
    }

    public long getTimestampBegin() {
        return this.timestampBegin;
    }

    public void setTimestampBegin(long timestampBegin) {
        this.timestampBegin = timestampBegin;
    }

    public long getTimestampEnd() {
        return this.timestampEnd;
    }

    public void setTimestampEnd(long timestampEnd) {
        this.timestampEnd = timestampEnd;
    }

    public long getLostEvents() {
        return this.lostEvents;
    }

    public void setLostEvents(long lostEvents) {
        this.lostEvents = lostEvents;
    }

    public void addAttribute(String field, Object value) {
        this.attributes.put(field, value);
    }

    public Object lookupAttribute(String field) {
        return this.attributes.get(field);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        this.targetID = Integer.parseInt(target.replaceAll("[\\D]", ""));
    }

    public long getTargetId() {
        return this.targetID;
    }
}

