/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class CommentBlock
extends Block {
    private static final Pattern COMMENT_START_PATTERN = Pattern.compile("\\s*(<!--).*");
    private static final Pattern COMMENT_END_PATTERN = Pattern.compile("(-->)");

    protected int processLineContent(String line, int offset) {
        Matcher closeMatcher = COMMENT_END_PATTERN.matcher(line);
        if (offset > 0) {
            closeMatcher.region(offset, line.length());
        }
        if (closeMatcher.find()) {
            int newContentStart = closeMatcher.end(1);
            this.setClosed(true);
            if (newContentStart < line.length()) {
                return newContentStart;
            }
            return -1;
        }
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        Matcher matcher = COMMENT_START_PATTERN.matcher(line);
        if (lineOffset > 0) {
            matcher.region(lineOffset, line.length());
        }
        return matcher.matches();
    }
}

