/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;

public class CPPASTInitializerList
extends ASTNode
implements ICPPASTInitializerList,
IASTAmbiguityParent {
    private static final ICPPASTInitializerClause[] NO_CLAUSES = new ICPPASTInitializerClause[0];
    private ICPPASTInitializerClause[] initializers;
    private int initializersPos = -1;
    private int actualSize;
    private boolean fIsPackExpansion;
    private ICPPEvaluation fEvaluation;

    @Override
    public CPPASTInitializerList copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTInitializerList copy(IASTNode.CopyStyle style) {
        CPPASTInitializerList copy = new CPPASTInitializerList();
        ICPPASTInitializerClause[] iCPPASTInitializerClauseArray = this.getClauses();
        int n = iCPPASTInitializerClauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTInitializerClause initializer = iCPPASTInitializerClauseArray[n2];
            copy.addClause(initializer == null ? null : initializer.copy(style));
            ++n2;
        }
        copy.setOffsetAndLength(this);
        copy.actualSize = this.getSize();
        copy.fIsPackExpansion = this.fIsPackExpansion;
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public int getSize() {
        return this.actualSize;
    }

    public ICPPASTInitializerClause[] getClauses() {
        if (this.initializers == null) {
            return NO_CLAUSES;
        }
        this.initializers = ArrayUtil.trimAt(ICPPASTInitializerClause.class, this.initializers, this.initializersPos);
        return this.initializers;
    }

    @Override
    @Deprecated
    public IASTInitializer[] getInitializers() {
        ICPPASTInitializerClause[] clauses = this.getClauses();
        if (clauses.length == 0) {
            return IASTInitializer.EMPTY_INITIALIZER_ARRAY;
        }
        IASTInitializer[] inits = new IASTInitializer[clauses.length];
        int i = 0;
        while (i < inits.length) {
            ICPPASTInitializerClause clause = clauses[i];
            if (clause instanceof IASTInitializer) {
                inits[i] = (IASTInitializer)((Object)clause);
            } else if (clause instanceof IASTExpression) {
                CPPASTEqualsInitializer initExpr = new CPPASTEqualsInitializer(((IASTExpression)((Object)clause)).copy());
                initExpr.setParent(this);
                initExpr.setPropertyInParent(NESTED_INITIALIZER);
                inits[i] = initExpr;
            }
            ++i;
        }
        return inits;
    }

    @Override
    public void addClause(IASTInitializerClause d) {
        this.assertNotFrozen();
        if (d != null) {
            this.initializers = ArrayUtil.appendAt(ICPPASTInitializerClause.class, this.initializers, ++this.initializersPos, (ICPPASTInitializerClause)d);
            d.setParent(this);
            d.setPropertyInParent(NESTED_INITIALIZER);
        }
        ++this.actualSize;
    }

    @Override
    @Deprecated
    public void addInitializer(IASTInitializer d) {
        this.assertNotFrozen();
        if (d instanceof IASTInitializerClause) {
            this.addClause((IASTInitializerClause)((Object)d));
        } else if (d instanceof IASTEqualsInitializer) {
            this.addClause(((IASTEqualsInitializer)d).getInitializerClause());
        } else {
            this.addClause(null);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        ICPPASTInitializerClause[] list;
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICPPASTInitializerClause[] iCPPASTInitializerClauseArray = list = this.getClauses();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTInitializerClause clause = iCPPASTInitializerClauseArray[n2];
            if (!clause.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitInitializers || action.leave(this) != 2;
    }

    @Override
    public boolean isPackExpansion() {
        return this.fIsPackExpansion;
    }

    @Override
    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fIsPackExpansion = val;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.initializers != null) {
            int i = 0;
            while (i < this.initializers.length) {
                if (child == this.initializers[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.initializers[i] = (ICPPASTInitializerClause)other;
                }
                ++i;
            }
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.createEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation createEvaluation() {
        ICPPASTInitializerClause[] clauses = this.getClauses();
        ICPPEvaluation[] evals = new ICPPEvaluation[clauses.length];
        int i = 0;
        while (i < evals.length) {
            evals[i] = clauses[i].getEvaluation();
            ++i;
        }
        return new EvalInitList(evals, this);
    }
}

