/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConversionName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.core.runtime.PlatformObject;

public class CPPClosureType
extends PlatformObject
implements ICPPClassType,
ICPPInternalBinding {
    private static final CPPBasicType NO_RETURN_TYPE = new CPPBasicType(IBasicType.Kind.eUnspecified, 0);
    private final ICPPASTLambdaExpression fLambdaExpression;
    private ICPPMethod[] fMethods;
    private ClassScope fScope;

    public CPPClosureType(ICPPASTLambdaExpression lambdaExpr) {
        this.fLambdaExpression = lambdaExpr;
    }

    private ICPPMethod[] createMethods() {
        boolean needConversionOperator = this.fLambdaExpression.getCaptureDefault() == ICPPASTLambdaExpression.CaptureDefault.UNSPECIFIED && this.fLambdaExpression.getCaptures().length == 0;
        ICPPClassScope scope = this.getCompositeScope();
        ICPPMethod[] result = new ICPPMethod[needConversionOperator ? 6 : 5];
        CPPImplicitConstructor ctor = new CPPImplicitConstructor(scope, CharArrayUtils.EMPTY, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY);
        ctor.setDeleted(true);
        result[0] = ctor;
        CPPReferenceType pType = new CPPReferenceType(SemanticUtil.constQualify(this), false);
        IParameter[] ps = new ICPPParameter[]{new CPPParameter(pType, 0)};
        ctor = new CPPImplicitConstructor(scope, CharArrayUtils.EMPTY, (ICPPParameter[])ps);
        result[1] = ctor;
        CPPReferenceType refType = new CPPReferenceType(this, false);
        ICPPFunctionType ft = CPPVisitor.createImplicitFunctionType(refType, ps, false, false);
        CPPImplicitMethod m = new CPPImplicitMethod(scope, OverloadableOperator.ASSIGN.toCharArray(), ft, (ICPPParameter[])ps);
        result[2] = m;
        ft = CPPVisitor.createImplicitFunctionType(NO_RETURN_TYPE, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, false, false);
        m = new CPPImplicitMethod(scope, new char[]{'~'}, ft, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY);
        result[3] = m;
        IType returnType = this.getReturnType();
        IType[] parameterTypes = this.getParameterTypes();
        ft = new CPPFunctionType(returnType, parameterTypes, !this.isMutable(), false, false);
        ICPPParameter[] params = new ICPPParameter[parameterTypes.length];
        int i = 0;
        while (i < params.length) {
            params[i] = new CPPParameter(parameterTypes[i], i);
            ++i;
        }
        m = new CPPImplicitMethod(scope, OverloadableOperator.PAREN.toCharArray(), ft, params){

            @Override
            public boolean isImplicit() {
                return false;
            }
        };
        result[4] = m;
        if (needConversionOperator) {
            CPPFunctionType conversionTarget = new CPPFunctionType(returnType, parameterTypes);
            ft = new CPPFunctionType(conversionTarget, IType.EMPTY_TYPE_ARRAY, true, false, false);
            m = new CPPImplicitMethod(scope, CPPASTConversionName.createName(conversionTarget, null), ft, params);
            result[5] = m;
        }
        return result;
    }

    public ICPPMethod getFunctionCallOperator() {
        return this.getMethods()[4];
    }

    private boolean isMutable() {
        ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
        return lambdaDtor != null && lambdaDtor.isMutable();
    }

    private IType getReturnType() {
        IASTReturnStatement rtstmt;
        IASTExpression expr;
        IASTStatement stmt;
        IASTStatement[] stmts;
        IASTTypeId trailingReturnType;
        ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
        if (lambdaDtor != null && (trailingReturnType = lambdaDtor.getTrailingReturnType()) != null) {
            return CPPVisitor.createType(trailingReturnType);
        }
        IASTCompoundStatement body = this.fLambdaExpression.getBody();
        if (body != null && (stmts = body.getStatements()).length > 0 && (stmt = stmts[stmts.length - 1]) instanceof IASTReturnStatement && (expr = (rtstmt = (IASTReturnStatement)stmt).getReturnValue()) != null) {
            IType type = expr.getExpressionType();
            if ((type = Conversions.lvalue_to_rvalue(type, false)) != null) {
                return type;
            }
        }
        return CPPSemantics.VOID_TYPE;
    }

    private IType[] getParameterTypes() {
        ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
        if (lambdaDtor != null) {
            return CPPVisitor.createParameterTypes(lambdaDtor);
        }
        return IType.EMPTY_TYPE_ARRAY;
    }

    @Override
    public final String getName() {
        return "";
    }

    @Override
    public char[] getNameCharArray() {
        return CharArrayUtils.EMPTY;
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.fLambdaExpression);
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        if (this.fScope == null) {
            this.fScope = new ClassScope();
        }
        return this.fScope;
    }

    @Override
    public int getKey() {
        return 3;
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() {
        return this.getOwner() == null;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    @Override
    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    public ICPPField[] getFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public ICPPMethod[] getMethods() {
        if (this.fMethods == null) {
            this.fMethods = this.createMethods();
        }
        return this.fMethods;
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        ICPPMethod[] methods = this.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!(methods[i] instanceof ICPPConstructor)) break;
            ++i;
        }
        ICPPConstructor[] result = new ICPPConstructor[i];
        System.arraycopy(methods, 0, result, 0, i);
        return result;
    }

    @Override
    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public IField findField(String name) {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return this.fLambdaExpression.getRawSignature();
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findDeclarationOwner(this.fLambdaExpression, true);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public IASTNode getDefinition() {
        return this.fLambdaExpression;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return IASTNode.EMPTY_NODE_ARRAY;
    }

    @Override
    public void addDefinition(IASTNode node) {
    }

    @Override
    public void addDeclaration(IASTNode node) {
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public int getVisibility(IBinding member) {
        throw new IllegalArgumentException(String.valueOf(member.getName()) + " is not a member of " + this.getName());
    }

    private final class ClassScope
    implements ICPPClassScope {
        private ClassScope() {
        }

        @Override
        public EScopeKind getKind() {
            return EScopeKind.eClassType;
        }

        @Override
        public IName getScopeName() {
            return null;
        }

        @Override
        public IScope getParent() {
            return CPPClosureType.this.getScope();
        }

        private IBinding getBinding(char[] name) {
            ICPPMethod[] iCPPMethodArray = CPPClosureType.this.getMethods();
            int n = iCPPMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod m = iCPPMethodArray[n2];
                if (!(m instanceof ICPPConstructor) && CharArrayUtils.equals(name, m.getNameCharArray())) {
                    return m;
                }
                ++n2;
            }
            return null;
        }

        private IBinding[] getBindings(char[] name) {
            IBinding m = this.getBinding(name);
            if (m != null) {
                return new IBinding[]{m};
            }
            return IBinding.EMPTY_BINDING_ARRAY;
        }

        private IBinding[] getPrefixBindings(char[] name) {
            ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
            IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(name);
            ICPPMethod[] iCPPMethodArray = CPPClosureType.this.getMethods();
            int n = iCPPMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod m = iCPPMethodArray[n2];
                if (!(m instanceof ICPPConstructor) && matcher.match(m.getNameCharArray())) {
                    result.add(m);
                }
                ++n2;
            }
            return result.toArray(new IBinding[result.size()]);
        }

        @Override
        public IBinding[] find(String name) {
            return this.getBindings(name.toCharArray());
        }

        @Override
        public IBinding getBinding(IASTName name, boolean resolve) {
            if (name instanceof ICPPASTTemplateId) {
                return null;
            }
            return this.getBinding(name.getSimpleID());
        }

        @Override
        public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet acceptLocalBindings) {
            return this.getBinding(name, resolve);
        }

        @Override
        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) {
            return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
        }

        @Override
        @Deprecated
        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet acceptLocalBindings) {
            return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
        }

        @Override
        public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
            if (lookup.getLookupName() instanceof ICPPASTTemplateId) {
                return IBinding.EMPTY_BINDING_ARRAY;
            }
            if (lookup.isPrefixLookup()) {
                return this.getPrefixBindings(lookup.getLookupKey());
            }
            return this.getBindings(lookup.getLookupKey());
        }

        @Override
        public ICPPClassType getClassType() {
            return CPPClosureType.this;
        }

        @Override
        public ICPPMethod[] getImplicitMethods() {
            return CPPClosureType.this.getMethods();
        }

        @Override
        public ICPPConstructor[] getConstructors() {
            return CPPClosureType.this.getConstructors();
        }
    }
}

