/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import com.ibm.icu.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CCorePreferenceConstants;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IncludeExportPatterns;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.pdom.AbstractIndexerTask;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.indexer.AbstractPDOMIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskUpdater;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class PDOMIndexerTask
extends AbstractIndexerTask
implements IPDOMIndexerTask {
    private static final String TRUE = "true";
    private AbstractPDOMIndexer fIndexer;
    private boolean fWriteInfoToLog;

    protected PDOMIndexerTask(ITranslationUnit[] forceFiles, ITranslationUnit[] updateFiles, ITranslationUnit[] removeFiles, AbstractPDOMIndexer indexer, boolean isFastIndexer) {
        super(PDOMIndexerTask.concat(forceFiles, updateFiles), removeFiles, new ProjectIndexerInputAdapter(indexer.getProject()), isFastIndexer);
        this.fIndexer = indexer;
        this.setShowActivity(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/activity", TRUE));
        this.setShowInclusionProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems/inclusion", TRUE));
        this.setShowScannerProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems/scanner", TRUE));
        this.setShowSyntaxProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems/syntax", TRUE));
        this.setShowProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems", TRUE));
        long limit = this.getIntProperty("skipFilesLargerThanMB", 0);
        this.setFileSizeLimit(limit * 1024L * 1024L);
        if (this.checkProperty("skipReferences")) {
            this.setSkipReferences(SKIP_ALL_REFERENCES);
        } else {
            int skipRefs = 0;
            if (this.checkProperty("skipImplicitReferences")) {
                skipRefs |= SKIP_IMPLICIT_REFERENCES;
            }
            if (this.checkProperty("skipTypeReferences")) {
                skipRefs |= SKIP_TYPE_REFERENCES;
            }
            if (this.checkProperty("skipMacroReferences")) {
                skipRefs |= SKIP_MACRO_REFERENCES;
            }
            if (skipRefs != 0) {
                this.setSkipReferences(skipRefs);
            }
        }
        if (this.checkProperty("indexAllFiles")) {
            this.setIndexFilesWithoutBuildConfiguration(true);
            boolean i1 = this.checkProperty("indexUnusedHeadersWithDefaultLang");
            boolean i2 = this.checkProperty("indexUnusedHeadersWithAlternateLang");
            AbstractIndexerTask.UnusedHeaderStrategy strategy = i1 == i2 ? (i1 ? AbstractIndexerTask.UnusedHeaderStrategy.useBoth : AbstractIndexerTask.UnusedHeaderStrategy.skip) : (i1 == CProject.hasCCNature(this.getCProject().getProject()) ? AbstractIndexerTask.UnusedHeaderStrategy.useCPP : AbstractIndexerTask.UnusedHeaderStrategy.useC);
            this.setIndexHeadersWithoutContext(strategy);
        } else {
            this.setIndexFilesWithoutBuildConfiguration(false);
            this.setIndexHeadersWithoutContext(AbstractIndexerTask.UnusedHeaderStrategy.skip);
        }
        this.setUpdateFlags(18);
        this.setForceFirstFiles(forceFiles.length);
    }

    private static ITranslationUnit[] concat(ITranslationUnit[] added, ITranslationUnit[] changed) {
        HashSet<ITranslationUnit> union = new HashSet<ITranslationUnit>(added.length + changed.length);
        union.addAll(Arrays.asList(added));
        union.addAll(Arrays.asList(changed));
        ITranslationUnit[] result = union.toArray(new ITranslationUnit[union.size()]);
        Arrays.sort(result, new Comparator<ITranslationUnit>(){

            @Override
            public int compare(ITranslationUnit o1, ITranslationUnit o2) {
                IResource res1 = o1.getResource();
                IResource res2 = o2.getResource();
                if (res1 != null && res2 != null) {
                    return this.compare(res1.getFullPath().segments(), res2.getFullPath().segments());
                }
                return res1 != null ? -1 : (res2 != null ? 1 : 0);
            }

            @Override
            private int compare(String[] s1, String[] s2) {
                int max = Math.min(s1.length, s2.length) - 1;
                int i = 0;
                while (i < max) {
                    int cmp = s1[i].compareTo(s2[i]);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
                int cmp = s1.length - s2.length;
                if (cmp != 0) {
                    return cmp;
                }
                return s1[max].compareTo(s2[max]);
            }
        });
        return result;
    }

    @Override
    public final IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    @Override
    public final void run(IProgressMonitor monitor) throws InterruptedException {
        long start = System.currentTimeMillis();
        this.runTask(monitor);
        this.traceEnd(start, this.fIndex, monitor.isCanceled());
    }

    public static boolean checkDebugOption(String option, String value) {
        String trace = Platform.getDebugOption((String)option);
        boolean internallyActivated = Boolean.getBoolean(option);
        return internallyActivated || trace != null && trace.equalsIgnoreCase(value);
    }

    private boolean checkProperty(String key) {
        return TRUE.equals(this.getIndexer().getProperty(key));
    }

    private int getIntProperty(String key, int defaultValue) {
        String value = this.getIndexer().getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    @Override
    protected final IWritableIndex createIndex() {
        try {
            return ((IWritableIndexManager)CCorePlugin.getIndexManager()).getWritableIndex(this.getCProject());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    protected final ITodoTaskUpdater createTodoTaskUpdater() {
        return new TodoTaskUpdater();
    }

    @Override
    protected final IncludeExportPatterns getIncludeExportPatterns() {
        ICProject project = this.getCProject();
        String exportPattern = CCorePreferenceConstants.getPreference("includes.exportPattern", project, null);
        String beginExportsPattern = CCorePreferenceConstants.getPreference("includes.beginExportsPattern", project, null);
        String endExportsPattern = CCorePreferenceConstants.getPreference("includes.endExportsPattern", project, null);
        if (exportPattern == null && beginExportsPattern == null && endExportsPattern == null) {
            return null;
        }
        return new IncludeExportPatterns(exportPattern, beginExportsPattern, endExportsPattern);
    }

    protected void traceEnd(long start, IWritableIndex index, boolean wasCancelled) {
        if (this.fWriteInfoToLog && !wasCancelled && index != null) {
            long totalTime = System.currentTimeMillis() - start;
            IndexerProgress info = this.getProgressInformation();
            int sum = this.fStatistics.fDeclarationCount + this.fStatistics.fReferenceCount + this.fStatistics.fProblemBindingCount;
            double problemPct = sum == 0 ? 0.0 : (double)this.fStatistics.fProblemBindingCount / (double)sum;
            NumberFormat nfGroup = NumberFormat.getNumberInstance();
            nfGroup.setGroupingUsed(true);
            NumberFormat nfPercent = NumberFormat.getPercentInstance();
            nfPercent.setMaximumFractionDigits(2);
            nfPercent.setMinimumFractionDigits(2);
            NumberFormat nfTime = NumberFormat.getNumberInstance();
            nfTime.setMaximumFractionDigits(2);
            nfTime.setMinimumFractionDigits(2);
            nfTime.setGroupingUsed(true);
            String msg = NLS.bind((String)Messages.PDOMIndexerTask_indexerInfo, (Object[])new Object[]{this.getCProject().getElementName(), nfGroup.format((long)info.fCompletedSources), nfGroup.format((long)info.fCompletedHeaders), nfTime.format((double)totalTime / 1000.0), nfGroup.format((long)this.fStatistics.fDeclarationCount), nfGroup.format((long)this.fStatistics.fReferenceCount), nfGroup.format((long)this.fStatistics.fUnresolvedIncludesCount), nfGroup.format((long)(this.fStatistics.fPreprocessorProblemCount + this.fStatistics.fSyntaxProblemsCount)), nfGroup.format((long)this.fStatistics.fProblemBindingCount), nfPercent.format(problemPct)});
            CCorePlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.cdt.core", msg));
        }
        if (PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/statistics", TRUE)) {
            String ident = "   ";
            long totalTime = System.currentTimeMillis() - start;
            IndexerProgress info = this.getProgressInformation();
            int sum = this.fStatistics.fDeclarationCount + this.fStatistics.fReferenceCount + this.fStatistics.fProblemBindingCount;
            double problemPct = sum == 0 ? 0.0 : (double)this.fStatistics.fProblemBindingCount / (double)sum;
            String kind = this.getIndexer().getClass().getName();
            kind = kind.substring(kind.lastIndexOf(46) + 1);
            long dbSize = index.getDatabaseSizeBytes();
            System.out.println("C/C++ Indexer: Project '" + this.getCProject().getElementName() + "' (" + info.fCompletedSources + " sources, " + info.fCompletedHeaders + " headers)");
            boolean skipRefs = this.checkProperty("skipReferences");
            boolean skipImplRefs = skipRefs || this.checkProperty("skipImplicitReferences");
            boolean skipTypeRefs = skipRefs || this.checkProperty("skipTypeReferences");
            boolean skipMacroRefs = skipRefs || this.checkProperty("skipMacroReferences");
            System.out.println(String.valueOf(ident) + " Options: " + "indexer='" + kind + "', parseAllFiles=" + this.indexFilesWithoutConfiguration() + ", unusedHeaders=" + (Object)((Object)this.getIndexHeadersWithoutContext()) + ", skipReferences=" + skipRefs + ", skipImplicitReferences=" + skipImplRefs + ", skipTypeReferences=" + skipTypeRefs + ", skipMacroReferences=" + skipMacroRefs + ".");
            System.out.println(String.valueOf(ident) + " Database: " + dbSize + " bytes");
            System.out.println(String.valueOf(ident) + " Timings: " + totalTime + " total, " + this.fStatistics.fParsingTime + " parser, " + this.fStatistics.fResolutionTime + " resolution, " + this.fStatistics.fAddToIndexTime + " index update.");
            System.out.println(String.valueOf(ident) + " Errors: " + this.fStatistics.fErrorCount + " internal, " + this.fStatistics.fUnresolvedIncludesCount + " include, " + this.fStatistics.fPreprocessorProblemCount + " scanner, " + this.fStatistics.fSyntaxProblemsCount + " syntax errors.");
            NumberFormat nfPercent = NumberFormat.getPercentInstance();
            nfPercent.setMaximumFractionDigits(2);
            nfPercent.setMinimumFractionDigits(2);
            System.out.println(String.valueOf(ident) + " Names: " + this.fStatistics.fDeclarationCount + " declarations, " + this.fStatistics.fReferenceCount + " references, " + this.fStatistics.fProblemBindingCount + "(" + nfPercent.format(problemPct) + ") unresolved.");
            long misses = index.getCacheMisses();
            long hits = index.getCacheHits();
            long tries = misses + hits;
            double missPct = tries == 0L ? 0.0 : (double)misses / (double)tries;
            System.out.println(String.valueOf(ident) + " Cache[" + ChunkCache.getSharedInstance().getMaxSize() / 1024L / 1024L + "MB]: " + hits + " hits, " + misses + "(" + nfPercent.format(missPct) + ") misses.");
            if (TRUE.equals(System.getProperty("SHOW_COMPRESSED_INDEXER_INFO"))) {
                Calendar cal = Calendar.getInstance();
                NumberFormat twoDigits = NumberFormat.getNumberInstance();
                twoDigits.setMinimumIntegerDigits(2);
                NumberFormat nfGroup = NumberFormat.getNumberInstance();
                nfGroup.setGroupingUsed(true);
                System.out.print("|");
                System.out.print(String.valueOf(cal.get(1)) + twoDigits.format((long)(cal.get(2) + 1)) + twoDigits.format((long)cal.get(5)));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)info.fCompletedSources));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)info.fCompletedHeaders));
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((totalTime + 500L) / 1000L)) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((long)((this.fStatistics.fParsingTime + 500) / 1000))) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((long)((this.fStatistics.fResolutionTime + 500) / 1000))) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((long)((this.fStatistics.fAddToIndexTime + 500) / 1000))) + "s");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((dbSize + 524288L) / 1024L / 1024L)) + "MB");
                System.out.print("|  ");
                System.out.print(String.valueOf(nfGroup.format((tries + 500000L) / 1000000L)) + "M");
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)this.fStatistics.fDeclarationCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)this.fStatistics.fReferenceCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)this.fStatistics.fProblemBindingCount));
                System.out.print("|  ");
                System.out.print(nfPercent.format(problemPct));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)this.fStatistics.fErrorCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)this.fStatistics.fUnresolvedIncludesCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)this.fStatistics.fPreprocessorProblemCount));
                System.out.print("|  ");
                System.out.print(nfGroup.format((long)this.fStatistics.fSyntaxProblemsCount));
                System.out.println("|");
            }
        }
    }

    protected ICProject getCProject() {
        return this.fIndexer.project;
    }

    public void setWriteInfoToLog() {
        this.fWriteInfoToLog = true;
    }

    @Override
    public synchronized boolean acceptUrgentTask(IPDOMIndexerTask urgentTask) {
        IPDOMIndexer ti = urgentTask.getIndexer();
        if (this.fIndexer == null || ti == null || this.fIndexer.getProject().getProject() != ti.getProject().getProject()) {
            return false;
        }
        return super.acceptUrgentTask(urgentTask);
    }
}

