﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;


namespace FineUI.Examples
{
    public class PageBase : System.Web.UI.Page
    {
        #region OnInit

        protected override void OnInit(EventArgs e)
        {
            if (!IsPostBack)
            {
                if (PageManager.Instance != null)
                {
                    HttpCookie themeCookie = Request.Cookies["Theme_v4"];
                    if (themeCookie != null)
                    {
                        string themeValue = themeCookie.Value;
                        PageManager.Instance.Theme = (Theme)Enum.Parse(typeof(Theme), themeValue, true);

                        //if (IsSystemTheme(themeValue))
                        //{
                        //    PageManager.Instance.Theme = (Theme)Enum.Parse(typeof(Theme), themeValue, true);
                        //}
                        //else
                        //{
                        //    PageManager.Instance.CustomTheme = themeValue;
                        //}
                    }

                    HttpCookie langCookie = Request.Cookies["Language_v4"];
                    if (langCookie != null)
                    {
                        string langValue = langCookie.Value;
                        PageManager.Instance.Language = (Language)Enum.Parse(typeof(Language), langValue, true);
                    }
                }
            }

            base.OnInit(e);
        }

        private bool IsSystemTheme(string themeName)
        {
            themeName = themeName.ToLower();
            string[] themes = Enum.GetNames(typeof(Theme));
            foreach (string theme in themes)
            {
                if (theme.ToLower() == themeName)
                {
                    return true;
                }
            }
            return false;
        }

        #endregion

        #region 上传文件类型判断

        protected readonly static List<string> VALID_FILE_TYPES = new List<string> { "jpg", "bmp", "gif", "jpeg", "png" };

        protected static bool ValidateFileType(string fileName)
        {
            string fileType = String.Empty;
            int lastDotIndex = fileName.LastIndexOf(".");
            if (lastDotIndex >= 0)
            {
                fileType = fileName.Substring(lastDotIndex + 1).ToLower();
            }

            if (VALID_FILE_TYPES.Contains(fileType))
            {
                return true;
            }
            else
            {
                return false;
            }
        }


        #endregion

        #region 省市县

        protected readonly static JArray SHENG_JSON = JArray.Parse("[\"北京\",\"天津\",\"上海\",\"重庆\",\"河北\",\"山西\",\"辽宁\",\"吉林\",\"黑龙江\",\"江苏\",\"浙江\",\"安徽\",\"福建\",\"江西\",\"山东\",\"河南\",\"湖北\",\"湖南\",\"广东\",\"海南\",\"四川\",\"贵州\",\"云南\",\"陕西\",\"甘肃\",\"青海\",\"内蒙古\",\"广西\",\"西藏\",\"宁夏\",\"新疆\",\"香港\",\"澳门\",\"台湾\"]");
        protected readonly static JObject SHI_JSON = JObject.Parse("{\"北京\":[\"北京市\"],\"天津\":[\"天津市\"],\"上海\":[\"上海市\"],\"重庆\":[\"重庆市\"],\"河北\":[\"石家庄市\",\"唐山市\",\"秦皇岛市\",\"邯郸市\",\"邢台市\",\"保定市\",\"张家口市\",\"承德市\",\"沧州市\",\"廊坊市\",\"衡水市\"],\"山西\":[\"太原市\",\"大同市\",\"阳泉市\",\"长治市\",\"晋城市\",\"朔州市\",\"晋中市运城市忻州市\",\"临汾市\",\"吕梁市\"],\"辽宁\":[\"沈阳市\",\"大连市\",\"鞍山市\",\"抚顺市\",\"本溪市\",\"丹东市\",\"锦州市\",\"营口市\",\"阜新市\",\"辽阳市\",\"盘锦市\",\"铁岭市\",\"朝阳市\",\"葫芦岛市\"],\"吉林\":[\"长春市\",\"吉林市\",\"四平市\",\"辽源市\",\"通化市\",\"白山市\",\"松原市\",\"白城市\",\"延边朝鲜族自治州\"],\"黑龙江\":[\"哈尔滨市\",\"齐齐哈尔市\",\"鹤岗市\",\"双鸭山市\",\"鸡西市\",\"大庆市\",\"伊春市\",\"牡丹江市\",\"佳木斯市\",\"七台河市\",\"黑河市\",\"绥化市\",\"大兴安岭地区\"],\"江苏\":[\"南京市\",\"苏州市\",\"无锡市\",\"常州市\",\"镇江市\",\"南通市\",\"泰州市\",\"扬州市\",\"盐城市\",\"连云港市\",\"徐州市\",\"淮安市\",\"宿迁市\"],\"浙江\":[\"杭州市\",\"宁波市\",\"温州市\",\"嘉兴市\",\"湖州市\",\"绍兴市\",\"金华市\",\"衢州市\",\"舟山市\",\"台州市\",\"丽水市\"],\"安徽\":[\"合肥市\",\"芜湖市\",\"蚌埠市\",\"淮南市\",\"马鞍山市\",\"淮北市\",\"铜陵市\",\"安庆市\",\"黄山市\",\"滁州市\",\"阜阳市\",\"宿州市\",\"巢湖市\",\"六安市\",\"亳州市\",\"池州市\",\"宣城市\"],\"福建\":[\"福州市\",\"厦门市\",\"莆田市\",\"三明市\",\"泉州市\",\"漳州市\",\"南平市\",\"龙岩市\",\"宁德市\"],\"江西\":[\"南昌市\",\"景德镇市\",\"萍乡市\",\"九江市\",\"新余市\",\"鹰潭市\",\"赣州市\",\"吉安市\",\"宜春市\",\"抚州市\",\"上饶市\"],\"山东\":[\"济南市\",\"青岛市\",\"淄博市\",\"枣庄市\",\"东营市\",\"烟台市\",\"潍坊市\",\"济宁市\",\"泰安市\",\"威海市\",\"日照市\",\"莱芜市\",\"临沂市\",\"德州市\",\"聊城市\",\"滨州市\",\"菏泽市\"],\"河南\":[\"郑州市\",\"开封市\",\"洛阳市\",\"平顶山市\",\"安阳市\",\"鹤壁市\",\"新乡市\",\"焦作市\",\"濮阳市\",\"许昌市\",\"漯河市\",\"三门峡市\",\"南阳市\",\"商丘市\",\"信阳市\",\"周口市\",\"驻马店市\",\"济源市\"],\"湖北\":[\"武汉市\",\"黄石市\",\"十堰市\",\"荆州市\",\"宜昌市\",\"襄樊市\",\"鄂州市\",\"荆门市\",\"孝感市\",\"黄冈市\",\"咸宁市\",\"随州市\",\"恩施土家族苗族自治州\",\"仙桃市\",\"天门市\",\"潜江市\",\"神农架林区\"],\"湖南\":[\"长沙市\",\"株洲市\",\"湘潭市\",\"衡阳市\",\"邵阳市\",\"岳阳市\",\"常德市\",\"张家界市\",\"益阳市\",\"郴州市\",\"永州市\",\"怀化市\",\"娄底市\",\"湘西土家族苗族自治州\"],\"广东\":[\"广州市\",\"深圳市\",\"珠海市\",\"汕头市\",\"韶关市\",\"佛山市\",\"江门市\",\"湛江市\",\"茂名市\",\"肇庆市\",\"惠州市\",\"梅州市\",\"汕尾市\",\"河源市\",\"阳江市\",\"清远市\",\"东莞市\",\"中山市\",\"潮州市\",\"揭阳市\",\"云浮市\"],\"海南\":[\"海口市\",\"三亚市\",\"五指山市\",\"琼海市\",\"儋州市\",\"文昌市\",\"万宁市\",\"东方市\",\"澄迈县\",\"定安县\",\"屯昌县\",\"临高县\",\"白沙黎族自治县\",\"昌江黎族自治县\",\"乐东黎族自治县\",\"陵水黎族自治县\",\"保亭黎族苗族自治县\",\"琼中黎族苗族自治县\"],\"四川\":[\"成都市\",\"自贡市\",\"攀枝花市\",\"泸州市\",\"德阳市\",\"绵阳市\",\"广元市\",\"遂宁市\",\"内江市\",\"乐山市\",\"南充市\",\"眉山市\",\"宜宾市\",\"广安市\",\"达州市\",\"雅安市\",\"巴中市\",\"资阳市\",\"阿坝藏族羌族自治州\",\"甘孜藏族自治州\",\"凉山彝族自治州\"],\"贵州\":[\"贵阳市\",\"六盘水市\",\"遵义市\",\"安顺市\",\"铜仁地区\",\"毕节地区\",\"黔西南布依族苗族自治州\",\"黔东南苗族侗族自治州\",\"黔南布依族苗族自治州\"],\"云南\":[\"昆明市\",\"曲靖市\",\"玉溪市\",\"保山市\",\"昭通市\",\"丽江市\",\"普洱市\",\"临沧市\",\"德宏傣族景颇族自治州\",\"怒江傈僳族自治州\",\"迪庆藏族自治州\",\"大理白族自治州\",\"楚雄彝族自治州\",\"红河哈尼族彝族自治州\",\"文山壮族苗族自治州\",\"西双版纳傣族自治州\"],\"陕西\":[\"西安市\",\"铜川市\",\"宝鸡市\",\"咸阳市\",\"渭南市\",\"延安市\",\"汉中市\",\"榆林市\",\"安康市\",\"商洛市\"],\"甘肃\":[\"兰州市\",\"嘉峪关市\",\"金昌市\",\"白银市\",\"天水市\",\"武威市\",\"酒泉市\",\"张掖市\",\"庆阳市\",\"平凉市\",\"定西市\",\"陇南市\",\"临夏回族自治州\",\"甘南藏族自治州\"],\"青海\":[\"西宁市\",\"海东地区\",\"海北藏族自治州\",\"海南藏族自治州\",\"黄南藏族自治州\",\"果洛藏族自治州\",\"玉树藏族自治州\",\"海西蒙古族藏族自治州\"],\"内蒙古\":[\"呼和浩特市\",\"包头市\",\"乌海市\",\"赤峰市\",\"通辽市\",\"鄂尔多斯市\",\"呼伦贝尔市\",\"巴彦淖尔市\",\"乌兰察布市\",\"锡林郭勒盟\",\"兴安盟\",\"阿拉善盟\"],\"广西\":[\"南宁市\",\"柳州市\",\"桂林市\",\"梧州市\",\"北海市\",\"防城港市\",\"钦州市\",\"贵港市\",\"玉林市\",\"百色市\",\"贺州市\",\"河池市\",\"来宾市\",\"崇左市\"],\"西藏\":[\"拉萨市\",\"那曲地区\",\"昌都地区\",\"林芝地区\",\"山南地区\",\"日喀则地区\",\"阿里地区\"],\"宁夏\":[\"银川市\",\"石嘴山市\",\"吴忠市\",\"固原市\",\"中卫市\"],\"新疆\":[\"乌鲁木齐市\",\"克拉玛依市\",\"吐鲁番地区\",\"哈密地区\",\"和田地区\",\"阿克苏地区\",\"喀什地区\",\"克孜勒苏柯尔克孜自治州\",\"巴音郭楞蒙古自治州\",\"昌吉回族自治州\",\"博尔塔拉蒙古自治州\",\"石河子市\",\"阿拉尔市\",\"图木舒克市\",\"五家渠市\",\"伊犁哈萨克自治州\",\"塔城地区\",\"阿勒泰地区\"],\"香港\":[\"中西区\",\"湾仔区\",\"东区\",\"南区\",\"黄大仙区\",\"观塘区\",\"深水埗区\",\"油尖旺区\",\"九龙城区\",\"北区\",\"大埔区\",\"沙田区\",\"西贡区\",\"元朗区\",\"屯门区\",\"荃湾区\",\"葵青区\",\"离岛区\"],\"澳门\":[\"花地玛堂区\",\"圣安多尼堂区\",\"大堂区\",\"望德堂区\",\"风顺堂区\",\"氹仔\",\"路环\",\"路氹城\"],\"台湾\":[\"台北市\",\"高雄市\",\"基隆市\",\"新竹市\",\"台中市\",\"嘉义市\",\"台南市\",\"台北县\",\"桃园县\",\"新竹县\",\"苗栗县\",\"台中县\",\"彰化县\",\"南投县\",\"云林县\",\"嘉义县\",\"台南县\",\"高雄县\",\"屏东县\",\"宜兰县\",\"花莲县\",\"台东县\",\"澎湖县\",\"金门县\",\"连江县\"]}");
        protected readonly static JObject XIAN_JSON = JObject.Parse("{\"北京市\":[\"东城区\",\"西城区\",\"崇文区\",\"宣武区\",\"朝阳区\",\"丰台区\",\"石景山区\",\"海淀区\",\"门头沟区\",\"房山区\",\"通州区\",\"顺义区\",\"昌平区\",\"大兴区\",\"怀柔区\",\"平谷区\",\"密云县\",\"延庆县\"],\"天津市\":[\"和平区\",\"河东区\",\"河西区\",\"南开区\",\"河北区\",\"红桥区\",\"塘沽区\",\"汉沽区\",\"大港区\",\"东丽区\",\"西青区\",\"北辰区\",\"津南区\",\"武清区\",\"宝坻区\",\"静海县\",\"宁河县\",\"蓟县\"],\"上海市\":[\"黄浦区\",\"卢湾区\",\"徐汇区\",\"长宁区\",\"静安区\",\"普陀区\",\"闸北区\",\"虹口区\",\"杨浦区\",\"宝山区\",\"闵行区\",\"嘉定区\",\"松江区\",\"金山区\",\"青浦区\",\"奉贤区\",\"浦东新区\",\"崇明县\"],\"重庆市\":[\"渝中区\",\"大渡口区\",\"江北区\",\"南岸区\",\"北碚区\",\"渝北区\",\"巴南区\",\"长寿区\",\"双桥区\",\"沙坪坝区\",\"万盛区\",\"万州区\",\"涪陵区\",\"黔江区\",\"永川区\",\"合川区\",\"江津区\",\"九龙坡区\",\"南川区\",\"綦江县\",\"潼南县\",\"荣昌县\",\"璧山县\",\"大足县\",\"铜梁县\",\"梁平县\",\"开县\",\"忠县\",\"城口县\",\"垫江县\",\"武隆县\",\"丰都县\",\"奉节县\",\"云阳县\",\"巫溪县\",\"巫山县\",\"石柱土家族自治县\",\"秀山土家族苗族自治县\",\"酉阳土家族苗族自治县\",\"彭水苗族土家族自治县\"],\"石家庄市\":[\"长安区\",\"桥东区\",\"桥西区\",\"新华区\",\"裕华区\",\"井陉矿区\",\"鹿泉市\",\"辛集市\",\"藁城市\",\"晋州市\",\"新乐市\",\"深泽县\",\"无极县\",\"赵县\",\"灵寿县\",\"高邑县\",\"元氏县\",\"赞皇县\",\"平山县\",\"井陉县\",\"栾城县\",\"正定县\",\"行唐县\"],\"唐山市\":[\"路北区\",\"路南区\",\"古冶区\",\"开平区\",\"丰南区\",\"丰润区\",\"遵化市\",\"迁安市\",\"迁西县\",\"滦南县\",\"玉田县\",\"唐海县\",\"乐亭县\",\"滦县\",\"汉沽管理区\"],\"秦皇岛市\":[\"海港区\",\"山海关区\",\"北戴河区\",\"昌黎县\",\"抚宁县\",\"卢龙县\",\"青龙满族自治县\"],\"邯郸市\":[\"邯山区\",\"丛台区\",\"复兴区\",\"峰峰矿区\",\"武安市\",\"邱县\",\"大名县\",\"魏县\",\"曲周县\",\"鸡泽县\",\"肥乡县\",\"广平县\",\"成安县\",\"临漳县\",\"磁县\",\"涉县\",\"永年县\",\"馆陶县\",\"邯郸县\"],\"邢台市\":[\"桥东区\",\"桥西区\",\"南宫市\",\"沙河市\",\"临城县\",\"内丘县\",\"柏乡县\",\"隆尧县\",\"任县\",\"南和县\",\"宁晋县\",\"巨鹿县\",\"新河县\",\"广宗县\",\"平乡县\",\"威县\",\"清河县\",\"临西县\",\"邢台县\"],\"保定市\":[\"新市区\",\"北市区\",\"南市区\",\"定州市\",\"涿州市\",\"安国市\",\"高碑店市\",\"易县\",\"徐水县\",\"涞源县\",\"顺平县\",\"唐县\",\"望都县\",\"涞水县\",\"高阳县\",\"安新县\",\"雄县\",\"容城县\",\"蠡县\",\"曲阳县\",\"阜平县\",\"博野县\",\"满城县\",\"清苑县\",\"定兴县\"],\"张家口市\":[\"桥东区\",\"桥西区\",\"宣化区\",\"下花园区\",\"张北县\",\"康保县\",\"沽源县\",\"尚义县\",\"蔚县\",\"阳原县\",\"怀安县\",\"万全县\",\"怀来县\",\"赤城县\",\"崇礼县\",\"宣化县\",\"涿鹿县\",\"塞北管理区\"],\"承德市\":[\"双桥区\",\"双滦区\",\"鹰手营子矿区\",\"兴隆县\",\"平泉县\",\"滦平县\",\"隆化县\",\"承德县\",\"丰宁满族自治县\",\"宽城满族自治县\",\"围场满族蒙古族自治县\"],\"沧州市\":[\"新华区\",\"运河区\",\"泊头市\",\"任丘市\",\"黄骅市\",\"河间市\",\"献县\",\"吴桥县\",\"沧县\",\"东光县\",\"肃宁县\",\"南皮县\",\"盐山县\",\"青县\",\"海兴县\",\"孟村回族自治县\"],\"廊坊市\":[\"安次区\",\"广阳区\",\"霸州市\",\"三河市\",\"香河县\",\"永清县\",\"固安县\",\"文安县\",\"大城县\",\"大厂回族自治县\"],\"衡水市\":[\"桃城区\",\"冀州市\",\"深州市\",\"枣强县\",\"武邑县\",\"武强县\",\"饶阳县\",\"安平县\",\"故城县\",\"景县\",\"阜城县\"],\"太原市\":[\"杏花岭区\",\"小店区\",\"迎泽区\",\"尖草坪区\",\"万柏林区\",\"晋源区\",\"古交市\",\"阳曲县\",\"清徐县\",\"娄烦县\"],\"大同市\":[\"城区\",\"矿区\",\"南郊区\",\"新荣区\",\"大同县\",\"天镇县\",\"灵丘县\",\"阳高县\",\"左云县\",\"广灵县\",\"浑源县\"],\"阳泉市\":[\"城区\",\"矿区\",\"郊区\",\"平定县\",\"盂县\"],\"长治市\":[\"城区\",\"郊区\",\"潞城市\",\"长治县\",\"长子县\",\"平顺县\",\"襄垣县\",\"沁源县\",\"屯留县\",\"黎城县\",\"武乡县\",\"沁县\",\"壶关县\"],\"晋城市\":[\"城区\",\"高平市\",\"泽州县\",\"陵川县\",\"阳城县\",\"沁水县\"],\"朔州市\":[\"朔城区\",\"平鲁区\",\"山阴县\",\"右玉县\",\"应县\",\"怀仁县\"],\"晋中市\":[\"榆次区\",\"介休市\",\"昔阳县\",\"灵石县\",\"祁县\",\"左权县\",\"寿阳县\",\"太谷县\",\"和顺县\",\"平遥县\",\"榆社县\"],\"运城市\":[\"盐湖区\",\"河津市\",\"永济市\",\"闻喜县\",\"新绛县\",\"平陆县\",\"垣曲县\",\"绛县\",\"稷山县\",\"芮城县\",\"夏县\",\"万荣县\",\"临猗县\"],\"忻州市\":[\"忻府区\",\"原平市\",\"代县\",\"神池县\",\"五寨县\",\"五台县\",\"偏关县\",\"宁武县\",\"静乐县\",\"繁峙县\",\"河曲县\",\"保德县\",\"定襄县\",\"岢岚县\"],\"临汾市\":[\"尧都区\",\"侯马市\",\"霍州市\",\"汾西县\",\"吉县\",\"安泽县\",\"大宁县\",\"浮山县\",\"古县\",\"隰县\",\"襄汾县\",\"翼城县\",\"永和县\",\"乡宁县\",\"曲沃县\",\"洪洞县\",\"蒲县\"],\"吕梁市\":[\"离石区\",\"孝义市\",\"汾阳市\",\"文水县\",\"中阳县\",\"兴县\",\"临县\",\"方山县\",\"柳林县\",\"岚县\",\"交口县\",\"交城县\",\"石楼县\"],\"沈阳市\":[\"沈河区\",\"皇姑区\",\"和平区\",\"大东区\",\"铁西区\",\"苏家屯区\",\"东陵区\",\"沈北新区\",\"于洪区\",\"新民市\",\"法库县\",\"辽中县\",\"康平县\"],\"大连市\":[\"西岗区\",\"中山区\",\"沙河口区\",\"甘井子区\",\"旅顺口区\",\"金州区\",\"瓦房店市\",\"普兰店市\",\"庄河市\",\"长海县\"],\"鞍山市\":[\"铁东区\",\"铁西区\",\"立山区\",\"千山区\",\"海城市\",\"台安县\",\"岫岩满族自治县\"],\"抚顺市\":[\"顺城区\",\"新抚区\",\"东洲区\",\"望花区\",\"抚顺县\",\"清原满族自治县\",\"新宾满族自治县\"],\"本溪市\":[\"平山区\",\"明山区\",\"溪湖区\",\"南芬区\",\"本溪满族自治县\",\"桓仁满族自治县\"],\"丹东市\":[\"振兴区\",\"元宝区\",\"振安区\",\"东港市\",\"凤城市\",\"宽甸满族自治县\"],\"锦州市\":[\"太和区\",\"古塔区\",\"凌河区\",\"凌海市\",\"北镇市\",\"黑山县\",\"义县\"],\"营口市\":[\"站前区\",\"西市区\",\"鲅鱼圈区\",\"老边区\",\"大石桥市\",\"盖州市\"],\"阜新市\":[\"海州区\",\"新邱区\",\"太平区\",\"清河门区\",\"细河区\",\"彰武县\",\"阜新蒙古族自治县\"],\"辽阳市\":[\"白塔区\",\"文圣区\",\"宏伟区\",\"太子河区\",\"弓长岭区\",\"灯塔市\",\"辽阳县\"],\"盘锦市\":[\"双台子区\",\"兴隆台区\",\"盘山县\",\"大洼县\"],\"铁岭市\":[\"银州区\",\"清河区\",\"调兵山市\",\"开原市\",\"铁岭县\",\"昌图县\",\"西丰县\"],\"朝阳市\":[\"双塔区\",\"龙城区\",\"凌源市\",\"北票市\",\"朝阳县\",\"建平县\",\"喀喇沁左翼蒙古族自治县\"],\"葫芦岛市\":[\"龙港区\",\"南票区\",\"连山区\",\"兴城市\",\"绥中县\",\"建昌县\"],\"长春市\":[\"朝阳区\",\"宽城区\",\"二道区\",\"南关区\",\"绿园区\",\"双阳区\",\"九台市\",\"榆树市\",\"德惠市\",\"农安县\"],\"吉林市\":[\"船营区\",\"昌邑区\",\"龙潭区\",\"丰满区\",\"舒兰市\",\"桦甸市\",\"蛟河市\",\"磐石市\",\"永吉县\"],\"四平市\":[\"铁西区\",\"铁东区\",\"公主岭市\",\"双辽市\",\"梨树县\",\"伊通满族自治县\"],\"辽源市\":[\"龙山区\",\"西安区\",\"东辽县\",\"东丰县\"],\"通化市\":[\"东昌区\",\"二道江区\",\"梅河口市\",\"集安市\",\"通化县\",\"辉南县\",\"柳河县\"],\"白山市\":[\"八道江区\",\"江源区\",\"临江市\",\"靖宇县\",\"抚松县\",\"长白朝鲜族自治县\"],\"松原市\":[\"宁江区\",\"乾安县\",\"长岭县\",\"扶余县\",\"前郭尔罗斯蒙古族自治县\"],\"白城市\":[\"洮北区\",\"大安市\",\"洮南市\",\"镇赉县\",\"通榆县\"],\"延边朝鲜族自治州\":[\"延吉市\",\"图们市\",\"敦化市\",\"龙井市\",\"珲春市\",\"和龙市\",\"安图县\",\"汪清县\"],\"哈尔滨市\":[\"松北区\",\"道里区\",\"南岗区\",\"平房区\",\"香坊区\",\"道外区\",\"呼兰区\",\"阿城区\",\"双城市\",\"尚志市\",\"五常市\",\"宾县\",\"方正县\",\"通河县\",\"巴彦县\",\"延寿县\",\"木兰县\",\"依兰县\"],\"齐齐哈尔市\":[\"龙沙区\",\"昂昂溪区\",\"铁锋区\",\"建华区\",\"富拉尔基区\",\"碾子山区\",\"梅里斯达斡尔族区\",\"讷河市\",\"富裕县\",\"拜泉县\",\"甘南县\",\"依安县\",\"克山县\",\"泰来县\",\"克东县\",\"龙江县\"],\"鹤岗市\":[\"兴山区\",\"工农区\",\"南山区\",\"兴安区\",\"向阳区\",\"东山区\",\"萝北县\",\"绥滨县\"],\"双鸭山市\":[\"尖山区\",\"岭东区\",\"四方台区\",\"宝山区\",\"集贤县\",\"宝清县\",\"友谊县\",\"饶河县\"],\"鸡西市\":[\"鸡冠区\",\"恒山区\",\"城子河区\",\"滴道区\",\"梨树区\",\"麻山区\",\"密山市\",\"虎林市\",\"鸡东县\"],\"大庆市\":[\"萨尔图区\",\"红岗区\",\"龙凤区\",\"让胡路区\",\"大同区\",\"林甸县\",\"肇州县\",\"肇源县\",\"杜尔伯特蒙古族自治县\"],\"伊春市\":[\"伊春区\",\"带岭区\",\"南岔区\",\"金山屯区\",\"西林区\",\"美溪区\",\"乌马河区\",\"翠峦区\",\"友好区\",\"上甘岭区\",\"五营区\",\"红星区\",\"新青区\",\"汤旺河区\",\"乌伊岭区\",\"铁力市\",\"嘉荫县\"],\"牡丹江市\":[\"爱民区\",\"东安区\",\"阳明区\",\"西安区\",\"绥芬河市\",\"宁安市\",\"海林市\",\"穆棱市\",\"林口县\",\"东宁县\"],\"佳木斯市\":[\"前进区\",\"向阳区\",\"东风区\",\"郊区\",\"同江市\",\"富锦市\",\"桦川县\",\"抚远县\",\"桦南县\",\"汤原县\"],\"七台河市\":[\"桃山区\",\"新兴区\",\"茄子河区\",\"勃利县\"],\"黑河市\":[\"爱辉区\",\"北安市\",\"五大连池市\",\"逊克县\",\"嫩江县\",\"孙吴县\"],\"绥化市\":[\"北林区\",\"安达市\",\"肇东市\",\"海伦市\",\"绥棱县\",\"兰西县\",\"明水县\",\"青冈县\",\"庆安县\",\"望奎县\"],\"大兴安岭地区\":[\"呼玛县\",\"塔河县\",\"漠河县\"],\"南京市\":[\"玄武区\",\"白下区\",\"秦淮区\",\"建邺区\",\"鼓楼区\",\"下关区\",\"栖霞区\",\"雨花台区\",\"浦口区\",\"江宁区\",\"六合区\",\"溧水县\",\"高淳县\"],\"苏州市\":[\"金阊区\",\"平江区\",\"沧浪区\",\"吴中区\",\"相城区\",\"虎丘区\",\"张家港市\",\"常熟市\",\"太仓市\",\"昆山市\",\"吴江市\"],\"无锡市\":[\"崇安区\",\"南长区\",\"北塘区\",\"滨湖区\",\"锡山区\",\"惠山区\",\"江阴市\",\"宜兴市\"],\"常州市\":[\"钟楼区\",\"天宁区\",\"戚墅堰区\",\"新北区\",\"武进区\",\"金坛市\",\"溧阳市\"],\"镇江市\":[\"京口区\",\"润州区\",\"丹徒区\",\"丹阳市\",\"扬中市\",\"句容市\"],\"南通市\":[\"崇川区\",\"港闸区\",\"通州区\",\"如皋市\",\"海门市\",\"启东市\",\"海安县\",\"如东县\"],\"泰州市\":[\"海陵区\",\"高港区\",\"姜堰市\",\"泰兴市\",\"靖江市\",\"兴化市\"],\"扬州市\":[\"广陵区\",\"维扬区\",\"邗江区\",\"江都市\",\"仪征市\",\"高邮市\",\"宝应县\"],\"盐城市\":[\"亭湖区\",\"盐都区\",\"大丰市\",\"东台市\",\"建湖县\",\"射阳县\",\"阜宁县\",\"滨海县\",\"响水县\"],\"连云港市\":[\"新浦区\",\"海州区\",\"连云区\",\"东海县\",\"灌云县\",\"赣榆县\",\"灌南县\"],\"徐州市\":[\"云龙区\",\"鼓楼区\",\"九里区\",\"泉山区\",\"贾汪区\",\"邳州市\",\"新沂市\",\"铜山县\",\"睢宁县\",\"沛县\",\"丰县\"],\"淮安市\":[\"清河区\",\"清浦区\",\"楚州区\",\"淮阴区\",\"涟水县\",\"洪泽县\",\"金湖县\",\"盱眙县\"],\"宿迁市\":[\"宿城区\",\"宿豫区\",\"沭阳县\",\"泗阳县\",\"泗洪县\"],\"杭州市\":[\"拱墅区\",\"西湖区\",\"上城区\",\"下城区\",\"江干区\",\"滨江区\",\"余杭区\",\"萧山区\",\"建德市\",\"富阳市\",\"临安市\",\"桐庐县\",\"淳安县\"],\"宁波市\":[\"海曙区\",\"江东区\",\"江北区\",\"镇海区\",\"北仑区\",\"鄞州区\",\"余姚市\",\"慈溪市\",\"奉化市\",\"宁海县\",\"象山县\"],\"温州市\":[\"鹿城区\",\"龙湾区\",\"瓯海区\",\"瑞安市\",\"乐清市\",\"永嘉县\",\"洞头县\",\"平阳县\",\"苍南县\",\"文成县\",\"泰顺县\"],\"嘉兴市\":[\"南湖区\",\"秀洲区\",\"海宁市\",\"平湖市\",\"桐乡市\",\"嘉善县\",\"海盐县\"],\"湖州市\":[\"吴兴区\",\"南浔区\",\"长兴县\",\"德清县\",\"安吉县\"],\"绍兴市\":[\"越城区\",\"诸暨市\",\"上虞市\",\"嵊州市\",\"绍兴县\",\"新昌县\"],\"金华市\":[\"婺城区\",\"金东区\",\"兰溪市\",\"义乌市\",\"东阳市\",\"永康市\",\"武义县\",\"浦江县\",\"磐安县\"],\"衢州市\":[\"柯城区\",\"衢江区\",\"江山市\",\"龙游县\",\"常山县\",\"开化县\"],\"舟山市\":[\"定海区\",\"普陀区\",\"岱山县\",\"嵊泗县\"],\"台州市\":[\"椒江区\",\"黄岩区\",\"路桥区\",\"临海市\",\"温岭市\",\"玉环县\",\"天台县\",\"仙居县\",\"三门县\"],\"丽水市\":[\"莲都区\",\"龙泉市\",\"缙云县\",\"青田县\",\"云和县\",\"遂昌县\",\"松阳县\",\"庆元县\",\"景宁畲族自治县\"],\"合肥市\":[\"蜀山区\",\"庐阳区\",\"瑶海区\",\"包河区\",\"长丰县\",\"肥东县\",\"肥西县\"],\"芜湖市\":[\"镜湖区\",\"弋江区\",\"鸠江区\",\"三山区\",\"芜湖县\",\"南陵县\",\"繁昌县\"],\"蚌埠市\":[\"蚌山区\",\"龙子湖区\",\"禹会区\",\"淮上区\",\"怀远县\",\"固镇县\",\"五河县\"],\"淮南市\":[\"田家庵区\",\"大通区\",\"谢家集区\",\"八公山区\",\"潘集区\",\"凤台县\"],\"马鞍山市\":[\"雨山区\",\"花山区\",\"金家庄区\",\"当涂县\"],\"淮北市\":[\"相山区\",\"杜集区\",\"烈山区\",\"濉溪县\"],\"铜陵市\":[\"铜官山区\",\"狮子山区\",\"郊区\",\"铜陵县\"],\"安庆市\":[\"迎江区\",\"大观区\",\"宜秀区\",\"桐城市\",\"宿松县\",\"枞阳县\",\"太湖县\",\"怀宁县\",\"岳西县\",\"望江县\",\"潜山县\"],\"黄山市\":[\"屯溪区\",\"黄山区\",\"徽州区\",\"休宁县\",\"歙县\",\"祁门县\",\"黟县\"],\"滁州市\":[\"琅琊区\",\"南谯区\",\"天长市\",\"明光市\",\"全椒县\",\"来安县\",\"定远县\",\"凤阳县\"],\"阜阳市\":[\"颍州区\",\"颍东区\",\"颍泉区\",\"界首市\",\"临泉县\",\"颍上县\",\"阜南县\",\"太和县\"],\"宿州市\":[\"埇桥区\",\"萧县\",\"泗县\",\"砀山县\",\"灵璧县\"],\"巢湖市\":[\"居巢区\",\"含山县\",\"无为县\",\"庐江县\",\"和县\"],\"六安市\":[\"金安区\",\"裕安区\",\"寿县\",\"霍山县\",\"霍邱县\",\"舒城县\",\"金寨县\"],\"亳州市\":[\"谯城区\",\"利辛县\",\"涡阳县\",\"蒙城县\"],\"池州市\":[\"贵池区\",\"东至县\",\"石台县\",\"青阳县\"],\"宣城市\":[\"宣州区\",\"宁国市\",\"广德县\",\"郎溪县\",\"泾县\",\"旌德县\",\"绩溪县\"],\"福州市\":[\"鼓楼区\",\"台江区\",\"仓山区\",\"马尾区\",\"晋安区\",\"福清市\",\"长乐市\",\"闽侯县\",\"闽清县\",\"永泰县\",\"连江县\",\"罗源县\",\"平潭县\"],\"厦门市\":[\"思明区\",\"海沧区\",\"湖里区\",\"集美区\",\"同安区\",\"翔安区\"],\"莆田市\":[\"城厢区\",\"涵江区\",\"荔城区\",\"秀屿区\",\"仙游县\"],\"三明市\":[\"梅列区\",\"三元区\",\"永安市\",\"明溪县\",\"将乐县\",\"大田县\",\"宁化县\",\"建宁县\",\"沙县\",\"尤溪县\",\"清流县\",\"泰宁县\"],\"泉州市\":[\"鲤城区\",\"丰泽区\",\"洛江区\",\"泉港区\",\"石狮市\",\"晋江市\",\"南安市\",\"惠安县\",\"永春县\",\"安溪县\",\"德化县\",\"金门县\"],\"漳州市\":[\"芗城区\",\"龙文区\",\"龙海市\",\"平和县\",\"南靖县\",\"诏安县\",\"漳浦县\",\"华安县\",\"东山县\",\"长泰县\",\"云霄县\"],\"南平市\":[\"延平区\",\"建瓯市\",\"邵武市\",\"武夷山市\",\"建阳市\",\"松溪县\",\"光泽县\",\"顺昌县\",\"浦城县\",\"政和县\"],\"龙岩市\":[\"新罗区\",\"漳平市\",\"长汀县\",\"武平县\",\"上杭县\",\"永定县\",\"连城县\"],\"宁德市\":[\"蕉城区\",\"福安市\",\"福鼎市\",\"寿宁县\",\"霞浦县\",\"柘荣县\",\"屏南县\",\"古田县\",\"周宁县\"],\"南昌市\":[\"东湖区\",\"西湖区\",\"青云谱区\",\"湾里区\",\"青山湖区\",\"新建县\",\"南昌县\",\"进贤县\",\"安义县\"],\"景德镇市\":[\"珠山区\",\"昌江区\",\"乐平市\",\"浮梁县\"],\"萍乡市\":[\"安源区\",\"湘东区\",\"莲花县\",\"上栗县\",\"芦溪县\"],\"九江市\":[\"浔阳区\",\"庐山区\",\"瑞昌市\",\"九江县\",\"星子县\",\"武宁县\",\"彭泽县\",\"永修县\",\"修水县\",\"湖口县\",\"德安县\",\"都昌县\"],\"新余市\":[\"渝水区\",\"分宜县\"],\"鹰潭市\":[\"月湖区\",\"贵溪市\",\"余江县\"],\"赣州市\":[\"章贡区\",\"瑞金市\",\"南康市\",\"石城县\",\"安远县\",\"赣县\",\"宁都县\",\"寻乌县\",\"兴国县\",\"定南县\",\"上犹县\",\"于都县\",\"龙南县\",\"崇义县\",\"信丰县\",\"全南县\",\"大余县\",\"会昌县\"],\"吉安市\":[\"吉州区\",\"青原区\",\"井冈山市\",\"吉安县\",\"永丰县\",\"永新县\",\"新干县\",\"泰和县\",\"峡江县\",\"遂川县\",\"安福县\",\"吉水县\",\"万安县\"],\"宜春市\":[\"袁州区\",\"丰城市\",\"樟树市\",\"高安市\",\"铜鼓县\",\"靖安县\",\"宜丰县\",\"奉新县\",\"万载县\",\"上高县\"],\"抚州市\":[\"临川区\",\"南丰县\",\"乐安县\",\"金溪县\",\"南城县\",\"东乡县\",\"资溪县\",\"宜黄县\",\"广昌县\",\"黎川县\",\"崇仁县\"],\"上饶市\":[\"信州区\",\"德兴市\",\"上饶县\",\"广丰县\",\"鄱阳县\",\"婺源县\",\"铅山县\",\"余干县\",\"横峰县\",\"弋阳县\",\"玉山县\",\"万年县\"],\"济南市\":[\"市中区\",\"历下区\",\"天桥区\",\"槐荫区\",\"历城区\",\"长清区\",\"章丘市\",\"平阴县\",\"济阳县\",\"商河县\"],\"青岛市\":[\"市南区\",\"市北区\",\"四方区\",\"李沧区\",\"崂山区\",\"城阳区\",\"黄岛区\",\"即墨市\",\"胶州市\",\"胶南市\",\"平度市\",\"莱西市\"],\"淄博市\":[\"张店区\",\"临淄区\",\"淄川区\",\"博山区\",\"周村区\",\"桓台县\",\"高青县\",\"沂源县\"],\"枣庄市\":[\"市中区\",\"山亭区\",\"峄城区\",\"台儿庄区\",\"薛城区\",\"滕州市\"],\"东营市\":[\"东营区\",\"河口区\",\"垦利县\",\"广饶县\",\"利津县\"],\"烟台市\":[\"芝罘区\",\"福山区\",\"牟平区\",\"莱山区\",\"龙口市\",\"莱阳市\",\"莱州市\",\"招远市\",\"蓬莱市\",\"栖霞市\",\"海阳市\",\"长岛县\"],\"潍坊市\":[\"潍城区\",\"寒亭区\",\"坊子区\",\"奎文区\",\"青州市\",\"诸城市\",\"寿光市\",\"安丘市\",\"高密市\",\"昌邑市\",\"昌乐县\",\"临朐县\"],\"济宁市\":[\"市中区\",\"任城区\",\"曲阜市\",\"兖州市\",\"邹城市\",\"鱼台县\",\"金乡县\",\"嘉祥县\",\"微山县\",\"汶上县\",\"泗水县\",\"梁山县\"],\"泰安市\":[\"泰山区\",\"岱岳区\",\"新泰市\",\"肥城市\",\"宁阳县\",\"东平县\"],\"威海市\":[\"环翠区\",\"乳山市\",\"文登市\",\"荣成市\"],\"日照市\":[\"东港区\",\"岚山区\",\"五莲县\",\"莒县\"],\"莱芜市\":[\"莱城区\",\"钢城区\"],\"临沂市\":[\"兰山区\",\"罗庄区\",\"河东区\",\"沂南县\",\"郯城县\",\"沂水县\",\"苍山县\",\"费县\",\"平邑县\",\"莒南县\",\"蒙阴县\",\"临沭县\"],\"德州市\":[\"德城区\",\"乐陵市\",\"禹城市\",\"陵县\",\"宁津县\",\"齐河县\",\"武城县\",\"庆云县\",\"平原县\",\"夏津县\",\"临邑县\"],\"聊城市\":[\"东昌府区\",\"临清市\",\"高唐县\",\"阳谷县\",\"茌平县\",\"莘县\",\"东阿县\",\"冠县\"],\"滨州市\":[\"滨城区\",\"邹平县\",\"沾化县\",\"惠民县\",\"博兴县\",\"阳信县\",\"无棣县\"],\"菏泽市\":[\"牡丹区\",\"鄄城县\",\"单县\",\"郓城县\",\"曹县\",\"定陶县\",\"巨野县\",\"东明县\",\"成武县\"],\"郑州市\":[\"中原区\",\"金水区\",\"二七区\",\"管城回族区\",\"上街区\",\"惠济区\",\"巩义市\",\"新郑市\",\"新密市\",\"登封市\",\"荥阳市\",\"中牟县\"],\"开封市\":[\"鼓楼区\",\"龙亭区\",\"顺河回族区\",\"禹王台区\",\"金明区\",\"开封县\",\"尉氏县\",\"兰考县\",\"杞县\",\"通许县\"],\"洛阳市\":[\"西工区\",\"老城区\",\"涧西区\",\"瀍河回族区\",\"洛龙区\",\"吉利区\",\"偃师市\",\"孟津县\",\"汝阳县\",\"伊川县\",\"洛宁县\",\"嵩县\",\"宜阳县\",\"新安县\",\"栾川县\"],\"平顶山市\":[\"新华区\",\"卫东区\",\"湛河区\",\"石龙区\",\"汝州市\",\"舞钢市\",\"宝丰县\",\"叶县\",\"郏县\",\"鲁山县\"],\"安阳市\":[\"北关区\",\"文峰区\",\"殷都区\",\"龙安区\",\"林州市\",\"安阳县\",\"滑县\",\"内黄县\",\"汤阴县\"],\"鹤壁市\":[\"淇滨区\",\"山城区\",\"鹤山区\",\"浚县\",\"淇县\"],\"新乡市\":[\"卫滨区\",\"红旗区\",\"凤泉区\",\"牧野区\",\"卫辉市\",\"辉县市\",\"新乡县\",\"获嘉县\",\"原阳县\",\"长垣县\",\"封丘县\",\"延津县\"],\"焦作市\":[\"解放区\",\"中站区\",\"马村区\",\"山阳区\",\"沁阳市\",\"孟州市\",\"修武县\",\"温县\",\"武陟县\",\"博爱县\"],\"濮阳市\":[\"华龙区\",\"濮阳县\",\"南乐县\",\"台前县\",\"清丰县\",\"范县\"],\"许昌市\":[\"魏都区\",\"禹州市\",\"长葛市\",\"许昌县\",\"鄢陵县\",\"襄城县\"],\"漯河市\":[\"源汇区\",\"郾城区\",\"召陵区\",\"临颍县\",\"舞阳县\"],\"三门峡市\":[\"湖滨区\",\"义马市\",\"灵宝市\",\"渑池县\",\"卢氏县\",\"陕县\"],\"南阳市\":[\"卧龙区\",\"宛城区\",\"邓州市\",\"桐柏县\",\"方城县\",\"淅川县\",\"镇平县\",\"唐河县\",\"南召县\",\"内乡县\",\"新野县\",\"社旗县\",\"西峡县\"],\"商丘市\":[\"梁园区\",\"睢阳区\",\"永城市\",\"宁陵县\",\"虞城县\",\"民权县\",\"夏邑县\",\"柘城县\",\"睢县\"],\"信阳市\":[\"浉河区\",\"平桥区\",\"潢川县\",\"淮滨县\",\"息县\",\"新县\",\"商城县\",\"固始县\",\"罗山县\",\"光山县\"],\"周口市\":[\"川汇区\",\"项城市\",\"商水县\",\"淮阳县\",\"太康县\",\"鹿邑县\",\"西华县\",\"扶沟县\",\"沈丘县\",\"郸城县\"],\"驻马店市\":[\"驿城区\",\"确山县\",\"新蔡县\",\"上蔡县\",\"西平县\",\"泌阳县\",\"平舆县\",\"汝南县\",\"遂平县\",\"正阳县\"],\"济源市\":[],\"武汉市\":[\"江岸区\",\"武昌区\",\"江汉区\",\"硚口区\",\"汉阳区\",\"青山区\",\"洪山区\",\"东西湖区\",\"汉南区\",\"蔡甸区\",\"江夏区\",\"黄陂区\",\"新洲区\"],\"黄石市\":[\"黄石港区\",\"西塞山区\",\"下陆区\",\"铁山区\",\"大冶市\",\"阳新县\"],\"十堰市\":[\"张湾区\",\"茅箭区\",\"丹江口市\",\"郧县\",\"竹山县\",\"房县\",\"郧西县\",\"竹溪县\"],\"荆州市\":[\"沙市区\",\"荆州区\",\"洪湖市\",\"石首市\",\"松滋市\",\"监利县\",\"公安县\",\"江陵县\"],\"宜昌市\":[\"西陵区\",\"伍家岗区\",\"点军区\",\"猇亭区\",\"夷陵区\",\"宜都市\",\"当阳市\",\"枝江市\",\"秭归县\",\"远安县\",\"兴山县\",\"五峰土家族自治县\",\"长阳土家族自治县\"],\"襄樊市\":[\"襄城区\",\"樊城区\",\"襄阳区\",\"老河口市\",\"枣阳市\",\"宜城市\",\"南漳县\",\"谷城县\",\"保康县\"],\"鄂州市\":[\"鄂城区\",\"华容区\",\"梁子湖区\"],\"荆门市\":[\"东宝区\",\"掇刀区\",\"钟祥市\",\"京山县\",\"沙洋县\"],\"孝感市\":[\"孝南区\",\"应城市\",\"安陆市\",\"汉川市\",\"云梦县\",\"大悟县\",\"孝昌县\"],\"黄冈市\":[\"黄州区\",\"麻城市\",\"武穴市\",\"红安县\",\"罗田县\",\"浠水县\",\"蕲春县\",\"黄梅县\",\"英山县\",\"团风县\"],\"咸宁市\":[\"咸安区\",\"赤壁市\",\"嘉鱼县\",\"通山县\",\"崇阳县\",\"通城县\"],\"随州市\":[\"曾都区\",\"广水市\",\"随县\"],\"恩施土家族苗族自治州\":[\"恩施市\",\"利川市\",\"建始县\",\"来凤县\",\"巴东县\",\"鹤峰县\",\"宣恩县\",\"咸丰县\"],\"仙桃市\":[],\"天门市\":[],\"潜江市\":[],\"神农架林区\":[],\"长沙市\":[\"岳麓区\",\"芙蓉区\",\"天心区\",\"开福区\",\"雨花区\",\"浏阳市\",\"长沙县\",\"望城县\",\"宁乡县\"],\"株洲市\":[\"天元区\",\"荷塘区\",\"芦淞区\",\"石峰区\",\"醴陵市\",\"株洲县\",\"炎陵县\",\"茶陵县\",\"攸县\"],\"湘潭市\":[\"岳塘区\",\"雨湖区\",\"湘乡市\",\"韶山市\",\"湘潭县\"],\"衡阳市\":[\"雁峰区\",\"珠晖区\",\"石鼓区\",\"蒸湘区\",\"南岳区\",\"耒阳市\",\"常宁市\",\"衡阳县\",\"衡东县\",\"衡山县\",\"衡南县\",\"祁东县\"],\"邵阳市\":[\"双清区\",\"大祥区\",\"北塔区\",\"武冈市\",\"邵东县\",\"洞口县\",\"新邵县\",\"绥宁县\",\"新宁县\",\"邵阳县\",\"隆回县\",\"城步苗族自治县\"],\"岳阳市\":[\"岳阳楼区\",\"云溪区\",\"君山区\",\"临湘市\",\"汨罗市\",\"岳阳县\",\"湘阴县\",\"平江县\",\"华容县\"],\"常德市\":[\"武陵区\",\"鼎城区\",\"津市市\",\"澧县\",\"临澧县\",\"桃源县\",\"汉寿县\",\"安乡县\",\"石门县\"],\"张家界市\":[\"永定区\",\"武陵源区\",\"慈利县\",\"桑植县\"],\"益阳市\":[\"赫山区\",\"资阳区\",\"沅江市\",\"桃江县\",\"南县\",\"安化县\"],\"郴州市\":[\"北湖区\",\"苏仙区\",\"资兴市\",\"宜章县\",\"汝城县\",\"安仁县\",\"嘉禾县\",\"临武县\",\"桂东县\",\"永兴县\",\"桂阳县\"],\"永州市\":[\"冷水滩区\",\"零陵区\",\"祁阳县\",\"蓝山县\",\"宁远县\",\"新田县\",\"东安县\",\"江永县\",\"道县\",\"双牌县\",\"江华瑶族自治县\"],\"怀化市\":[\"鹤城区\",\"洪江市\",\"会同县\",\"沅陵县\",\"辰溪县\",\"溆浦县\",\"中方县\",\"新晃侗族自治县\",\"芷江侗族自治县\",\"通道侗族自治县\",\"靖州苗族侗族自治县\",\"麻阳苗族自治县\",\"洪江区\"],\"娄底市\":[\"娄星区\",\"冷水江市\",\"涟源市\",\"新化县\",\"双峰县\"],\"湘西土家族苗族自治州\":[\"吉首市\",\"古丈县\",\"龙山县\",\"永顺县\",\"凤凰县\",\"泸溪县\",\"保靖县\",\"花垣县\"],\"广州市\":[\"越秀区\",\"荔湾区\",\"海珠区\",\"天河区\",\"白云区\",\"黄埔区\",\"番禺区\",\"花都区\",\"南沙区\",\"萝岗区\",\"增城市\",\"从化市\"],\"深圳市\":[\"福田区\",\"罗湖区\",\"南山区\",\"宝安区\",\"龙岗区\",\"盐田区\"],\"珠海市\":[\"香洲区\",\"斗门区\",\"金湾区\"],\"汕头市\":[\"金平区\",\"濠江区\",\"龙湖区\",\"潮阳区\",\"潮南区\",\"澄海区\",\"南澳县\"],\"韶关市\":[\"浈江区\",\"武江区\",\"曲江区\",\"乐昌市\",\"南雄市\",\"始兴县\",\"仁化县\",\"翁源县\",\"新丰县\",\"乳源瑶族自治县\"],\"佛山市\":[\"禅城区\",\"南海区\",\"顺德区\",\"三水区\",\"高明区\"],\"江门市\":[\"蓬江区\",\"江海区\",\"新会区\",\"恩平市\",\"台山市\",\"开平市\",\"鹤山市\"],\"湛江市\":[\"赤坎区\",\"霞山区\",\"坡头区\",\"麻章区\",\"吴川市\",\"廉江市\",\"雷州市\",\"遂溪县\",\"徐闻县\"],\"茂名市\":[\"茂南区\",\"茂港区\",\"化州市\",\"信宜市\",\"高州市\",\"电白县\"],\"肇庆市\":[\"端州区\",\"鼎湖区\",\"高要市\",\"四会市\",\"广宁县\",\"怀集县\",\"封开县\",\"德庆县\"],\"惠州市\":[\"惠城区\",\"惠阳区\",\"博罗县\",\"惠东县\",\"龙门县\"],\"梅州市\":[\"梅江区\",\"兴宁市\",\"梅县\",\"大埔县\",\"丰顺县\",\"五华县\",\"平远县\",\"蕉岭县\"],\"汕尾市\":[\"城区\",\"陆丰市\",\"海丰县\",\"陆河县\"],\"河源市\":[\"源城区\",\"紫金县\",\"龙川县\",\"连平县\",\"和平县\",\"东源县\"],\"阳江市\":[\"江城区\",\"阳春市\",\"阳西县\",\"阳东县\"],\"清远市\":[\"清城区\",\"英德市\",\"连州市\",\"佛冈县\",\"阳山县\",\"清新县\",\"连山壮族瑶族自治县\",\"连南瑶族自治县\"],\"东莞市\":[],\"中山市\":[],\"潮州市\":[\"湘桥区\",\"潮安县\",\"饶平县\"],\"揭阳市\":[\"榕城区\",\"普宁市\",\"揭东县\",\"揭西县\",\"惠来县\"],\"云浮市\":[\"云城区\",\"罗定市\",\"云安县\",\"新兴县\",\"郁南县\"],\"海口市\":[\"龙华区\",\"秀英区\",\"琼山区\",\"美兰区\"],\"三亚市\":[],\"五指山市\":[],\"琼海市\":[],\"儋州市\":[],\"文昌市\":[],\"万宁市\":[],\"东方市\":[],\"澄迈县\":[],\"定安县\":[],\"屯昌县\":[],\"临高县\":[],\"白沙黎族自治县\":[],\"昌江黎族自治县\":[],\"乐东黎族自治县\":[],\"陵水黎族自治县\":[],\"保亭黎族苗族自治县\":[],\"琼中黎族苗族自治县\":[],\"成都市\":[\"青羊区\",\"锦江区\",\"金牛区\",\"武侯区\",\"成华区\",\"龙泉驿区\",\"青白江区\",\"新都区\",\"温江区\",\"都江堰市\",\"彭州市\",\"邛崃市\",\"崇州市\",\"金堂县\",\"郫县\",\"新津县\",\"双流县\",\"蒲江县\",\"大邑县\"],\"自贡市\":[\"大安区\",\"自流井区\",\"贡井区\",\"沿滩区\",\"荣县\",\"富顺县\"],\"攀枝花市\":[\"东区\",\"西区\",\"仁和区\",\"米易县\",\"盐边县\"],\"泸州市\":[\"江阳区\",\"纳溪区\",\"龙马潭区\",\"泸县\",\"合江县\",\"叙永县\",\"古蔺县\"],\"德阳市\":[\"旌阳区\",\"广汉市\",\"什邡市\",\"绵竹市\",\"罗江县\",\"中江县\"],\"绵阳市\":[\"涪城区\",\"游仙区\",\"江油市\",\"盐亭县\",\"三台县\",\"平武县\",\"安县\",\"梓潼县\",\"北川羌族自治县\"],\"广元市\":[\"利州区\",\"元坝区\",\"朝天区\",\"青川县\",\"旺苍县\",\"剑阁县\",\"苍溪县\"],\"遂宁市\":[\"船山区\",\"安居区\",\"射洪县\",\"蓬溪县\",\"大英县\"],\"内江市\":[\"市中区\",\"东兴区\",\"资中县\",\"隆昌县\",\"威远县\"],\"乐山市\":[\"市中区\",\"五通桥区\",\"沙湾区\",\"金口河区\",\"峨眉山市\",\"夹江县\",\"井研县\",\"犍为县\",\"沐川县\",\"马边彝族自治县\",\"峨边彝族自治县\"],\"南充市\":[\"顺庆区\",\"高坪区\",\"嘉陵区\",\"阆中市\",\"营山县\",\"蓬安县\",\"仪陇县\",\"南部县\",\"西充县\"],\"眉山市\":[\"东坡区\",\"仁寿县\",\"彭山县\",\"洪雅县\",\"丹棱县\",\"青神县\"],\"宜宾市\":[\"翠屏区\",\"宜宾县\",\"兴文县\",\"南溪县\",\"珙县\",\"长宁县\",\"高县\",\"江安县\",\"筠连县\",\"屏山县\"],\"广安市\":[\"广安区\",\"华蓥市\",\"岳池县\",\"邻水县\",\"武胜县\"],\"达州市\":[\"通川区\",\"万源市\",\"达县\",\"渠县\",\"宣汉县\",\"开江县\",\"大竹县\"],\"雅安市\":[\"雨城区\",\"芦山县\",\"石棉县\",\"名山县\",\"天全县\",\"荥经县\",\"宝兴县\",\"汉源县\"],\"巴中市\":[\"巴州区\",\"南江县\",\"平昌县\",\"通江县\"],\"资阳市\":[\"雁江区\",\"简阳市\",\"安岳县\",\"乐至县\"],\"阿坝藏族羌族自治州\":[\"马尔康县\",\"九寨沟县\",\"红原县\",\"汶川县\",\"阿坝县\",\"理县\",\"若尔盖县\",\"小金县\",\"黑水县\",\"金川县\",\"松潘县\",\"壤塘县\",\"茂县\"],\"甘孜藏族自治州\":[\"康定县\",\"丹巴县\",\"炉霍县\",\"九龙县\",\"甘孜县\",\"雅江县\",\"新龙县\",\"道孚县\",\"白玉县\",\"理塘县\",\"德格县\",\"乡城县\",\"石渠县\",\"稻城县\",\"色达县\",\"巴塘县\",\"泸定县\",\"得荣县\"],\"凉山彝族自治州\":[\"西昌市\",\"美姑县\",\"昭觉县\",\"金阳县\",\"甘洛县\",\"布拖县\",\"雷波县\",\"普格县\",\"宁南县\",\"喜德县\",\"会东县\",\"越西县\",\"会理县\",\"盐源县\",\"德昌县\",\"冕宁县\",\"木里藏族自治县\"],\"贵阳市\":[\"乌当区\",\"南明区\",\"云岩区\",\"花溪区\",\"白云区\",\"小河区\",\"清镇市\",\"开阳县\",\"息烽县\",\"修文县\"],\"六盘水市\":[\"钟山区\",\"六枝特区\",\"盘县\",\"水城县\"],\"遵义市\":[\"红花岗区\",\"汇川区\",\"赤水市\",\"仁怀市\",\"遵义县\",\"绥阳县\",\"桐梓县\",\"习水县\",\"凤冈县\",\"正安县\",\"余庆县\",\"湄潭县\",\"道真仡佬族苗族自治县\",\"务川仡佬族苗族自治县\"],\"安顺市\":[\"西秀区\",\"普定县\",\"平坝县\",\"镇宁布依族苗族自治县\",\"紫云苗族布依族自治县\",\"关岭布依族苗族自治县\"],\"铜仁地区\":[\"铜仁市\",\"德江县\",\"江口县\",\"思南县\",\"石阡县\",\"玉屏侗族自治县\",\"松桃苗族自治县\",\"印江土家族苗族自治县\",\"沿河土家族自治县\",\"万山特区\"],\"毕节地区\":[\"毕节市\",\"黔西县\",\"大方县\",\"织金县\",\"金沙县\",\"赫章县\",\"纳雍县\",\"威宁彝族回族苗族自治县\"],\"黔西南布依族苗族自治州\":[\"兴义市\",\"望谟县\",\"兴仁县\",\"普安县\",\"册亨县\",\"晴隆县\",\"贞丰县\",\"安龙县\"],\"黔东南苗族侗族自治州\":[\"凯里市\",\"施秉县\",\"从江县\",\"锦屏县\",\"镇远县\",\"麻江县\",\"台江县\",\"天柱县\",\"黄平县\",\"榕江县\",\"剑河县\",\"三穗县\",\"雷山县\",\"黎平县\",\"岑巩县\",\"丹寨县\"],\"黔南布依族苗族自治州\":[\"都匀市\",\"福泉市\",\"贵定县\",\"惠水县\",\"罗甸县\",\"瓮安县\",\"荔波县\",\"龙里县\",\"平塘县\",\"长顺县\",\"独山县\",\"三都水族自治县\"],\"昆明市\":[\"盘龙区\",\"五华区\",\"官渡区\",\"西山区\",\"东川区\",\"安宁市\",\"呈贡县\",\"晋宁县\",\"富民县\",\"宜良县\",\"嵩明县\",\"石林彝族自治县\",\"禄劝彝族苗族自治县\",\"寻甸回族彝族自治县\"],\"曲靖市\":[\"麒麟区\",\"宣威市\",\"马龙县\",\"沾益县\",\"富源县\",\"罗平县\",\"师宗县\",\"陆良县\",\"会泽县\"],\"玉溪市\":[\"红塔区\",\"江川县\",\"澂江县\",\"通海县\",\"华宁县\",\"易门县\",\"峨山彝族自治县\",\"新平彝族傣族自治县\",\"元江哈尼族彝族傣族自治县\"],\"保山市\":[\"隆阳区\",\"施甸县\",\"腾冲县\",\"龙陵县\",\"昌宁县\"],\"昭通市\":[\"昭阳区\",\"鲁甸县\",\"巧家县\",\"盐津县\",\"大关县\",\"永善县\",\"绥江县\",\"镇雄县\",\"彝良县\",\"威信县\",\"水富县\"],\"丽江市\":[\"古城区\",\"永胜县\",\"华坪县\",\"玉龙纳西族自治县\",\"宁蒗彝族自治县\"],\"普洱市\":[\"思茅区\",\"宁洱哈尼族彝族自治县\",\"墨江哈尼族自治县\",\"景东彝族自治县\",\"景谷傣族彝族自治县\",\"镇沅彝族哈尼族拉祜族自治县\",\"江城哈尼族彝族自治县\",\"孟连傣族拉祜族佤族自治县\",\"澜沧拉祜族自治县\",\"西盟佤族自治县\"],\"临沧市\":[\"临翔区\",\"凤庆县\",\"云县\",\"永德县\",\"镇康县\",\"双江拉祜族佤族布朗族傣族自治县\",\"耿马傣族佤族自治县\",\"沧源佤族自治县\"],\"德宏傣族景颇族自治州\":[\"潞西市\",\"瑞丽市\",\"梁河县\",\"盈江县\",\"陇川县\"],\"怒江傈僳族自治州\":[\"泸水县\",\"福贡县\",\"贡山独龙族怒族自治县\",\"兰坪白族普米族自治县\"],\"迪庆藏族自治州\":[\"香格里拉县\",\"德钦县\",\"维西傈僳族自治县\"],\"大理白族自治州\":[\"大理市\",\"祥云县\",\"宾川县\",\"弥渡县\",\"永平县\",\"云龙县\",\"洱源县\",\"剑川县\",\"鹤庆县\",\"漾濞彝族自治县\",\"南涧彝族自治县\",\"巍山彝族回族自治县\"],\"楚雄彝族自治州\":[\"楚雄市\",\"双柏县\",\"牟定县\",\"南华县\",\"姚安县\",\"大姚县\",\"永仁县\",\"元谋县\",\"武定县\",\"禄丰县\"],\"红河哈尼族彝族自治州\":[\"蒙自县\",\"个旧市\",\"开远市\",\"绿春县\",\"建水县\",\"石屏县\",\"弥勒县\",\"泸西县\",\"元阳县\",\"红河县\",\"金平苗族瑶族傣族自治县\",\"河口瑶族自治县\",\"屏边苗族自治县\"],\"文山壮族苗族自治州\":[\"文山县\",\"砚山县\",\"西畴县\",\"麻栗坡县\",\"马关县\",\"丘北县\",\"广南县\",\"富宁县\"],\"西双版纳傣族自治州\":[\"景洪市\",\"勐海县\",\"勐腊县\"],\"西安市\":[\"未央区\",\"莲湖区\",\"新城区\",\"碑林区\",\"雁塔区\",\"灞桥区\",\"阎良区\",\"临潼区\",\"长安区\",\"高陵县\",\"蓝田县\",\"户县\",\"周至县\"],\"铜川市\":[\"耀州区\",\"王益区\",\"印台区\",\"宜君县\"],\"宝鸡市\":[\"金台区\",\"渭滨区\",\"陈仓区\",\"岐山县\",\"凤翔县\",\"陇县\",\"太白县\",\"麟游县\",\"扶风县\",\"千阳县\",\"眉县\",\"凤县\"],\"咸阳市\":[\"秦都区\",\"渭城区\",\"杨陵区\",\"兴平市\",\"礼泉县\",\"泾阳县\",\"永寿县\",\"三原县\",\"彬县\",\"旬邑县\",\"长武县\",\"乾县\",\"武功县\",\"淳化县\"],\"渭南市\":[\"临渭区\",\"韩城市\",\"华阴市\",\"蒲城县\",\"潼关县\",\"白水县\",\"澄城县\",\"华县\",\"合阳县\",\"富平县\",\"大荔县\"],\"延安市\":[\"宝塔区\",\"安塞县\",\"洛川县\",\"子长县\",\"黄陵县\",\"延川县\",\"富县\",\"延长县\",\"甘泉县\",\"宜川县\",\"志丹县\",\"黄龙县\",\"吴起县\"],\"汉中市\":[\"汉台区\",\"留坝县\",\"镇巴县\",\"城固县\",\"南郑县\",\"洋县\",\"宁强县\",\"佛坪县\",\"勉县\",\"西乡县\",\"略阳县\"],\"榆林市\":[\"榆阳区\",\"清涧县\",\"绥德县\",\"神木县\",\"佳县\",\"府谷县\",\"子洲县\",\"靖边县\",\"横山县\",\"米脂县\",\"吴堡县\",\"定边县\"],\"安康市\":[\"汉滨区\",\"紫阳县\",\"岚皋县\",\"旬阳县\",\"镇坪县\",\"平利县\",\"石泉县\",\"宁陕县\",\"白河县\",\"汉阴县\"],\"商洛市\":[\"商州区\",\"镇安县\",\"山阳县\",\"洛南县\",\"商南县\",\"丹凤县\",\"柞水县\"],\"兰州市\":[\"城关区\",\"七里河区\",\"西固区\",\"安宁区\",\"红古区\",\"永登县\",\"皋兰县\",\"榆中县\"],\"嘉峪关市\":[],\"金昌市\":[\"金川区\",\"永昌县\"],\"白银市\":[\"白银区\",\"平川区\",\"靖远县\",\"会宁县\",\"景泰县\"],\"天水市\":[\"秦州区\",\"麦积区\",\"清水县\",\"秦安县\",\"甘谷县\",\"武山县\",\"张家川回族自治县\"],\"武威市\":[\"凉州区\",\"民勤县\",\"古浪县\",\"天祝藏族自治县\"],\"酒泉市\":[\"肃州区\",\"玉门市\",\"敦煌市\",\"金塔县\",\"瓜州县\",\"肃北蒙古族自治县\",\"阿克塞哈萨克族自治县\"],\"张掖市\":[\"甘州区\",\"民乐县\",\"临泽县\",\"高台县\",\"山丹县\",\"肃南裕固族自治县\"],\"庆阳市\":[\"西峰区\",\"庆城县\",\"环县\",\"华池县\",\"合水县\",\"正宁县\",\"宁县\",\"镇原县\"],\"平凉市\":[\"崆峒区\",\"泾川县\",\"灵台县\",\"崇信县\",\"华亭县\",\"庄浪县\",\"静宁县\"],\"定西市\":[\"安定区\",\"通渭县\",\"临洮县\",\"漳县\",\"岷县\",\"渭源县\",\"陇西县\"],\"陇南市\":[\"武都区\",\"成县\",\"宕昌县\",\"康县\",\"文县\",\"西和县\",\"礼县\",\"两当县\",\"徽县\"],\"临夏回族自治州\":[\"临夏市\",\"临夏县\",\"康乐县\",\"永靖县\",\"广河县\",\"和政县\",\"东乡族自治县\",\"积石山保安族东乡族撒拉族自治县\"],\"甘南藏族自治州\":[\"合作市\",\"临潭县\",\"卓尼县\",\"舟曲县\",\"迭部县\",\"玛曲县\",\"碌曲县\",\"夏河县\"],\"西宁市\":[\"城中区\",\"城东区\",\"城西区\",\"城北区\",\"湟源县\",\"湟中县\",\"大通回族土族自治县\"],\"海东地区\":[\"平安县\",\"乐都县\",\"民和回族土族自治县\",\"互助土族自治县\",\"化隆回族自治县\",\"循化撒拉族自治县\"],\"海北藏族自治州\":[\"海晏县\",\"祁连县\",\"刚察县\",\"门源回族自治县\"],\"海南藏族自治州\":[\"共和县\",\"同德县\",\"贵德县\",\"兴海县\",\"贵南县\"],\"黄南藏族自治州\":[\"同仁县\",\"尖扎县\",\"泽库县\",\"河南蒙古族自治县\"],\"果洛藏族自治州\":[\"玛沁县\",\"班玛县\",\"甘德县\",\"达日县\",\"久治县\",\"玛多县\"],\"玉树藏族自治州\":[\"玉树县\",\"杂多县\",\"称多县\",\"治多县\",\"囊谦县\",\"曲麻莱县\"],\"海西蒙古族藏族自治州\":[\"德令哈市\",\"格尔木市\",\"乌兰县\",\"都兰县\",\"天峻县\"],\"呼和浩特市\":[\"回民区\",\"玉泉区\",\"新城区\",\"赛罕区\",\"托克托县\",\"清水河县\",\"武川县\",\"和林格尔县\",\"土默特左旗\"],\"包头市\":[\"昆都仑区\",\"青山区\",\"东河区\",\"九原区\",\"石拐区\",\"白云矿区\",\"固阳县\",\"土默特右旗\",\"达尔罕茂明安联合旗\"],\"乌海市\":[\"海勃湾区\",\"乌达区\",\"海南区\"],\"赤峰市\":[\"红山区\",\"元宝山区\",\"松山区\",\"宁城县\",\"林西县\",\"喀喇沁旗\",\"巴林左旗\",\"敖汉旗\",\"阿鲁科尔沁旗\",\"翁牛特旗\",\"克什克腾旗\",\"巴林右旗\"],\"通辽市\":[\"科尔沁区\",\"霍林郭勒市\",\"开鲁县\",\"科尔沁左翼中旗\",\"科尔沁左翼后旗\",\"库伦旗\",\"奈曼旗\",\"扎鲁特旗\"],\"鄂尔多斯市\":[\"东胜区\",\"准格尔旗\",\"乌审旗\",\"伊金霍洛旗\",\"鄂托克旗\",\"鄂托克前旗\",\"杭锦旗\",\"达拉特旗\"],\"呼伦贝尔市\":[\"海拉尔区\",\"满洲里市\",\"牙克石市\",\"扎兰屯市\",\"根河市\",\"额尔古纳市\",\"陈巴尔虎旗\",\"阿荣旗\",\"新巴尔虎左旗\",\"新巴尔虎右旗\",\"鄂伦春自治旗\",\"莫力达瓦达斡尔族自治旗\",\"鄂温克族自治旗\"],\"巴彦淖尔市\":[\"临河区\",\"五原县\",\"磴口县\",\"杭锦后旗\",\"乌拉特中旗\",\"乌拉特前旗\",\"乌拉特后旗\"],\"乌兰察布市\":[\"集宁区\",\"丰镇市\",\"兴和县\",\"卓资县\",\"商都县\",\"凉城县\",\"化德县\",\"四子王旗\",\"察哈尔右翼前旗\",\"察哈尔右翼中旗\",\"察哈尔右翼后旗\"],\"锡林郭勒盟\":[\"锡林浩特市\",\"二连浩特市\",\"多伦县\",\"阿巴嘎旗\",\"西乌珠穆沁旗\",\"东乌珠穆沁旗\",\"苏尼特左旗\",\"苏尼特右旗\",\"太仆寺旗\",\"正镶白旗\",\"正蓝旗\",\"镶黄旗\"],\"兴安盟\":[\"乌兰浩特市\",\"阿尔山市\",\"突泉县\",\"扎赉特旗\",\"科尔沁右翼前旗\",\"科尔沁右翼中旗\"],\"阿拉善盟\":[\"阿拉善左旗\",\"阿拉善右旗\",\"额济纳旗\"],\"南宁市\":[\"青秀区\",\"兴宁区\",\"西乡塘区\",\"良庆区\",\"江南区\",\"邕宁区\",\"武鸣县\",\"隆安县\",\"马山县\",\"上林县\",\"宾阳县\",\"横县\"],\"柳州市\":[\"城中区\",\"鱼峰区\",\"柳北区\",\"柳南区\",\"柳江县\",\"柳城县\",\"鹿寨县\",\"融安县\",\"融水苗族自治县\",\"三江侗族自治县\"],\"桂林市\":[\"象山区\",\"秀峰区\",\"叠彩区\",\"七星区\",\"雁山区\",\"阳朔县\",\"临桂县\",\"灵川县\",\"全州县\",\"平乐县\",\"兴安县\",\"灌阳县\",\"荔浦县\",\"资源县\",\"永福县\",\"龙胜各族自治县\",\"恭城瑶族自治县\"],\"梧州市\":[\"万秀区\",\"蝶山区\",\"长洲区\",\"岑溪市\",\"苍梧县\",\"藤县\",\"蒙山县\"],\"北海市\":[\"海城区\",\"银海区\",\"铁山港区\",\"合浦县\"],\"防城港市\":[\"港口区\",\"防城区\",\"东兴市\",\"上思县\"],\"钦州市\":[\"钦南区\",\"钦北区\",\"灵山县\",\"浦北县\"],\"贵港市\":[\"港北区\",\"港南区\",\"覃塘区\",\"桂平市\",\"平南县\"],\"玉林市\":[\"玉州区\",\"北流市\",\"容县\",\"陆川县\",\"博白县\",\"兴业县\"],\"百色市\":[\"右江区\",\"凌云县\",\"平果县\",\"西林县\",\"乐业县\",\"德保县\",\"田林县\",\"田阳县\",\"靖西县\",\"田东县\",\"那坡县\",\"隆林各族自治县\"],\"贺州市\":[\"八步区\",\"钟山县\",\"昭平县\",\"富川瑶族自治县\"],\"河池市\":[\"金城江区\",\"宜州市\",\"天峨县\",\"凤山县\",\"南丹县\",\"东兰县\",\"都安瑶族自治县\",\"罗城仫佬族自治县\",\"巴马瑶族自治县\",\"环江毛南族自治县\",\"大化瑶族自治县\"],\"来宾市\":[\"兴宾区\",\"合山市\",\"象州县\",\"武宣县\",\"忻城县\",\"金秀瑶族自治县\"],\"崇左市\":[\"江州区\",\"凭祥市\",\"宁明县\",\"扶绥县\",\"龙州县\",\"大新县\",\"天等县\"],\"拉萨市\":[\"城关区\",\"林周县\",\"当雄县\",\"尼木县\",\"曲水县\",\"堆龙德庆县\",\"达孜县\",\"墨竹工卡县\"],\"那曲地区\":[\"那曲县\",\"嘉黎县\",\"比如县\",\"聂荣县\",\"安多县\",\"申扎县\",\"索县\",\"班戈县\",\"巴青县\",\"尼玛县\"],\"昌都地区\":[\"昌都县\",\"江达县\",\"贡觉县\",\"类乌齐县\",\"丁青县\",\"察雅县\",\"八宿县\",\"左贡县\",\"芒康县\",\"洛隆县\",\"边坝县\"],\"林芝地区\":[\"林芝县\",\"工布江达县\",\"米林县\",\"墨脱县\",\"波密县\",\"察隅县\",\"朗县\"],\"山南地区\":[\"乃东县\",\"扎囊县\",\"贡嘎县\",\"桑日县\",\"琼结县\",\"曲松县\",\"措美县\",\"洛扎县\",\"加查县\",\"隆子县\",\"错那县\",\"浪卡子县\"],\"日喀则地区\":[\"日喀则市\",\"南木林县\",\"江孜县\",\"定日县\",\"萨迦县\",\"拉孜县\",\"昂仁县\",\"谢通门县\",\"白朗县\",\"仁布县\",\"康马县\",\"定结县\",\"仲巴县\",\"亚东县\",\"吉隆县\",\"聂拉木县\",\"萨嘎县\",\"岗巴县\"],\"阿里地区\":[\"噶尔县\",\"普兰县\",\"札达县\",\"日土县\",\"革吉县\",\"改则县\",\"措勤县\"],\"银川市\":[\"兴庆区\",\"西夏区\",\"金凤区\",\"灵武市\",\"永宁县\",\"贺兰县\"],\"石嘴山市\":[\"大武口区\",\"惠农区\",\"平罗县\"],\"吴忠市\":[\"利通区\",\"青铜峡市\",\"盐池县\",\"同心县\"],\"固原市\":[\"原州区\",\"西吉县\",\"隆德县\",\"泾源县\",\"彭阳县\"],\"中卫市\":[\"沙坡头区\",\"中宁县\",\"海原县\"],\"乌鲁木齐市\":[\"天山区\",\"沙依巴克区\",\"新市区\",\"水磨沟区\",\"头屯河区\",\"达坂城区\",\"米东区\",\"乌鲁木齐县\"],\"克拉玛依市\":[\"克拉玛依区\",\"独山子区\",\"白碱滩区\",\"乌尔禾区\"],\"吐鲁番地区\":[\"吐鲁番市\",\"托克逊县\",\"鄯善县\"],\"哈密地区\":[\"哈密市\",\"伊吾县\",\"巴里坤哈萨克自治县\"],\"和田地区\":[\"和田市\",\"和田县\",\"洛浦县\",\"民丰县\",\"皮山县\",\"策勒县\",\"于田县\",\"墨玉县\"],\"阿克苏地区\":[\"阿克苏市\",\"温宿县\",\"沙雅县\",\"拜城县\",\"阿瓦提县\",\"库车县\",\"柯坪县\",\"新和县\",\"乌什县\"],\"喀什地区\":[\"喀什市\",\"巴楚县\",\"泽普县\",\"伽师县\",\"叶城县\",\"岳普湖县\",\"疏勒县\",\"麦盖提县\",\"英吉沙县\",\"莎车县\",\"疏附县\",\"塔什库尔干塔吉克自治县\"],\"克孜勒苏柯尔克孜自治州\":[\"阿图什市\",\"阿合奇县\",\"乌恰县\",\"阿克陶县\"],\"巴音郭楞蒙古自治州\":[\"库尔勒市\",\"和静县\",\"尉犁县\",\"和硕县\",\"且末县\",\"博湖县\",\"轮台县\",\"若羌县\",\"焉耆回族自治县\"],\"昌吉回族自治州\":[\"昌吉市\",\"阜康市\",\"奇台县\",\"玛纳斯县\",\"吉木萨尔县\",\"呼图壁县\",\"木垒哈萨克自治县\"],\"博尔塔拉蒙古自治州\":[\"博乐市\",\"精河县\",\"温泉县\"],\"石河子市\":[],\"阿拉尔市\":[],\"图木舒克市\":[],\"五家渠市\":[],\"伊犁哈萨克自治州\":[\"伊宁市\",\"奎屯市\",\"伊宁县\",\"特克斯县\",\"尼勒克县\",\"昭苏县\",\"新源县\",\"霍城县\",\"巩留县\",\"察布查尔锡伯自治县\"],\"塔城地区\":[\"塔城市\",\"乌苏市\",\"额敏县\",\"裕民县\",\"沙湾县\",\"托里县\",\"和布克赛尔蒙古自治县\"],\"阿勒泰地区\":[\"阿勒泰市\",\"青河县\",\"吉木乃县\",\"富蕴县\",\"布尔津县\",\"福海县\",\"哈巴河县\"],\"中西区\":[],\"湾仔区\":[],\"东区\":[],\"南区\":[],\"黄大仙区\":[],\"观塘区\":[],\"深水埗区\":[],\"油尖旺区\":[],\"九龙城区\":[],\"北区\":[],\"大埔区\":[],\"沙田区\":[],\"西贡区\":[],\"元朗区\":[],\"屯门区\":[],\"荃湾区\":[],\"葵青区\":[],\"离岛区\":[],\"花地玛堂区\":[],\"圣安多尼堂区\":[],\"大堂区\":[],\"望德堂区\":[],\"风顺堂区\":[],\"氹仔\":[],\"路环\":[],\"路氹城\":[],\"台北市\":[],\"高雄市\":[],\"基隆市\":[],\"新竹市\":[],\"台中市\":[],\"嘉义市\":[],\"台南市\":[],\"台北县\":[],\"桃园县\":[],\"新竹县\":[],\"苗栗县\":[],\"台中县\":[],\"彰化县\":[],\"南投县\":[],\"云林县\":[],\"嘉义县\":[],\"台南县\":[],\"高雄县\":[],\"屏东县\":[],\"宜兰县\":[],\"花莲县\":[],\"台东县\":[],\"澎湖县\":[],\"金门县\":[],\"连江县\":[]}");

        #endregion

        #region 表格相关

        /// <summary>
        /// 选中的行
        /// </summary>
        /// <param name="grid"></param>
        /// <returns></returns>
        protected string HowManyRowsAreSelected(Grid grid)
        {
            StringBuilder sb = new StringBuilder();
            int selectedCount = grid.SelectedRowIndexArray.Length;
            if (selectedCount > 0)
            {
                sb.AppendFormat("共选中了 {0} 行：", selectedCount);
                sb.Append("<table class=\"result\">");

                sb.Append("<tr><th>行号</th>");
                foreach (string datakey in grid.DataKeyNames)
                {
                    sb.AppendFormat("<th>{0}</th>", datakey);
                }
                sb.Append("</tr>");


                for (int i = 0; i < selectedCount; i++)
                {
                    int rowIndex = grid.SelectedRowIndexArray[i];
                    sb.Append("<tr>");

                    sb.AppendFormat("<td>{0}</td>", rowIndex + 1);

                    // 如果是内存分页，所有分页的数据都存在，rowIndex 就是在全部数据中的顺序，而不是当前页的顺序
                    if (grid.AllowPaging && !grid.IsDatabasePaging)
                    {
                        rowIndex = grid.PageIndex * grid.PageSize + rowIndex;
                    }

                    object[] dataKeys = grid.DataKeys[rowIndex];
                    for (int j = 0; j < dataKeys.Length; j++)
                    {
                        sb.AppendFormat("<td>{0}</td>", dataKeys[j]);
                    }

                    sb.Append("</tr>");
                }
                sb.Append("</table>");
            }
            else
            {
                sb.Append("<strong>没有选中任何一行！</strong>");
            }

            return sb.ToString();
        }

        /// <summary>
        /// 获取性别的字面值，在 ASPX 中调用
        /// </summary>
        /// <param name="gender"></param>
        /// <returns></returns>
        protected string GetGender(object gender)
        {
            if (Convert.ToInt32(gender) == 1)
            {
                return "男";
            }
            else
            {
                return "女";
            }
        }

        protected DataTable GetClassDataTable()
        {
            DataTable table = new DataTable();
            table.Columns.Add(new DataColumn("Id", typeof(int)));
            table.Columns.Add(new DataColumn("Name", typeof(String)));
            table.Columns.Add(new DataColumn("EntranceYear", typeof(String)));
            table.Columns.Add(new DataColumn("LogTime", typeof(DateTime)));
            table.Columns.Add(new DataColumn("Desc", typeof(string)));

            DataRow row = table.NewRow();

            row[0] = 101;
            row[1] = "班级一";
            row[2] = "2000";
            row[3] = DateTime.Parse("2000-09-01");
            row[4] = "班级一创建于2000年9月1号，班长胡飞，连续三年获得全校优秀班级称号。";
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 102;
            row[1] = "班级二";
            row[2] = "2005";
            row[3] = DateTime.Parse("2005-09-01");
            row[4] = "班级一创建于2005年9月1号，班长董婷婷，连续两年获得全校优秀班级称号。";
            table.Rows.Add(row);

            return table;
        }


        /// <summary>
        /// 获取模拟表格2
        /// </summary>
        /// <returns></returns>
        protected DataTable GetDataTable2()
        {
            DataTable table = new DataTable();
            table.Columns.Add(new DataColumn("Id", typeof(int)));
            table.Columns.Add(new DataColumn("Name", typeof(String)));
            table.Columns.Add(new DataColumn("EntranceYear", typeof(String)));
            table.Columns.Add(new DataColumn("AtSchool", typeof(bool)));
            table.Columns.Add(new DataColumn("Major", typeof(String)));
            table.Columns.Add(new DataColumn("Group", typeof(int)));
            table.Columns.Add(new DataColumn("Gender", typeof(int)));
            table.Columns.Add(new DataColumn("LogTime", typeof(DateTime)));
            table.Columns.Add(new DataColumn("Desc", typeof(string)));
            table.Columns.Add(new DataColumn("Guid", typeof(Guid)));
            table.Columns.Add(new DataColumn("Hobby", typeof(String)));
            table.Columns.Add(new DataColumn("EntranceDate", typeof(String)));
            table.Columns.Add(new DataColumn("Donate", typeof(int)));
            table.Columns.Add(new DataColumn("Fee", typeof(int)));
            // Hobby：reading,basketball,travel,movie,music
            // 爱好：读书, 篮球, 旅游, 电影, 音乐 

            DataRow row = null;

            row = table.NewRow();
            row[0] = 101;
            row[1] = "陈萍萍";
            row[2] = "2000";
            row[3] = true;
            row[4] = "计算机应用技术";
            row[5] = 1;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-100);
            row[8] = "陈萍萍，女，20岁，出生于中国南方的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball,travel";
            row[11] = "2000-09-01";
            row[12] = 299;
            row[13] = 2990;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 102;
            row[1] = "胡飞";
            row[2] = "2008";
            row[3] = false;
            row[4] = "信息工程";
            row[5] = 1;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-90);
            row[8] = "胡飞，男，20岁，出生于中国北方的一个小山村，毕业于南方科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball";
            row[11] = "2008-09-01";
            row[12] = 199;
            row[13] = 1990;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 103;
            row[1] = "金婷婷";
            row[2] = "2001";
            row[3] = true;
            row[4] = "会计学";
            row[5] = 2;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-80);
            row[8] = "金婷婷，女，28岁，出生于中国海南岛的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball,music";
            row[11] = "2001-09-01";
            row[12] = 299;
            row[13] = 3990;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 104;
            row[1] = "潘国";
            row[2] = "2008";
            row[3] = false;
            row[4] = "国际经济与贸易";
            row[5] = 2;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-70);
            row[8] = "潘国，男，22岁，出生于中国澳门的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,music";
            row[11] = "2008-09-01";
            row[12] = 399;
            row[13] = 3998;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 105;
            row[1] = "吴颖颖";
            row[2] = "2002";
            row[3] = true;
            row[4] = "市场营销";
            row[5] = 3;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-60);
            row[8] = "吴颖颖，女，26岁，出生于中国福建的一个小山村，毕业于香港科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,movie,music";
            row[11] = "2002-09-01";
            row[12] = 499;
            row[13] = 4992;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 106;
            row[1] = "张博";
            row[2] = "2003";
            row[3] = false;
            row[4] = "财务管理";
            row[5] = 3;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-50);
            row[8] = "张博，男，28岁，出生于中国浙江的一个小山村，毕业于电子科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "movie,music";
            row[11] = "2003-09-01";
            row[12] = 99;
            row[13] = 997;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 107;
            row[1] = "杨倩倩";
            row[2] = "2000";
            row[3] = true;
            row[4] = "材料物理与化学";
            row[5] = 4;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-40);
            row[8] = "杨倩倩，女，25岁，出生于中国北方的一个小山村，毕业于北京科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "travel,movie,music";
            row[11] = "2000-09-01";
            row[12] = 399;
            row[13] = 3995;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 108;
            row[1] = "董超";
            row[2] = "2004";
            row[3] = false;
            row[4] = "生物医学工程";
            row[5] = 4;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-30);
            row[8] = "董超，男，26岁，出生于中国河南的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "basketball,movie,music";
            row[11] = "2004-09-01";
            row[12] = 299;
            row[13] = 2996;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 109;
            row[1] = "张娟娟";
            row[2] = "2003";
            row[3] = true;
            row[4] = "土木工程";
            row[5] = 5;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-20);
            row[8] = "张娟娟，女，25岁，出生于中国广西的一个小山村，毕业于南方科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,travel,movie,music";
            row[11] = "2003-09-01";
            row[12] = 599;
            row[13] = 5990;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 110;
            row[1] = "叶鹏";
            row[2] = "2006";
            row[3] = false;
            row[4] = "电子商务";
            row[5] = 5;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-10);
            row[8] = "叶鹏，男，23岁，出生于中国安徽的一个小山村，毕业于国防科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,movie,music";
            row[11] = "2006-09-01";
            row[12] = 699;
            row[13] = 6990;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 111;
            row[1] = "李玲玲";
            row[2] = "2002";
            row[3] = true;
            row[4] = "管理学";
            row[5] = 5;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-5);
            row[8] = "李玲玲，女，22岁，出生于中国台湾的一个小山村，毕业于台湾科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,travel,music";
            row[11] = "2002-09-01";
            row[12] = 399;
            row[13] = 3990;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 112;
            row[1] = "张萍萍";
            row[2] = "2000";
            row[3] = true;
            row[4] = "计算机应用技术";
            row[5] = 1;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-100);
            row[8] = "张萍萍，女，20岁，出生于中国南方的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball,travel";
            row[11] = "2000-09-01";
            row[12] = 299;
            row[13] = 2999;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 113;
            row[1] = "曹飞";
            row[2] = "2008";
            row[3] = false;
            row[4] = "信息工程";
            row[5] = 1;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-90);
            row[8] = "曹飞，男，20岁，出生于中国北方的一个小山村，毕业于南方科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball";
            row[11] = "2008-09-01";
            row[12] = 399;
            row[13] = 3996;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 114;
            row[1] = "孙婷婷";
            row[2] = "2001";
            row[3] = true;
            row[4] = "会计学";
            row[5] = 2;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-80);
            row[8] = "孙婷婷，女，28岁，出生于中国海南岛的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball,music";
            row[11] = "2001-09-01";
            row[12] = 499;
            row[13] = 4990;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 115;
            row[1] = "董国";
            row[2] = "2008";
            row[3] = false;
            row[4] = "国际经济与贸易";
            row[5] = 2;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-70);
            row[8] = "董国，男，22岁，出生于中国澳门的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,music";
            row[11] = "2008-09-01";
            row[12] = 299;
            row[13] = 2992;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 116;
            row[1] = "习颖颖";
            row[2] = "2002";
            row[3] = true;
            row[4] = "市场营销";
            row[5] = 3;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-60);
            row[8] = "习颖颖，女，26岁，出生于中国福建的一个小山村，毕业于香港科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,movie,music";
            row[11] = "2002-09-01";
            row[12] = 199;
            row[13] = 1990;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 117;
            row[1] = "李博";
            row[2] = "2003";
            row[3] = false;
            row[4] = "财务管理";
            row[5] = 3;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-50);
            row[8] = "李博，男，28岁，出生于中国浙江的一个小山村，毕业于电子科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "movie,music";
            row[11] = "2003-09-01";
            row[12] = 99;
            row[13] = 990;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 118;
            row[1] = "黄倩倩";
            row[2] = "2000";
            row[3] = true;
            row[4] = "材料物理与化学";
            row[5] = 4;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-40);
            row[8] = "黄倩倩，女，25岁，出生于中国北方的一个小山村，毕业于北京科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "travel,movie,music";
            row[11] = "2000-09-01";
            row[12] = 399;
            row[13] = 3990;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 119;
            row[1] = "韩超";
            row[2] = "2004";
            row[3] = false;
            row[4] = "生物医学工程";
            row[5] = 4;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-30);
            row[8] = "韩超，男，26岁，出生于中国河南的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "basketball,movie,music";
            row[11] = "2004-09-01";
            row[12] = 399;
            row[13] = 3991;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 120;
            row[1] = "王娟娟";
            row[2] = "2003";
            row[3] = true;
            row[4] = "土木工程";
            row[5] = 5;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-20);
            row[8] = "王娟娟，女，25岁，出生于中国广西的一个小山村，毕业于南方科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,travel,movie,music";
            row[11] = "2003-09-01";
            row[12] = 399;
            row[13] = 3992;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 121;
            row[1] = "周鹏";
            row[2] = "2006";
            row[3] = false;
            row[4] = "电子商务";
            row[5] = 5;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-10);
            row[8] = "周鹏，男，23岁，出生于中国安徽的一个小山村，毕业于国防科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,movie,music";
            row[11] = "2006-09-01";
            row[12] = 299;
            row[13] = 2992;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 122;
            row[1] = "吴玲玲";
            row[2] = "2002";
            row[3] = true;
            row[4] = "管理学";
            row[5] = 5;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-5);
            row[8] = "吴玲玲，女，22岁，出生于中国台湾的一个小山村，毕业于台湾科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,travel,music";
            row[11] = "2002-09-01";
            row[12] = 399;
            row[13] = 3993;
            table.Rows.Add(row);


            return table;
        }

        /// <summary>
        /// 获取模拟表格
        /// </summary>
        /// <returns></returns>
        protected DataTable GetDataTable()
        {
            DataTable table = new DataTable();
            table.Columns.Add(new DataColumn("Id", typeof(int)));
            table.Columns.Add(new DataColumn("Name", typeof(String)));
            table.Columns.Add(new DataColumn("EntranceYear", typeof(String)));
            table.Columns.Add(new DataColumn("AtSchool", typeof(bool)));
            table.Columns.Add(new DataColumn("Major", typeof(String)));
            table.Columns.Add(new DataColumn("Group", typeof(int)));
            table.Columns.Add(new DataColumn("Gender", typeof(int)));
            table.Columns.Add(new DataColumn("LogTime", typeof(DateTime)));
            table.Columns.Add(new DataColumn("Desc", typeof(string)));
            table.Columns.Add(new DataColumn("Guid", typeof(Guid)));
            table.Columns.Add(new DataColumn("Hobby", typeof(String)));
            table.Columns.Add(new DataColumn("EntranceDate", typeof(String)));
            // Hobby：reading,basketball,travel,movie,music
            // 爱好：读书, 篮球, 旅游, 电影, 音乐 
            table.Columns.Add(new DataColumn("ChineseScore", typeof(Int32)));
            table.Columns.Add(new DataColumn("MathScore", typeof(Int32)));
            table.Columns.Add(new DataColumn("TotalScore", typeof(Int32)));


            DataRow row = table.NewRow();
            row[0] = 101;
            row[1] = "张萍萍";
            row[2] = "2000";
            row[3] = true;
            row[4] = "材料科学与工程系";
            row[5] = 1;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-100);
            row[8] = "张萍萍，女，20岁，出生于中国南方的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,travel,music";
            row[11] = "2000-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 102;
            row[1] = "陈飞";
            row[2] = "2001";
            row[3] = false;
            row[4] = "化学系";
            row[5] = 1;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-90);
            row[8] = "陈飞，男，20岁，出生于中国北方的一个小山村，毕业于南方科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "basketball,travel,movie,reading,music";
            row[11] = "2001-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 103;
            row[1] = "董婷婷";
            row[2] = "2008";
            row[3] = true;
            row[4] = "化学系";
            row[5] = 2;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-80);
            row[8] = "董婷婷，女，28岁，出生于中国海南岛的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "basketball,movie,music";
            row[11] = "2008-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 104;
            row[1] = "刘国";
            row[2] = "2002";
            row[3] = false;
            row[4] = "化学系";
            row[5] = 2;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-70);
            row[8] = "刘国，男，22岁，出生于中国澳门的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball,movie";
            row[11] = "2002-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 105;
            row[1] = "康颖颖";
            row[2] = "2008";
            row[3] = true;
            row[4] = "数学系";
            row[5] = 3;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-60);
            row[8] = "康颖颖，女，26岁，出生于中国福建的一个小山村，毕业于香港科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,travel,movie,music";
            row[11] = "2008-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 106;
            row[1] = "彭博";
            row[2] = "2003";
            row[3] = false;
            row[4] = "数学系";
            row[5] = 3;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-50);
            row[8] = "彭博，男，28岁，出生于中国浙江的一个小山村，毕业于电子科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "basketball,travel,music";
            row[11] = "2003-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 107;
            row[1] = "黄倩倩";
            row[2] = "2000";
            row[3] = true;
            row[4] = "数学系";
            row[5] = 4;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-40);
            row[8] = "黄倩倩，女，25岁，出生于中国北方的一个小山村，毕业于北京科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "travel,movie,music,reading";
            row[11] = "2000-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 108;
            row[1] = "唐超";
            row[2] = "2004";
            row[3] = false;
            row[4] = "物理系";
            row[5] = 4;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-30);
            row[8] = "唐超，男，26岁，出生于中国河南的一个小山村，毕业于中国科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,movie,music,basketball";
            row[11] = "2004-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);


            row = table.NewRow();
            row[0] = 109;
            row[1] = "杨娟娟";
            row[2] = "2003";
            row[3] = true;
            row[4] = "物理系";
            row[5] = 5;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-20);
            row[8] = "杨娟娟，女，25岁，出生于中国广西的一个小山村，毕业于南方科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball,movie";
            row[11] = "2003-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 110;
            row[1] = "徐鹏";
            row[2] = "2002";
            row[3] = false;
            row[4] = "物理系";
            row[5] = 5;
            row[6] = 1;
            row[7] = DateTime.Now.AddDays(-10);
            row[8] = "徐鹏，男，23岁，出生于中国安徽的一个小山村，毕业于国防科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,basketball,travel";
            row[11] = "2002-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);

            row = table.NewRow();
            row[0] = 111;
            row[1] = "纪玲玲";
            row[2] = "2006";
            row[3] = true;
            row[4] = "自动化系";
            row[5] = 5;
            row[6] = 0;
            row[7] = DateTime.Now.AddDays(-5);
            row[8] = "纪玲玲，女，22岁，出生于中国台湾的一个小山村，毕业于台湾科学技术大学。";
            row[9] = Guid.NewGuid();
            row[10] = "reading,movie,music,basketball";
            row[11] = "2006-09-01";
            row[12] = 80;
            row[13] = 0;
            row[14] = 0;
            table.Rows.Add(row);


            return table;
        }

        /// <summary>
        /// 获取空数据表
        /// </summary>
        /// <returns></returns>
        protected DataTable GetEmptyDataTable()
        {
            DataTable table = new DataTable();
            table.Columns.Add(new DataColumn("Id", typeof(int)));
            table.Columns.Add(new DataColumn("Name", typeof(String)));
            table.Columns.Add(new DataColumn("EntranceYear", typeof(String)));
            table.Columns.Add(new DataColumn("AtSchool", typeof(bool)));
            table.Columns.Add(new DataColumn("Major", typeof(String)));
            table.Columns.Add(new DataColumn("Group", typeof(int)));
            table.Columns.Add(new DataColumn("Gender", typeof(int)));


            return table;
        }


        #endregion

        #region 压缩ViewState

        //protected override object LoadPageStateFromPersistenceMedium()
        //{
        //    string gzippedState = Request.Form[StringUtil.GZIPPED_VIEWSTATE_ID];
        //    return StringUtil.LoadGzippedViewState(gzippedState);
        //}

        //protected override void SavePageStateToPersistenceMedium(object viewState)
        //{
        //    ClientScript.RegisterHiddenField(StringUtil.GZIPPED_VIEWSTATE_ID, StringUtil.GenerateGzippedViewState(viewState));
        //} 

        #endregion

        #region 实用函数

        /// <summary>
        /// 获取回发的参数
        /// </summary>
        /// <returns></returns>
        public string GetRequestEventArgument()
        {
            return Request.Form["__EVENTARGUMENT"];
        }

        #endregion

    }

}
