﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

namespace FineUI.Examples.grid
{
    public partial class grid_checkboxfield_rowcheckall : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGrid();
            }
        }

        #region BindGrid

        private void BindGrid()
        {
            DataTable table = GetDataTable();

            Grid1.DataSource = table;
            Grid1.DataBind();

        }

        #endregion

        #region Events

        protected void Button1_Click(object sender, EventArgs e)
        {
            CheckBoxField field1 = (CheckBoxField)Grid1.FindColumn("CheckBoxField1");
            CheckBoxField field2 = (CheckBoxField)Grid1.FindColumn("CheckBoxField2");
            CheckBoxField field3 = (CheckBoxField)Grid1.FindColumn("CheckBoxField3");

            StringBuilder sb = new StringBuilder();
            int selectedCount = Grid1.SelectedRowIndexArray.Length;
            if (selectedCount > 0)
            {
                sb.AppendFormat("共选中了 {0} 行：", selectedCount);
                sb.Append("<ol class=\"result\">");
                for (int i = 0; i < selectedCount; i++)
                {
                    int rowIndex = Grid1.SelectedRowIndexArray[i];
                    sb.Append("<li><ul>");

                    sb.AppendFormat("<li>行号：{0}</li>", rowIndex + 1);
                    sb.AppendFormat("<li>是否在校1：{0}</li>", field1.GetCheckedState(rowIndex));
                    sb.AppendFormat("<li>是否在校2：{0}</li>", field2.GetCheckedState(rowIndex));
                    sb.AppendFormat("<li>是否在校3：{0}</li>", field3.GetCheckedState(rowIndex));

                    sb.Append("</ul></li>");
                }
                sb.Append("</ol>");
            }
            else
            {
                sb.Append("<strong>没有选中任何一行！</strong>");
            }

            labResult.Text = sb.ToString();
        }


        

        private void ChangeCheckBoxStatus(bool checkedState)
        {
            CheckBoxField field1 = (CheckBoxField)Grid1.FindColumn("CheckBoxField1");
            CheckBoxField field2 = (CheckBoxField)Grid1.FindColumn("CheckBoxField2");
            CheckBoxField field3 = (CheckBoxField)Grid1.FindColumn("CheckBoxField3");


            foreach (int rowIndex in Grid1.SelectedRowIndexArray)
            {
                field1.SetCheckedState(rowIndex, checkedState);
                field2.SetCheckedState(rowIndex, checkedState);
                field3.SetCheckedState(rowIndex, checkedState);
            }

        }


        protected void btnSelectRows_Click(object sender, EventArgs e)
        {
            ChangeCheckBoxStatus(true);
        }

        protected void btnUnselectRows_Click(object sender, EventArgs e)
        {
            ChangeCheckBoxStatus(false);
        }

        #endregion

    }
}
