
#region Comment

/*
 * Project    FineUI
 * 
 * FileName:    GridColumn.cs
 * CreatedOn:   2008-05-19
 * CreatedBy:   30372245@qq.com
 * 
 * 
 * Description
 *      ->
 *   
 * History
 *      ->
 * 
 * 
 * 
 * 
 */

#endregion

using System;
using System.Collections;
using System.ComponentModel;
using System.ComponentModel.Design.Serialization;
using System.Text;
using System.Xml;
using System.Web;
using System.Web.UI;
using System.Globalization;
using System.Data;
using System.Reflection;
using System.Web.UI.WebControls;


namespace FineUI
{
    /// <summary>
    /// лࣩࣨ
    /// </summary>
    [ToolboxItem(false)]
    [ParseChildren(true)]
    [PersistChildren(false)]
    [DefaultProperty("HeaderText")]
    public abstract class GridColumn : ControlBase
    {
        #region Grid/ColumnIndex

        private Grid _grid;

        /// <summary>
        /// 
        /// </summary>
        [Browsable(false)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        [Description("")]
        public Grid Grid
        {
            get
            {
                if (_grid == null)
                {
                    _grid = GetParentGrid();
                }
                return _grid;
            }
        }

        private Grid GetParentGrid()
        {
            if (Parent is Grid)
            {
                return (Grid)Parent;
            }
            else
            {
                return ResolveParentGrid(Parent as GridColumn);
            }
        }

        private Grid ResolveParentGrid(GridColumn column)
        {
            if (column != null)
            {
                if (column.Parent is Grid)
                {
                    return (Grid)column.Parent;
                }
                else
                {
                    return ResolveParentGrid(column.Parent as GridColumn);
                }
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [Browsable(false)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        [Description("")]
        public int ColumnIndex
        {
            get
            {
                return Grid.AllColumns.IndexOf(this);
            }
        }

        #endregion

        #region SortField

        ///// <summary>
        ///// ǰеʽ
        ///// </summary>
        //[Browsable(false)]
        //[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        //public string SortExpression
        //{
        //    get
        //    {
        //        return String.Format("{0} {1}", SortField, SortDirection);
        //    }
        //}

        //public string _sortDirection = "ASC";

        ///// <summary>
        ///// 
        ///// </summary>
        //[Browsable(false)]
        //[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        //public string SortDirection
        //{
        //    get
        //    {
        //        return _sortDirection;
        //    }
        //    set
        //    {
        //        _sortDirection = value;
        //    }
        //}

        private string _sortField = String.Empty;

        /// <summary>
        /// ֶ
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue("")]
        [Description("ֶ")]
        public string SortField
        {
            get
            {
                return _sortField;
            }
            set
            {
                _sortField = value;
            }
        }

        #endregion

        #region Properties

        private bool _hidden = false;

        /// <summary>
        /// Ƿ
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue(false)]
        [Description("Ƿ")]
        public override bool Hidden
        {
            get
            {
                return _hidden;
            }
            set
            {
                _hidden = value;
            }
        }



        private string _columnID = String.Empty;

        /// <summary>
        /// IDûãΪClientID
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue("")]
        [Description("IDûãΪClientID")]
        public string ColumnID
        {
            get
            {
                if (String.IsNullOrEmpty(_columnID))
                {
                    return ClientID;
                }
                return _columnID;
            }
            set
            {
                _columnID = value;
            }
        }


        private string _headerText = String.Empty;
        /// <summary>
        /// ʾ
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue("")]
        [Description("ʾ")]
        public string HeaderText
        {
            get
            {
                return _headerText;
            }
            set
            {
                _headerText = value;
            }
        }

        private string _headerToolTip = String.Empty;
        /// <summary>
        /// ֵʾı
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue("")]
        [Description("ֵʾı")]
        public string HeaderToolTip
        {
            get
            {
                return _headerToolTip;
            }
            set
            {
                _headerToolTip = value;
            }
        }

        private ToolTipType _headerTooltipType = ToolTipType.Qtip;
        /// <summary>
        /// ֵʾı
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue(ToolTipType.Qtip)]
        [Description("ֵʾı")]
        public ToolTipType HeaderToolTipType
        {
            get
            {
                return _headerTooltipType;
            }
            set
            {
                _headerTooltipType = value;
            }
        }


        private Unit _width = Unit.Empty;
        /// <summary>
        /// п
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue(typeof(Unit), "")]
        [Description("п")]
        public virtual Unit Width
        {
            get
            {
                return _width;
            }
            set
            {
                _width = value;
            }
        }


        /// <summary>
        /// ӿؼĳߴ磨ʹHBox֣
        /// </summary>
        [Category(CategoryName.LAYOUT)]
        [DefaultValue(0)]
        [Description("ӿؼĳߴ磨ʹHBox֣")]
        public int BoxFlex
        {
            get
            {
                object obj = FState["BoxFlex"];
                return obj == null ? 0 : (int)obj;
            }
            set
            {
                FState["BoxFlex"] = value;
            }
        }


        private bool _expandUnusedSpace = false;

        /// <summary>
        /// лչδʹõĿ
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue(false)]
        [Description("лչδʹõĿ")]
        public bool ExpandUnusedSpace
        {
            get
            {
                return _expandUnusedSpace;
            }
            set
            {
                _expandUnusedSpace = value;
            }
        }


        private TextAlign _textalign = TextAlign.Left;

        /// <summary>
        /// ıλ
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue(TextAlign.Left)]
        [Description("ıλ")]
        public TextAlign TextAlign
        {
            get
            {
                return _textalign;
            }
            set
            {
                _textalign = value;
            }
        }

        private bool _enableHeaderMenu = true;
        /// <summary>
        /// ñͷ˵
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue(true)]
        [Description("ñͷ˵")]
        public virtual bool EnableHeaderMenu
        {
            get
            {
                return _enableHeaderMenu;
            }
            set
            {
                _enableHeaderMenu = value;
            }
        }


        private bool _enableColumnHide = true;
        /// <summary>
        /// й
        /// </summary>
        [Category(CategoryName.OPTIONS)]
        [DefaultValue(true)]
        [Description("й")]
        public virtual bool EnableColumnHide
        {
            get
            {
                return _enableColumnHide;
            }
            set
            {
                _enableColumnHide = value;
            }
        }


        /// <summary>
        /// Ԫʽ
        /// </summary>
        internal virtual string InnerCls
        {
            get
            {
                return String.Empty;
            }
        }


        #endregion

        #region virtual GetColumnValue/GetColumnState/PersistState

        /// <summary>
        /// ȡͷȾHTML
        /// </summary>
        /// <returns>ȾHTML</returns>
        internal virtual string GetHeaderValue()
        {
            return String.IsNullOrEmpty(HeaderText) ? "&nbsp;" : HeaderText;
        }

        /// <summary>
        /// ȡȾHTML
        /// </summary>
        /// <param name="row">ʵ</param>
        /// <returns>ȾHTML</returns>
        internal virtual string GetColumnValue(GridRow row)
        {
            return String.Empty;
        }


        /// <summary>
        /// ǷҪ״̬ĿǰֻCheckBoxFieldʵ壩
        /// </summary>
        internal virtual bool PersistState
        {
            get
            {
                return false;
            }
        }

        /// <summary>
        /// ȡе״̬
        /// </summary>
        /// <param name="row"></param>
        /// <returns></returns>
        internal virtual object GetColumnState(GridRow row)
        {
            return null;
        }

        #endregion

        #region OnPreRender

        /// <summary>
        /// Ⱦ HTML ֮ǰãAJAXط
        /// </summary>
        protected override void OnAjaxPreRender()
        {
            // пؼԵĸı
        }

        /// <summary>
        /// Ⱦ HTML ֮ǰãҳһμػͨط
        /// </summary>
        protected override void OnFirstPreRender()
        {
            base.OnFirstPreRender();

            
            if (this is TemplateField && (this as TemplateField).RenderAsRowExpander)
            {
                // չҪ⴦
            }
            else
            {
                //JsObjectBuilder columnBuilder = new JsObjectBuilder();

                // еĽûᷴӳÿԪϣͷ
                OB.RemoveProperty("disabled");

                if (this is RowNumberField)
                {
                    OB.AddProperty("xtype", "rownumberer");
                }

                OB.AddProperty("text", GetHeaderValue());

                if (!String.IsNullOrEmpty(HeaderToolTip))
                {
                    OB.AddProperty("tooltip", HeaderToolTip);
                    OB.AddProperty("tooltipType", ToolTipTypeName.GetName(HeaderToolTipType));
                }

                if (Hidden)
                {
                    OB.AddProperty("hidden", true);
                }

                if (!String.IsNullOrEmpty(InnerCls))
                {
                    OB.AddProperty("innerCls", InnerCls);
                }

                if (Grid.AllowSorting)
                {
                    if (String.IsNullOrEmpty(SortField))
                    {
                        OB.AddProperty("sortable", false);
                    }
                    else
                    {
                        OB.AddProperty("sortable", true);
                    }
                }
                else
                {
                    OB.AddProperty("sortable", false);
                }


                if (PersistState)
                {
                    OB.AddProperty("f_persistState", true);
                    OB.AddProperty("f_persistStateType", "checkbox");
                }



                //If not specified, the column's index is used as an index into the Record's data Array.
                OB.AddProperty("dataIndex", ColumnID);
                OB.AddProperty("id", ColumnID);

                if (TextAlign != TextAlign.Left)
                {
                    OB.AddProperty("align", TextAlignName.GetName(TextAlign));
                }

                if (Width != Unit.Empty)
                {
                    OB.AddProperty("width", Width.Value);
                }
                else if (BoxFlex != 0)
                {
                    OB.AddProperty("flex", BoxFlex);
                }

                if (ExpandUnusedSpace)
                {
                    OB.AddProperty("flex", 1);
                }

                if (Grid.EnableHeaderMenu)
                {
                    if (EnableHeaderMenu)
                    {
                        OB.AddProperty("menuDisabled", false);
                    }
                    else
                    {
                        OB.AddProperty("menuDisabled", true);
                    }
                }
                else
                {
                    OB.AddProperty("menuDisabled", true);
                }

                if (EnableColumnHide)
                {
                    OB.AddProperty("hideable", true);
                }
                else
                {
                    OB.AddProperty("hideable", false);
                }


                if (Grid.EnableSummary)
                {
                    if (this is RowNumberField)
                    {
                        //  ûкϼ
                    }
                    else
                    {
                        OB.AddProperty("summaryType", String.Format("F.util.summaryType('{0}')", Grid.ClientID), true);
                    }
                }







            }
        }

        #endregion

        #region AddGridColumnScript
        
        /// <summary>
        /// ӱеȾű
        /// </summary>
        /// <param name="jsContent"></param>
        protected void AddGridColumnScript(string jsContent)
        {
            AddStartupScript(jsContent);
        } 

        #endregion

    }
}



