CONTAINER Oforester
{
	NAME Oforester;
	INCLUDE Obase;

	GROUP TREE_PARAMETERS
	{
		
		LONG FR_CURRENTFRAME		{HIDDEN;}
		
		BITMAPBUTTON FR_FORESTERTITLE_BITMAP {}

		GROUP GRP_TREE_PREVIEW
		{		
			DEFAULT 1;	
			
			GROUP
			{
				COLUMNS 3;
				BOOL FR_PREVIEWMODE			{}
				COLOR FR_COLOR 				{}
				BUTTON FR_RANDOMIZE 		{}
			}
			GROUP
			{
				COLUMNS 2;
				BOOL FR_HIGHLIGHTLASTLEVEL	{}
				BOOL FR_KEEPLINESVISIBLE	{}		
			}
		}
		
		GROUP GRP_TREE_LEVELS 
		{				
			DEFAULT 1;
			LONG FR_LEVELS				{  MIN 1; MINSLIDER 1; MAXSLIDER 5; STEP 1; CUSTOMGUI LONGSLIDER; }
			BOOL FR_USERENDERLEVELS		{}
			LONG FR_RENDERLEVELS		{  MIN 1; MINSLIDER 1; MAXSLIDER 8; STEP 1; CUSTOMGUI LONGSLIDER; }
			LONG FR_TURBSEED			{  MIN 0;  MINSLIDER 0; MAXSLIDER 9999; STEP 1; CUSTOMGUI LONGSLIDER; }
		}

		GROUP GRP_TREE_PARAMETERS
		{
			DEFAULT 1;
			REAL FR_TREESIZE			{ MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_treeGROW			{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_GROWRATIO			{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_GROWOVERLAP			{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_FLATTENTREE			{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_ADJUSTMESHING		{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		} 

		GROUP GRP_TREE_NOISE
		{
			DEFAULT 1;
			LONG FR_NOISESELECTOR	
			{
				CYCLE
				{
					FR_NOISE_HAMA;
					FR_NOISE_NAKI;
					FR_NOISE_NOISE;
					FR_NOISE_NUTOUS;
					FR_NOISE_POXO;
					FR_NOISE_STUPL;
					FR_NOISE_TURBULENCE;
					FR_NOISE_VLNOISE;
					FR_NOISE_WAVYTURB;
					FR_NOISE_SPARSECONV;
					FR_NOISE_VORONOI1;
					FR_NOISE_VORONOI2;
					FR_NOISE_VORONOI3;
					FR_NOISE_FIRE;
					FR_NOISE_ELECTRIC;
					FR_NOISE_GASEOUS;
					FR_NOISE_NONE;
				}
			}	

			REAL FR_TURBCOMPLEXITY		{ MIN 0.0; MAX 10.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			

		}
		
	}


	GROUP TRUNK_PARAMETERS
	{

		GROUP GRP_TR_PARAMETERS
		{
			DEFAULT 1;
			GROUP
			{ 
				COLUMNS 2;
				BOOL FR_TRUNKCAPS		{}
				BOOL FR_trEXPANDINGGROWTH {}
			}
			LONG FR_trRENDERSUBD 	{  MIN 1; MINSLIDER 1; MAXSLIDER 20; STEP 1; CUSTOMGUI LONGSLIDER; }	
			LONG FR_trSEGS			{  MIN 1;  MINSLIDER 1; MAXSLIDER 500; STEP 1; CUSTOMGUI LONGSLIDER; }
			LONG FR_trSIDES			{ MIN 3; MINSLIDER 3; MAXSLIDER 500; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_trHEIGHT		{ UNIT METER; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 5000.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_trRADIUS		{ UNIT METER; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 200.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
		}
		
		GROUP GRP_TR_DEFORM
		{
			DEFAULT 1;
			BOOL FR_trWAVESCW		{}
			REAL FR_trWAVES_X		{ MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trWAVES_Z		{ MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }					
			REAL FR_trWAVESSCALE	{ MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_trTURB			{ MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trTURBSCALE		{ MIN 0.0;   MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trSTRAIGHTTOP	{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trSTRAIGHTTOP_BIAS { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trDEFORM_BIAS	{ MIN 0.0; MINSLIDER 1.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_TR_DISPLACEMENT
		{

			DEFAULT 1;
			REAL FR_trDISPLACE_MULT { MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trDISPLACE_SCALE { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trDISPLACE_STRETCH { MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trDISPLACE_RISE  { MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}			
		
		GROUP GRP_TR_MODIFY
		{
			DEFAULT 1;
			REAL FR_trBEND			{ MINSLIDER -720.0; MAXSLIDER 720.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
			REAL FR_trBENDPOWER 	{ MINSLIDER 1.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trBENDDIRECTION { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		GROUP GRP_TR_CROSSSECTION
		{
			DEFAULT 1;

			REAL FR_trTWISTCS		{ MINSLIDER -720.0; MAXSLIDER 720.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			LONG FR_trROOTFLARES_COUNT { MIN 1; MINSLIDER 1; MAXSLIDER 20; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_trROOTFLARES_STRENGTH { MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trROOTFLARES_BIAS { MINSLIDER 1.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }

			GROUP
			{	
				COLUMNS 2;
				BOOL 	FR_USETRUNKCSSPLINE {} 
				BOOL 	FR_trREVERSECSSPLINE {}
			}
			GROUP
			{	
				COLUMNS 2;
				BOOL 	FR_NORMALIZE_TRUNK_CSSPLINE {}
				LONG 	FR_NORMALIZE_TrCsSp_ITERATIONS { MIN 1; MINSLIDER 5; MAXSLIDER 500; STEP 1; CUSTOMGUI LONGSLIDER; SCALE_H;} 					
			}				
			LINK FR_TRUNKCSLINK
			{
				ACCEPT { Ospline; } 
				REFUSE {}			
			}	
			REAL FR_trCSRISE  { MIN 0.0;   MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_TR_CUSTOMSPLINE
		{
			DEFAULT 1;

			BOOL FR_USETRUNKCUSTOMSPLINE {} 

			GROUP
			{	
				COLUMNS 2;
				BOOL 	FR_NORMALIZE_TRUNK_SPLINE {}
				LONG 	FR_NORMALIZE_TrSp_ITERATIONS { MIN 1; MINSLIDER 5; MAXSLIDER 500; STEP 1; CUSTOMGUI LONGSLIDER; SCALE_H; }
				
			}	
			LINK FR_TRUNKSPLINELINK
			{ 
				ACCEPT { Ospline; } 
				REFUSE {}
			}
			REAL FR_trCUSTOMSPLINE_ADJUSTHEIGHT { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_TR_PROFILE
		{
			DEFAULT 1;
			SPLINE FR_TRUNKPROFILE	
			{
				EDIT_H; 
				EDIT_V; 
				X_MIN 0; 
				X_MAX 1.0; 

				Y_MIN 0; 
				Y_MAX 1.0; 				
			}

		}
	}	


	GROUP ATTACH_GROUP
	{
		LONG FR_ATTACHMENT_SEED  {  MIN 0;  MINSLIDER 0; MAXSLIDER 9999; STEP 1; CUSTOMGUI LONGSLIDER; }
		GROUP TRUNK_ATTACHMENTS
		{
			DEFAULT 1;
			BOOL FR_trPROTRUSIONS_ON {}

			IN_EXCLUDE  FR_trPROTRUSION_LIST 
			{ 
				
				ACCEPT { Obase; };
			}

			
			REAL FR_trPROTRUSION_GROW   { MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trPROTRUSIONS_START  { MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trPROTRUSIONS_END	  { MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trPROTRUSION_THRESHOLD { MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			VECTOR FR_trPROTRUSION_ROTATION { MIN -180 -180 -180; MAX 180 180 180; STEP 1; UNIT REAL;  }
			VECTOR FR_trPROTRUSION_RANDROT { MIN 0 0 0; MAX 1 1 1; STEP 0.01; UNIT REAL;  }
			REAL FR_trPROTRUSION_OFFSET { MINSLIDER -100; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }			
			REAL FR_trPROTRUSION_SIZE 	 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trPROTRUSION_SCALEY	 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trPROTRUSION_RANDOMIZESIZE  { MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trPROTRUSION_SCALETOPROFILE  { MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			

		}

		GROUP ROOT_ATTACH
		{
			DEFAULT 1;
			BOOL	FR_rtATTACHON {}

			IN_EXCLUDE  FR_trROOT_LIST 
			{ 
				ACCEPT { Obase; };
			}
			LONG FR_ROOT_COUNT 			{ MIN 1; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			LONG FR_ROOT_ROWSCOUNT		{ MIN 1; MINSLIDER 1; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_rtGROW 				{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_rtSIZE 				{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_rtRANDOMIZESIZE 	{ MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_rtOFFSET 			{ MINSLIDER -100; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			VECTOR FR_rtROTATION 		{ MIN -180 -180 -180; MAX 180 180 180; STEP 1; UNIT REAL;  }
			VECTOR	FR_rtRANDROT 		{ MIN 0 0 0; MAX 1 1 1; STEP 0.01; UNIT REAL;  }
		}

		GROUP FR_trATTACH_TOTOP_GRP
		{
			DEFAULT 1;
			BOOL FR_trATTACH_TOTOP_ON 	{}
			LINK	FR_trATT_LINK
			{
				ACCEPT {  }
				REFUSE {  }
			}
			LONG FR_trATT_SEGOFFSET   	{ MIN 0; MINSLIDER 0; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			VECTOR FR_trATT_ROTATION	{ MIN -180 -180 -180; MAX 180 180 180; STEP 1; UNIT REAL;  }
			REAL FR_trATT_SIZE			{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }

		}	

		GROUP FR_trATTACH_TOBASE_GRP
		{
			DEFAULT 1;
			BOOL FR_trATTACH_TOBASE_ON 	{}
			LINK	FR_trATB_LINK
			{
				ACCEPT {  }
				REFUSE {  }
			}
			LONG FR_trATB_SEGOFFSET   	{ MIN 0; MINSLIDER 0; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			VECTOR FR_trATB_ROTATION	{ MIN -180 -180 -180; MAX 180 180 180; STEP 1; UNIT REAL;  }
			REAL FR_trATB_SIZE			{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }

		}

		

	}	


	GROUP WIND
	{
		
		REAL FR_brSPREAD_EFFECTIVE { HIDDEN; }
		REAL FR_WINDSPEED_CACHED { HIDDEN; }

		GROUP GRP_WIND_GLOBAL
		{
			DEFAULT 1;
			GROUP
			{
				COLUMNS 2;
				BOOL FR_wdON   {}
				BOOL FR_RENDERTIMEWIND	{}
			}
			LONG FR_WINDMODEL 		{ MIN 0; MAX 1; MINSLIDER 0; MAXSLIDER 1; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_GLOBALWINDMULT	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			
			LONG FR_wdSTARTLEVEL 	{ MINSLIDER 1; MAXSLIDER 8; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_wdGROW  		{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_WINDGLOBALPHASE		{ MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			GROUP
			{
				COLUMNS 2;			
				BOOL	FR_wdGROW_RANDOMIZE {}
				BOOL 	FR_wdGROW_REVERSE {}
			}
			
			REAL FR_WINDSCALE   { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_WINDCOMPLEXITY { MIN 0.0; MAX 10.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_RANDOMIZEWINDSTRENGTH  { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_lfWINDVARIANCE  { MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_AUGMENTWINDBYLEVEL	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_WINDLEVELRATIO		{ MIN 1.0;  MINSLIDER 1.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_wdORIENTLEAVES		{ MIN 0.0; MAX 2.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_lfREDUCEWINDFLIP { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_wdDEF_STIFFNESS { MIN 0.01;  MINSLIDER 3.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			BOOL FR_REDUCEBRANCH_WINDFLIP {}


		}

		GROUP GRP_DIRECTIONAL_WIND
		{
			DEFAULT 1;
			REAL FR_wdSPEED  		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_wdDIRECTIONALWIND_STRENGTH { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_wdSIN_STRENGTH  { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			
			REAL FR_wdDEF_DIRECTION { MINSLIDER -180.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_wdDEF_WAVESFREQUENCY  { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 50.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_TRUNKWINDMULT  { MIN 0.0; MAX 100.0;  MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trWINDSTIFFNESS { MIN 0.01;  MINSLIDER 3.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_lfWINDSTRENGTHX	{ MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_lfWINDSTRENGTHZ	{ MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_lfWINDSPEED	{ MIN 0.0; MAX 1000.0;  MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_wdPHASE		{ MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	

		}

		GROUP GRP_LOOPING_WIND
		{
			DEFAULT 1;
			GROUP 
			{
				COLUMNS 2; 	

				BOOL FR_LOOPINGWIND {}
				LONG FR_WINDLOOPDURATION { MIN 0; }
			}
			REAL FR_wdDEF_STRENGTH  { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_lfNOISEWIND_STRENGTHX { MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_lfNOISEWIND_STRENGTHZ { MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}
		
		

	}	

	GROUP SIMULATE_GRP
	{
		GROUP GRP_SIMULATION_CACHE
		{ 
			DEFAULT 1;
			GROUP
			{ 
				COLUMNS 3;
				BUTTON FR_CACHESIM 	{}	
				BUTTON FR_ERASECACHE {}
				BOOL FR_USECACHEDSIM {}
			}
		}
		GROUP GRP_SPREAD_SIMULATION
		{
			DEFAULT 1;
			BOOL FR_SIMULATE_BRANCHSPREAD {}
			REAL FR_BRSPREAD		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRSPREADSPRING	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRSPREADDAMPING	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
	}	

	GROUP FR_GLOBALS
	{
		GROUP GRP_GLOBAL_MODIFY
		{
			DEFAULT 1;
			REAL FR_GLOBAL_RADIUS 			{ MINSLIDER -50.0; MAXSLIDER 50.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_GLOBAL_BRLENGTH			{ MINSLIDER -500.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_GLOBAL_PRUNE			{ MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_GLOBAL_BRFLATTEN		{ MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_GLOBAL_BRTAPER			{ MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brGLOBALGRAVITY			{ MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brGLOBALGRAVITY_RATIO	{ MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brGRAVITY_STIFFNESS		{ MIN 0.01;  MINSLIDER 0.01; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }		
		}

		GROUP GRP_GLOBAL_ORIENTATION
		{
			DEFAULT 1;
			BOOL FR_GLOBAL_ORITOSEG			{}
			REAL FR_GLOBAL_ANGLE			{ MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_GLOBAL		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_GLOBAL_TURBULENCE
		{
			DEFAULT 1;
			REAL FR_brWAVESX_GLOBAL			{ MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_GLOBAL			{ MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESSCALE_GLOBAL		{ MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_GLOBALTURBULENCE	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_GLOBALTURBSCALE		{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
		}

	}	


	GROUP BRANCH_GLOBAL
	{

		GROUP GRP_BRGLOBALPARAMETERS
		{
			DEFAULT 1;
			BOOL FR_GENERATEBRANCHES {}
			BOOL FR_CACHEGENERATEBRANCHES {HIDDEN;}
			GROUP
			{
				COLUMNS 2;
				LONG FR_GLOBAL_brINSERTION {  MIN 0; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
				BOOL FR_GLOBAL_brINS_AFFECTLV0 {}
			}
			
			LONG FR_brRENDERSUBD 	{  MIN 1; MINSLIDER 1; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }			
			LONG FR_brSEGS			{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 50; STEP 1; CUSTOMGUI LONGSLIDER; }
			LONG FR_brSIDES			{ MIN 3; MAX 1000; MINSLIDER 3; MAXSLIDER 50; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brSHORTEN		{ MIN 0.0; MAX 2.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTAPERBIAS		{ MIN 0.001; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTILT_RATIO	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_BRRADIUSPROFILE
		{
			DEFAULT 1;
			BOOL FR_USELVLRADPRFL 	{}
			SPLINE FR_LEVELRADIUSPROFILE 	{}
		}

	}	



	GROUP BRLV0
	{

		GROUP GRP_BR_INSERTION_LV0
		{
			DEFAULT 1;
			LONG FR_trINSCNT		{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brINSBIAS_TR	{  MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }		
			LONG FR_brTRUNKTIPOFFSET{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brOFFSETFROMTRUNK { MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_trPRUNE			{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		GROUP GRP_BR_ORIENTATION_LV0
		{		
			DEFAULT 1;
			REAL FR_SWIVELLV0		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_LVL0 { MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPLV0 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brPOINTTOTIPBIAS_LV0 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SPINLV0			{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_ORITOTRUNK		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brANGLELV0		{ MIN 0.0; MAX 180.0;  MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_RANDANGL0		{ MIN -100; MAX 100.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTILT_LV0		{  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}
		
		GROUP GRP_BR_DEFORM_LV0
		{		
			DEFAULT 1;	
			REAL FR_brTURBLV0		{  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTURBSCALELV0	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESX_LV0		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_LV0		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brWAVESSCALELV0 { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brWAVESOFFSET_LV0	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}

		GROUP GRP_BR_MODIFIERS_LV0
		{
			DEFAULT 1;
			REAL FR_brLENGTHLV0		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 5000.0; STEP 0.1; CUSTOMGUI REALSLIDER; }	
			REAL FR_brRANDLENGLV0	{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRADIUSLV0		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 50.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brREDUCERADIUSONBRANCH_LV0 	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
			REAL FR_brTAPERLV0		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brSTRAIGHTENTOPS_LV0 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brFLATTEN_LV0	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_SHORTENLV0		{   MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRESIZE_TOPBRANCH {   MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRBENDLV0		{ MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDDIRECTION_LV0  { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDPOWER_LV0 { MIN 0.1;  MINSLIDER 0.1; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
			REAL FR_GRAVLV0			{ MIN -1000; MAX 1000.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brGRAVITYRATIO_LV0  { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_RANDGRAVLV0		{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brRANDOMIZERANGE_LV0 { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		
		
	}	


	GROUP BRLV1
	{  

		GROUP GRP_BR_INSERTION_LV1
		{
			DEFAULT 1;
			LONG FR_brINSCNTLV0		{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brINSBIAS_LV0	{  MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			LONG FR_brOFFSETFROMTIP_LV0		{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brPRUNELV0		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }		

		}

		GROUP GRP_BR_ORIENTATION_LV1
		{
			DEFAULT 1;
			BOOL FR_brORIENTTOROOT_LV0 {}
			REAL FR_SWIVELLV1		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_LVL1 { MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPLV1 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPBIAS_LV1 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SPINLV1			{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brANGLELV1		{ MIN 0.0; MAX 180.0;  MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_RANDANGL1		{ MIN -100; MAX 100.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brTILT_LV1		{  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brHORIZONTAL_LV1 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }

		}
		GROUP GRP_BR_DEFORM_LV1
		{			
			DEFAULT 1;
			REAL FR_brTURBLV1		{  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTURBSCALELV1	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESX_LV1		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_LV1		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brWAVESSCALELV1 { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESOFFSET_LV1	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }			
		}

		GROUP GRP_BR_MODIFIERS_LV1
		{
			DEFAULT 1;
			REAL FR_brLENGTHLV1		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDLENGLV1	{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRADIUSLV1		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brREDUCERADIUSONBRANCH_LV1 	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_INHERITRADIUS_LV1	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTAPERLV1		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brSTRAIGHTENTOPS_LV1 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTIPS_LV1 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brFLATTEN_LV1	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }					
			REAL FR_SHORTENLV1		{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_SHORTENTIPLV1	{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRBENDLV1		{ MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDDIRECTION_LV1  { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDPOWER_LV1 { MIN 0.1;  MINSLIDER 0.1; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_GRAVLV1			{ MIN -1000; MAX 1000.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brGRAVITYRATIO_LV1  { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			
			REAL FR_RANDGRAVLV1		{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brRANDOMIZERANGE_LV1 { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	

		}	
		
		
		
	}



	GROUP BRLV2
	{

		GROUP GRP_BR_INSERTION_LV2
		{
			DEFAULT 1;
			LONG FR_brINSCNTLV1		{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brINSBIAS_LV1	{  MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			LONG FR_brOFFSETFROMTIP_LV1		{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brPRUNELV1		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}

		GROUP GRP_BR_ORIENTATION_LV2
		{
			DEFAULT 1;
			BOOL FR_brORIENTTOROOT_LV1 {}
			REAL FR_SWIVELLV2		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_LVL2 { MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPLV2 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPBIAS_LV2 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SPINLV2			{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brANGLELV2		{ MIN 0.0; MAX 180.0;  MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_RANDANGL2		{ MIN -100; MAX 100.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTILT_LV2		{  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brHORIZONTAL_LV2 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_BR_DEFORM_LV2
		{
			DEFAULT 1;
			REAL FR_brTURBLV2		{  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTURBSCALELV2	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESX_LV2		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_LV2		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESSCALELV2 { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brWAVESOFFSET_LV2	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		GROUP GRP_BR_MODIFIERS_LV2
		{
			DEFAULT 1;
			REAL FR_brLENGTHLV2		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDLENGLV2	{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRADIUSLV2		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brREDUCERADIUSONBRANCH_LV2 	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_INHERITRADIUS_LV2	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTAPERLV2		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTOPS_LV2 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTIPS_LV2 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brFLATTEN_LV2	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
			REAL FR_SHORTENLV2		{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SHORTENTIPLV2	{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRBENDLV2		{ MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brBENDDIRECTION_LV2  { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDPOWER_LV2 { MIN 0.1;  MINSLIDER 0.1; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			
			REAL FR_GRAVLV2			{ MIN -1000; MAX 1000.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brGRAVITYRATIO_LV2  { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			
			REAL FR_RANDGRAVLV2		{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }		
			REAL FR_brRANDOMIZERANGE_LV2 { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	

		}

		
		
		
	}

	GROUP BRLV3
	{
		GROUP GRP_BR_INSERTION_LV3
		{
			DEFAULT 1;
			LONG FR_brINSCNTLV2		{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brINSBIAS_LV2	{  MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			LONG FR_brOFFSETFROMTIP_LV2		{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brPRUNELV2		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }

		}

		GROUP GRP_BR_ORIENTATION_LV3
		{
			DEFAULT 1;
			BOOL FR_brORIENTTOROOT_LV2 {}
			REAL FR_SWIVELLV3		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_LVL3 { MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPLV3 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPBIAS_LV3 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SPINLV3			{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brANGLELV3		{ MIN 0.0; MAX 180.0;  MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_RANDANGL3		{ MIN -100; MAX 100.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTILT_LV3		{  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brHORIZONTAL_LV3 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }

		}

		GROUP GRP_BR_DEFORM_LV3
		{
			DEFAULT 1;
			REAL FR_brTURBLV3		{  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTURBSCALELV3	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESX_LV3	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_LV3	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESSCALELV3 { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brWAVESOFFSET_LV3	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		GROUP GRP_BR_MODIFIERS_LV3
		{
			DEFAULT 1;
			REAL FR_brLENGTHLV3		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDLENGLV3	{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRADIUSLV3		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brREDUCERADIUSONBRANCH_LV3 	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_INHERITRADIUS_LV3	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTAPERLV3		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTOPS_LV3 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTIPS_LV3 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brFLATTEN_LV3	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SHORTENLV3		{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SHORTENTIPLV3	{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRBENDLV3		{ MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brBENDDIRECTION_LV3  { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDPOWER_LV3 { MIN 0.1;  MINSLIDER 0.1; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
			REAL FR_GRAVLV3			{ MIN -1000; MAX 1000.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brGRAVITYRATIO_LV3  { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }			
			REAL FR_RANDGRAVLV3		{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDOMIZERANGE_LV3 { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}
		
		
	}


	GROUP BRLV4
	{
		GROUP GRP_BR_INSERTION_LV4
		{
			DEFAULT 1;
			LONG FR_brINSCNTLV3		{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brINSBIAS_LV3	{  MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			LONG FR_brOFFSETFROMTIP_LV3		{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brPRUNELV3		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	

		}

		GROUP GRP_BR_ORIENTATION_LV4
		{
			DEFAULT 1;
			BOOL FR_brORIENTTOROOT_LV3 {}
			REAL FR_SWIVELLV4		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_LVL4 { MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPLV4 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPBIAS_LV4 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SPINLV4			{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brANGLELV4		{ MIN 0.0; MAX 180.0;  MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_RANDANGL4		{ MIN -100; MAX 100.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTILT_LV4		{  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brHORIZONTAL_LV4 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }

		}
		GROUP GRP_BR_DEFORM_LV4
		{
			DEFAULT 1;
			REAL FR_brTURBLV4		{  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTURBSCALELV4	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESX_LV4	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_LV4	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESSCALELV4 { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESOFFSET_LV4 	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		GROUP GRP_BR_MODIFIERS_LV4
		{
			DEFAULT 1;
			REAL FR_brLENGTHLV4		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDLENGLV4	{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRADIUSLV4		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brREDUCERADIUSONBRANCH_LV4 	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_INHERITRADIUS_LV4	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTAPERLV4		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brSTRAIGHTENTOPS_LV4 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTIPS_LV4 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brFLATTEN_LV4	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_SHORTENLV4		{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SHORTENTIPLV4	{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRBENDLV4		{ MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brBENDDIRECTION_LV4  { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDPOWER_LV4 { MIN 0.1;  MINSLIDER 0.1; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			
			REAL FR_GRAVLV4			{ MIN -1000; MAX 1000.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }		
			REAL FR_brGRAVITYRATIO_LV4  { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			
			REAL FR_RANDGRAVLV4		{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brRANDOMIZERANGE_LV4 { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }		
		}
		
	}


	GROUP BRLV5
	{
		GROUP GRP_BR_INSERTION_LV5
		{
			DEFAULT 1;
			LONG FR_brINSCNTLV4		{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brINSBIAS_LV4	{  MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			LONG FR_brOFFSETFROMTIP_LV4		{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brPRUNELV4		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}

		GROUP GRP_BR_ORIENTATION_LV5
		{
			DEFAULT 1;
			BOOL FR_brORIENTTOROOT_LV4 {}
			REAL FR_SWIVELLV5		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_LVL5 { MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPLV5 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPBIAS_LV5 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SPINLV5			{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brANGLELV5		{ MIN 0.0; MAX 180.0;  MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_RANDANGL5		{ MIN -100; MAX 100.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTILT_LV5		{  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brHORIZONTAL_LV5 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_BR_DEFORM_LV5
		{
			DEFAULT 1;
			REAL FR_brTURBLV5		{  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTURBSCALELV5	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESX_LV5	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_LV5	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESSCALELV5 { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brWAVESOFFSET_LV5 	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		GROUP GRP_BR_MODIFIERS_LV5
		{
			DEFAULT 1;
			REAL FR_brLENGTHLV5		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDLENGLV5	{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRADIUSLV5		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brREDUCERADIUSONBRANCH_LV5 	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_INHERITRADIUS_LV5	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTAPERLV5		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brSTRAIGHTENTOPS_LV5 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTIPS_LV5 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brFLATTEN_LV5	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
			REAL FR_SHORTENLV5		{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SHORTENTIPLV5	{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRBENDLV5		{ MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brBENDDIRECTION_LV5  { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDPOWER_LV5 { MIN 0.1;  MINSLIDER 0.1; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			
			REAL FR_GRAVLV5			{ MIN -1000; MAX 1000.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brGRAVITYRATIO_LV5 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			
			REAL FR_RANDGRAVLV5		{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brRANDOMIZERANGE_LV5 { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}	
		
		
	}

	GROUP BRLV6
	{
		GROUP GRP_BR_INSERTION_LV6
		{
			DEFAULT 1;
			LONG FR_brINSCNTLV5		{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brINSBIAS_LV5	{  MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			LONG FR_brOFFSETFROMTIP_LV5		{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL FR_brPRUNELV5		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }		
		}

		GROUP GRP_BR_ORIENTATION_LV6
		{
			DEFAULT 1;
			BOOL FR_brORIENTTOROOT_LV5 {}
			REAL FR_SWIVELLV6		{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDSWIVEL_LVL6 { MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPLV6 { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brPOINTTOTIPBIAS_LV6 { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SPINLV6			{ MINSLIDER 0.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brANGLELV6		{ MIN 0.0; MAX 180.0;  MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_RANDANGL6		{ MIN -100; MAX 100.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTILT_LV6		{  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brHORIZONTAL_LV6 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP GRP_BR_DEFORM_LV6
		{
			DEFAULT 1;
			REAL FR_brTURBLV6		{  MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTURBSCALELV6	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESX_LV6	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESZ_LV6	{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESSCALELV6 { MIN 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brWAVESOFFSET_LV6 	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		
		GROUP GRP_BR_MODIFIERS_LV6
		{
			DEFAULT 1;
			REAL FR_brLENGTHLV6		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brRANDLENGLV6	{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brRADIUSLV6		{ UNIT METER; MIN 0.0;  MINSLIDER 0.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL FR_brREDUCERADIUSONBRANCH_LV6 	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_INHERITRADIUS_LV6	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brTAPERLV6		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brSTRAIGHTENTOPS_LV6 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brSTRAIGHTENTIPS_LV6 { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brFLATTEN_LV6	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SHORTENLV6		{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_SHORTENTIPLV6	{ MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_BRBENDLV6		{ MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brBENDDIRECTION_LV6  { MINSLIDER -360.0; MAXSLIDER 360.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_brBENDPOWER_LV6 { MIN 0.1;  MINSLIDER 0.1; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }				
			REAL FR_GRAVLV6			{ MIN -1000; MAX 1000.0;  MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brGRAVITYRATIO_LV6  { MIN -1.0; MAX 1.0;  MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }			
			REAL FR_RANDGRAVLV6		{ MIN 0.0; MAX 10.0;  MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_brRANDOMIZERANGE_LV6 { MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }			
		}		

		
		
	}

	GROUP SPLINE_CONTROL
	{
		

	}	

	GROUP FR_LEAVESGRP
	{

		GROUP GRP_LEAF_DISTRIBUTION
		{
			DEFAULT 1;
			BOOL 	FR_LEAVESON			{}
			LONG 	FR_lfSTARTLEVEL		{ MIN 1; MAX 10; MINSLIDER 1; MAXSLIDER 8; STEP 1; CUSTOMGUI LONGSLIDER;}
			LONG 	FR_lfLEAFMULTIPLIER { MIN 1; MINSLIDER 1; MAXSLIDER 50; STEP 1; CUSTOMGUI LONGSLIDER; }
			LONG  	FR_lfPRUNE			{ MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 20; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL 	FR_lfPOP 		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H; }	
			LONG 	FR_lfKEEPEVERYNTH	{ MIN 1; MINSLIDER 1; MAXSLIDER 50; STEP 1; CUSTOMGUI LONGSLIDER; }
			
			GROUP
			{
				COLUMNS 2;
				REAL 	FR_lfGLOBALPRUNE	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H; }	
				BOOL FR_lfREVERSEGLOBALPRUNE {}		
			}
			
			GROUP
			{
				COLUMNS 2; 
				LONG FR_lfMATERIAL_COUNT { MIN 1; MAX 3; MINSLIDER 1; MAXSLIDER 3; STEP 1; CUSTOMGUI LONGSLIDER; SCALE_H; }
				BOOL FR_lfSHUFFLEMATERIALS {}														
			}
		}

		GROUP GRP_LEAF_SIZE
		{
			DEFAULT 1;
			REAL 	FR_lfGROWTH			{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_LEAFGROWTH_OVERLAP { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfSIZE			{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfRANDSIZE		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL	FR_lfWIDTH 			{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL	FR_lfLENGTH   		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 500.0; STEP 0.01; CUSTOMGUI REALSLIDER; }			
			REAL 	FR_lfRESIZETOPLEAVES { MINSLIDER -1.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}
		
		GROUP GRP_LEAF_MODIFY
		{
			DEFAULT 1;
			LONG	FR_lfHALFSIDES 		{ MIN 1; MAX 50; MINSLIDER 1; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
			LONG 	FR_lfSEGS 			{ MIN 1; MAX 1000; MINSLIDER 1; MAXSLIDER 50; STEP 1; CUSTOMGUI LONGSLIDER; }
			REAL 	FR_lfBEND			{ MIN -360.0; MAX 360.0;  MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfFOLD			{ MINSLIDER -25.0; MAXSLIDER 25.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfFOLDFREQ		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfWAVY			{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfWAVEFREQ		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}
		
		GROUP GRP_LEAF_ORIENTATION
		{
			DEFAULT 1;			
			GROUP
			{
				COLUMNS 2; 
				BOOL 	FR_lfSYMSPREAD		{}	

			}
			REAL    FR_lfHORIZONTALIZE	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfSPREADONBRANCH { MIN 0.0;   MINSLIDER 0.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfRANDSPREAD		{ MINSLIDER 0.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL 	FR_lfSWIVELONBRANCH { MINSLIDER 0.0; MAXSLIDER 180.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfPOINTTOBRANCHTIP	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfSPINLOCAL		{ MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL 	FR_lfSPINGLOBAL		{ MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfINCRSPIN		{ MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfTILT			{ MINSLIDER -90.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfRANDTILT		{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 90.0; STEP 0.01; CUSTOMGUI REALSLIDER; }			
			REAL 	FR_lfTURBULENCE		{ MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL 	FR_lfRANDRANGE		{ MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}
		


		GROUP GRP_LEAF_PROFILE
		{
			DEFAULT 1;
			REAL 	FR_lfPROFILEMULT	{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			SPLINE FR_LEAFPROFILE 		{}
		}	

		GROUP GRP_LEAF_SIZEALONGBRANCH
		{
			DEFAULT 1;
			SPLINE FR_lfSIZEALONGBRANCH_PROFILE 	{}
		}	
		
		
	}	


	GROUP FR_FRUITGROUP
	{
		GROUP GRP_FRUIT_PARAMETERS
		{
			DEFAULT 1;
			BOOL FR_FRUITS_ON			{}
			REAL FR_FRUIT_GROW			{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			LONG FR_FRUITCOUNT			{  MIN 0;  MINSLIDER 0; MAXSLIDER 100; STEP 1; CUSTOMGUI LONGSLIDER; }
			GROUP
			{
				COLUMNS 2;
				REAL FR_FRUIT_OFFSET		{  MINSLIDER -100.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H;}
				BOOL FR_FRUITOFFSET_VERTICAL {}
			}
			LONG FR_FRUIT_SEED			{  MIN 0;  MINSLIDER 0; MAXSLIDER 9999; STEP 1; CUSTOMGUI LONGSLIDER; }
		}	
		
		GROUP GRP_FRUIT_TYPE
		{
			DEFAULT 1;
			
			IN_EXCLUDE  FR_FRUIT_LIST 
			{ 
				ACCEPT { Obase; };
			}
		}

		GROUP GRP_FRUIT_SIZE
		{
			DEFAULT 1;
			REAL FR_FRUITSIZE			{ MIN 0.0; MINSLIDER 0.0; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL FR_FRUIT_RANDOMIZESIZE		{ MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}
		
		GROUP GRP_FRUIT_ORIENTATION
		{
			DEFAULT 1;
			REAL FR_FRUIT_VERTICALIZE   { MIN 0.0; MAX 1.0;  MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			VECTOR FR_FRUIT_ROTATION	{ MIN -180 -180 -180; MAX 180 180 180; STEP 1; UNIT REAL;  }	
			VECTOR FR_FRUIT_RANDROT		{ MIN 0 0 0; MAX 1 1 1; STEP 0.01; UNIT REAL;  }
		}
	}


	GROUP FR_SNOW_GRP
	{
		BUTTON FR_GENERATE_SNOW {}
		LONG FR_snSTARTLEVEL		{  MIN 1;  MINSLIDER 1; MAXSLIDER 8; STEP 1; CUSTOMGUI LONGSLIDER; }
		LONG FR_SNOWBRANCHPRUNE		{  MIN 0;  MINSLIDER 0; MAXSLIDER 20; STEP 1; CUSTOMGUI LONGSLIDER; }
		REAL FR_snRISE 				{ MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		LONG FR_snEVERY_NTH_BRANCH 	{  MIN 1;  MINSLIDER 1; MAXSLIDER 10; STEP 1; CUSTOMGUI LONGSLIDER; }
	}



	GROUP FR_UV
	{


		GROUP GRP_TRUNK_UVS
		{
			DEFAULT 1;
			GROUP
			{
				REAL FR_trUTILING		{ MIN 0.0; MAX 1000.0;  MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
				REAL FR_trVTILING		{ MIN 0.0; MAX 1000.0;  MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
				GROUP
				{
					LAYOUTGROUP ; COLUMNS 3;
					GROUP
					{
						BOOL FR_SWAPtrUV 			{}
					}
					GROUP
					{
						BOOL FR_FLIPtrU 			{}	
					}
					GROUP
					{
						BOOL FR_FLIPtrV 			{}	
					}
				}
			}
		}

		GROUP GRP_BRANCH_UVS
		{
			DEFAULT 1;
			GROUP
			{
				REAL FR_brUTILING		{ MIN 0.0; MAX 1000.0;  MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
				REAL FR_brVTILING		{ MIN 0.0; MAX 1000.0;  MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
				GROUP
				{
					LAYOUTGROUP ; COLUMNS 3;
					GROUP
					{
						BOOL FR_SWAPbrUV 			{}
					}
					GROUP
					{
						BOOL FR_FLIPbrU 			{}	
					}
					GROUP
					{
						BOOL FR_FLIPbrV 			{}	
					}
				}
			}
		}

		GROUP GRP_LEAF_UVS
		{	
			DEFAULT 1;
			LAYOUTGROUP ; COLUMNS 3;
			GROUP
			{
				BOOL FR_SWAPlfUV 			{}
			}
			GROUP
			{
				BOOL FR_FLIPlfU 			{}	
			}
			GROUP
			{
				BOOL FR_FLIPlfV 			{}	
			}
		}

		GROUP GRP_CAP_UVS
		{	
			DEFAULT 1;
			REAL FR_trCAPUVSCALE_TOP 	{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
			REAL FR_trCAPUVSCALE_BOTTOM 		{ MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }	
		}		

	}




	GROUP FR_TREE_LIBRARY1_GRP
	{
		GROUP 
		{
			COLUMNS 3;		
			BOOL FR_RANDOMIZESEED {}
			BOOL FR_CHANGEMATERIALS {}
			BOOL FR_CHANGEUVS {}
		}

		BUTTON FR_REMOVEMATERIALS {}
		
		GROUP 
		{
			COLUMNS 4;
			BITMAPBUTTON FR_DEFAULTTREE_BTN {}
			BITMAPBUTTON FR_abiesfraseri_BTN {}
			BITMAPBUTTON FR_acer_BTN {}
			BITMAPBUTTON FR_albizia_BTN {}
			BITMAPBUTTON FR_apple_BTN {}
			BITMAPBUTTON FR_aralia_BTN {}
			BITMAPBUTTON FR_aspen_BTN {}
			BITMAPBUTTON FR_bamboo_BTN {}
			BITMAPBUTTON FR_barberry_BTN {}
			BITMAPBUTTON FR_beachpalm_BTN {}
			BITMAPBUTTON FR_beech_BTN {}
			BITMAPBUTTON FR_birch_BTN {}
			BITMAPBUTTON FR_bluespruce_BTN {}
			BITMAPBUTTON FR_carolinapoplar_BTN {}
			BITMAPBUTTON FR_ceiba_BTN {}
			BITMAPBUTTON FR_coconutpalm_BTN {}
			BITMAPBUTTON FR_corktree_BTN {}
			BITMAPBUTTON FR_cornus_BTN {}
			BITMAPBUTTON FR_cupressaceae_BTN {}
			BITMAPBUTTON FR_curlypalm_BTN {}
			BITMAPBUTTON FR_cypressoak_BTN {}
			BITMAPBUTTON FR_datepalm_BTN {}
			BITMAPBUTTON FR_delonix_BTN {}
			BITMAPBUTTON FR_eucalyptus_BTN {}
			BITMAPBUTTON FR_heartwood_BTN {}
			BITMAPBUTTON FR_japanesepine_BTN {}
			BITMAPBUTTON FR_juniper_BTN {}
			BITMAPBUTTON FR_kaizuka_BTN {}
			BITMAPBUTTON FR_lagerstroemia_BTN {}
			BITMAPBUTTON FR_lebcedar_BTN {}
			BITMAPBUTTON FR_lemontree_BTN {}
			BITMAPBUTTON FR_liveoak_BTN {}
			BITMAPBUTTON FR_mangrove_BTN {}
			BITMAPBUTTON FR_maple_BTN {}
			BITMAPBUTTON FR_morton_BTN {}
			BITMAPBUTTON FR_mountainmaple_BTN {}
			BITMAPBUTTON FR_oak_BTN {}
			BITMAPBUTTON FR_oleaceae_BTN {}
			BITMAPBUTTON FR_olive_BTN {}
			BITMAPBUTTON FR_orange_BTN {}
			BITMAPBUTTON FR_palmetto_BTN {}
			BITMAPBUTTON FR_peach_BTN {}
			BITMAPBUTTON FR_pertusa_BTN {}
			BITMAPBUTTON FR_piceaabies_BTN {}
			BITMAPBUTTON FR_pinetree_BTN {}
			BITMAPBUTTON FR_pinuslonga_BTN {}
			BITMAPBUTTON FR_pinusstrobus_BTN {}
			BITMAPBUTTON FR_pinustaeda_BTN {}
			BITMAPBUTTON FR_platanus_BTN {}
			BITMAPBUTTON FR_plumeria_BTN {}
			BITMAPBUTTON FR_ponytailpalm_BTN {}
			BITMAPBUTTON FR_populusnigra_BTN {}
			BITMAPBUTTON FR_prosopis_BTN {}
			BITMAPBUTTON FR_prunus_BTN {}
			BITMAPBUTTON FR_pseudocamellia_BTN {}
			BITMAPBUTTON FR_pyrus_BTN {}
			BITMAPBUTTON FR_queenpalm_BTN {}
			BITMAPBUTTON FR_rainbow_BTN {}
			BITMAPBUTTON FR_redmaple_BTN {}
			BITMAPBUTTON FR_redoak_BTN {}
			BITMAPBUTTON FR_rosegum_BTN {}
			BITMAPBUTTON FR_senegalia_BTN {}
			BITMAPBUTTON FR_sycamore_BTN {}
			BITMAPBUTTON FR_taxodium_BTN {}
			BITMAPBUTTON FR_thorntree_BTN {}
			BITMAPBUTTON FR_tilia_BTN {}
			BITMAPBUTTON FR_tupelo_BTN {}
			BITMAPBUTTON FR_tuscancypress_BTN {}
			BITMAPBUTTON FR_ulmaceae_BTN {}
			BITMAPBUTTON FR_whitebirch_BTN {}
			BITMAPBUTTON FR_willow_BTN {}
			BITMAPBUTTON FR_yellowcypress_BTN {}

		}


	}

	GROUP FR_MATERIAL_SELECTION_GRP	
	{
		STATICTEXT FR_ST_TRUNKMATERIAL			{ ANIM OFF; }
		STATICTEXT FR_ST_TRUNKCAPMATERIAL		{ ANIM OFF; }		
		STATICTEXT FR_ST_BRANCHMATERIAL			{ ANIM OFF; }
		STATICTEXT FR_ST_LEAFMATERIAL1			{ ANIM OFF; }
		STATICTEXT FR_ST_LEAFMATERIAL2			{ ANIM OFF; }
		STATICTEXT FR_ST_LEAFMATERIAL3			{ ANIM OFF; }
	}	


}
