<?xml version="1.0" encoding="GBK"?>
<xsl:stylesheet version="2.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
<xsl:output method="html" encoding="gbk" indent="yes"/>
<xsl:template match="/Threads">
<HTML>
<HEAD>
<LINK href="wind-reset.css" type="text/css" rel="stylesheet" /><!--css-->
<STYLE type="text/css">BODY {
	FONT-SIZE: 9pt; COLOR: #333; FONT-FAMILY: Verdana; BACKGROUND-COLOR: #ffffff
}
H3 {
	DISPLAY: inline
}
H2 {
	DISPLAY: inline
}
H2 A {
	FONT-SIZE: 14px; COLOR: #000
}
H3 A {
	FONT-SIZE: 14px; COLOR: #333
}
.subject {
	FONT-SIZE: 14px
}
.v-in INPUT {
	VERTICAL-ALIGN: baseline
}
H4 {
	FONT-SIZE: 1.1em; MARGIN: 20px 0px 10px
}
A {
	COLOR: #333333; TEXT-DECORATION: none
}
A:hover {
	TEXT-DECORATION: underline
}
.pdD {
	PADDING-RIGHT: 0.5em; PADDING-LEFT: 0.5em; PADDING-BOTTOM: 0.3em; PADDING-TOP: 0.3em
}
.p10 {
	PADDING-RIGHT: 10px; PADDING-LEFT: 10px; PADDING-BOTTOM: 10px; PADDING-TOP: 10px
}
.f_one {
	BACKGROUND: #ffffff
}
.t_one {
	BACKGROUND: #ffffff
}
.r_one {
	BACKGROUND: #ffffff
}
.f_two {
	BACKGROUND: #f3f9fb
}
.t_two {
	BACKGROUND: #f3f9fb
}
.r_two {
	BACKGROUND: #f3f9fb
}
.btn {
	BORDER-LEFT-COLOR: #1b72af; BACKGROUND: #1b72af; BORDER-BOTTOM-COLOR: #1b72af; COLOR: #fff; BORDER-TOP-COLOR: #1b72af; MARGIN-RIGHT: 1em; BORDER-RIGHT-COLOR: #1b72af
}
.btn {
	BORDER-TOP-WIDTH: 1px; PADDING-RIGHT: 1em; PADDING-LEFT: 1em; BORDER-LEFT-WIDTH: 1px; FONT-SIZE: 9pt; BORDER-BOTTOM-WIDTH: 1px; PADDING-BOTTOM: 0px; OVERFLOW: visible; CURSOR: pointer; LINE-HEIGHT: 130%; PADDING-TOP: 0px; BORDER-RIGHT-WIDTH: 1px; moz-border-radius: 2px; khtml-border-radius: 2px; webkit-border-radius: 2px; border-radius: 2px
}
.bt {
	BORDER-TOP-WIDTH: 1px; PADDING-RIGHT: 1em; PADDING-LEFT: 1em; BORDER-LEFT-WIDTH: 1px; FONT-SIZE: 9pt; BORDER-BOTTOM-WIDTH: 1px; PADDING-BOTTOM: 0px; OVERFLOW: visible; CURSOR: pointer; LINE-HEIGHT: 130%; PADDING-TOP: 0px; BORDER-RIGHT-WIDTH: 1px; moz-border-radius: 2px; khtml-border-radius: 2px; webkit-border-radius: 2px; border-radius: 2px
}
.bt {
	BORDER-LEFT-COLOR: #e4e4e4; BACKGROUND: url(images/wind/btn.png) #f7f7f7 repeat-x 0px -52px; BORDER-BOTTOM-COLOR: #cccccc; VERTICAL-ALIGN: middle; CURSOR: pointer; BORDER-TOP-COLOR: #e4e4e4; BORDER-RIGHT-COLOR: #cccccc
}
.bta {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 8px; BORDER-TOP: #d5e6ed 1px solid; PADDING-LEFT: 8px; BACKGROUND: #f3f9fb; PADDING-BOTTOM: 2px; MARGIN: 2px; BORDER-LEFT: #d5e6ed 1px solid; CURSOR: pointer; COLOR: #333333; PADDING-TOP: 2px; BORDER-BOTTOM: #d5e6ed 1px solid; WHITE-SPACE: nowrap; moz-border-radius: 2px; khtml-border-radius: 2px; webkit-border-radius: 2px; border-radius: 2px
}
.abtn2 A {
	BORDER-RIGHT: #fbfdff 1px solid; PADDING-RIGHT: 4px; BORDER-TOP: #fbfdff 1px solid; PADDING-LEFT: 4px; PADDING-BOTTOM: 1px; BORDER-LEFT: #fbfdff 1px solid; COLOR: #555; PADDING-TOP: 2px; BORDER-BOTTOM: #fbfdff 1px solid
}
.abtn2 A:hover {
	BORDER-RIGHT: #2195d2 1px solid; BORDER-TOP: #2195d2 1px solid; BACKGROUND: #fff; BORDER-LEFT: #2195d2 1px solid; COLOR: #2195d2; BORDER-BOTTOM: #2195d2 1px solid; TEXT-DECORATION: none
}
TEXTAREA {
	PADDING-RIGHT: 3px; PADDING-LEFT: 3px; MARGIN-BOTTOM: 1px; PADDING-BOTTOM: 0px; FONT: 12px Arial; VERTICAL-ALIGN: middle; PADDING-TOP: 1px
}
INPUT {
	PADDING-RIGHT: 3px; PADDING-LEFT: 3px; MARGIN-BOTTOM: 1px; PADDING-BOTTOM: 0px; FONT: 12px Arial; VERTICAL-ALIGN: middle; PADDING-TOP: 1px
}
SELECT {
	PADDING-RIGHT: 3px; PADDING-LEFT: 3px; MARGIN-BOTTOM: 1px; PADDING-BOTTOM: 0px; FONT: 12px Arial; VERTICAL-ALIGN: middle; PADDING-TOP: 1px
}
SELECT {
	BORDER-RIGHT: #d5e6ed 1px solid; BORDER-TOP: #d5e6ed 1px solid; BORDER-LEFT: #d5e6ed 1px solid; BORDER-BOTTOM: #d5e6ed 1px solid
}
.input {
	BORDER-RIGHT: #ededed 1px solid; PADDING-RIGHT: 0px; BORDER-TOP: #c0c0c0 1px solid; PADDING-LEFT: 1px; FONT-SIZE: 1em; PADDING-BOTTOM: 2px; VERTICAL-ALIGN: middle; BORDER-LEFT: #c0c0c0 1px solid; COLOR: #000; PADDING-TOP: 2px; BORDER-BOTTOM: #ededed 1px solid
}
TEXTAREA {
	BORDER-RIGHT: #ededed 1px solid; BORDER-TOP: #c0c0c0 1px solid; BORDER-LEFT: #c0c0c0 1px solid; BORDER-BOTTOM: #ededed 1px solid
}
.new_topbar {
	MARGIN: auto; OVERFLOW: hidden; WIDTH: 98%; min-width: 800px
}
#header {
	BACKGROUND: url(images/wind/bg.png) repeat-x 0px -2px; min-width: 980px
}
#head {
	MARGIN: 0px auto; WIDTH: 98%; max-width: 1200px
}
#nav {
	MARGIN: auto; WIDTH: 98%; HEIGHT: 35px; BACKGROUND-COLOR: #176eac; max-width: 1200px
}
#main {
	MARGIN: 0px auto; WIDTH: 98%; max-width: 1200px
}
#footer {
	PADDING-RIGHT: 0px; PADDING-LEFT: 0px; PADDING-BOTTOM: 30px; MARGIN: 0px auto; WIDTH: 98%; PADDING-TOP: 0px; max-width: 1200px
}
.bottom {
	BORDER-RIGHT: #d5e6ed 1px solid; BORDER-TOP: #d5e6ed 1px solid; BACKGROUND: #f3f9fb; MARGIN: 0px auto 10px; BORDER-LEFT: #d5e6ed 1px solid; BORDER-BOTTOM: #d5e6ed 1px solid
}
.bottom UL {
	PADDING-RIGHT: 5px; PADDING-LEFT: 5px; PADDING-BOTTOM: 5px; MARGIN: 0px; PADDING-TOP: 5px; LIST-STYLE-TYPE: none
}
.bottom UL LI {
	PADDING-RIGHT: 10px; DISPLAY: inline; PADDING-LEFT: 0px; PADDING-BOTTOM: 0px; PADDING-TOP: 0px
}
.bottom UL LI A {
	WHITE-SPACE: nowrap
}
#breadCrumb {
	PADDING-RIGHT: 10px; BORDER-TOP: #a6cbe7 1px solid; PADDING-LEFT: 10px; BACKGROUND: url(images/wind/bg.png) repeat-x 0px -10px; PADDING-BOTTOM: 10px; COLOR: #999; PADDING-TOP: 10px; ZOOM: 1
}
.noticebg {
	BACKGROUND: url(images/wind/bg.png) repeat-x 0px -10px
}
#notice {
	PADDING-RIGHT: 10px; PADDING-LEFT: 10px; BACKGROUND: url(images/wind/file/anc.png) no-repeat 12px 12px; PADDING-BOTTOM: 10px; PADDING-TOP: 10px
}
#notice LI {
	PADDING-LEFT: 1.6em; FLOAT: left; WHITE-SPACE: nowrap; LIST-STYLE-TYPE: none; HEIGHT: 18px
}
#notice A {
	PADDING-RIGHT: 0.5em
}
.ad-text {
	BORDER-RIGHT: #d5e6ed 1px solid; BORDER-TOP: #d5e6ed 1px solid; BACKGROUND: #ffffff; MARGIN: 0px auto 8px; BORDER-LEFT: #d5e6ed 1px solid; BORDER-BOTTOM: #d5e6ed 0px solid
}
.ad-text .tr3 TD {
	PADDING-RIGHT: 0.6em; PADDING-LEFT: 0.6em; PADDING-BOTTOM: 0.4em; PADDING-TOP: 0.4em; BORDER-BOTTOM: #d5e6ed 1px solid
}
.ad-text .tr3 TH {
	PADDING-RIGHT: 0.6em; PADDING-LEFT: 0.6em; PADDING-BOTTOM: 0.4em; PADDING-TOP: 0.4em; BORDER-BOTTOM: #d5e6ed 1px solid
}
#nav-global {
	BACKGROUND: url(images/wind/nav-bg.png)
}
.nav-left {
	BACKGROUND: url(images/wind/nav-bg.png)
}
.nav-right {
	BACKGROUND: url(images/wind/nav-bg.png)
}
.nav-left {
	WIDTH: 5px; HEIGHT: 35px
}
.nav-right {
	WIDTH: 5px; HEIGHT: 35px
}
.nav-left {
	BACKGROUND-POSITION: 0px 0px; MARGIN-RIGHT: -3px
}
.nav-right {
	BACKGROUND-POSITION: 0px -70px; MARGIN-LEFT: -3px
}
#nav-global {
	BACKGROUND-POSITION: 0px -35px; OVERFLOW: hidden; HEIGHT: 35px
}
#nav-global UL {
	PADDING-LEFT: 10px; FONT-SIZE: 14px
}
#nav-global LI {
	BACKGROUND: url(images/wind/nav-cur.png) no-repeat 999em 999em
}
#nav-global LI A {
	BACKGROUND: url(images/wind/nav-cur.png) no-repeat 999em 999em
}
#nav-global LI {
	FLOAT: left; MARGIN: 5px 0px 0px
}
#nav-global LI A {
	PADDING-RIGHT: 10px; PADDING-LEFT: 10px; FONT-WEIGHT: 700; FLOAT: left; PADDING-BOTTOM: 0px; COLOR: #ffffff; LINE-HEIGHT: 23px; PADDING-TOP: 0px; HEIGHT: 27px; outline: none
}
#nav-global LI A:hover {
	COLOR: #ffea00; TEXT-DECORATION: none
}
#nav-global .current {
	BACKGROUND-POSITION: left top; MARGIN: 2px 5px 0px; LINE-HEIGHT: 33px; HEIGHT: 33px
}
#nav-global .current A {
	PADDING-RIGHT: 19px; BACKGROUND-POSITION: right top; DISPLAY: inline; PADDING-LEFT: 19px; PADDING-BOTTOM: 0px; COLOR: #1b72af; LINE-HEIGHT: 33px; PADDING-TOP: 0px; HEIGHT: 33px; TEXT-DECORATION: none
}
#nav-global .current A:hover {
	PADDING-RIGHT: 19px; BACKGROUND-POSITION: right top; DISPLAY: inline; PADDING-LEFT: 19px; PADDING-BOTTOM: 0px; COLOR: #1b72af; LINE-HEIGHT: 33px; PADDING-TOP: 0px; HEIGHT: 33px; TEXT-DECORATION: none
}
#td_mymenu {
	BACKGROUND: url(images/wind/shortcut.gif) no-repeat 0px 0px; COLOR: #555
}
#td_mymenu_old {
	BACKGROUND: url(images/wind/shortcut.gif) no-repeat 0px 0px; COLOR: #555
}
#td_mymenu_old {
	BACKGROUND-POSITION: 0px bottom; COLOR: #888
}
#nav-s {
	BACKGROUND: url(images/wind/nav-search.png); FLOAT: right; MARGIN-LEFT: -3px; OVERFLOW: hidden; WIDTH: 270px; HEIGHT: 35px
}
#nav-s .fr {
	MARGIN: 11px 20px 0px 0px; LINE-HEIGHT: 14px
}
.s-btn {
	BORDER-TOP-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px; BACKGROUND: none transparent scroll repeat 0% 0%; BORDER-BOTTOM-WIDTH: 0px; BORDER-RIGHT-WIDTH: 0px
}
.s-input {
	BORDER-TOP-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px; BACKGROUND: none transparent scroll repeat 0% 0%; BORDER-BOTTOM-WIDTH: 0px; BORDER-RIGHT-WIDTH: 0px
}
.s-btn {
	MARGIN: 5px 0px 0px 1px; VERTICAL-ALIGN: baseline; WIDTH: 55px; CURSOR: pointer; HEIGHT: 21px
}
.s-input {
	PADDING-RIGHT: 1px; PADDING-LEFT: 1px; FLOAT: left; PADDING-BOTTOM: 0px; MARGIN: 5px 0px 0px 10px; WIDTH: 150px; PADDING-TOP: 4px; HEIGHT: 17px
}
.index-info {
	BACKGROUND: #ffffff; MARGIN: 0px auto; WIDTH: 98%; max-width: 1200px
}
.index-info TD {
	PADDING-RIGHT: 0px; PADDING-LEFT: 10px; PADDING-BOTTOM: 2px; LINE-HEIGHT: 24px; PADDING-TOP: 3px
}
.index-info A {
	MARGIN-RIGHT: 10px; WHITE-SPACE: nowrap
}
.forum-info {
	PADDING-RIGHT: 10px; PADDING-LEFT: 10px; BACKGROUND: #ffffff; PADDING-BOTTOM: 6px; LINE-HEIGHT: 1; PADDING-TOP: 0px; BORDER-BOTTOM: #a6cbe7 1px solid
}
.user-table TD {
	PADDING-RIGHT: 1em; PADDING-LEFT: 2em; PADDING-BOTTOM: 0.5em; PADDING-TOP: 1em
}
.t {
	BORDER-RIGHT: #a6cbe7 1px solid; PADDING-RIGHT: 1px; BORDER-TOP: #a6cbe7 1px solid; PADDING-LEFT: 1px; BACKGROUND: #ffffff; PADDING-BOTTOM: 1px; BORDER-LEFT: #a6cbe7 1px solid; PADDING-TOP: 1px; BORDER-BOTTOM: #a6cbe7 1px solid
}
.t table {
	BORDER-RIGHT: #ffffff 1px solid; BORDER-TOP: #ffffff 1px solid; BORDER-LEFT: #ffffff 1px solid; WIDTH: 100%; BORDER-BOTTOM: #ffffff 1px solid
}
.t3 {
	MARGIN: 5px auto
}
.t5 {
	BORDER-RIGHT: #d5e6ed 1px solid; BORDER-TOP: #d5e6ed 1px solid; BORDER-LEFT: #d5e6ed 1px solid; BORDER-BOTTOM: #d5e6ed 1px solid
}
.t {
	MARGIN: 0px auto 10px; OVERFLOW: hidden; HEIGHT: auto
}
.t5 {
	MARGIN: 0px auto 10px; OVERFLOW: hidden; HEIGHT: auto
}
.h {
	PADDING-RIGHT: 10px; PADDING-LEFT: 10px; BACKGROUND: #e8f5fb; PADDING-BOTTOM: 0px; COLOR: #1b72af; LINE-HEIGHT: 220%; PADDING-TOP: 2px; BORDER-BOTTOM: #c5d8e8 1px solid; TEXT-ALIGN: left
}
.h SPAN {
	FONT-WEIGHT: normal
}
.h H2 {
	FONT-WEIGHT: bold
}
.h A {
	COLOR: #1b72af; FONT-FAMILY: Arial
}
.h SPAN A {
	COLOR: #1b72af
}
.h SPAN {
	COLOR: #1b72af
}
.closeicon {
	MARGIN-TOP: 0.3em
}
.cate_fold {
	PADDING-RIGHT: 5px; PADDING-LEFT: 5px; MARGIN-BOTTOM: 2px; PADDING-BOTTOM: 0px; PADDING-TOP: 0px; TEXT-DECORATION: none
}
.cate_fold:hover {
	TEXT-DECORATION: none
}
.tr1 TH {
	PADDING-RIGHT: 10px; PADDING-LEFT: 10px; FONT-WEIGHT: normal; PADDING-BOTTOM: 5px; VERTICAL-ALIGN: top; PADDING-TOP: 5px; TEXT-ALIGN: left
}
.tr1 TD.td1 {
	BORDER-BOTTOM: #d5e6ed 1px solid
}
.tr2 {
	BACKGROUND: url(images/wind/tr2.png) #ffffff repeat-x 0px bottom; COLOR: #666666
}
.tr2 TD {
	PADDING-RIGHT: 6px; PADDING-LEFT: 6px; PADDING-BOTTOM: 1px; LINE-HEIGHT: 18px; PADDING-TOP: 4px; BORDER-BOTTOM: #c5d8e8 1px solid
}
.tr2 TH {
	PADDING-RIGHT: 6px; PADDING-LEFT: 6px; PADDING-BOTTOM: 1px; LINE-HEIGHT: 18px; PADDING-TOP: 4px; BORDER-BOTTOM: #c5d8e8 1px solid
}
.tr2 A {
	MARGIN: 0px 2px; COLOR: #1b72af
}
.tr3 TD {
	PADDING-RIGHT: 0.6em; PADDING-LEFT: 0.6em; PADDING-BOTTOM: 0.6em; LINE-HEIGHT: 1.3; PADDING-TOP: 0.6em; BORDER-BOTTOM: #d5e6ed 1px solid
}
.tr3 TH {
	PADDING-RIGHT: 0.6em; PADDING-LEFT: 0.6em; PADDING-BOTTOM: 0.6em; LINE-HEIGHT: 1.3; PADDING-TOP: 0.6em; BORDER-BOTTOM: #d5e6ed 1px solid
}
.tr3 TH {
	FONT-WEIGHT: normal; TEXT-ALIGN: left
}
.z .tr3:hover {
	BACKGROUND: #f3f9fb
}
.tr TD {
	PADDING-RIGHT: 2px; PADDING-LEFT: 2px; PADDING-BOTTOM: 2px; PADDING-TOP: 2px
}
.tr TH {
	PADDING-RIGHT: 2px; PADDING-LEFT: 2px; PADDING-BOTTOM: 2px; PADDING-TOP: 2px
}
.tr5 TD {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-LEFT: 0.5em; BORDER-BOTTOM: #d5e6ed 1px solid
}
H1 {
	FONT-WEIGHT: 700; FONT-SIZE: 16px; MARGIN: 15px; COLOR: #3366cc; LINE-HEIGHT: 1
}
.read_h1 {
	FONT-WEIGHT: 700; FONT-SIZE: 16px; MARGIN: 15px; COLOR: #3366cc; LINE-HEIGHT: 1
}
.honor {
	PADDING-RIGHT: 10px; PADDING-LEFT: 0px; PADDING-BOTTOM: 5px; OVERFLOW: hidden; COLOR: #777; PADDING-TOP: 0px
}
.tpc_content {
	PADDING-RIGHT: 15px; PADDING-LEFT: 15px; PADDING-BOTTOM: 20px; MARGIN: 0px; LINE-HEIGHT: 2em; PADDING-TOP: 0px; FONT-FAMILY: Arial
}
.tpc_content FONT {
	LINE-HEIGHT: 1.5em
}
.tpc_content A {
	COLOR: #0070af; TEXT-DECORATION: none
}
.tpc_content A:hover {
	TEXT-DECORATION: underline
}
.tpc_content OL {
	LIST-STYLE-TYPE: decimal
}
.tpc_content UL {
	LIST-STYLE-TYPE: disc
}
.tips {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 5px; BORDER-TOP: #d5e6ed 1px solid; PADDING-LEFT: 5px; BACKGROUND: #f3f9fb; PADDING-BOTTOM: 3px; BORDER-LEFT: #d5e6ed 1px solid; PADDING-TOP: 3px; BORDER-BOTTOM: #d5e6ed 1px solid
}
.tips2 {
	PADDING-RIGHT: 0px; BORDER-TOP: #d5e6ed 1px dashed; PADDING-LEFT: 0px; PADDING-BOTTOM: 10px; PADDING-TOP: 10px
}
.tips {
	DISPLAY: inline; FLOAT: left; MARGIN: 5px 15px; LINE-HEIGHT: 24px; TEXT-ALIGN: left
}
.tips2 {
	DISPLAY: inline; FLOAT: left; MARGIN: 5px 15px; LINE-HEIGHT: 24px; TEXT-ALIGN: left
}
.tips2 LI {
	FLOAT: left; MARGIN: 0px 10px 0px 0px; OVERFLOW: hidden; WIDTH: 30%; LIST-STYLE-TYPE: none; HEIGHT: 24px; TEXT-OVERFLOW: ellipsis; min-width: 210px
}
.tiptop {
	PADDING-RIGHT: 0px; PADDING-LEFT: 1px; PADDING-BOTTOM: 0px; MARGIN: 0px 15px; LINE-HEIGHT: 27px; PADDING-TOP: 0px; BORDER-BOTTOM: #ccc 1px dashed; HEIGHT: 27px
}
.tipad {
	MARGIN: 20px 15px 10px
}
.tipad .fr A {
	COLOR: #888
}
BLOCKQUOTE {
	PADDING-LEFT: 1em
}
.blockquote3 {
	CLEAR: left; BORDER-RIGHT: #ccc 1px dashed; PADDING-RIGHT: 10px; BORDER-TOP: #ccc 1px dashed; PADDING-LEFT: 10px; BACKGROUND: url(images/blockquote3.png) #f7f7f7 no-repeat right top; PADDING-BOTTOM: 5px; MARGIN: 10px 0px 0px; BORDER-LEFT: #ccc 1px dashed; PADDING-TOP: 5px; BORDER-BOTTOM: #ccc 1px dashed
}
.blockquote3 .quote {
	FONT-SIZE: 12px; COLOR: #999
}
.blockquote3 .text {
	PADDING-RIGHT: 10px; PADDING-LEFT: 10px; PADDING-BOTTOM: 10px; PADDING-TOP: 0px
}
.blockquote {
	BORDER-RIGHT: #fcefbb 1px solid; PADDING-RIGHT: 8px; BORDER-TOP: #fcefbb 1px solid; PADDING-LEFT: 8px; BACKGROUND: #fffff3; PADDING-BOTTOM: 5px; MARGIN: 0px 15px; BORDER-LEFT: #fcefbb 1px solid; COLOR: #000; LINE-HEIGHT: 1.3; PADDING-TOP: 5px; BORDER-BOTTOM: #fcefbb 1px solid; ZOOM: 1
}
.block-img {
	PADDING-LEFT: 28px; BACKGROUND: url(images/attention.png) #fffae1 no-repeat 8px 6px; MARGIN: 0px 15px 10px
}
.blockquote2 {
	BORDER-RIGHT: #ededed 1px solid; PADDING-RIGHT: 0px; BORDER-TOP: #c0c0c0 1px solid; PADDING-LEFT: 2em; BACKGROUND: #fff; PADDING-BOTTOM: 0px; MARGIN: 0px; OVERFLOW: hidden; BORDER-LEFT: #c0c0c0 1px solid; LINE-HEIGHT: 2em; PADDING-TOP: 0px; BORDER-BOTTOM: #ededed 1px solid
}
.blockquote2 OL {
	PADDING-RIGHT: 0px; PADDING-LEFT: 0px; PADDING-BOTTOM: 0px; MARGIN: 0px 0px 0px 1.5em; PADDING-TOP: 0px
}
.blockquote2 OL LI {
	PADDING-RIGHT: 1em; PADDING-LEFT: 10px; FONT-SIZE: 12px; BACKGROUND: #f7f7f7; BORDER-LEFT: #ccc 1px solid; FONT-FAMILY: "Courier New" serif
}
.blockquote2 OL LI:hover {
	BACKGROUND: #fff; COLOR: #008ef1
}
.blockquote2 OL LI {
	LIST-STYLE-TYPE: decimal
}
.read_form {
	BORDER-TOP: #d5e6ed 1px solid; BACKGROUND: #f3f9fb; BORDER-LEFT: #d5e6ed 1px solid
}
.read_form TD {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 5px; PADDING-LEFT: 5px; PADDING-BOTTOM: 0px; PADDING-TOP: 0px; BORDER-BOTTOM: #d5e6ed 1px solid; HEIGHT: 20px
}
.pages A {
	DISPLAY: block; FLOAT: left; MARGIN-RIGHT: 3px
}
.pages B {
	DISPLAY: block; FLOAT: left; MARGIN-RIGHT: 3px
}
.pages .pagesone {
	DISPLAY: block; FLOAT: left; MARGIN-RIGHT: 3px
}
.pages A {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 7px; BORDER-TOP: #d5e6ed 1px solid; PADDING-LEFT: 7px; BACKGROUND: #ffffff; PADDING-BOTTOM: 0px; BORDER-LEFT: #d5e6ed 1px solid; PADDING-TOP: 0px; BORDER-BOTTOM: #d5e6ed 1px solid
}
.pages B {
	BORDER-RIGHT: #1b72af 1px solid; PADDING-RIGHT: 7px; BORDER-TOP: #1b72af 1px solid; PADDING-LEFT: 7px; BACKGROUND: #1b72af; PADDING-BOTTOM: 0px; BORDER-LEFT: #1b72af 1px solid; COLOR: #ffffff; PADDING-TOP: 0px; BORDER-BOTTOM: #1b72af 1px solid; TEXT-DECORATION: none
}
.pages A:hover {
	BORDER-RIGHT: #1b72af 1px solid; PADDING-RIGHT: 7px; BORDER-TOP: #1b72af 1px solid; PADDING-LEFT: 7px; BACKGROUND: #1b72af; PADDING-BOTTOM: 0px; BORDER-LEFT: #1b72af 1px solid; COLOR: #ffffff; PADDING-TOP: 0px; BORDER-BOTTOM: #1b72af 1px solid; TEXT-DECORATION: none
}
.pages .pagesone {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 1px; BORDER-TOP: #d5e6ed 1px solid; BACKGROUND: #ffffff; FONT: 11px/18px Verdana; BORDER-LEFT: #d5e6ed 1px solid; BORDER-BOTTOM: #d5e6ed 1px solid; HEIGHT: 18px
}
.pages INPUT {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 0px; BORDER-TOP: #d5e6ed 1px solid; MARGIN-TOP: 1px; PADDING-LEFT: 0px; FLOAT: left; PADDING-BOTTOM: 0px; FONT: 10px/12px Verdana; BORDER-LEFT: #d5e6ed 1px solid; PADDING-TOP: 0px; BORDER-BOTTOM: #d5e6ed 1px solid; HEIGHT: 14px
}
.pages .pagesone SPAN {
	FLOAT: left; MARGIN: 0px 5px
}
.pages .c {
	WIDTH: 1px
}
.pages BUTTON {
	BORDER-RIGHT: #a6cbe7 1px solid; BORDER-TOP: #a6cbe7 1px solid; BACKGROUND: #d5e6ed; FLOAT: left; MARGIN: 1px 0px 0px 1px; BORDER-LEFT: #a6cbe7 1px solid; CURSOR: pointer; COLOR: #1b72af; LINE-HEIGHT: 12px; BORDER-BOTTOM: #a6cbe7 1px solid; HEIGHT: 16px
}
.y-bg2 {
	BACKGROUND: #ffffff
}
.y-bg3 {
	BACKGROUND: #ffffff
}
.y-bg4 {
	BACKGROUND: #ffffff
}
.y-bg {
	BORDER-TOP: #d5e6ed 1px solid; MARGIN: 0px 4px
}
.y-bg2 {
	BORDER-RIGHT: #d5e6ed 2px solid; BORDER-TOP: #d5e6ed 0px solid; MARGIN: 0px 2px; OVERFLOW: hidden; BORDER-LEFT: #d5e6ed 2px solid; BORDER-BOTTOM: #d5e6ed 0px solid; HEIGHT: 1px
}
.y-bg3 {
	BORDER-RIGHT: #d5e6ed 1px solid; BORDER-TOP: #d5e6ed 0px solid; MARGIN: 0px 1px; OVERFLOW: hidden; BORDER-LEFT: #d5e6ed 1px solid; BORDER-BOTTOM: #d5e6ed 0px solid; HEIGHT: 2px
}
.y-bg4 {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 10px; BORDER-TOP: #d5e6ed 0px solid; PADDING-LEFT: 10px; PADDING-BOTTOM: 0px; OVERFLOW: hidden; BORDER-LEFT: #d5e6ed 1px solid; PADDING-TOP: 0px; BORDER-BOTTOM: #d5e6ed 0px solid
}
.menu {
	BORDER-RIGHT: #d5e6ed 1px solid; BORDER-TOP: #d5e6ed 1px solid; BACKGROUND: #fff; BORDER-LEFT: #d5e6ed 1px solid; BORDER-BOTTOM: #d5e6ed 1px solid; POSITION: absolute
}
.menu A {
	PADDING-RIGHT: 8px; DISPLAY: block; PADDING-LEFT: 8px; PADDING-BOTTOM: 4px; PADDING-TOP: 4px
}
.menu-post {
	BORDER-RIGHT: #a6cbe7 1px solid; BORDER-TOP: #a6cbe7 1px solid; BORDER-LEFT: #a6cbe7 1px solid; BORDER-BOTTOM: #a6cbe7 1px solid
}
.menu-post .menu-b {
	BORDER-RIGHT: #d5e6ed 3px solid; BORDER-TOP: #d5e6ed 3px solid; BACKGROUND: #ffffff; BORDER-LEFT: #d5e6ed 3px solid; BORDER-BOTTOM: #d5e6ed 3px solid
}
.menu_tasksA .menu-b {
	BORDER-TOP-WIDTH: 8px; BORDER-LEFT-WIDTH: 8px; BORDER-BOTTOM-WIDTH: 8px; BORDER-RIGHT-WIDTH: 8px
}
.popoutContent {
	BORDER-RIGHT: #a6cbe7 1px solid; BORDER-TOP: #a6cbe7 1px solid; BACKGROUND: #ffffff; BORDER-LEFT: #a6cbe7 1px solid; BORDER-BOTTOM: #a6cbe7 1px solid
}
.bgcorner1 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.bgcorner2 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.bgcorner3 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.bgcorner4 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.pobg1 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.pobg2 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.pobg3 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.pobg4 {
	Z-INDEX: 1005; FILTER: Alpha(opacity=90); OVERFLOW: hidden; LINE-HEIGHT: 0; opacity: .9
}
.bgcorner1 {
	BACKGROUND: #a6cbe7; WIDTH: 5px; HEIGHT: 5px
}
.bgcorner2 {
	BACKGROUND: #a6cbe7; WIDTH: 5px; HEIGHT: 5px
}
.bgcorner3 {
	BACKGROUND: #a6cbe7; WIDTH: 5px; HEIGHT: 5px
}
.bgcorner4 {
	BACKGROUND: #a6cbe7; WIDTH: 5px; HEIGHT: 5px
}
.bgcorner1 {
	BACKGROUND-POSITION: 0px 0px
}
.bgcorner2 {
	BACKGROUND-POSITION: -5px 0px
}
.bgcorner3 {
	BACKGROUND-POSITION: -5px -5px
}
.bgcorner4 {
	BACKGROUND-POSITION: 0px -5px
}
.pobg1 {
	BACKGROUND: #a6cbe7
}
.pobg2 {
	BACKGROUND: #a6cbe7
}
.pobg3 {
	BACKGROUND: #a6cbe7
}
.pobg4 {
	BACKGROUND: #a6cbe7
}
.pobg1 {
	HEIGHT: 5px
}
.pobg2 {
	WIDTH: 5px
}
.pobg3 {
	HEIGHT: 5px
}
.pobg4 {
	WIDTH: 5px
}
.popoutContent TD {
	PADDING-RIGHT: 0.6em; PADDING-LEFT: 0.6em; PADDING-BOTTOM: 0.5em; PADDING-TOP: 0.5em; BORDER-BOTTOM: #d5e6ed 1px solid
}
.popoutContent TD TD {
	PADDING-RIGHT: 1em; PADDING-LEFT: 0px; PADDING-BOTTOM: 0.3em; PADDING-TOP: 0.3em; BORDER-BOTTOM-STYLE: none
}
.black {
	COLOR: #333
}
.black A {
	COLOR: #333
}
.s1 {
	COLOR: #008000
}
.s2 {
	COLOR: #984b98
}
.s3 {
	COLOR: #ff6600
}
.s4 {
	COLOR: #3366cc
}
.s4 A {
	COLOR: #3366cc
}
.s5 A {
	COLOR: #1b72af
}
.gray {
	COLOR: #888888
}
.gray A {
	COLOR: #888888
}
.gray2 {
	COLOR: #bbbbbb
}
.gray2 A {
	COLOR: #bbbbbb
}
.red {
	COLOR: #ff0000
}
.mr5 {
	MARGIN-RIGHT: 5px
}
A.select_arrow {
	DISPLAY: block; BACKGROUND: url(images/select_arrow.gif) no-repeat; MARGIN: 0px 2px 0px 0px; OVERFLOW: hidden; WIDTH: 15px; TEXT-INDENT: -2000em; HEIGHT: 15px
}
A.select_arrow:hover {
	BACKGROUND: url(images/select_arrow_over.gif) no-repeat
}
.sel_name LI {
	BORDER-BOTTOM: #d5e6ed 1px solid
}
.pw_list_a {
	BACKGROUND: #e8f5fb; COLOR: #1b72af; BORDER-BOTTOM: #c5d8e8 1px solid
}
.pw_list_a LI A {
	COLOR: #1b72af
}
.pw_list_a .current A {
	BORDER-RIGHT: #a6cbe7 1px solid; BORDER-TOP: #a6cbe7 1px solid; BACKGROUND: #ffffff; BORDER-LEFT: #a6cbe7 1px solid; COLOR: #666666; BORDER-BOTTOM: #a6cbe7 0px solid
}
.pw_list_a LI.none A {
	BORDER-RIGHT: #a6cbe7 1px solid; BORDER-TOP: #a6cbe7 1px solid; BACKGROUND: #ffffff; MARGIN-LEFT: 5px; BORDER-LEFT: #a6cbe7 1px solid; BORDER-BOTTOM: #a6cbe7 1px solid
}
</STYLE>
<STYLE type="text/css">
.sigline {
	MARGIN-TOP: 10px; BACKGROUND: url(images/wind/read/sigline.gif) no-repeat right bottom; MARGIN-LEFT: 15px; MARGIN-RIGHT: 30em; HEIGHT: 5px
}
.signature {
	PADDING-RIGHT: 15px; PADDING-LEFT: 15px; PADDING-BOTTOM: 0px; PADDING-TOP: 10px; ; HEIGHT: expression(this.scrollHeight>parseInt(this.currentStyle.maxHeight)?this.currentStyle.maxHeight:"auto")
}
.user-pic IMG {
	BORDER-RIGHT: #d5e6ed 1px solid; PADDING-RIGHT: 3px; BORDER-TOP: #d5e6ed 1px solid; PADDING-LEFT: 3px; BACKGROUND: #fff; PADDING-BOTTOM: 3px; BORDER-LEFT: #d5e6ed 1px solid; PADDING-TOP: 3px; BORDER-BOTTOM: #d5e6ed 1px solid
}
.small {
	FONT-SIZE: 12px
}
.middle {
	FONT-SIZE: 14px
}
.big {
	FONT-SIZE: 18px
}
.dig {
	BORDER-RIGHT: #ffd0a8 1px solid; PADDING-RIGHT: 0.4em; BACKGROUND-POSITION: -22px -57px; BORDER-TOP: #ffd0a8 1px solid; PADDING-LEFT: 1.6em; FONT-SIZE: 12px; PADDING-BOTTOM: 0px; MARGIN: 12px 5px 10px 15px; BORDER-LEFT: #ffd0a8 1px solid; CURSOR: pointer; COLOR: #666; LINE-HEIGHT: 18px; PADDING-TOP: 0px; BORDER-BOTTOM: #ffd0a8 1px solid; HEIGHT: 18px; BACKGROUND-COLOR: #ffffee
}
.dig:hover {
	BORDER-RIGHT: #f5a25c 1px solid; BORDER-TOP: #f5a25c 1px solid; BORDER-LEFT: #f5a25c 1px solid; COLOR: #ff6600; BORDER-BOTTOM: #f5a25c 1px solid; TEXT-DECORATION: none
}
.readbot {
	PADDING-RIGHT: 0px; PADDING-LEFT: 0px; PADDING-BOTTOM: 0px; PADDING-TOP: 0px
}
.readbot A {
	PADDING-RIGHT: 0px; PADDING-LEFT: 1.5em; BACKGROUND: url(images/wind/read/yin.gif) no-repeat; FLOAT: left; PADDING-BOTTOM: 0px; MARGIN: 0px; WIDTH: 3.5em; CURSOR: pointer; PADDING-TOP: 0px; LIST-STYLE-TYPE: none; HEIGHT: 16px
}
.readbot .r-quote:hover {
	BACKGROUND-POSITION: 0px 0px
}
.readbot .r-reply:hover {
	BACKGROUND-POSITION: 0px -20px
}
.readbot .r-score:hover {
	BACKGROUND-POSITION: 0px -40px
}
.readbot .r-keep:hover {
	BACKGROUND-POSITION: 0px -60px
}
.readbot .r-recommend:hover {
	BACKGROUND-POSITION: 0px -160px
}
.readbot .r-report:hover {
	BACKGROUND-POSITION: 0px -200px
}
.readbot .r-quote {
	BACKGROUND-POSITION: 0px -80px
}
.readbot .r-reply {
	BACKGROUND-POSITION: 0px -100px
}
.readbot .r-score {
	BACKGROUND-POSITION: 0px -120px
}
.readbot .r-keep {
	BACKGROUND-POSITION: 0px -140px
}
.readbot .r-recommend {
	BACKGROUND-POSITION: 0px -180px
}
.readbot .r-report {
	BACKGROUND-POSITION: 0px -220px
}
.down {
	BORDER-RIGHT: #c5d8e8 1px solid; PADDING-RIGHT: 5px; BORDER-TOP: #c5d8e8 1px solid; PADDING-LEFT: 30px; BACKGROUND: url(images/post/down.gif) no-repeat 5px center; PADDING-BOTTOM: 5px; MARGIN: 0px 1em 0px 0px; BORDER-LEFT: #c5d8e8 1px solid; LINE-HEIGHT: 40px; PADDING-TOP: 5px; BORDER-BOTTOM: #c5d8e8 1px solid
}
.img-50 {
	WIDTH: 48px; HEIGHT: 48px
}
.cates {
	MARGIN: 0px 0px 10px
}
.cates .cate-list LI {
	PADDING-RIGHT: 0px; PADDING-LEFT: 10px; FONT-WEIGHT: 500; PADDING-BOTTOM: 1px; COLOR: #444444; PADDING-TOP: 2px; LIST-STYLE-TYPE: none
}
.cates .cate-list EM {
	FLOAT: left; WIDTH: 100px; FONT-STYLE: normal
}
.cates .cate-list CITE {
	FONT-STYLE: normal
}
.cates INPUT {
	VERTICAL-ALIGN: middle
}
.cates .w {
	MARGIN-RIGHT: 10px
}
.cates .two {
	BACKGROUND: #f3f9fb
}
.app-post {
	DISPLAY: block; PADDING-LEFT: 17px; BACKGROUND: url(images/app-post.png); FLOAT: left; WIDTH: 78px; COLOR: #ffffff; LINE-HEIGHT: 25px; HEIGHT: 26px
}
.app-post:hover {
	BACKGROUND-POSITION: 0px -50px; TEXT-DECORATION: none
}
.cate_meg_player {
	PADDING-RIGHT: 10px; PADDING-LEFT: 0px; BACKGROUND: #fff; FLOAT: right; PADDING-BOTTOM: 9px; WIDTH: 200px; MARGIN-RIGHT: 10px; PADDING-TOP: 0px
}
.flash {
	POSITION: relative
}
.flash IMG {
	WIDTH: 100%; HEIGHT: 100%
}
.flash UL {
	Z-INDEX: 3; RIGHT: 8px; BOTTOM: 8px; POSITION: absolute
}
.flash UL LI {
	BACKGROUND: #ffffff; FLOAT: left; MARGIN-LEFT: 2px; WIDTH: 18px; LINE-HEIGHT: 13px; LIST-STYLE-TYPE: none; HEIGHT: 13px; TEXT-ALIGN: center
}
.flash UL LI A {
	DISPLAY: block; FONT-SIZE: 10px; WIDTH: 18px; COLOR: #333333; FONT-FAMILY: Tahoma; HEIGHT: 13px
}
.flash UL LI A:hover {
	BACKGROUND: #ffa900; COLOR: #fff; TEXT-DECORATION: none
}
.flash UL LI A.sel {
	BACKGROUND: #ffa900; COLOR: #fff; TEXT-DECORATION: none
}
.score {
	BORDER-TOP: #d5e6ed 1px dashed; MARGIN: 10px 15px; LINE-HEIGHT: 22px; PADDING-TOP: 10px
}
.score TD {
	PADDING-RIGHT: 10px; PADDING-LEFT: 5px; PADDING-BOTTOM: 2px; PADDING-TOP: 2px
}
.score TH {
	PADDING-RIGHT: 0px; PADDING-LEFT: 0px; PADDING-BOTTOM: 0px; PADDING-TOP: 6px
}
.score TR:hover {
	BACKGROUND: #f3f9fb
}
.score A {
	COLOR: #3366cc
}
.overprint_opl A {
	PADDING-RIGHT: 3px; DISPLAY: block; PADDING-LEFT: 3px; FLOAT: left; PADDING-BOTTOM: 3px; MARGIN: 3px; PADDING-TOP: 3px
}
.overprint_opl A.current {
	BORDER-RIGHT: #ccc 1px solid; PADDING-RIGHT: 2px; BORDER-TOP: #ccc 1px solid; PADDING-LEFT: 2px; PADDING-BOTTOM: 2px; BORDER-LEFT: #ccc 1px solid; PADDING-TOP: 2px; BORDER-BOTTOM: #ccc 1px solid
}
.overprint_opl A:hover {
	BORDER-RIGHT: #ddd 1px solid; PADDING-RIGHT: 2px; BORDER-TOP: #ddd 1px solid; PADDING-LEFT: 2px; BACKGROUND: #fff9f0; PADDING-BOTTOM: 2px; BORDER-LEFT: #ddd 1px solid; PADDING-TOP: 2px; BORDER-BOTTOM: #ddd 1px solid
}
.overprint_opl {
	OVERFLOW: auto; HEIGHT: 200px
}
.tipad .fr A {
	PADDING-RIGHT: 0px; PADDING-LEFT: 6px; PADDING-BOTTOM: 0px; PADDING-TOP: 0px
}
</STYLE>
<base>
<xsl:attribute name="href">
  <xsl:value-of select="Url" />
</xsl:attribute>
</base>
</HEAD>
<BODY>
<div class="t" style="BORDER-BOTTOM-WIDTH: 0px; MARGIN-BOTTOM: 0px">
<table cellSpacing="0" cellPadding="0" width="100%">
  <tbody>
  <TR>
    <TD class="tal h" style="BORDER-BOTTOM-WIDTH: 0px; height: 37px; width: 603px;"> 
      <xsl:value-of select="Board" />&#187;<xsl:value-of select="Subject" /></TD>
    <TD class="tar h" style="BORDER-BOTTOM-WIDTH: 0px; height: 37px;">
      </TD></TR></tbody></table></div>
<div class="t5" 
style="BORDER-RIGHT: #a6cbe7 1px solid; BORDER-TOP: #a6cbe7 1px solid; BORDER-LEFT: #a6cbe7 1px solid; BORDER-BOTTOM: #a6cbe7 1px solid">
      
<xsl:for-each select="Note[Layer=0]" >
<table style="table-LAYOUT: fixed" cellSpacing="0" cellPadding="0" width="100%">
  <tbody>
  <TR>
    <TD class="r_two" style="VERTICAL-ALIGN: top; WIDTH: 185px" rowSpan="2">
      <div 
      style="PADDING-RIGHT: 0px; PADDING-LEFT: 8px; PADDING-BOTTOM: 20px; PADDING-TOP: 8px">
      <div class="cc" style="PADDING-BOTTOM: 3px"><B class="fl black"><xsl:value-of select="Author"/></B>&#160; </div>
      <div class="user-pic">&#160;</div>
      </div></TD>
    <TD class="r_one" id="td_tpc" 
    style="BORDER-TOP-WIDTH: 0px; PADDING-RIGHT: 0px; PADDING-LEFT: 0px; BORDER-LEFT-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; PADDING-BOTTOM: 0px; OVERFLOW: hidden; PADDING-TOP: 0px; BORDER-RIGHT-WIDTH: 0px" 
    vAlign="top" height="100%">
      <div id="read_overprint" 
      style="MARGIN-TOP: 25px; MARGIN-LEFT: 440px; OVERFLOW: hidden; POSITION: absolute"></div>
      <div class="tiptop cc"><SPAN class="fl">¥&#160; </SPAN><SPAN 
      class="fl gray" style="WHITE-SPACE: nowrap">: 
      <xsl:value-of select="ReportTime" /></SPAN> </div>
      <div class="c"></div>
      <H1 id="subject_tpc"><xsl:value-of select="Title" /></H1>
      <div class="c"></div>
      <div class="tpc_content">
      <div class="c" id="p_tpc"></div>
      <div class="f14" id="read_tpc"><xsl:value-of select="Content" disable-output-escaping="yes" /></div></div></TD></TR>
</tbody></table>
</xsl:for-each>
<xsl:for-each select="Note[Layer>0]" >
<table style="table-LAYOUT: fixed" cellSpacing="0" cellPadding="0" width="100%">
  <tbody>
  <TR>
    <TD class="r_two" style="VERTICAL-ALIGN: top; WIDTH: 185px" rowSpan="2">
      <div 
      style="PADDING-RIGHT: 0px; PADDING-LEFT: 8px; PADDING-BOTTOM: 20px; PADDING-TOP: 8px">
      <div class="cc" style="PADDING-BOTTOM: 3px"><B class="fl black"><xsl:value-of select="Author"/></B>&#160; </div>
      <div class="user-pic">&#160;</div>
      </div></TD>
    <TD class="r_one" id="td_tpc" 
    style="BORDER-TOP-WIDTH: 0px; PADDING-RIGHT: 0px; PADDING-LEFT: 0px; BORDER-LEFT-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; PADDING-BOTTOM: 0px; OVERFLOW: hidden; PADDING-TOP: 0px; BORDER-RIGHT-WIDTH: 0px" 
    vAlign="top" height="100%">
      <div id="read_overprint" 
      style="MARGIN-TOP: 25px; MARGIN-LEFT: 440px; OVERFLOW: hidden; POSITION: absolute"></div>
      <div class="tiptop cc"><SPAN class="fl"><xsl:value-of select="Layer+1"/>¥&#160; </SPAN><SPAN 
      class="fl gray" style="WHITE-SPACE: nowrap">ظ: 
      <xsl:value-of select="ReportTime" /></SPAN> </div>
      <div class="c"></div>
      <H1 id="subject_tpc"><xsl:value-of select="Title" /></H1>
      <div class="c"></div>
      <div class="tpc_content">
      <div class="c" id="p_tpc"></div>
      <div class="f14" id="read_tpc"><xsl:value-of select="Content" disable-output-escaping="yes" /></div></div></TD></TR>
</tbody></table>
</xsl:for-each>
</div>
<table align="center" style="font-size:12px">
<TR>
<TD>ҳ ̳  <xsl:value-of select="GenerateTime" /> Զɡ</TD>
</TR>
</table>
</BODY>
</HTML>
</xsl:template>
</xsl:stylesheet>
