DROP TABLE DEPARTMENTS;

CREATE TABLE DEPARTMENTS (
   ID                  INTEGER       not null,
   DEPARTMENT_NAME     VARCHAR(128),
 PRIMARY KEY (ID));

DROP TABLE COMPUTERS;

CREATE TABLE COMPUTERS (
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   DEPARTMENT_ID       INTEGER,
   USER_NAME           VARCHAR(128),
   IP_ADDRESSES        VARCHAR(128),
   MAC_ADDRESSES       VARCHAR(128),
   WINDOWS_NAME        VARCHAR(128),
   WINDOWS_SP          VARCHAR(64),
   DISK_TOTAL          INTEGER,
   DISK_FREE           INTEGER,
   PROCESSOR_COUNT     INTEGER,
   PROCESSOR_SPEED     INTEGER,
   MEMORY_SIZE         INTEGER,
   COLLECT_TIME        DATETIME,
 PRIMARY KEY (COMPUTER_NAME));


DROP TABLE CLASSES;

CREATE TABLE CLASSES (
   CLASS_NAME          VARCHAR(16)   not NULL,
   CLASS_COMMENT       VARCHAR(128),
 PRIMARY KEY (CLASS_NAME));


DROP TABLE HARDWARE;

CREATE TABLE HARDWARE (
   ID                  INTEGER       not null,
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   CLASS_NAME          VARCHAR(16)   not NULL,
   HARDWARE_NAME       VARCHAR(128),
 PRIMARY KEY (ID));


DROP TABLE SOFTWARE;

CREATE TABLE SOFTWARE (
   ID                  INTEGER       not null,
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   SOFTWARE_NAME       VARCHAR(128),
   VERSION             VARCHAR(128),
   DEVELOPER           VARCHAR(128),
   HOME_PAGE           VARCHAR(128),
 PRIMARY KEY (ID));
 

DROP TABLE HISTORY;

CREATE TABLE HISTORY (
   ID                   INTEGER      not null,
   COMPUTER_NAME        VARCHAR(64)  not NULL,
   EVENT_TIME           DATETIME,
   SOURCE_TYPE          VARCHAR(8),
   CLASS_NAME           VARCHAR(16),
   OLD_VALUE            VARCHAR(128),
   NEW_VALUE            VARCHAR(128),
 PRIMARY KEY (ID));
 

DROP TABLE ADDITIONAL_EDITORS;

CREATE TABLE ADDITIONAL_EDITORS (
   ID                  INTEGER       not null,
   EDITOR_NAME         VARCHAR(128),
 PRIMARY KEY (ID));
 

DROP TABLE ADDITIONAL_VALUES;

CREATE TABLE ADDITIONAL_VALUES (
   ID                  INTEGER       not null,
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   EDITOR_ID           INTEGER,
   CUR_VALUE           VARCHAR(128),
 PRIMARY KEY (ID));


DROP TABLE USER_EDITORS;

CREATE TABLE USER_EDITORS (
   ID                  INTEGER       not null,
   EDITOR_NAME         VARCHAR(128),
 PRIMARY KEY (ID));
 

DROP TABLE USERS;

CREATE TABLE USERS (
   ID                  INTEGER       not null,
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   USER_NAME           VARCHAR(128),
   PRIMARY KEY (ID));
 

DROP TABLE USER_VALUES;

CREATE TABLE USER_VALUES (
   ID                  INTEGER       not null,
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   EDITOR_ID           INTEGER,
   USER_ID             INTEGER,
   CUR_VALUE           VARCHAR(128),
 PRIMARY KEY (ID));


DROP TABLE JOURNALS;

CREATE TABLE JOURNALS (
   ID                  INTEGER       not null,
   JOURNAL_NAME        VARCHAR(128),
 PRIMARY KEY (ID));


DROP TABLE JOURNAL_EDITORS;

CREATE TABLE JOURNAL_EDITORS (
   ID                  INTEGER       not null,
   JOURNAL_ID          INTEGER,
   EDITOR_NAME         VARCHAR(128),
 PRIMARY KEY (ID));
 
 
DROP TABLE JOURNAL_RECORDS;

CREATE TABLE JOURNAL_RECORDS (
   ID                  INTEGER       not null,
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   JOURNAL_ID          INTEGER,
   RECORD_NAME         VARCHAR(128),
 PRIMARY KEY (ID));
 

DROP TABLE JOURNAL_VALUES;

CREATE TABLE JOURNAL_VALUES (
   ID                  INTEGER       not null,
   COMPUTER_NAME       VARCHAR(64)   not NULL,
   JOURNAL_ID          INTEGER,
   RECORD_ID           INTEGER,
   EDITOR_ID           INTEGER,
   CUR_VALUE           VARCHAR(128),
 PRIMARY KEY (ID));
