#!/bin/sh
#
# usage: format_flash.sh device start_cylinder erase
#
# Need to identify device to be operated on; /dev/hda1 is /mnt/disk0
# /dev/hdb1 is /mnt/disk1
#
#------------------------------------------------------------------
# Copyright (c) 2006, 2007 by Cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------
#
if [ $1 = /dev/hda1 ]; then
DEV=/dev/hda
MNT=/mnt/disk0
else
DEV=/dev/hdb
MNT=/mnt/disk1
fi

if [ $3 = 1 ]; then
FLAGS="-F 16 -e"
else
FLAGS="-F 16"
fi

#
# Create fdisk.in based on starting cylinder parameter, etc
#
echo "d" >  /asa/scripts/fdisk.in
echo "o" >> /asa/scripts/fdisk.in
echo "n" >> /asa/scripts/fdisk.in
echo "p" >> /asa/scripts/fdisk.in
echo "1" >> /asa/scripts/fdisk.in
echo $2  >> /asa/scripts/fdisk.in
echo " " >> /asa/scripts/fdisk.in
echo "t" >> /asa/scripts/fdisk.in
echo "4" >> /asa/scripts/fdisk.in
echo "w" >> /asa/scripts/fdisk.in

/bin/umount $MNT > /dev/null 2> /dev/null
echo -n "Initializing partition - "
/sbin/fdisk $DEV < /asa/scripts/fdisk.in > /dev/null 2> /dev/null
echo "done!"
/sbin/mkdosfs $FLAGS $1
echo ""
echo "System tables written to disk"
/bin/mount -t vfat -o umask=0000,noatime,check=s,posix,shortname=mixed $1 $MNT
