import uuid

from PythonPlugin import PythonPlugin


class Main(PythonPlugin):

    def Query(self, param):
        results = []

        count = 1

        try:
            count = int(param.strip())
        except ValueError:
            count = 1

        guid_list = self.get_guid(count)

        is_multi = len(guid_list) > 1

        results.append({
            "Title": ("已生成GUID *" + len(guid_list).__str__()) if is_multi else guid_list[0],
            "SubTitle": "选择复制" + ("全部" if is_multi else "此项"),
            "IconPath": "img/app.png",
            "Action": {
                'FuncName': 'Ra_CopyPath',
                'Parameter': "\n".join(guid_list) if is_multi else guid_list[0]
            }
        })

        if is_multi:
            for item in guid_list:
                results.append({
                    "Title": item,
                    "SubTitle": "选择复制此项",
                    "IconPath": "img/app.png",
                    "Action": {
                        'FuncName': 'Ra_CopyPath',
                        'Parameter': item
                    }
                })

        return results

    @staticmethod
    def get_guid(count):
        guid_list = []
        for _ in range(0, count):
            guid = uuid.uuid4().__str__()
            guid_list.append(guid.replace("-", "").upper())
        return guid_list


if __name__ == '__main__':
    Main()
