/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/dist/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(19);


/***/ },
/* 1 */,
/* 2 */,
/* 3 */,
/* 4 */,
/* 5 */,
/* 6 */,
/* 7 */,
/* 8 */,
/* 9 */,
/* 10 */,
/* 11 */,
/* 12 */,
/* 13 */,
/* 14 */,
/* 15 */,
/* 16 */,
/* 17 */,
/* 18 */,
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	var Panel, name, panel, ref, version;

	Panel = __webpack_require__(20);

	ref = __webpack_require__(30), name = ref.name, version = ref.version;

	__webpack_require__(31);

	panel = new Panel('Griddify');

	panel.updateNotifier.init({
	  name: name,
	  version: version,
	  channel: "beta",
	  hub: "http://gelobi.org/griddify/updateHub2/",
	  updateUrl: "http://gelobi.org/griddify"
	});

	panel.setPersistency(true, "Griddify");


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	var CSInterface, Form, OpenInBrowserHelper, Panel, Rotator, ThemeHandler, UpdateNotifier;

	window.CC = window.__adobe_cep__ != null;

	__webpack_require__(21);

	OpenInBrowserHelper = __webpack_require__(22);

	UpdateNotifier = __webpack_require__(23);

	ThemeHandler = __webpack_require__(26);

	if (window.CC) {
	  CSInterface = __webpack_require__(27);
	}

	Rotator = __webpack_require__(28);

	Form = __webpack_require__(29);

	module.exports = Panel = (function() {
	  function Panel(panelName, rootNode, options) {
	    this.panelName = panelName;
	    this.rootNode = rootNode != null ? rootNode : document.body;
	    this.options = options;
	    if (window.CC) {
	      this.csi = new CSInterface;
	    }
	    this.themeHandler = new ThemeHandler(this);
	    Rotator.applyTo(this.rootNode, this);
	    Form.applyTo(this.rootNode, this);
	    OpenInBrowserHelper.applyTo(this.rootNode, this);
	    this.updateNotifier = new UpdateNotifier(this);
	  }

	  Panel.prototype.setPersistency = function(isOn, id) {
	    var event;
	    if (!window.CC) {
	      return;
	    }
	    if (isOn) {
	      event = new CSInterface.CSEvent("com.adobe.PhotoshopPersistent", "APPLICATION");
	    } else {
	      event = new CSInterface.CSEvent("com.adobe.PhotoshopUnPersistent", "APPLICATION");
	    }
	    event.extensionId = id;
	    return this.csi.dispatchEvent(event);
	  };

	  Panel.prototype.invoke = function(method, data, stringify) {
	    var args, e, error, file, obj, src;
	    if (stringify == null) {
	      stringify = true;
	    }
	    if (stringify) {
	      data = JSON.stringify(data);
	    }
	    try {
	      if (window.CC) {
	        src = "$.global._panels." + method + ("(" + data + ");");
	        this.csi.evalScript(src, function(ret) {
	          return console.log(arguments);
	        });
	      } else {
	        file = this.options.jsx;
	        obj = '_panels';
	        args = [data];
	        _AdobeInvokeFunctionInScriptFile(file, obj, method, args);
	      }
	    } catch (error) {
	      e = error;
	      console.error(e);
	    }
	  };

	  return Panel;

	})();


/***/ },
/* 21 */
/***/ function(module, exports) {

	
	(function () {

	if (typeof window.Element === "undefined" || "classList" in document.documentElement) return;

	var prototype = Array.prototype,
	    push = prototype.push,
	    splice = prototype.splice,
	    join = prototype.join;

	function DOMTokenList(el) {
	  this.el = el;
	  // The className needs to be trimmed and split on whitespace
	  // to retrieve a list of classes.
	  var classes = el.className.replace(/^\s+|\s+$/g,'').split(/\s+/);
	  for (var i = 0; i < classes.length; i++) {
	    push.call(this, classes[i]);
	  }
	};

	DOMTokenList.prototype = {
	  add: function(token) {
	    if(this.contains(token)) return;
	    push.call(this, token);
	    this.el.className = this.toString();
	  },
	  contains: function(token) {
	    return this.el.className.indexOf(token) != -1;
	  },
	  item: function(index) {
	    return this[index] || null;
	  },
	  remove: function(token) {
	    if (!this.contains(token)) return;
	    for (var i = 0; i < this.length; i++) {
	      if (this[i] == token) break;
	    }
	    splice.call(this, i, 1);
	    this.el.className = this.toString();
	  },
	  toString: function() {
	    return join.call(this, ' ');
	  },
	  toggle: function(token) {
	    if (!this.contains(token)) {
	      this.add(token);
	    } else {
	      this.remove(token);
	    }

	    return this.contains(token);
	  }
	};

	window.DOMTokenList = DOMTokenList;

	function defineElementGetter (obj, prop, getter) {
	    if (Object.defineProperty) {
	        Object.defineProperty(obj, prop,{
	            get : getter
	        });
	    } else {
	        obj.__defineGetter__(prop, getter);
	    }
	}

	defineElementGetter(Element.prototype, 'classList', function () {
	  return new DOMTokenList(this);
	});

	})();
	;
	if (String.prototype.trim == null) {
	  String.prototype.trim = function() {
	    return this.replace(/^\s+|\s+$/g, '');
	  };
	}


/***/ },
/* 22 */
/***/ function(module, exports) {

	var OpenInBrowserHelper;

	module.exports = OpenInBrowserHelper = (function() {
	  OpenInBrowserHelper.applyTo = function(node, panel) {
	    return new OpenInBrowserHelper(node, panel);
	  };

	  function OpenInBrowserHelper(node1, panel1) {
	    this.node = node1;
	    this.panel = panel1;
	    this.node.addEventListener('click', (function(_this) {
	      return function(e) {
	        var el;
	        el = e.target;
	        if (el.tagName === 'A' && el.classList.contains('browse')) {
	          e.preventDefault();
	          return _this.browse(el.href, _this.panel);
	        }
	      };
	    })(this));
	  }

	  OpenInBrowserHelper.prototype.browse = function(url) {
	    var isWindows, processPath, rootDir;
	    isWindows = window.navigator.platform.toLowerCase().indexOf("win") > -1;
	    rootDir = "/";
	    if (isWindows) {
	      rootDir = this.panel.csi.getSystemPath("commonFiles").substring(0, 3);
	    }
	    processPath = "/usr/bin/open";
	    if (isWindows) {
	      processPath = rootDir + "Windows/explorer.exe";
	    }
	    return window.cep.process.createProcess(processPath, url);
	  };

	  return OpenInBrowserHelper;

	})();


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	var UpdateNotifier, semver,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

	semver = __webpack_require__(24);

	module.exports = UpdateNotifier = (function() {
	  function UpdateNotifier(panel) {
	    this.panel = panel;
	    this._close = bind(this._close, this);
	  }

	  UpdateNotifier.prototype.init = function(options) {
	    this.name = options.name;
	    this.version = options.version;
	    this.hub = options.hub;
	    this.channel = options.channel;
	    this.updateUrl = options.updateUrl;
	    this.request = new XMLHttpRequest;
	    this.request.onreadystatechange = (function(_this) {
	      return function() {
	        if (_this.request.readyState === 4) {
	          return _this._processResult(_this.request.responseText);
	        }
	      };
	    })(this);
	    this.request.open('GET', this.hub, true);
	    return this.request.send(null);
	  };

	  UpdateNotifier.prototype._processResult = function(response) {
	    var json, latestVersionOnChannel;
	    json = JSON.parse(response);
	    if (!((json.channels != null) && (json.channels[this.channel] != null))) {
	      return;
	    }
	    latestVersionOnChannel = json.channels[this.channel];
	    if (semver.gt(latestVersionOnChannel, this.version)) {
	      return this._considerShowingUpdateNotification();
	    }
	  };

	  UpdateNotifier.prototype._considerShowingUpdateNotification = function() {
	    return this._showUpdateNotification();
	  };

	  UpdateNotifier.prototype._showUpdateNotification = function() {
	    this.node = document.createElement('div');
	    this.node.className = "serverNotification visible";
	    document.body.appendChild(this.node);
	    this.linkNode = document.createElement('a');
	    this.linkNode.className = "serverNotification-msg browse";
	    this.linkNode.href = this.updateUrl;
	    this.linkNode.innerHTML = 'New Version Available at ' + this.updateUrl.replace('http://', '');
	    this.node.appendChild(this.linkNode);
	    this.closeNode = document.createElement('button');
	    this.closeNode.className = "serverNotification-discard";
	    this.closeNode.innerHTML = "Remind Me Later";
	    this.node.appendChild(this.closeNode);
	    this.linkNode.addEventListener('click', this._close);
	    return this.closeNode.addEventListener('click', this._close);
	  };

	  UpdateNotifier.prototype._close = function() {
	    return this.node.classList.remove('visible');
	  };

	  return UpdateNotifier;

	})();


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {exports = module.exports = SemVer;

	// The debug function is excluded entirely from the minified version.
	/* nomin */ var debug;
	/* nomin */ if (typeof process === 'object' &&
	    /* nomin */ process.env &&
	    /* nomin */ process.env.NODE_DEBUG &&
	    /* nomin */ /\bsemver\b/i.test(process.env.NODE_DEBUG))
	  /* nomin */ debug = function() {
	    /* nomin */ var args = Array.prototype.slice.call(arguments, 0);
	    /* nomin */ args.unshift('SEMVER');
	    /* nomin */ console.log.apply(console, args);
	    /* nomin */ };
	/* nomin */ else
	  /* nomin */ debug = function() {};

	// Note: this is the semver.org version of the spec that it implements
	// Not necessarily the package version of this code.
	exports.SEMVER_SPEC_VERSION = '2.0.0';

	var MAX_LENGTH = 256;
	var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;

	// The actual regexps go on exports.re
	var re = exports.re = [];
	var src = exports.src = [];
	var R = 0;

	// The following Regular Expressions can be used for tokenizing,
	// validating, and parsing SemVer version strings.

	// ## Numeric Identifier
	// A single `0`, or a non-zero digit followed by zero or more digits.

	var NUMERICIDENTIFIER = R++;
	src[NUMERICIDENTIFIER] = '0|[1-9]\\d*';
	var NUMERICIDENTIFIERLOOSE = R++;
	src[NUMERICIDENTIFIERLOOSE] = '[0-9]+';


	// ## Non-numeric Identifier
	// Zero or more digits, followed by a letter or hyphen, and then zero or
	// more letters, digits, or hyphens.

	var NONNUMERICIDENTIFIER = R++;
	src[NONNUMERICIDENTIFIER] = '\\d*[a-zA-Z-][a-zA-Z0-9-]*';


	// ## Main Version
	// Three dot-separated numeric identifiers.

	var MAINVERSION = R++;
	src[MAINVERSION] = '(' + src[NUMERICIDENTIFIER] + ')\\.' +
	                   '(' + src[NUMERICIDENTIFIER] + ')\\.' +
	                   '(' + src[NUMERICIDENTIFIER] + ')';

	var MAINVERSIONLOOSE = R++;
	src[MAINVERSIONLOOSE] = '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' +
	                        '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' +
	                        '(' + src[NUMERICIDENTIFIERLOOSE] + ')';

	// ## Pre-release Version Identifier
	// A numeric identifier, or a non-numeric identifier.

	var PRERELEASEIDENTIFIER = R++;
	src[PRERELEASEIDENTIFIER] = '(?:' + src[NUMERICIDENTIFIER] +
	                            '|' + src[NONNUMERICIDENTIFIER] + ')';

	var PRERELEASEIDENTIFIERLOOSE = R++;
	src[PRERELEASEIDENTIFIERLOOSE] = '(?:' + src[NUMERICIDENTIFIERLOOSE] +
	                                 '|' + src[NONNUMERICIDENTIFIER] + ')';


	// ## Pre-release Version
	// Hyphen, followed by one or more dot-separated pre-release version
	// identifiers.

	var PRERELEASE = R++;
	src[PRERELEASE] = '(?:-(' + src[PRERELEASEIDENTIFIER] +
	                  '(?:\\.' + src[PRERELEASEIDENTIFIER] + ')*))';

	var PRERELEASELOOSE = R++;
	src[PRERELEASELOOSE] = '(?:-?(' + src[PRERELEASEIDENTIFIERLOOSE] +
	                       '(?:\\.' + src[PRERELEASEIDENTIFIERLOOSE] + ')*))';

	// ## Build Metadata Identifier
	// Any combination of digits, letters, or hyphens.

	var BUILDIDENTIFIER = R++;
	src[BUILDIDENTIFIER] = '[0-9A-Za-z-]+';

	// ## Build Metadata
	// Plus sign, followed by one or more period-separated build metadata
	// identifiers.

	var BUILD = R++;
	src[BUILD] = '(?:\\+(' + src[BUILDIDENTIFIER] +
	             '(?:\\.' + src[BUILDIDENTIFIER] + ')*))';


	// ## Full Version String
	// A main version, followed optionally by a pre-release version and
	// build metadata.

	// Note that the only major, minor, patch, and pre-release sections of
	// the version string are capturing groups.  The build metadata is not a
	// capturing group, because it should not ever be used in version
	// comparison.

	var FULL = R++;
	var FULLPLAIN = 'v?' + src[MAINVERSION] +
	                src[PRERELEASE] + '?' +
	                src[BUILD] + '?';

	src[FULL] = '^' + FULLPLAIN + '$';

	// like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
	// also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
	// common in the npm registry.
	var LOOSEPLAIN = '[v=\\s]*' + src[MAINVERSIONLOOSE] +
	                 src[PRERELEASELOOSE] + '?' +
	                 src[BUILD] + '?';

	var LOOSE = R++;
	src[LOOSE] = '^' + LOOSEPLAIN + '$';

	var GTLT = R++;
	src[GTLT] = '((?:<|>)?=?)';

	// Something like "2.*" or "1.2.x".
	// Note that "x.x" is a valid xRange identifer, meaning "any version"
	// Only the first item is strictly required.
	var XRANGEIDENTIFIERLOOSE = R++;
	src[XRANGEIDENTIFIERLOOSE] = src[NUMERICIDENTIFIERLOOSE] + '|x|X|\\*';
	var XRANGEIDENTIFIER = R++;
	src[XRANGEIDENTIFIER] = src[NUMERICIDENTIFIER] + '|x|X|\\*';

	var XRANGEPLAIN = R++;
	src[XRANGEPLAIN] = '[v=\\s]*(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:' + src[PRERELEASE] + ')?' +
	                   src[BUILD] + '?' +
	                   ')?)?';

	var XRANGEPLAINLOOSE = R++;
	src[XRANGEPLAINLOOSE] = '[v=\\s]*(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:' + src[PRERELEASELOOSE] + ')?' +
	                        src[BUILD] + '?' +
	                        ')?)?';

	var XRANGE = R++;
	src[XRANGE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAIN] + '$';
	var XRANGELOOSE = R++;
	src[XRANGELOOSE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAINLOOSE] + '$';

	// Tilde ranges.
	// Meaning is "reasonably at or greater than"
	var LONETILDE = R++;
	src[LONETILDE] = '(?:~>?)';

	var TILDETRIM = R++;
	src[TILDETRIM] = '(\\s*)' + src[LONETILDE] + '\\s+';
	re[TILDETRIM] = new RegExp(src[TILDETRIM], 'g');
	var tildeTrimReplace = '$1~';

	var TILDE = R++;
	src[TILDE] = '^' + src[LONETILDE] + src[XRANGEPLAIN] + '$';
	var TILDELOOSE = R++;
	src[TILDELOOSE] = '^' + src[LONETILDE] + src[XRANGEPLAINLOOSE] + '$';

	// Caret ranges.
	// Meaning is "at least and backwards compatible with"
	var LONECARET = R++;
	src[LONECARET] = '(?:\\^)';

	var CARETTRIM = R++;
	src[CARETTRIM] = '(\\s*)' + src[LONECARET] + '\\s+';
	re[CARETTRIM] = new RegExp(src[CARETTRIM], 'g');
	var caretTrimReplace = '$1^';

	var CARET = R++;
	src[CARET] = '^' + src[LONECARET] + src[XRANGEPLAIN] + '$';
	var CARETLOOSE = R++;
	src[CARETLOOSE] = '^' + src[LONECARET] + src[XRANGEPLAINLOOSE] + '$';

	// A simple gt/lt/eq thing, or just "" to indicate "any version"
	var COMPARATORLOOSE = R++;
	src[COMPARATORLOOSE] = '^' + src[GTLT] + '\\s*(' + LOOSEPLAIN + ')$|^$';
	var COMPARATOR = R++;
	src[COMPARATOR] = '^' + src[GTLT] + '\\s*(' + FULLPLAIN + ')$|^$';


	// An expression to strip any whitespace between the gtlt and the thing
	// it modifies, so that `> 1.2.3` ==> `>1.2.3`
	var COMPARATORTRIM = R++;
	src[COMPARATORTRIM] = '(\\s*)' + src[GTLT] +
	                      '\\s*(' + LOOSEPLAIN + '|' + src[XRANGEPLAIN] + ')';

	// this one has to use the /g flag
	re[COMPARATORTRIM] = new RegExp(src[COMPARATORTRIM], 'g');
	var comparatorTrimReplace = '$1$2$3';


	// Something like `1.2.3 - 1.2.4`
	// Note that these all use the loose form, because they'll be
	// checked against either the strict or loose comparator form
	// later.
	var HYPHENRANGE = R++;
	src[HYPHENRANGE] = '^\\s*(' + src[XRANGEPLAIN] + ')' +
	                   '\\s+-\\s+' +
	                   '(' + src[XRANGEPLAIN] + ')' +
	                   '\\s*$';

	var HYPHENRANGELOOSE = R++;
	src[HYPHENRANGELOOSE] = '^\\s*(' + src[XRANGEPLAINLOOSE] + ')' +
	                        '\\s+-\\s+' +
	                        '(' + src[XRANGEPLAINLOOSE] + ')' +
	                        '\\s*$';

	// Star ranges basically just allow anything at all.
	var STAR = R++;
	src[STAR] = '(<|>)?=?\\s*\\*';

	// Compile to actual regexp objects.
	// All are flag-free, unless they were created above with a flag.
	for (var i = 0; i < R; i++) {
	  debug(i, src[i]);
	  if (!re[i])
	    re[i] = new RegExp(src[i]);
	}

	exports.parse = parse;
	function parse(version, loose) {
	  if (version instanceof SemVer)
	    return version;

	  if (typeof version !== 'string')
	    return null;

	  if (version.length > MAX_LENGTH)
	    return null;

	  var r = loose ? re[LOOSE] : re[FULL];
	  if (!r.test(version))
	    return null;

	  try {
	    return new SemVer(version, loose);
	  } catch (er) {
	    return null;
	  }
	}

	exports.valid = valid;
	function valid(version, loose) {
	  var v = parse(version, loose);
	  return v ? v.version : null;
	}


	exports.clean = clean;
	function clean(version, loose) {
	  var s = parse(version.trim().replace(/^[=v]+/, ''), loose);
	  return s ? s.version : null;
	}

	exports.SemVer = SemVer;

	function SemVer(version, loose) {
	  if (version instanceof SemVer) {
	    if (version.loose === loose)
	      return version;
	    else
	      version = version.version;
	  } else if (typeof version !== 'string') {
	    throw new TypeError('Invalid Version: ' + version);
	  }

	  if (version.length > MAX_LENGTH)
	    throw new TypeError('version is longer than ' + MAX_LENGTH + ' characters')

	  if (!(this instanceof SemVer))
	    return new SemVer(version, loose);

	  debug('SemVer', version, loose);
	  this.loose = loose;
	  var m = version.trim().match(loose ? re[LOOSE] : re[FULL]);

	  if (!m)
	    throw new TypeError('Invalid Version: ' + version);

	  this.raw = version;

	  // these are actually numbers
	  this.major = +m[1];
	  this.minor = +m[2];
	  this.patch = +m[3];

	  if (this.major > MAX_SAFE_INTEGER || this.major < 0)
	    throw new TypeError('Invalid major version')

	  if (this.minor > MAX_SAFE_INTEGER || this.minor < 0)
	    throw new TypeError('Invalid minor version')

	  if (this.patch > MAX_SAFE_INTEGER || this.patch < 0)
	    throw new TypeError('Invalid patch version')

	  // numberify any prerelease numeric ids
	  if (!m[4])
	    this.prerelease = [];
	  else
	    this.prerelease = m[4].split('.').map(function(id) {
	      if (/^[0-9]+$/.test(id)) {
	        var num = +id
	        if (num >= 0 && num < MAX_SAFE_INTEGER)
	          return num
	      }
	      return id;
	    });

	  this.build = m[5] ? m[5].split('.') : [];
	  this.format();
	}

	SemVer.prototype.format = function() {
	  this.version = this.major + '.' + this.minor + '.' + this.patch;
	  if (this.prerelease.length)
	    this.version += '-' + this.prerelease.join('.');
	  return this.version;
	};

	SemVer.prototype.toString = function() {
	  return this.version;
	};

	SemVer.prototype.compare = function(other) {
	  debug('SemVer.compare', this.version, this.loose, other);
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);

	  return this.compareMain(other) || this.comparePre(other);
	};

	SemVer.prototype.compareMain = function(other) {
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);

	  return compareIdentifiers(this.major, other.major) ||
	         compareIdentifiers(this.minor, other.minor) ||
	         compareIdentifiers(this.patch, other.patch);
	};

	SemVer.prototype.comparePre = function(other) {
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);

	  // NOT having a prerelease is > having one
	  if (this.prerelease.length && !other.prerelease.length)
	    return -1;
	  else if (!this.prerelease.length && other.prerelease.length)
	    return 1;
	  else if (!this.prerelease.length && !other.prerelease.length)
	    return 0;

	  var i = 0;
	  do {
	    var a = this.prerelease[i];
	    var b = other.prerelease[i];
	    debug('prerelease compare', i, a, b);
	    if (a === undefined && b === undefined)
	      return 0;
	    else if (b === undefined)
	      return 1;
	    else if (a === undefined)
	      return -1;
	    else if (a === b)
	      continue;
	    else
	      return compareIdentifiers(a, b);
	  } while (++i);
	};

	// preminor will bump the version up to the next minor release, and immediately
	// down to pre-release. premajor and prepatch work the same way.
	SemVer.prototype.inc = function(release, identifier) {
	  switch (release) {
	    case 'premajor':
	      this.prerelease.length = 0;
	      this.patch = 0;
	      this.minor = 0;
	      this.major++;
	      this.inc('pre', identifier);
	      break;
	    case 'preminor':
	      this.prerelease.length = 0;
	      this.patch = 0;
	      this.minor++;
	      this.inc('pre', identifier);
	      break;
	    case 'prepatch':
	      // If this is already a prerelease, it will bump to the next version
	      // drop any prereleases that might already exist, since they are not
	      // relevant at this point.
	      this.prerelease.length = 0;
	      this.inc('patch', identifier);
	      this.inc('pre', identifier);
	      break;
	    // If the input is a non-prerelease version, this acts the same as
	    // prepatch.
	    case 'prerelease':
	      if (this.prerelease.length === 0)
	        this.inc('patch', identifier);
	      this.inc('pre', identifier);
	      break;

	    case 'major':
	      // If this is a pre-major version, bump up to the same major version.
	      // Otherwise increment major.
	      // 1.0.0-5 bumps to 1.0.0
	      // 1.1.0 bumps to 2.0.0
	      if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0)
	        this.major++;
	      this.minor = 0;
	      this.patch = 0;
	      this.prerelease = [];
	      break;
	    case 'minor':
	      // If this is a pre-minor version, bump up to the same minor version.
	      // Otherwise increment minor.
	      // 1.2.0-5 bumps to 1.2.0
	      // 1.2.1 bumps to 1.3.0
	      if (this.patch !== 0 || this.prerelease.length === 0)
	        this.minor++;
	      this.patch = 0;
	      this.prerelease = [];
	      break;
	    case 'patch':
	      // If this is not a pre-release version, it will increment the patch.
	      // If it is a pre-release it will bump up to the same patch version.
	      // 1.2.0-5 patches to 1.2.0
	      // 1.2.0 patches to 1.2.1
	      if (this.prerelease.length === 0)
	        this.patch++;
	      this.prerelease = [];
	      break;
	    // This probably shouldn't be used publicly.
	    // 1.0.0 "pre" would become 1.0.0-0 which is the wrong direction.
	    case 'pre':
	      if (this.prerelease.length === 0)
	        this.prerelease = [0];
	      else {
	        var i = this.prerelease.length;
	        while (--i >= 0) {
	          if (typeof this.prerelease[i] === 'number') {
	            this.prerelease[i]++;
	            i = -2;
	          }
	        }
	        if (i === -1) // didn't increment anything
	          this.prerelease.push(0);
	      }
	      if (identifier) {
	        // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
	        // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
	        if (this.prerelease[0] === identifier) {
	          if (isNaN(this.prerelease[1]))
	            this.prerelease = [identifier, 0];
	        } else
	          this.prerelease = [identifier, 0];
	      }
	      break;

	    default:
	      throw new Error('invalid increment argument: ' + release);
	  }
	  this.format();
	  this.raw = this.version;
	  return this;
	};

	exports.inc = inc;
	function inc(version, release, loose, identifier) {
	  if (typeof(loose) === 'string') {
	    identifier = loose;
	    loose = undefined;
	  }

	  try {
	    return new SemVer(version, loose).inc(release, identifier).version;
	  } catch (er) {
	    return null;
	  }
	}

	exports.diff = diff;
	function diff(version1, version2) {
	  if (eq(version1, version2)) {
	    return null;
	  } else {
	    var v1 = parse(version1);
	    var v2 = parse(version2);
	    if (v1.prerelease.length || v2.prerelease.length) {
	      for (var key in v1) {
	        if (key === 'major' || key === 'minor' || key === 'patch') {
	          if (v1[key] !== v2[key]) {
	            return 'pre'+key;
	          }
	        }
	      }
	      return 'prerelease';
	    }
	    for (var key in v1) {
	      if (key === 'major' || key === 'minor' || key === 'patch') {
	        if (v1[key] !== v2[key]) {
	          return key;
	        }
	      }
	    }
	  }
	}

	exports.compareIdentifiers = compareIdentifiers;

	var numeric = /^[0-9]+$/;
	function compareIdentifiers(a, b) {
	  var anum = numeric.test(a);
	  var bnum = numeric.test(b);

	  if (anum && bnum) {
	    a = +a;
	    b = +b;
	  }

	  return (anum && !bnum) ? -1 :
	         (bnum && !anum) ? 1 :
	         a < b ? -1 :
	         a > b ? 1 :
	         0;
	}

	exports.rcompareIdentifiers = rcompareIdentifiers;
	function rcompareIdentifiers(a, b) {
	  return compareIdentifiers(b, a);
	}

	exports.major = major;
	function major(a, loose) {
	  return new SemVer(a, loose).major;
	}

	exports.minor = minor;
	function minor(a, loose) {
	  return new SemVer(a, loose).minor;
	}

	exports.patch = patch;
	function patch(a, loose) {
	  return new SemVer(a, loose).patch;
	}

	exports.compare = compare;
	function compare(a, b, loose) {
	  return new SemVer(a, loose).compare(b);
	}

	exports.compareLoose = compareLoose;
	function compareLoose(a, b) {
	  return compare(a, b, true);
	}

	exports.rcompare = rcompare;
	function rcompare(a, b, loose) {
	  return compare(b, a, loose);
	}

	exports.sort = sort;
	function sort(list, loose) {
	  return list.sort(function(a, b) {
	    return exports.compare(a, b, loose);
	  });
	}

	exports.rsort = rsort;
	function rsort(list, loose) {
	  return list.sort(function(a, b) {
	    return exports.rcompare(a, b, loose);
	  });
	}

	exports.gt = gt;
	function gt(a, b, loose) {
	  return compare(a, b, loose) > 0;
	}

	exports.lt = lt;
	function lt(a, b, loose) {
	  return compare(a, b, loose) < 0;
	}

	exports.eq = eq;
	function eq(a, b, loose) {
	  return compare(a, b, loose) === 0;
	}

	exports.neq = neq;
	function neq(a, b, loose) {
	  return compare(a, b, loose) !== 0;
	}

	exports.gte = gte;
	function gte(a, b, loose) {
	  return compare(a, b, loose) >= 0;
	}

	exports.lte = lte;
	function lte(a, b, loose) {
	  return compare(a, b, loose) <= 0;
	}

	exports.cmp = cmp;
	function cmp(a, op, b, loose) {
	  var ret;
	  switch (op) {
	    case '===':
	      if (typeof a === 'object') a = a.version;
	      if (typeof b === 'object') b = b.version;
	      ret = a === b;
	      break;
	    case '!==':
	      if (typeof a === 'object') a = a.version;
	      if (typeof b === 'object') b = b.version;
	      ret = a !== b;
	      break;
	    case '': case '=': case '==': ret = eq(a, b, loose); break;
	    case '!=': ret = neq(a, b, loose); break;
	    case '>': ret = gt(a, b, loose); break;
	    case '>=': ret = gte(a, b, loose); break;
	    case '<': ret = lt(a, b, loose); break;
	    case '<=': ret = lte(a, b, loose); break;
	    default: throw new TypeError('Invalid operator: ' + op);
	  }
	  return ret;
	}

	exports.Comparator = Comparator;
	function Comparator(comp, loose) {
	  if (comp instanceof Comparator) {
	    if (comp.loose === loose)
	      return comp;
	    else
	      comp = comp.value;
	  }

	  if (!(this instanceof Comparator))
	    return new Comparator(comp, loose);

	  debug('comparator', comp, loose);
	  this.loose = loose;
	  this.parse(comp);

	  if (this.semver === ANY)
	    this.value = '';
	  else
	    this.value = this.operator + this.semver.version;

	  debug('comp', this);
	}

	var ANY = {};
	Comparator.prototype.parse = function(comp) {
	  var r = this.loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
	  var m = comp.match(r);

	  if (!m)
	    throw new TypeError('Invalid comparator: ' + comp);

	  this.operator = m[1];
	  if (this.operator === '=')
	    this.operator = '';

	  // if it literally is just '>' or '' then allow anything.
	  if (!m[2])
	    this.semver = ANY;
	  else
	    this.semver = new SemVer(m[2], this.loose);
	};

	Comparator.prototype.toString = function() {
	  return this.value;
	};

	Comparator.prototype.test = function(version) {
	  debug('Comparator.test', version, this.loose);

	  if (this.semver === ANY)
	    return true;

	  if (typeof version === 'string')
	    version = new SemVer(version, this.loose);

	  return cmp(version, this.operator, this.semver, this.loose);
	};


	exports.Range = Range;
	function Range(range, loose) {
	  if ((range instanceof Range) && range.loose === loose)
	    return range;

	  if (!(this instanceof Range))
	    return new Range(range, loose);

	  this.loose = loose;

	  // First, split based on boolean or ||
	  this.raw = range;
	  this.set = range.split(/\s*\|\|\s*/).map(function(range) {
	    return this.parseRange(range.trim());
	  }, this).filter(function(c) {
	    // throw out any that are not relevant for whatever reason
	    return c.length;
	  });

	  if (!this.set.length) {
	    throw new TypeError('Invalid SemVer Range: ' + range);
	  }

	  this.format();
	}

	Range.prototype.format = function() {
	  this.range = this.set.map(function(comps) {
	    return comps.join(' ').trim();
	  }).join('||').trim();
	  return this.range;
	};

	Range.prototype.toString = function() {
	  return this.range;
	};

	Range.prototype.parseRange = function(range) {
	  var loose = this.loose;
	  range = range.trim();
	  debug('range', range, loose);
	  // `1.2.3 - 1.2.4` => `>=1.2.3 <=1.2.4`
	  var hr = loose ? re[HYPHENRANGELOOSE] : re[HYPHENRANGE];
	  range = range.replace(hr, hyphenReplace);
	  debug('hyphen replace', range);
	  // `> 1.2.3 < 1.2.5` => `>1.2.3 <1.2.5`
	  range = range.replace(re[COMPARATORTRIM], comparatorTrimReplace);
	  debug('comparator trim', range, re[COMPARATORTRIM]);

	  // `~ 1.2.3` => `~1.2.3`
	  range = range.replace(re[TILDETRIM], tildeTrimReplace);

	  // `^ 1.2.3` => `^1.2.3`
	  range = range.replace(re[CARETTRIM], caretTrimReplace);

	  // normalize spaces
	  range = range.split(/\s+/).join(' ');

	  // At this point, the range is completely trimmed and
	  // ready to be split into comparators.

	  var compRe = loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
	  var set = range.split(' ').map(function(comp) {
	    return parseComparator(comp, loose);
	  }).join(' ').split(/\s+/);
	  if (this.loose) {
	    // in loose mode, throw out any that are not valid comparators
	    set = set.filter(function(comp) {
	      return !!comp.match(compRe);
	    });
	  }
	  set = set.map(function(comp) {
	    return new Comparator(comp, loose);
	  });

	  return set;
	};

	// Mostly just for testing and legacy API reasons
	exports.toComparators = toComparators;
	function toComparators(range, loose) {
	  return new Range(range, loose).set.map(function(comp) {
	    return comp.map(function(c) {
	      return c.value;
	    }).join(' ').trim().split(' ');
	  });
	}

	// comprised of xranges, tildes, stars, and gtlt's at this point.
	// already replaced the hyphen ranges
	// turn into a set of JUST comparators.
	function parseComparator(comp, loose) {
	  debug('comp', comp);
	  comp = replaceCarets(comp, loose);
	  debug('caret', comp);
	  comp = replaceTildes(comp, loose);
	  debug('tildes', comp);
	  comp = replaceXRanges(comp, loose);
	  debug('xrange', comp);
	  comp = replaceStars(comp, loose);
	  debug('stars', comp);
	  return comp;
	}

	function isX(id) {
	  return !id || id.toLowerCase() === 'x' || id === '*';
	}

	// ~, ~> --> * (any, kinda silly)
	// ~2, ~2.x, ~2.x.x, ~>2, ~>2.x ~>2.x.x --> >=2.0.0 <3.0.0
	// ~2.0, ~2.0.x, ~>2.0, ~>2.0.x --> >=2.0.0 <2.1.0
	// ~1.2, ~1.2.x, ~>1.2, ~>1.2.x --> >=1.2.0 <1.3.0
	// ~1.2.3, ~>1.2.3 --> >=1.2.3 <1.3.0
	// ~1.2.0, ~>1.2.0 --> >=1.2.0 <1.3.0
	function replaceTildes(comp, loose) {
	  return comp.trim().split(/\s+/).map(function(comp) {
	    return replaceTilde(comp, loose);
	  }).join(' ');
	}

	function replaceTilde(comp, loose) {
	  var r = loose ? re[TILDELOOSE] : re[TILDE];
	  return comp.replace(r, function(_, M, m, p, pr) {
	    debug('tilde', comp, _, M, m, p, pr);
	    var ret;

	    if (isX(M))
	      ret = '';
	    else if (isX(m))
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    else if (isX(p))
	      // ~1.2 == >=1.2.0- <1.3.0-
	      ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	    else if (pr) {
	      debug('replaceTilde pr', pr);
	      if (pr.charAt(0) !== '-')
	        pr = '-' + pr;
	      ret = '>=' + M + '.' + m + '.' + p + pr +
	            ' <' + M + '.' + (+m + 1) + '.0';
	    } else
	      // ~1.2.3 == >=1.2.3 <1.3.0
	      ret = '>=' + M + '.' + m + '.' + p +
	            ' <' + M + '.' + (+m + 1) + '.0';

	    debug('tilde return', ret);
	    return ret;
	  });
	}

	// ^ --> * (any, kinda silly)
	// ^2, ^2.x, ^2.x.x --> >=2.0.0 <3.0.0
	// ^2.0, ^2.0.x --> >=2.0.0 <3.0.0
	// ^1.2, ^1.2.x --> >=1.2.0 <2.0.0
	// ^1.2.3 --> >=1.2.3 <2.0.0
	// ^1.2.0 --> >=1.2.0 <2.0.0
	function replaceCarets(comp, loose) {
	  return comp.trim().split(/\s+/).map(function(comp) {
	    return replaceCaret(comp, loose);
	  }).join(' ');
	}

	function replaceCaret(comp, loose) {
	  debug('caret', comp, loose);
	  var r = loose ? re[CARETLOOSE] : re[CARET];
	  return comp.replace(r, function(_, M, m, p, pr) {
	    debug('caret', comp, _, M, m, p, pr);
	    var ret;

	    if (isX(M))
	      ret = '';
	    else if (isX(m))
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    else if (isX(p)) {
	      if (M === '0')
	        ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	      else
	        ret = '>=' + M + '.' + m + '.0 <' + (+M + 1) + '.0.0';
	    } else if (pr) {
	      debug('replaceCaret pr', pr);
	      if (pr.charAt(0) !== '-')
	        pr = '-' + pr;
	      if (M === '0') {
	        if (m === '0')
	          ret = '>=' + M + '.' + m + '.' + p + pr +
	                ' <' + M + '.' + m + '.' + (+p + 1);
	        else
	          ret = '>=' + M + '.' + m + '.' + p + pr +
	                ' <' + M + '.' + (+m + 1) + '.0';
	      } else
	        ret = '>=' + M + '.' + m + '.' + p + pr +
	              ' <' + (+M + 1) + '.0.0';
	    } else {
	      debug('no pr');
	      if (M === '0') {
	        if (m === '0')
	          ret = '>=' + M + '.' + m + '.' + p +
	                ' <' + M + '.' + m + '.' + (+p + 1);
	        else
	          ret = '>=' + M + '.' + m + '.' + p +
	                ' <' + M + '.' + (+m + 1) + '.0';
	      } else
	        ret = '>=' + M + '.' + m + '.' + p +
	              ' <' + (+M + 1) + '.0.0';
	    }

	    debug('caret return', ret);
	    return ret;
	  });
	}

	function replaceXRanges(comp, loose) {
	  debug('replaceXRanges', comp, loose);
	  return comp.split(/\s+/).map(function(comp) {
	    return replaceXRange(comp, loose);
	  }).join(' ');
	}

	function replaceXRange(comp, loose) {
	  comp = comp.trim();
	  var r = loose ? re[XRANGELOOSE] : re[XRANGE];
	  return comp.replace(r, function(ret, gtlt, M, m, p, pr) {
	    debug('xRange', comp, ret, gtlt, M, m, p, pr);
	    var xM = isX(M);
	    var xm = xM || isX(m);
	    var xp = xm || isX(p);
	    var anyX = xp;

	    if (gtlt === '=' && anyX)
	      gtlt = '';

	    if (xM) {
	      if (gtlt === '>' || gtlt === '<') {
	        // nothing is allowed
	        ret = '<0.0.0';
	      } else {
	        // nothing is forbidden
	        ret = '*';
	      }
	    } else if (gtlt && anyX) {
	      // replace X with 0
	      if (xm)
	        m = 0;
	      if (xp)
	        p = 0;

	      if (gtlt === '>') {
	        // >1 => >=2.0.0
	        // >1.2 => >=1.3.0
	        // >1.2.3 => >= 1.2.4
	        gtlt = '>=';
	        if (xm) {
	          M = +M + 1;
	          m = 0;
	          p = 0;
	        } else if (xp) {
	          m = +m + 1;
	          p = 0;
	        }
	      } else if (gtlt === '<=') {
	        // <=0.7.x is actually <0.8.0, since any 0.7.x should
	        // pass.  Similarly, <=7.x is actually <8.0.0, etc.
	        gtlt = '<'
	        if (xm)
	          M = +M + 1
	        else
	          m = +m + 1
	      }

	      ret = gtlt + M + '.' + m + '.' + p;
	    } else if (xm) {
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    } else if (xp) {
	      ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	    }

	    debug('xRange return', ret);

	    return ret;
	  });
	}

	// Because * is AND-ed with everything else in the comparator,
	// and '' means "any version", just remove the *s entirely.
	function replaceStars(comp, loose) {
	  debug('replaceStars', comp, loose);
	  // Looseness is ignored here.  star is always as loose as it gets!
	  return comp.trim().replace(re[STAR], '');
	}

	// This function is passed to string.replace(re[HYPHENRANGE])
	// M, m, patch, prerelease, build
	// 1.2 - 3.4.5 => >=1.2.0 <=3.4.5
	// 1.2.3 - 3.4 => >=1.2.0 <3.5.0 Any 3.4.x will do
	// 1.2 - 3.4 => >=1.2.0 <3.5.0
	function hyphenReplace($0,
	                       from, fM, fm, fp, fpr, fb,
	                       to, tM, tm, tp, tpr, tb) {

	  if (isX(fM))
	    from = '';
	  else if (isX(fm))
	    from = '>=' + fM + '.0.0';
	  else if (isX(fp))
	    from = '>=' + fM + '.' + fm + '.0';
	  else
	    from = '>=' + from;

	  if (isX(tM))
	    to = '';
	  else if (isX(tm))
	    to = '<' + (+tM + 1) + '.0.0';
	  else if (isX(tp))
	    to = '<' + tM + '.' + (+tm + 1) + '.0';
	  else if (tpr)
	    to = '<=' + tM + '.' + tm + '.' + tp + '-' + tpr;
	  else
	    to = '<=' + to;

	  return (from + ' ' + to).trim();
	}


	// if ANY of the sets match ALL of its comparators, then pass
	Range.prototype.test = function(version) {
	  if (!version)
	    return false;

	  if (typeof version === 'string')
	    version = new SemVer(version, this.loose);

	  for (var i = 0; i < this.set.length; i++) {
	    if (testSet(this.set[i], version))
	      return true;
	  }
	  return false;
	};

	function testSet(set, version) {
	  for (var i = 0; i < set.length; i++) {
	    if (!set[i].test(version))
	      return false;
	  }

	  if (version.prerelease.length) {
	    // Find the set of versions that are allowed to have prereleases
	    // For example, ^1.2.3-pr.1 desugars to >=1.2.3-pr.1 <2.0.0
	    // That should allow `1.2.3-pr.2` to pass.
	    // However, `1.2.4-alpha.notready` should NOT be allowed,
	    // even though it's within the range set by the comparators.
	    for (var i = 0; i < set.length; i++) {
	      debug(set[i].semver);
	      if (set[i].semver === ANY)
	        continue;

	      if (set[i].semver.prerelease.length > 0) {
	        var allowed = set[i].semver;
	        if (allowed.major === version.major &&
	            allowed.minor === version.minor &&
	            allowed.patch === version.patch)
	          return true;
	      }
	    }

	    // Version has a -pre, but it's not one of the ones we like.
	    return false;
	  }

	  return true;
	}

	exports.satisfies = satisfies;
	function satisfies(version, range, loose) {
	  try {
	    range = new Range(range, loose);
	  } catch (er) {
	    return false;
	  }
	  return range.test(version);
	}

	exports.maxSatisfying = maxSatisfying;
	function maxSatisfying(versions, range, loose) {
	  return versions.filter(function(version) {
	    return satisfies(version, range, loose);
	  }).sort(function(a, b) {
	    return rcompare(a, b, loose);
	  })[0] || null;
	}

	exports.validRange = validRange;
	function validRange(range, loose) {
	  try {
	    // Return '*' instead of '' so that truthiness works.
	    // This will throw if it's invalid anyway
	    return new Range(range, loose).range || '*';
	  } catch (er) {
	    return null;
	  }
	}

	// Determine if version is less than all the versions possible in the range
	exports.ltr = ltr;
	function ltr(version, range, loose) {
	  return outside(version, range, '<', loose);
	}

	// Determine if version is greater than all the versions possible in the range.
	exports.gtr = gtr;
	function gtr(version, range, loose) {
	  return outside(version, range, '>', loose);
	}

	exports.outside = outside;
	function outside(version, range, hilo, loose) {
	  version = new SemVer(version, loose);
	  range = new Range(range, loose);

	  var gtfn, ltefn, ltfn, comp, ecomp;
	  switch (hilo) {
	    case '>':
	      gtfn = gt;
	      ltefn = lte;
	      ltfn = lt;
	      comp = '>';
	      ecomp = '>=';
	      break;
	    case '<':
	      gtfn = lt;
	      ltefn = gte;
	      ltfn = gt;
	      comp = '<';
	      ecomp = '<=';
	      break;
	    default:
	      throw new TypeError('Must provide a hilo val of "<" or ">"');
	  }

	  // If it satisifes the range it is not outside
	  if (satisfies(version, range, loose)) {
	    return false;
	  }

	  // From now on, variable terms are as if we're in "gtr" mode.
	  // but note that everything is flipped for the "ltr" function.

	  for (var i = 0; i < range.set.length; ++i) {
	    var comparators = range.set[i];

	    var high = null;
	    var low = null;

	    comparators.forEach(function(comparator) {
	      if (comparator.semver === ANY) {
	        comparator = new Comparator('>=0.0.0')
	      }
	      high = high || comparator;
	      low = low || comparator;
	      if (gtfn(comparator.semver, high.semver, loose)) {
	        high = comparator;
	      } else if (ltfn(comparator.semver, low.semver, loose)) {
	        low = comparator;
	      }
	    });

	    // If the edge version comparator has a operator then our version
	    // isn't outside it
	    if (high.operator === comp || high.operator === ecomp) {
	      return false;
	    }

	    // If the lowest version comparator has an operator and our version
	    // is less than it then it isn't higher than the range
	    if ((!low.operator || low.operator === comp) &&
	        ltefn(version, low.semver)) {
	      return false;
	    } else if (low.operator === ecomp && ltfn(version, low.semver)) {
	      return false;
	    }
	  }
	  return true;
	}

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(25)))

/***/ },
/* 25 */
/***/ function(module, exports) {

	// shim for using process in browser

	var process = module.exports = {};
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = setTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    clearTimeout(timeout);
	}

	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        setTimeout(drainQueue, 0);
	    }
	};

	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};

	function noop() {}

	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;

	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};

	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ },
/* 26 */
/***/ function(module, exports) {

	var ThemeHandler,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

	module.exports = ThemeHandler = (function() {
	  function ThemeHandler(panel) {
	    this.panel = panel;
	    this._themeChangeListenerCS = bind(this._themeChangeListenerCS, this);
	    this._themeChangeListenerCC = bind(this._themeChangeListenerCC, this);
	    this.current = 'light1';
	    this._changeTheme('dark1', 'Tahoma', '10');
	    if (window.CC) {
	      this.panel.csi.addEventListener(this.panel.csi.constructor.THEME_COLOR_CHANGED_EVENT, this._themeChangeListenerCC);
	      this._themeChangeListenerCC();
	    } else {
	      window.addEventListener('ThemeChangedEvent', this._themeChangeListenerCS);
	    }
	  }

	  ThemeHandler.prototype._themeChangeListenerCC = function() {
	    var color, skin, theme;
	    skin = this.panel.csi.hostEnvironment.appSkinInfo;
	    color = skin.panelBackgroundColor.color;
	    theme = color.red > 200 ? 'light2' : color.red > 120 ? 'light1' : color.red > 75 ? 'dark2' : 'dark1';
	    return this._changeTheme(theme, skin.baseFontFamily, skin.baseFontSize);
	  };

	  ThemeHandler.prototype._themeChangeListenerCS = function(e) {
	    var bgColor, skin, theme;
	    bgColor = e.appSkinInfo.panelBackgroundColor;
	    theme = (function() {
	      switch (bgColor) {
	        case '343434':
	          return 'dark1';
	        case 'b8b8b8':
	          return 'light1';
	        case 'd6d6d6':
	          return 'light2';
	        default:
	          return 'dark2';
	      }
	    })();
	    skin = e.appSkinInfo;
	    return this._changeTheme(theme, skin.baseFontFamily, skin.baseFontSize);
	  };

	  ThemeHandler.prototype._changeTheme = function(theme, fontFamily, fontSize) {
	    var body, html, i, j, len, len1, ref, ref1, s, size, t;
	    html = document.querySelector('html');
	    body = document.body;
	    body.style.fontFamily = fontFamily;
	    body.style.fontSize = fontSize + 'px';
	    ref = ['light1', 'light2', 'dark1', 'dark2', 'light', 'dark'];
	    for (i = 0, len = ref.length; i < len; i++) {
	      t = ref[i];
	      html.classList.remove(t);
	    }
	    html.classList.add(theme);
	    if (theme === 'light1' || theme === 'light2') {
	      html.classList.add('light');
	    } else {
	      html.classList.add('dark');
	    }
	    this.current = theme;
	    size = fontSize <= 10 ? 'small' : fontSize < 12 ? 'medium' : 'large';
	    ref1 = ['small', 'medium', 'big'];
	    for (j = 0, len1 = ref1.length; j < len1; j++) {
	      s = ref1[j];
	      html.classList.remove("size-" + s);
	    }
	    return html.classList.add("size-" + size);
	  };

	  ThemeHandler.prototype.isLight = function() {
	    var ref;
	    return (ref = this.current) === 'light1' || ref === 'light2';
	  };

	  return ThemeHandler;

	})();


/***/ },
/* 27 */
/***/ function(module, exports) {

	
	/*
	ADOBE SYSTEMS INCORPORATED
	Copyright 2013 Adobe Systems Incorporated. All Rights Reserved.

	NOTICE:  Adobe permits you to use, modify, and distribute this file in
	accordance with the terms of the Adobe license agreement accompanying it.
	If you have received this file from a source other than Adobe, then your
	use, modification, or distribution of it requires the prior written
	permission of Adobe.
	*/

	/**
	 * Stores constants for the window types supported by the CSXS infrastructure.
	 */
	function CSXSWindowType()
	{
	};

	/** Constant for the CSXS window type Panel. **/
	CSXSWindowType._PANEL = "Panel";

	/** Constant for the CSXS window type Modeless. **/
	CSXSWindowType._MODELESS = "Modeless";

	/** Constant for the CSXS window type ModalDialog. **/
	CSXSWindowType._MODAL_DIALOG = "ModalDialog";

	/** EvalScript error message**/
	EvalScript_ErrMessage = "EvalScript error.";

	/**
	 * Class Version
	 * Defines a version number with major, minor, micro, and special
	 * components. The major, minor and micro values are numeric; the special
	 * value can be any string.
	 *
	 * @param major   The major version component, a positive integer up to nine digits long.
	 * @param minor   The minor version component, a positive integer up to nine digits long.
	 * @param micro   The micro version component, a positive integer up to nine digits long.
	 * @param special The special version component, an arbitrary string.
	 *
	 * @return A Version object.
	 */
	function Version(major, minor, micro, special)
	{
		this.major = major;
		this.minor = minor;
		this.micro = micro;
		this.special = special;
	};

	/**
	 * The maximum value allowed for a Numeric version component.
	 * This reflects the maximum value allowed in PlugPlug and the manifest schema.
	 */
	Version.MAX_NUM = 999999999;

	/**
	 * Class VersionBound
	 * Defines a boundary for a version range, which associates a Version object with a flag for whether it is an inclusive
	 * or exclusive boundary.
	 *
	 * @param version   The Version object.
	 *					@see Version class.
	 * @param inclusive True if this boundary is inclusive, false if it is exclusive.
	 *
	 * @return A VersionBound object.
	 */
	function VersionBound(version, inclusive)
	{
		this.version = version;
		this.inclusive = inclusive;
	};

	/**
	 * Class VersionRange.
	 * Defines a range of versions using a lower boundary and optional upper boundary.
	 *
	 * @param lowerBound The VersionBound object. @see VersionBound.
	 * @param upperBound The VersionBound object, or null for a range with no upper boundary. @see VersionBound.
	 *
	 * @return A VersionRange object.
	 */
	function VersionRange(lowerBound, upperBound)
	{
		this.lowerBound = lowerBound;
		this.upperBound = upperBound;
	};

	/**
	 * Class Runtime.
	 * Represents a runtime related to the CSXS infrastructure. Extensions can declare dependencies on particular
	 * CSXS runtime versions in the extension manifest.
	 *
	 * @param name 	  The runtime name.
	 * @param version The VersionRange object. @see VersionRange.
	 *
	 * @return A Runtime object.
	 */
	function Runtime(name, versionRange)
	{
		this.name = name;
		this.versionRange = versionRange;
	};

	/**
	* Class Extension.
	* Contains the classes that define data types for the CEP libraries.
	*
	* @param id 					 The unique identifier of this extension.
	* @param name 					 The localizable display name of this extension.
	* @param mainPath 				 The path of the "index.html" file.
	* @param basePath 				 The base path of this extension.
	* @param windowType 			 The window type of the main window of this extension. Valid values are defined by CSXSWindowType. @see CSXSWindowType.
	* @param width 					 The default width in pixels of the main window of this extension.
	* @param height 				 The default height in pixels of the main window of this extension.
	* @param minWidth 				 The minimum width in pixels of the main window of this extension.
	* @param minHeight 				 The minimum height in pixels of the main window of this extension.
	* @param maxWidth 				 The maximum width in pixels of the main window of this extension.
	* @param maxHeight 				 The maximum height in pixels of the main window of this extension.
	* @param defaultExtensionDataXml The extension data contained in the default ExtensionDispatchInfo section of the extension manifest.
	* @param specialExtensionDataXml The extension data contained in the application-specific ExtensionDispatchInfo section of the extension manifest.
	* @param requiredRuntimeList 	 An array of Runtime objects for runtimes required by this extension. @see VersionRange.
	* @param isAutoVisible 			 True if this extension is visible on loading.
	* @param isPluginExtension 		 True if this extension has been deployed in the Plugins folder of the host application.
	*
	* @return An Extension object.
	*/
	function Extension(id, name, mainPath, basePath, windowType, width, height, minWidth, minHeight, maxWidth, maxHeight,
					   defaultExtensionDataXml, specialExtensionDataXml, requiredRuntimeList, isAutoVisible, isPluginExtension)
	{
		this.id = id;
		this.name = name;
		this.mainPath = mainPath;
		this.basePath = basePath;
		this.windowType = windowType;
		this.width = width;
		this.height = height;
		this.minWidth = minWidth;
		this.minHeight = minHeight;
		this.maxWidth = maxWidth;
		this.maxHeight = maxHeight;
		this.defaultExtensionDataXml = defaultExtensionDataXml;
		this.specialExtensionDataXml = specialExtensionDataXml;
		this.requiredRuntimeList = requiredRuntimeList;
		this.isAutoVisible = isAutoVisible;
		this.isPluginExtension = isPluginExtension;
	};

	/**
	 * Class CSEvent.
	 * You can use it to dispatch a standard Javascript event.
	 *
	 * @param type 		  Event type.
	 * @param scope 	  The scope of event, can be "GLOBAL" or "APPLICATION".
	 * @param appId 	  The unique identifier of the application that generated the event.
	 * @param extensionId The unique identifier of the extension that generated the event.
	 *
	 * @return CSEvent object
	 */
	function CSEvent(type, scope, appId, extensionId)
	{
	    this.type = type;
	    this.scope = scope;
	    this.appId = appId;
	    this.extensionId = extensionId;
	};

	/** The event specific data. **/
	CSEvent.prototype.data = "";

	/**
	 * Class SystemPath
	 * Stores operating-system-specific location constants for use getSystemPath method.
	 */
	function SystemPath()
	{
	};

	/** Identifies the path to user data.  */
	SystemPath.USER_DATA = "userData";

	/** Identifies the path to common files for Adobe applications.  */
	SystemPath.COMMON_FILES = "commonFiles";

	/** Identifies the path to the user's default document folder.  */
	SystemPath.MY_DOCUMENTS = "myDocuments";

	/** Identifies the path to current extension.  */
	/** DEPRECATED, PLEASE USE EXTENSION INSTEAD.  */
	SystemPath.APPLICATION = "application";

	/** Identifies the path to current extension.  */
	SystemPath.EXTENSION = "extension";

	/** Identifies the path to hosting application's executable.  */
	SystemPath.HOST_APPLICATION = "hostApplication";

	/**
	 * Class ColorType
	 * Stores the color-type constants.
	 */
	function ColorType()
	{
	};

	/** rgb type. */
	ColorType.RGB = "rgb";

	/** gradient type. */
	ColorType.GRADIENT = "gradient";

	/** none type. */
	ColorType.NONE = "none";

	/**
	 * Class RGBColor
	 * Stores an RGB color with red, green, blue, and alpha values. All values are in the range
	 * [0.0 to 255.0]. Invalid numeric values are converted to numbers within this range.
	 *
	 * @param red   The red value, in the range [0.0 to 255.0].
	 * @param green The green value, in the range [0.0 to 255.0].
	 * @param blue  The blue value, in the range [0.0 to 255.0].
	 * @param alpha The alpha (transparency) value, in the range [0.0 to 255.0].
	 * 		  		The default (255.0) means that the color is fully opaque.
	 *
	 * @return RGBColor object.
	 */
	function RGBColor(red, green, blue, alpha)
	{
		this.red = red;
		this.green = green;
		this.blue = blue;
		this.alpha = alpha;
	};

	/**
	 * Class Direction
	 * Stores a point information.
	 *
	 * @param x X axis position.
	 * @param y Y axis position.
	 *
	 * @return Direction object.
	 */
	function Direction(x, y)
	{
		this.x = x;
		this.y = y;
	};

	/**
	 * Class GradientStop
	 * Stores gradient stop information.
	 *
	 * @param offset   The offset of the gradient stop, in the range [0.0 to 1.0].
	 * @param rgbColor The RGBColor object. @see RGBColor.
	 *
	 * @return GradientStop object.
	 */
	function GradientStop(offset, rgbColor)
	{
		this.offset = offset;
		this.rgbColor = rgbColor;
	};

	/**
	 * Class GradientColor
	 * Stores gradient color information.
	 *
	 * @param type 		 	   The gradient type, the only valid value is "linear".
	 * @param direction 	   A vector describing the direction of the gradient.
	 *						   A point value, in which the y component is 0 and the x component
	 *						   is positive or negative for a right or left direction,
	 * 						   or the x component is 0 and the y component is positive or negative for
	 *						   an up or down direction. @see Direction.
	 * @param numStops  	   The number of stops.
	 * @param gradientStopList An array of GradientStop objects. @see GradientStop.
	 *
	 * @return GradientColor object.
	 */
	function GradientColor(type, direction, numStops, arrGradientStop)
	{
		this.type = type;
		this.direction = direction;
		this.numStops = numStops;
		this.arrGradientStop = arrGradientStop;
	};

	/**
	 * Class UIColor
	 * Stores color information, including the type, anti-alias level, and specific color
	 * values in a color object of an appropriate type.
	 *
	 * @param type 			 The color type constant, 1 for "rgb" and 2 for "gradient".
	 * @param antialiasLevel The anti-alias level constant.
	 * @param color 		 A GradientColor object or a RGBColor containing specific color information.
	 *						 The type of color object depends on type parameter. @see GradientColor and RGBColor.
	 *
	 * @return UIColor object.
	 */
	function UIColor(type, antialiasLevel, color)
	{
		this.type = type;
		this.antialiasLevel = antialiasLevel;
		this.color = color;
	};

	/**
	 * Class AppSkinInfo
	 * Stores window-skin properties, such as color and font. All parameters' type are UIColor. @see UIColor.
	 *
	 * @param baseFontFamily 			The base font family of the application.
	 * @param baseFontSize 				The base font size of the application.
	 * @param appBarBackgroundColor 	The application bar background color.
	 * @param panelBackgroundColor 		The background color of the extension panel.
	 * @param appBarBackgroundColorSRGB The application bar background color, as sRGB.
	 * @param panelBackgroundColorSRGB  The background color of the extension panel, as sRGB.
	 * @param systemHighlightColor      The operating-system highlight color, as sRGB.
	 *
	 * @return AppSkinInfo object.
	 */
	function AppSkinInfo(baseFontFamily, baseFontSize, appBarBackgroundColor, panelBackgroundColor, appBarBackgroundColorSRGB, panelBackgroundColorSRGB, systemHighlightColor)
	{
		this.baseFontFamily = baseFontFamily;
		this.baseFontSize = baseFontSize;
		this.appBarBackgroundColor = appBarBackgroundColor;
		this.panelBackgroundColor = panelBackgroundColor;
		this.appBarBackgroundColorSRGB = appBarBackgroundColorSRGB;
		this.panelBackgroundColorSRGB = panelBackgroundColorSRGB;
		this.systemHighlightColor = systemHighlightColor;
	};

	/**
	 * Class HostEnvironment
	 * Stores information about the environment in which the extension is loaded.
	 *
	 * @param appName 	   The application's name.
	 * @param appVersion   The application's version.
	 * @param appLocale    The application's current license locale.
	 * @param appId 	   The application's unique identifier.
	 * @param isAppOffline True if the application is currently offline.
	 * @param appSkinInfo  A skin-information object containing the application's default color and font styles. @see AppSkinInfo.
	 * @param appUILocale  The application's current UI locale.
	 *
	 * @return HostEnvironment object.
	 */
	function HostEnvironment(appName, appVersion, appLocale, appUILocale, appId, isAppOffline, appSkinInfo)
	{
		this.appName = appName;
		this.appVersion = appVersion;
		this.appLocale = appLocale;
		this.appUILocale = appUILocale;
		this.appId = appId;
		this.isAppOffline = isAppOffline;
		this.appSkinInfo = appSkinInfo;
	};

	/***********************************************************************************/
	/**
	 * Class CSInterface.
	 * You can use it to communicate with native application.
	 *
	 * @return CSInterface object
	 */
	function CSInterface()
	{
	};

	/**
	 * User can add this event listener to handle native application theme color changes.
	 * Callback function gives extensions ability to fine-tune their theme color after the
	 * global theme color has been changed.
	 * The callback function should be like below:
	 *
	 * @example
	 * // event is a CSEvent object, but user can ignore it.
	 * function OnAppThemeColorChanged(event)
	 * {
	 *	  // Should get a latest HostEnvironment object from application.
	 *	  var skinInfo = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
	 *    // Gets the style information such as color info from the skinInfo,
	 *	  // and redraw all UI controls of your extension according to the style info.
	 * }
	 */
	CSInterface.THEME_COLOR_CHANGED_EVENT = "com.adobe.csxs.events.ThemeColorChanged";

	/** The host environment data object **/
	CSInterface.prototype.hostEnvironment = JSON.parse(window.__adobe_cep__.getHostEnvironment());

	/** Close the current extension **/
	CSInterface.prototype.closeExtension = function()
	{
		window.__adobe_cep__.closeExtension();
	};

	/**
	 * Get system path.
	 *
	 * @param pathType A string containing a path-type constant defined in the SystemPath class,
	 * 		           such as SystemPath.USER_DATA.
	 * @return path string
	 */
	CSInterface.prototype.getSystemPath = function(pathType)
	{
		var path = decodeURI(window.__adobe_cep__.getSystemPath(pathType));
		var OSVersion = this.getOSInformation();
		if (OSVersion.indexOf("Windows") >= 0)
		{
		  path = path.replace("file:///", "");
		}
		else if (OSVersion.indexOf("Mac") >= 0)
		{
		  path = path.replace("file://", "");
		}
	    return path;
	};

	/**
	 * Eval scripts. You can use it to operate the DOM of native application.
	 *
	 * @param script   The raw JavaScript.
	 * @param callback The callback function that receives the execution result of the script. This parameter is optional.
	 * 				   If it fails to execute the script, the callback function will receive the error message EvalScript_ErrMessage.
	 */
	CSInterface.prototype.evalScript = function(script, callback)
	{
	    if(callback == null || callback == undefined)
	    {
	        callback = function(result){};
	    }
	    window.__adobe_cep__.evalScript(script, callback);
	};

	/**
	 * Get the identifier of the host application.
	 *
	 * @return a string identifier of the host application
	 */
	CSInterface.prototype.getApplicationID = function()
	{
	    var appId = this.hostEnvironment.appId;
	    return appId;
	};

	/**
	 * Get host capability information about the host application.
	 *
	 * @return an object that contains host capability information
	 */
	CSInterface.prototype.getHostCapabilities = function()
	{
	    var hostCapabilities = JSON.parse(window.__adobe_cep__.getHostCapabilities() );
	    return hostCapabilities;
	};

	/**
	 * Triggering a CS Event programmatically. You can use it to dispatch a CSEvent.
	 *
	 * @param event a CS Event
	 */
	CSInterface.prototype.dispatchEvent = function(event)
	{
	    if (typeof event.data == "object")
	    {
	        event.data = JSON.stringify(event.data);
	    }

	    window.__adobe_cep__.dispatchEvent(event);
	};

	/**
	 * Register a CS Event listener. You can use it to listen a CSEvent.
	 *
	 * @param type     The Event type
	 * @param listener The JavaScript function that receives a notification when
	 *                 a CS event of the specified type occurs.
	 * @param obj 	   The object that listener belongs to. Use it when listener is a method
	 *				   of an object. This parameter is optional and its default value is null.
	 */
	CSInterface.prototype.addEventListener = function(type, listener, obj)
	{
	    window.__adobe_cep__.addEventListener(type, listener, obj);
	};

	/**
	 * Remove the CS Event listener.
	 *
	 * @param type event type
	 * @param listener The JavaScript function that receives a notification when
	 *                 a CS event of the specified type occurs.
	 * @param obj 	   The object that listener belongs to. Use it when listener is a method
	 *				   of an object. This parameter is optional and its default value is null.
	 */
	CSInterface.prototype.removeEventListener = function(type, listener, obj)
	{
	    window.__adobe_cep__.removeEventListener(type, listener, obj);
	};

	/**
	 * Loads and launches another extension. If the target extension is already loaded, it is activated.
	 *
	 * @param extensionId   The extension's unique identifier.
	 * @param startupParams Startup parameters to be passed to the loaded extension.
	 * 	 					Specify key-value pairs as a GET URL parameter list; for example: "key1=value1&amp;key2=value2".
	 *						Currently this parameter is not supported by CEP, so it will always be "" for now.
	 *
	 * @example
	 * To launch the extension "help" with ID "HLP" from this extension, call:
	 * requestOpenExtension("HLP", "");
	 *
	 */
	CSInterface.prototype.requestOpenExtension = function(extensionId, params)
	{
		window.__adobe_cep__.requestOpenExtension(extensionId, params);
	};

	/**
	 * Retrieves the list of extensions currently loaded in the current host application.
	 * The extension list is initialized once, and remains the same during the lifetime of the CSXS session.
	 *
	 * @param extensionIds An array of unique identifiers for extensions of interest.
	 * 					   If omitted, retrieves data for all extensions.
	 *
	 * @return An Extension object.
	 */
	CSInterface.prototype.getExtensions = function(extensionIds)
	{
		var extensionIdsStr = JSON.stringify(extensionIds);
		var extensionsStr = window.__adobe_cep__.getExtensions(extensionIdsStr);

		var extensions = JSON.parse(extensionsStr);
		return extensions;
	};

	/**
	 * Retrieves network-related preferences.
	 *
	 * @return A NetworkPreferences object.
	 */
	CSInterface.prototype.getNetworkPreferences = function()
	{
		var result = window.__adobe_cep__.getNetworkPreferences();
		var networkPre = JSON.parse(result);

		return networkPre;
	};

	/**
	 * Initializes the resource bundle for this extension with property values for the current application and locale.
	 * If user wants to support multi-locale to the extension, they should define a property file. An example of the property file content is:
	 *
	 *  key1=value1
	 *  key2=value2
	 *	key3.value=value3
	 *
	 * The property file should be placed in its corresponding locale folder. For example for en_US, the property file would be placed in YourExtension/locale/en_US/messages.properties.
	 * Users can define a default property file, placed in "YourExtension/locale/" which will be used when the corresponding locale file is not defined.
	 * Users should initialize locale strings during the loading of the extension. The locale loaded should match the current UI locale of the host application.
	 * 'data-locale' is the custom HTML element attribute and you can added it to each HTML element that you want to localize.
	 *
	 * For example:
	 *
	 *	<input type="submit" value="" data-locale="key3"/>
	 *	<script type="text/javascript">
	 *		var cs = new CSInterface();
	 *		// Get properties according to current locale of host application.
	 *		var resourceBundle = cs.initResourceBundle();
	 *		// Refer the locale string.
	 *		document.write(resourceBundle.key1);
	 *		document.write(resourceBundle.key2);
	 *	</script>
	 *
	 * @return An object containing the resource bundle information.
	 */
	CSInterface.prototype.initResourceBundle = function()
	{
		var resourceBundle = JSON.parse(window.__adobe_cep__.initResourceBundle());
		var resElms = document.querySelectorAll('[data-locale]');
		for (var n = 0; n < resElms.length; n++)
		{
		   var resEl = resElms[n];
		   // Get the resource key from the element.
		   var resKey = resEl.getAttribute('data-locale');
		   if (resKey)
		   {
			   // Get all the resources that start with the key.
			   for (var key in resourceBundle)
			   {
				   if (key.indexOf(resKey) == 0)
				   {
					   var resValue = resourceBundle[key];
					   if (key.indexOf('.') == -1)
					   {
						   // No dot notation in resource key,
						   // assign the resource value to the element's
						   // innerHTML.
						   resEl.innerHTML = resValue;
					   }
					   else
					   {
						   // Dot notation in resource key, assign the
						   // resource value to the element's property
						   // whose name corresponds to the substring
						   // after the dot.
						   var attrKey = key.substring(key.indexOf('.') + 1);
						   resEl[attrKey] = resValue;
					   }
				   }
			   }
		   }
		}
		return resourceBundle;
	};

	/**
	 * Writes installation information to a file.
	 *
	 * @return The dump info file path.
	 */
	CSInterface.prototype.dumpInstallationInfo = function()
	{
		return window.__adobe_cep__.dumpInstallationInfo();
	};

	/**
	 * Get current Operating System information including version and 32-bit/64-bit.
	 * Refer to http://www.useragentstring.com/pages/Chrome/ for all of the navigator.userAgent values retrieved by Chrome.
	 *
	 * @return The OS version in string or "unknown Operation System".
	 */
	CSInterface.prototype.getOSInformation = function()
	{
	    var userAgent = navigator.userAgent;

	    if ((navigator.platform == "Win32") || (navigator.platform == "Windows"))
	    {
	        var winVersion = "Windows platform";
	        if (userAgent.indexOf("Windows NT 5.0") > -1)
	        {
	            winVersion = "Windows 2000";
	        }
	        else if (userAgent.indexOf("Windows NT 5.1") > -1)
	        {
	            winVersion = "Windows XP";
	        }
	        else if (userAgent.indexOf("Windows NT 5.2") > -1)
	        {
	            winVersion = "Windows Server 2003";
	        }
	        else if (userAgent.indexOf("Windows NT 6.0") > -1)
	        {
	            winVersion = "Windows Vista";
	        }
	        else if (userAgent.indexOf("Windows NT 6.1") > -1)
	        {
	            winVersion = "Windows 7";
	        }
	        else if (userAgent.indexOf("Windows NT 6.2") > -1)
	        {
	            winVersion = "Windows 8";
	        }

	        var winBit = "32-bit";
	        if (userAgent.indexOf("WOW64") > -1)
	        {
	            winBit = "64-bit";
	        }

	        return winVersion + " " + winBit;
	    }
	    else if ((navigator.platform == "MacIntel") || (navigator.platform == "Macintosh"))
	    {
	        var agentStr = new String();
	        agentStr = userAgent;
			var verLength = agentStr.indexOf(")") - agentStr.indexOf("Mac OS X");
			var verStr = agentStr.substr(agentStr.indexOf("Mac OS X"), verLength);
			var result = verStr.replace("_", ".");
			result = result.replace("_", ".");
	        return result;
	    }

	    return "Unknown Operation System";
	};

	;
	CSInterface.SystemPath = SystemPath;

	CSInterface.CSEvent = CSEvent;

	module.exports = CSInterface;


/***/ },
/* 28 */
/***/ function(module, exports) {

	var Rotator,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

	module.exports = Rotator = (function() {
	  function Rotator(node1) {
	    var i, j, k, len, o, options, ref, thingy;
	    this.node = node1;
	    this.rotate = bind(this.rotate, this);
	    this.name = this.node.getAttribute('data-name');
	    options = this.node.getAttribute('data-options');
	    if (!((options != null) && options.trim() !== '')) {
	      throw Error("Rotator isn't supplied with data-options");
	    }
	    this.options = [];
	    ref = options.split(/\s*,\s*/);
	    for (j = 0, len = ref.length; j < len; j++) {
	      o = ref[j];
	      this.options.push(o);
	    }
	    this.node.classList.add('panel-input-rotator');
	    for (i = k = 0; k <= 6; i = ++k) {
	      thingy = document.createElement('div');
	      thingy.classList.add('thingy');
	      thingy.classList.add('n' + i);
	      this.node.appendChild(thingy);
	    }
	    this.input = document.createElement('input');
	    this.input.type = 'hidden';
	    this.input.name = this.name;
	    this.node.parentNode.appendChild(this.input);
	    this.set(this.node.getAttribute('data-default') || this.options[0]);
	    this.node.addEventListener('click', this.rotate);
	  }

	  Rotator.prototype.set = function(to) {
	    if (indexOf.call(this.options, to) < 0) {
	      throw Error("Option '" + to + "' isn't defined.");
	    }
	    if (this.current != null) {
	      this.node.classList.remove(this.current);
	    }
	    this.node.classList.add(to);
	    this.current = to;
	    this.input.value = to;
	    return this;
	  };

	  Rotator.prototype.rotate = function() {
	    var newIndex;
	    newIndex = this.options.indexOf(this.current) + 1;
	    newIndex = newIndex % this.options.length;
	    this.set(this.options[newIndex]);
	    return this;
	  };

	  Rotator.applyTo = function(root) {
	    var j, len, node, nodes;
	    nodes = root.querySelectorAll('[data-type="rotator"]');
	    for (j = 0, len = nodes.length; j < len; j++) {
	      node = nodes[j];
	      new Rotator(node);
	    }
	  };

	  return Rotator;

	})();


/***/ },
/* 29 */
/***/ function(module, exports) {

	var Form;

	module.exports = Form = (function() {
	  function Form(panel1, node) {
	    this.panel = panel1;
	    this.node = node;
	    this.csi = this.panel.csi;
	    this.node.addEventListener('submit', (function(_this) {
	      return function(e) {
	        e.preventDefault();
	        return _this._submit();
	      };
	    })(this));
	  }

	  Form.prototype._submit = function() {
	    var data, i, input, len, ref;
	    data = {};
	    ref = this.node.querySelectorAll('input');
	    for (i = 0, len = ref.length; i < len; i++) {
	      input = ref[i];
	      data[input.name] = input.value;
	    }
	    return this._wire(data);
	  };

	  Form.prototype._wire = function(data) {
	    var action, matches, method;
	    action = this.node.action;
	    if (!(matches = action.match(/\#([a-zA-Z0-9\_]+)$/))) {
	      throw Error("Couldn't parse action address '" + action + "'");
	    }
	    method = matches[1];
	    return this.panel.invoke(method, data);
	  };

	  Form.applyTo = function(rootNode, panel) {
	    var form, i, len, ref;
	    ref = rootNode.querySelectorAll('form');
	    for (i = 0, len = ref.length; i < len; i++) {
	      form = ref[i];
	      if (String(form.getAttribute('action')).match(/^#/)) {
	        new Form(panel, form);
	      }
	    }
	  };

	  return Form;

	})();


/***/ },
/* 30 */
/***/ function(module, exports) {

	module.exports = {
		"name": "griddify",
		"private": "true",
		"version": "1.1.0-beta.1",
		"description": "A tiny photoshop panel to make guides and grids",
		"main": "index.js",
		"scripts": {
			"dev": "webpack --watch --config ./build-tools/webpack-dev.js --colors --progress",
			"prepublish": "webpack --config ./build-tools/webpack-production.js --colors --progress"
		},
		"repository": {
			"type": "git",
			"url": "https://github.com/pixana/griddify.git"
		},
		"keywords": [
			"photoshop"
		],
		"author": "Aria Minaei",
		"license": "GPL V3",
		"bugs": {
			"url": "https://github.com/pixana/griddify/issues"
		},
		"dependencies": {
			"photoshopjs-core": "~0.1.0-dev.1",
			"semver": "^5.1.0"
		},
		"devDependencies": {
			"autoprefixer": "^6.1.2",
			"coffee-loader": "^0.7.2",
			"coffee-script": "^1.10.0",
			"css-loader": "^0.23.0",
			"file-loader": "^0.8.5",
			"json-loader": "^0.5.4",
			"postcss-short": "^1.4.0",
			"poststylus": "^0.2.2",
			"style-loader": "^0.13.0",
			"stylus-loader": "^1.4.2",
			"url-loader": "^0.5.7",
			"webpack": "^1.12.9",
			"webpack-error-notification": "^0.1.5"
		}
	};

/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag

	// load the styles
	var content = __webpack_require__(32);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(38)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../node_modules/css-loader/index.js!./../node_modules/stylus-loader/index.js!./griddify.styl", function() {
				var newContent = require("!!./../node_modules/css-loader/index.js!./../node_modules/stylus-loader/index.js!./griddify.styl");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(33)();
	// imports


	// module
	exports.push([module.id, ".size-small .fittableButton {\n  width: 54px !important;\n}\n.size-medium .fittableButton {\n  width: 60px !important;\n}\n.size-large .fittableButton {\n  width: 70px !important;\n}\n* {\n  margin: 0;\n  padding: 0;\n  box-sizing: border-box;\n}\n#body {\n  overflow: hidden;\n  padding-top: 8px;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  position: absolute;\n  font-family: Tahoma, Helvetica, sans-serif;\n  font-size: 10px;\n  line-height: 22px;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  cursor: default;\n}\n.dark1 #body {\n  background-color: #343434;\n}\n.dark2 #body {\n  background-color: #535353;\n}\n.light1 #body {\n  background-color: #b8b8b8;\n}\n.light2 #body {\n  background-color: #d6d6d6;\n}\n.dark1 #body {\n  color: #cacaca;\n}\n.dark2 #body {\n  color: #fff;\n}\n.light1 #body {\n  color: #000;\n}\n.light2 #body {\n  color: #000;\n}\n.dark1 #body {\n  text-shadow: none;\n}\n.dark2 #body {\n  text-shadow: none;\n}\n.light1 #body {\n  text-shadow: 0 1px 0.5px #dfdfdf;\n}\n.light2 #body {\n  text-shadow: none;\n}\n.hidden {\n  display: none;\n}\nhr {\n  height: 1px;\n  margin-bottom: -2px;\n  margin-top: 0;\n  box-sizing: content-box;\n  border: none;\n  border-bottom: 1px solid;\n}\n.dark1 hr {\n  background-color: #262626;\n  border-bottom-color: #484848;\n}\n.dark2 hr {\n  background-color: #383838;\n  border-bottom-color: #717171;\n}\n.light1 hr {\n  background-color: #808080;\n  border-bottom-color: #cacaca;\n}\n.light2 hr {\n  background-color: #9e9e9e;\n  border-bottom-color: #f0f0f0;\n}\n.noMargin {\n  margin-right: 0;\n}\ninput,\nbutton,\na.button {\n  position: relative;\n  display: inline-block;\n  height: 22px;\n  width: 70px;\n  margin-bottom: 8px;\n  margin-right: 5px;\n  vertical-align: bottom;\n  line-height: 16px;\n  outline: none !important;\n}\ninput.big,\nbutton.big,\na.button.big {\n  width: 140px;\n}\n.size-medium input,\n.size-medium button,\n.size-medium a.button {\n  height: 24px;\n  line-height: 13px;\n}\n.size-large input,\n.size-large button,\n.size-large a.button {\n  height: 25px;\n  line-height: 14px;\n}\n::-webkit-input-placeholder.light1,\n::-webkit-input-placeholder.light2 {\n  color: #666;\n}\n.dark1 input,\n.dark1 button,\n.dark1 a {\n  color: #cacaca;\n}\n.dark2 input,\n.dark2 button,\n.dark2 a {\n  color: #fff;\n}\n.light1 input,\n.light1 button,\n.light1 a {\n  color: #000;\n}\n.light2 input,\n.light2 button,\n.light2 a {\n  color: #000;\n}\nbutton {\n  font-size: inherit;\n}\ninput[type=text] {\n  padding-left: 4px;\n  padding-right: 4px;\n  outline: none;\n  font-size: inherit;\n  font-family: Helvetica, Arial, Tahoma, sans-serif;\n  border: 1px solid;\n}\n.dark1 input[type=text] {\n  background: #212121;\n  border-color: #111;\n  box-shadow: 0 1px 0 #464646, inset 0 1px 0 #1e1e1e;\n}\n.dark2 input[type=text] {\n  background: #3a3a3a;\n  border-color: #2a2a2a;\n  box-shadow: 0 1px 0 #696969, inset 0 1px 0 #373737;\n}\n.light1 input[type=text] {\n  background: #eee;\n  border-color: #5e5e5e;\n  box-shadow: 0 1px 0 #c6c6c6, inset 0 1px 0 #cfcfcf;\n}\n.light2 input[type=text] {\n  background: #fff;\n  border-color: #888;\n  box-shadow: 0 1px 0 #e8e8e8, inset 0 1px 0 #d9d9d9;\n}\ninput[type=text]:focus {\n  background: #fff;\n  color: #000;\n  border-color: #00bdff;\n  box-shadow: 0 0 4px -1px #000 !important;\n}\n.light2 input[type=text]:focus {\n  box-shadow: 0 0 4px -1px #00c7ff !important;\n}\nbutton,\ninput[type=submit],\na.button {\n  font: inherit;\n  text-decoration: none;\n  border: 1px solid #323232;\n  box-shadow: none !important;\n  border-radius: 3px !important;\n  cursor: default;\n}\n.dark1 button,\n.dark1 input[type=submit],\n.dark1 a.button {\n  border-color: #242424;\n  box-shadow: 0 1px 0 #464646, inset 0 1px 0 #464646;\n  background: -webkit-linear-gradient(top, #505050, #404040);\n  background: linear-gradient(to bottom, #505050, #404040);\n}\n.dark2 button,\n.dark2 input[type=submit],\n.dark2 a.button {\n  border-color: #2a2a2a;\n  box-shadow: 0 1px 0 #6a6a6a, inset 0 1px 0 #919191;\n  background: -webkit-linear-gradient(top, #666, #555);\n  background: linear-gradient(to bottom, #666, #555);\n  color: #eee;\n}\n.light1 button,\n.light1 input[type=submit],\n.light1 a.button {\n  border-color: #5e5e5e;\n  box-shadow: 0 1px 0 #c7c7c7, inset 0 1px 0 #f7f7f7;\n  background: -webkit-linear-gradient(top, #e7e7e7, #bdbdbd);\n  background: linear-gradient(to bottom, #e7e7e7, #bdbdbd);\n}\n.light2 button,\n.light2 input[type=submit],\n.light2 a.button {\n  border-color: #888;\n  box-shadow: 0 1px 0 #f7f7f7, inset 0 1px 0 #fff;\n  background: -webkit-linear-gradient(top, #e7e7e7, #bdbdbd);\n  background: linear-gradient(to bottom, #e7e7e7, #bdbdbd);\n}\n.dark1 button:hover,\n.dark1 input[type=submit]:hover,\n.dark1 a.button:hover {\n  border-color: #242424;\n  box-shadow: 0 1px 0 #464646, inset 0 1px 0 #464646;\n  background: -webkit-linear-gradient(top, #626262, #424242);\n  background: linear-gradient(to bottom, #626262, #424242);\n}\n.dark1 .dark1 button:hover,\n.dark1 .dark1 input[type=submit]:hover,\n.dark1 .dark1 a.button:hover {\n  color: #000;\n}\n.dark2 .dark1 button:hover,\n.dark2 .dark1 input[type=submit]:hover,\n.dark2 .dark1 a.button:hover {\n  color: #000;\n}\n.light1 .dark1 button:hover,\n.light1 .dark1 input[type=submit]:hover,\n.light1 .dark1 a.button:hover {\n  color: #fff;\n}\n.light2 .dark1 button:hover,\n.light2 .dark1 input[type=submit]:hover,\n.light2 .dark1 a.button:hover {\n  color: #fff;\n}\n.dark2 button:hover,\n.dark2 input[type=submit]:hover,\n.dark2 a.button:hover {\n  border-color: #2a2a2a;\n  box-shadow: 0 1px 0 #6a6a6a, inset 0 1px 0 #919191;\n  background: -webkit-linear-gradient(top, #848484, #656565);\n  background: linear-gradient(to bottom, #848484, #656565);\n  color: #111;\n}\n.light1 button:hover,\n.light1 input[type=submit]:hover,\n.light1 a.button:hover {\n  border-color: #5e5e5e;\n  box-shadow: 0 1px 0 #c7c7c7, inset 0 1px 0 #f7f7f7;\n  background: -webkit-linear-gradient(top, #e9e9e9, #bebebe);\n  background: linear-gradient(to bottom, #e9e9e9, #bebebe);\n}\n.light2 button:hover,\n.light2 input[type=submit]:hover,\n.light2 a.button:hover {\n  border-color: #888;\n  box-shadow: 0 1px 0 #f7f7f7, inset 0 1px 0 #fff;\n  background: -webkit-linear-gradient(top, #e9e9e9, #bebebe);\n  background: linear-gradient(to bottom, #e9e9e9, #bebebe);\n}\n.dark1 button:active,\n.dark1 input[type=submit]:active,\n.dark1 a.button:active {\n  border-color: #242424;\n  box-shadow: 0 1px 0 #464646, inset 0 1px 0 #464646;\n  background: #333;\n}\n.dark1 .dark1 button:active,\n.dark1 .dark1 input[type=submit]:active,\n.dark1 .dark1 a.button:active {\n  color: #000;\n}\n.dark2 .dark1 button:active,\n.dark2 .dark1 input[type=submit]:active,\n.dark2 .dark1 a.button:active {\n  color: #000;\n}\n.light1 .dark1 button:active,\n.light1 .dark1 input[type=submit]:active,\n.light1 .dark1 a.button:active {\n  color: #fff;\n}\n.light2 .dark1 button:active,\n.light2 .dark1 input[type=submit]:active,\n.light2 .dark1 a.button:active {\n  color: #fff;\n}\n.dark2 button:active,\n.dark2 input[type=submit]:active,\n.dark2 a.button:active {\n  border-color: #2a2a2a;\n  box-shadow: 0 1px 0 #6a6a6a, inset 0 1px 0 #919191;\n  background: #444;\n}\n.light1 button:active,\n.light1 input[type=submit]:active,\n.light1 a.button:active {\n  border-color: #5e5e5e;\n  box-shadow: 0 1px 0 #c7c7c7, inset 0 1px 0 #f7f7f7;\n  background: #bbb;\n}\n.light2 button:active,\n.light2 input[type=submit]:active,\n.light2 a.button:active {\n  border-color: #888;\n  box-shadow: 0 1px 0 #f7f7f7, inset 0 1px 0 #fff;\n  background: #bbb;\n}\ninput[type=text],\nbutton,\na.button {\n  border-radius: 2px;\n}\nbutton,\na.button,\ninput[type=submit] {\n  padding: 4px 8px;\n  width: auto;\n  height: 25px;\n  top: 1px;\n  line-height: 15px;\n}\n.size-large button,\n.size-large a.button,\n.size-large input[type=submit] {\n  height: 28px;\n}\n.size-medium button,\n.size-medium a.button,\n.size-medium input[type=submit] {\n  height: 27px;\n}\na.button {\n  padding-top: 1px;\n}\n.direction {\n  position: relative;\n  display: inline-block;\n  height: 22px;\n  width: 70px;\n  margin-bottom: 8px;\n  margin-right: 5px;\n  vertical-align: bottom;\n  line-height: 16px;\n  outline: none !important;\n  position: relative;\n  border-radius: 3px;\n  cursor: pointer;\n}\n.direction.big {\n  width: 140px;\n}\n.size-medium .direction {\n  height: 24px;\n  line-height: 13px;\n}\n.size-large .direction {\n  height: 25px;\n  line-height: 14px;\n}\n.direction > .thingy {\n  display: none;\n}\n.size-large .direction {\n  width: 26px !important;\n  height: 26px !important;\n}\n.size-medium .direction {\n  width: 26px !important;\n  height: 26px !important;\n}\n.dark1 .direction,\n.dark2 .direction {\n  border: 1px solid transparent;\n  width: 24px;\n  height: 24px;\n  top: 1px;\n}\n.light1 .direction,\n.light2 .direction {\n  border: 1px solid transparent;\n  width: 24px;\n  height: 24px;\n}\n.dark1 .direction {\n  border-color: #2a2a2a;\n  background: #313131;\n}\n.dark1 .direction:hover {\n  border-color: #030303;\n}\n.dark1 .direction:active {\n  background: #222;\n}\n.dark2 .direction {\n  border-color: #3f3f3f;\n  background: #4d4d4d;\n}\n.dark2 .direction:hover {\n  border-color: #272727;\n}\n.dark2 .direction:active {\n  background: #2e2e2e;\n}\n.light1 .direction {\n  border-color: #888;\n  background: #cecece;\n}\n.light1 .direction:hover {\n  border-color: #555;\n}\n.light1 .direction:active {\n  background: #eee;\n}\n.light2 .direction {\n  border-color: #aaa;\n  background: #dedede;\n}\n.light2 .direction:hover {\n  border-color: #757575;\n}\n.light2 .direction:active {\n  background: #f2f2f2;\n  border-color: #333;\n}\n.direction > .n1 {\n  display: block;\n  position: absolute;\n  width: 7px;\n  height: 12px;\n  top: 5px;\n  left: 8px;\n  opacity: 0.67;\n  -webkit-transition: all 0.21s;\n  transition: all 0.21s;\n}\n.dark1 .direction > .n1 {\n  background: url(" + __webpack_require__(34) + ") 0 0 no-repeat;\n}\n.dark2 .direction > .n1 {\n  background: url(" + __webpack_require__(35) + ") 0 0 no-repeat;\n}\n.light1 .direction > .n1 {\n  background: url(" + __webpack_require__(36) + ") 0 0 no-repeat;\n}\n.light2 .direction > .n1 {\n  background: url(" + __webpack_require__(37) + ") 0 0 no-repeat;\n}\n.size-large .direction > .n1 {\n  top: 6px;\n  left: 9px;\n}\n.size-medium .direction > .n1 {\n  top: 6px;\n  left: 9px;\n}\n.direction.right > .n1 {\n  -webkit-transform: rotateZ(0deg) translateZ(1px);\n          transform: rotateZ(0deg) translateZ(1px);\n}\n.direction.right:hover > .n1 {\n  -webkit-transform: rotateZ(20deg) translateZ(1px);\n          transform: rotateZ(20deg) translateZ(1px);\n}\n.direction.down > .n1 {\n  -webkit-transform: rotateZ(90deg) translateZ(1px);\n          transform: rotateZ(90deg) translateZ(1px);\n}\n.direction.down:hover > .n1 {\n  -webkit-transform: rotateZ(110deg) translateZ(1px);\n          transform: rotateZ(110deg) translateZ(1px);\n}\n.direction.left > .n1 {\n  -webkit-transform: rotateZ(180deg) translateZ(1px);\n          transform: rotateZ(180deg) translateZ(1px);\n}\n.direction.left:hover > .n1 {\n  -webkit-transform: rotateZ(200deg) translateZ(1px);\n          transform: rotateZ(200deg) translateZ(1px);\n}\n.direction.up > .n1 {\n  -webkit-transform: rotateZ(270deg) translateZ(1px);\n          transform: rotateZ(270deg) translateZ(1px);\n}\n.direction.up:hover > .n1 {\n  -webkit-transform: rotateZ(290deg) translateZ(1px);\n          transform: rotateZ(290deg) translateZ(1px);\n}\n.orientation {\n  position: relative;\n  display: inline-block;\n  height: 22px;\n  width: 70px;\n  margin-bottom: 8px;\n  margin-right: 5px;\n  vertical-align: bottom;\n  line-height: 16px;\n  outline: none !important;\n  position: relative;\n  border-radius: 3px;\n  cursor: pointer;\n}\n.orientation.big {\n  width: 140px;\n}\n.size-medium .orientation {\n  height: 24px;\n  line-height: 13px;\n}\n.size-large .orientation {\n  height: 25px;\n  line-height: 14px;\n}\n.orientation > .thingy {\n  display: none;\n}\n.size-large .orientation {\n  width: 26px !important;\n  height: 26px !important;\n}\n.size-medium .orientation {\n  width: 26px !important;\n  height: 26px !important;\n}\n.dark1 .orientation,\n.dark2 .orientation {\n  border: 1px solid transparent;\n  width: 24px;\n  height: 24px;\n  top: 1px;\n}\n.light1 .orientation,\n.light2 .orientation {\n  border: 1px solid transparent;\n  width: 24px;\n  height: 24px;\n}\n.dark1 .orientation {\n  border-color: #2a2a2a;\n  background: #313131;\n}\n.dark1 .orientation:hover {\n  border-color: #030303;\n}\n.dark1 .orientation:active {\n  background: #222;\n}\n.dark2 .orientation {\n  border-color: #3f3f3f;\n  background: #4d4d4d;\n}\n.dark2 .orientation:hover {\n  border-color: #272727;\n}\n.dark2 .orientation:active {\n  background: #2e2e2e;\n}\n.light1 .orientation {\n  border-color: #888;\n  background: #cecece;\n}\n.light1 .orientation:hover {\n  border-color: #555;\n}\n.light1 .orientation:active {\n  background: #eee;\n}\n.light2 .orientation {\n  border-color: #aaa;\n  background: #dedede;\n}\n.light2 .orientation:hover {\n  border-color: #757575;\n}\n.light2 .orientation:active {\n  background: #f2f2f2;\n  border-color: #333;\n}\n.orientation > .n0 {\n  display: block;\n  position: absolute;\n  width: 10px;\n  height: 10px;\n  top: 6px;\n  left: 6px;\n  -webkit-transition: all 0.21s;\n  transition: all 0.21s;\n  box-sizing: border-box;\n  opacity: 0.67;\n  z-index: 0;\n}\n.size-large .orientation > .n0 {\n  top: 7px;\n  left: 7px;\n}\n.size-medium .orientation > .n0 {\n  top: 7px;\n  left: 7px;\n}\n.dark1 .orientation > .n0 {\n  border: 1px solid #5f5f5f;\n}\n.dark2 .orientation > .n0 {\n  border: 1px solid #777;\n}\n.light1 .orientation > .n0 {\n  border: 1px solid #888;\n}\n.light2 .orientation > .n0 {\n  border: 1px solid #aaa;\n}\n.orientation .n1,\n.orientation .n2,\n.orientation .n3,\n.orientation .n4 {\n  display: block;\n  position: absolute;\n  -webkit-transition: all 0.21s;\n  transition: all 0.21s;\n  opacity: 0;\n}\n.dark1 .orientation .n1,\n.dark1 .orientation .n2,\n.dark1 .orientation .n3,\n.dark1 .orientation .n4,\n.dark2 .orientation .n1,\n.dark2 .orientation .n2,\n.dark2 .orientation .n3,\n.dark2 .orientation .n4 {\n  background: #bbb;\n}\n.light1 .orientation .n1,\n.light1 .orientation .n2,\n.light1 .orientation .n3,\n.light1 .orientation .n4,\n.light2 .orientation .n1,\n.light2 .orientation .n2,\n.light2 .orientation .n3,\n.light2 .orientation .n4 {\n  background: #222;\n}\n.orientation .n1 {\n  width: 1px;\n  height: 12px;\n  left: 6px;\n  top: 5px;\n}\n.size-large .orientation .n1 {\n  left: 7px;\n  top: 6px;\n}\n.size-medium .orientation .n1 {\n  left: 7px;\n  top: 6px;\n}\n.orientation .n2 {\n  width: 1px;\n  height: 12px;\n  left: 15px;\n  top: 5px;\n}\n.size-large .orientation .n2 {\n  left: 16px;\n  top: 6px;\n}\n.size-medium .orientation .n2 {\n  left: 16px;\n  top: 6px;\n}\n.orientation .n3 {\n  width: 12px;\n  height: 1px;\n  left: 5px;\n  top: 6px;\n}\n.size-large .orientation .n3 {\n  left: 6px;\n  top: 7px;\n}\n.size-medium .orientation .n3 {\n  left: 6px;\n  top: 7px;\n}\n.orientation .n4 {\n  width: 12px;\n  height: 1px;\n  left: 5px;\n  top: 15px;\n}\n.size-large .orientation .n4 {\n  left: 6px;\n  top: 16px;\n}\n.size-medium .orientation .n4 {\n  left: 6px;\n  top: 16px;\n}\n.orientation.vertical > .n1,\n.orientation.vertical .n2 {\n  opacity: 1;\n  -webkit-transform: translateX(0);\n          transform: translateX(0);\n}\n.orientation.vertical > .n3 {\n  opacity: 0;\n  -webkit-transform: translateY(10px);\n          transform: translateY(10px);\n}\n.orientation.vertical > .n4 {\n  opacity: 0;\n  -webkit-transform: translateY(-10px);\n          transform: translateY(-10px);\n}\n.orientation.horizontal > .n3,\n.orientation.horizontal .n4 {\n  opacity: 1;\n  -webkit-transform: translateY(0);\n          transform: translateY(0);\n}\n.orientation.horizontal > .n1 {\n  opacity: 0;\n  -webkit-transform: translateX(10px);\n          transform: translateX(10px);\n}\n.orientation.horizontal > .n2 {\n  opacity: 0;\n  -webkit-transform: translateX(-10px);\n          transform: translateX(-10px);\n}\n.orientation.both > .n1,\n.orientation.both .n2,\n.orientation.both .n3,\n.orientation.both .n4 {\n  opacity: 1;\n  -webkit-transform: translateX(0px);\n          transform: translateX(0px);\n}\nsection {\n  display: block;\n  position: relative;\n  padding: 0 6px;\n  white-space: nowrap;\n}\ndiv > hr,\nsection > hr {\n  margin-top: 1px;\n  margin-bottom: 6px;\n}\n.size-large div > hr,\n.size-large section > hr {\n  margin-top: 2px;\n  margin-bottom: 7px;\n}\ncode {\n  display: inline-block;\n}\n.serverNotification {\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  position: absolute;\n  border-radius: 4px;\n  z-index: 1000;\n  opacity: 0;\n  -webkit-transform: scale(1.2) translateZ(1px);\n          transform: scale(1.2) translateZ(1px);\n  -webkit-transition: all 0.2s;\n  transition: all 0.2s;\n  pointer-events: none;\n}\n.serverNotification:before {\n  content: \" \";\n  display: block;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  position: absolute;\n  opacity: 0.9;\n  -webkit-transform: translateZ(-1px);\n          transform: translateZ(-1px);\n  pointer-events: none;\n}\n.dark1 .serverNotification:before {\n  background-color: #343434;\n}\n.dark2 .serverNotification:before {\n  background-color: #535353;\n}\n.light1 .serverNotification:before {\n  background-color: #b8b8b8;\n}\n.light2 .serverNotification:before {\n  background-color: #d6d6d6;\n}\n.serverNotification.visible {\n  opacity: 1;\n  pointer-events: auto !important;\n  -webkit-transform: scale(1);\n          transform: scale(1);\n}\n.serverNotification-msg {\n  position: absolute;\n  top: 30px;\n  width: 100%;\n  display: inline-block;\n  clear: both;\n  text-align: center;\n  text-decoration: none;\n  color: #fff;\n  font-size: 11px;\n  cursor: pointer;\n}\n.serverNotification-msg:hover {\n  text-decoration: underline;\n}\n.serverNotification-discard {\n  position: absolute;\n  top: 70px;\n  left: 45px;\n  left: calc(50% - 80px);\n  width: 160px;\n}\n", ""]);

	// exports


/***/ },
/* 33 */
/***/ function(module, exports) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	// css base code, injected by the css-loader
	module.exports = function() {
		var list = [];

		// return the list of modules as css string
		list.toString = function toString() {
			var result = [];
			for(var i = 0; i < this.length; i++) {
				var item = this[i];
				if(item[2]) {
					result.push("@media " + item[2] + "{" + item[1] + "}");
				} else {
					result.push(item[1]);
				}
			}
			return result.join("");
		};

		// import a list of modules into the list
		list.i = function(modules, mediaQuery) {
			if(typeof modules === "string")
				modules = [[null, modules, ""]];
			var alreadyImportedModules = {};
			for(var i = 0; i < this.length; i++) {
				var id = this[i][0];
				if(typeof id === "number")
					alreadyImportedModules[id] = true;
			}
			for(i = 0; i < modules.length; i++) {
				var item = modules[i];
				// skip already imported module
				// this implementation is not 100% perfect for weird media query combinations
				//  when a module is imported multiple times with different media queries.
				//  I hope this will never occur (Hey this way we have smaller bundles)
				if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
					if(mediaQuery && !item[2]) {
						item[2] = mediaQuery;
					} else if(mediaQuery) {
						item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
					}
					list.push(item);
				}
			}
		};
		return list;
	};


/***/ },
/* 34 */
/***/ function(module, exports) {

	module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAMCAYAAACulacQAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyFpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNS1jMDE0IDc5LjE1MTQ4MSwgMjAxMy8wMy8xMy0xMjowOToxNSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDoyNDFGRkY3Q0ExNUQxMUUzQUJEMkFDMjU3MDE2OTQzOCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDoyNDFGRkY3REExNUQxMUUzQUJEMkFDMjU3MDE2OTQzOCI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjI0MUZGRjdBQTE1RDExRTNBQkQyQUMyNTcwMTY5NDM4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjI0MUZGRjdCQTE1RDExRTNBQkQyQUMyNTcwMTY5NDM4Ii8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+zbprWwAAAHtJREFUeNpi+P//fxwQMwExAzpmYmBg4AXi1UDMyYAOgCr4gPgzEJ8EYglknTDGzP8Q8BCIddAlDf4jwAcgdkOWBOFjSAp+A3EaE5L1v9CcwwTTpYPP2GlQiXtArI3sIJhXQHaKoXslB4iXAzEHegiBiAggZsQWfAABBgA6heivOLArTwAAAABJRU5ErkJggg=="

/***/ },
/* 35 */
/***/ function(module, exports) {

	module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAMCAYAAACulacQAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyFpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNS1jMDE0IDc5LjE1MTQ4MSwgMjAxMy8wMy8xMy0xMjowOToxNSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDoyNDFGRkY3Q0ExNUQxMUUzQUJEMkFDMjU3MDE2OTQzOCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDoyNDFGRkY3REExNUQxMUUzQUJEMkFDMjU3MDE2OTQzOCI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjI0MUZGRjdBQTE1RDExRTNBQkQyQUMyNTcwMTY5NDM4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjI0MUZGRjdCQTE1RDExRTNBQkQyQUMyNTcwMTY5NDM4Ii8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+zbprWwAAAHtJREFUeNpi+P//fxwQMwExAzpmYmBg4AXi1UDMyYAOgCr4gPgzEJ8EYglknTDGzP8Q8BCIddAlDf4jwAcgdkOWBOFjSAp+A3EaE5L1v9CcwwTTpYPP2GlQiXtArI3sIJhXQHaKoXslB4iXAzEHegiBiAggZsQWfAABBgA6heivOLArTwAAAABJRU5ErkJggg=="

/***/ },
/* 36 */
/***/ function(module, exports) {

	module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAMCAYAAACulacQAAAACXBIWXMAAAsTAAALEwEAmpwYAAA5k2lUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS41LWMwMTQgNzkuMTUxNDgxLCAyMDEzLzAzLzEzLTEyOjA5OjE1ICAgICAgICAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIgogICAgICAgICAgICB4bWxuczpzdFJlZj0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlUmVmIyIKICAgICAgICAgICAgeG1sbnM6c3RFdnQ9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZUV2ZW50IyIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIgogICAgICAgICAgICB4bWxuczpwaG90b3Nob3A9Imh0dHA6Ly9ucy5hZG9iZS5jb20vcGhvdG9zaG9wLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnRpZmY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvIgogICAgICAgICAgICB4bWxuczpleGlmPSJodHRwOi8vbnMuYWRvYmUuY29tL2V4aWYvMS4wLyI+CiAgICAgICAgIDx4bXA6Q3JlYXRvclRvb2w+QWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKTwveG1wOkNyZWF0b3JUb29sPgogICAgICAgICA8eG1wOkNyZWF0ZURhdGU+MjAxNC0wNC0wOFQyMTozNjoxOSswNDozMDwveG1wOkNyZWF0ZURhdGU+CiAgICAgICAgIDx4bXA6TW9kaWZ5RGF0ZT4yMDE0LTA0LTA4VDIxOjM3OjQxKzA0OjMwPC94bXA6TW9kaWZ5RGF0ZT4KICAgICAgICAgPHhtcDpNZXRhZGF0YURhdGU+MjAxNC0wNC0wOFQyMTozNzo0MSswNDozMDwveG1wOk1ldGFkYXRhRGF0ZT4KICAgICAgICAgPHhtcE1NOkluc3RhbmNlSUQ+eG1wLmlpZDpjZGJkZTM5ZS1hNjQ0LWY4NDQtYTg5Yi01NTU2MDYwNjc5OTE8L3htcE1NOkluc3RhbmNlSUQ+CiAgICAgICAgIDx4bXBNTTpEb2N1bWVudElEPnhtcC5kaWQ6MjQxRkZGN0RBMTVEMTFFM0FCRDJBQzI1NzAxNjk0Mzg8L3htcE1NOkRvY3VtZW50SUQ+CiAgICAgICAgIDx4bXBNTTpEZXJpdmVkRnJvbSByZGY6cGFyc2VUeXBlPSJSZXNvdXJjZSI+CiAgICAgICAgICAgIDxzdFJlZjppbnN0YW5jZUlEPnhtcC5paWQ6MjQxRkZGN0FBMTVEMTFFM0FCRDJBQzI1NzAxNjk0Mzg8L3N0UmVmOmluc3RhbmNlSUQ+CiAgICAgICAgICAgIDxzdFJlZjpkb2N1bWVudElEPnhtcC5kaWQ6MjQxRkZGN0JBMTVEMTFFM0FCRDJBQzI1NzAxNjk0Mzg8L3N0UmVmOmRvY3VtZW50SUQ+CiAgICAgICAgIDwveG1wTU06RGVyaXZlZEZyb20+CiAgICAgICAgIDx4bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ+eG1wLmRpZDoyNDFGRkY3REExNUQxMUUzQUJEMkFDMjU3MDE2OTQzODwveG1wTU06T3JpZ2luYWxEb2N1bWVudElEPgogICAgICAgICA8eG1wTU06SGlzdG9yeT4KICAgICAgICAgICAgPHJkZjpTZXE+CiAgICAgICAgICAgICAgIDxyZGY6bGkgcmRmOnBhcnNlVHlwZT0iUmVzb3VyY2UiPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6YWN0aW9uPnNhdmVkPC9zdEV2dDphY3Rpb24+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDppbnN0YW5jZUlEPnhtcC5paWQ6Y2RiZGUzOWUtYTY0NC1mODQ0LWE4OWItNTU1NjA2MDY3OTkxPC9zdEV2dDppbnN0YW5jZUlEPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6d2hlbj4yMDE0LTA0LTA4VDIxOjM3OjQxKzA0OjMwPC9zdEV2dDp3aGVuPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6c29mdHdhcmVBZ2VudD5BZG9iZSBQaG90b3Nob3AgQ0MgKFdpbmRvd3MpPC9zdEV2dDpzb2Z0d2FyZUFnZW50PgogICAgICAgICAgICAgICAgICA8c3RFdnQ6Y2hhbmdlZD4vPC9zdEV2dDpjaGFuZ2VkPgogICAgICAgICAgICAgICA8L3JkZjpsaT4KICAgICAgICAgICAgPC9yZGY6U2VxPgogICAgICAgICA8L3htcE1NOkhpc3Rvcnk+CiAgICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2UvcG5nPC9kYzpmb3JtYXQ+CiAgICAgICAgIDxwaG90b3Nob3A6Q29sb3JNb2RlPjM8L3Bob3Rvc2hvcDpDb2xvck1vZGU+CiAgICAgICAgIDx0aWZmOk9yaWVudGF0aW9uPjE8L3RpZmY6T3JpZW50YXRpb24+CiAgICAgICAgIDx0aWZmOlhSZXNvbHV0aW9uPjcyMDAwMC8xMDAwMDwvdGlmZjpYUmVzb2x1dGlvbj4KICAgICAgICAgPHRpZmY6WVJlc29sdXRpb24+NzIwMDAwLzEwMDAwPC90aWZmOllSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogICAgICAgICA8ZXhpZjpDb2xvclNwYWNlPjY1NTM1PC9leGlmOkNvbG9yU3BhY2U+CiAgICAgICAgIDxleGlmOlBpeGVsWERpbWVuc2lvbj43PC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxZRGltZW5zaW9uPjEyPC9leGlmOlBpeGVsWURpbWVuc2lvbj4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz40y4nLAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAACySURBVHjaXJAxaoJREIS//yn8pJg9giewFnIBuxCxtLCzMQfKDWxyjRBIHWKbShCx0KkkBNbmGeQtDFPMsDO7SFpKKplJiwIIeIuIB5rpJAWwA7bAs+39TSy2DWyACfAZEeN/sfJr5RHwHhFTgC4zAYiID+Cxmv6Al3KX/9v0KWQmksaSsuIkaZqZDKtrXfkHeLL93Z7yBcxsH257B33fr4ALMLd9vg8dAkdgYTvbD10HABnWRNT8jHqVAAAAAElFTkSuQmCC"

/***/ },
/* 37 */
/***/ function(module, exports) {

	module.exports = "data:image/png;base64,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"

/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	var stylesInDom = {},
		memoize = function(fn) {
			var memo;
			return function () {
				if (typeof memo === "undefined") memo = fn.apply(this, arguments);
				return memo;
			};
		},
		isOldIE = memoize(function() {
			return /msie [6-9]\b/.test(window.navigator.userAgent.toLowerCase());
		}),
		getHeadElement = memoize(function () {
			return document.head || document.getElementsByTagName("head")[0];
		}),
		singletonElement = null,
		singletonCounter = 0,
		styleElementsInsertedAtTop = [];

	module.exports = function(list, options) {
		if(false) {
			if(typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
		}

		options = options || {};
		// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
		// tags it will allow on a page
		if (typeof options.singleton === "undefined") options.singleton = isOldIE();

		// By default, add <style> tags to the bottom of <head>.
		if (typeof options.insertAt === "undefined") options.insertAt = "bottom";

		var styles = listToStyles(list);
		addStylesToDom(styles, options);

		return function update(newList) {
			var mayRemove = [];
			for(var i = 0; i < styles.length; i++) {
				var item = styles[i];
				var domStyle = stylesInDom[item.id];
				domStyle.refs--;
				mayRemove.push(domStyle);
			}
			if(newList) {
				var newStyles = listToStyles(newList);
				addStylesToDom(newStyles, options);
			}
			for(var i = 0; i < mayRemove.length; i++) {
				var domStyle = mayRemove[i];
				if(domStyle.refs === 0) {
					for(var j = 0; j < domStyle.parts.length; j++)
						domStyle.parts[j]();
					delete stylesInDom[domStyle.id];
				}
			}
		};
	}

	function addStylesToDom(styles, options) {
		for(var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];
			if(domStyle) {
				domStyle.refs++;
				for(var j = 0; j < domStyle.parts.length; j++) {
					domStyle.parts[j](item.parts[j]);
				}
				for(; j < item.parts.length; j++) {
					domStyle.parts.push(addStyle(item.parts[j], options));
				}
			} else {
				var parts = [];
				for(var j = 0; j < item.parts.length; j++) {
					parts.push(addStyle(item.parts[j], options));
				}
				stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
			}
		}
	}

	function listToStyles(list) {
		var styles = [];
		var newStyles = {};
		for(var i = 0; i < list.length; i++) {
			var item = list[i];
			var id = item[0];
			var css = item[1];
			var media = item[2];
			var sourceMap = item[3];
			var part = {css: css, media: media, sourceMap: sourceMap};
			if(!newStyles[id])
				styles.push(newStyles[id] = {id: id, parts: [part]});
			else
				newStyles[id].parts.push(part);
		}
		return styles;
	}

	function insertStyleElement(options, styleElement) {
		var head = getHeadElement();
		var lastStyleElementInsertedAtTop = styleElementsInsertedAtTop[styleElementsInsertedAtTop.length - 1];
		if (options.insertAt === "top") {
			if(!lastStyleElementInsertedAtTop) {
				head.insertBefore(styleElement, head.firstChild);
			} else if(lastStyleElementInsertedAtTop.nextSibling) {
				head.insertBefore(styleElement, lastStyleElementInsertedAtTop.nextSibling);
			} else {
				head.appendChild(styleElement);
			}
			styleElementsInsertedAtTop.push(styleElement);
		} else if (options.insertAt === "bottom") {
			head.appendChild(styleElement);
		} else {
			throw new Error("Invalid value for parameter 'insertAt'. Must be 'top' or 'bottom'.");
		}
	}

	function removeStyleElement(styleElement) {
		styleElement.parentNode.removeChild(styleElement);
		var idx = styleElementsInsertedAtTop.indexOf(styleElement);
		if(idx >= 0) {
			styleElementsInsertedAtTop.splice(idx, 1);
		}
	}

	function createStyleElement(options) {
		var styleElement = document.createElement("style");
		styleElement.type = "text/css";
		insertStyleElement(options, styleElement);
		return styleElement;
	}

	function createLinkElement(options) {
		var linkElement = document.createElement("link");
		linkElement.rel = "stylesheet";
		insertStyleElement(options, linkElement);
		return linkElement;
	}

	function addStyle(obj, options) {
		var styleElement, update, remove;

		if (options.singleton) {
			var styleIndex = singletonCounter++;
			styleElement = singletonElement || (singletonElement = createStyleElement(options));
			update = applyToSingletonTag.bind(null, styleElement, styleIndex, false);
			remove = applyToSingletonTag.bind(null, styleElement, styleIndex, true);
		} else if(obj.sourceMap &&
			typeof URL === "function" &&
			typeof URL.createObjectURL === "function" &&
			typeof URL.revokeObjectURL === "function" &&
			typeof Blob === "function" &&
			typeof btoa === "function") {
			styleElement = createLinkElement(options);
			update = updateLink.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
				if(styleElement.href)
					URL.revokeObjectURL(styleElement.href);
			};
		} else {
			styleElement = createStyleElement(options);
			update = applyToTag.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
			};
		}

		update(obj);

		return function updateStyle(newObj) {
			if(newObj) {
				if(newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap)
					return;
				update(obj = newObj);
			} else {
				remove();
			}
		};
	}

	var replaceText = (function () {
		var textStore = [];

		return function (index, replacement) {
			textStore[index] = replacement;
			return textStore.filter(Boolean).join('\n');
		};
	})();

	function applyToSingletonTag(styleElement, index, remove, obj) {
		var css = remove ? "" : obj.css;

		if (styleElement.styleSheet) {
			styleElement.styleSheet.cssText = replaceText(index, css);
		} else {
			var cssNode = document.createTextNode(css);
			var childNodes = styleElement.childNodes;
			if (childNodes[index]) styleElement.removeChild(childNodes[index]);
			if (childNodes.length) {
				styleElement.insertBefore(cssNode, childNodes[index]);
			} else {
				styleElement.appendChild(cssNode);
			}
		}
	}

	function applyToTag(styleElement, obj) {
		var css = obj.css;
		var media = obj.media;
		var sourceMap = obj.sourceMap;

		if(media) {
			styleElement.setAttribute("media", media)
		}

		if(styleElement.styleSheet) {
			styleElement.styleSheet.cssText = css;
		} else {
			while(styleElement.firstChild) {
				styleElement.removeChild(styleElement.firstChild);
			}
			styleElement.appendChild(document.createTextNode(css));
		}
	}

	function updateLink(linkElement, obj) {
		var css = obj.css;
		var media = obj.media;
		var sourceMap = obj.sourceMap;

		if(sourceMap) {
			// http://stackoverflow.com/a/26603875
			css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
		}

		var blob = new Blob([css], { type: "text/css" });

		var oldSrc = linkElement.href;

		linkElement.href = URL.createObjectURL(blob);

		if(oldSrc)
			URL.revokeObjectURL(oldSrc);
	}


/***/ }
/******/ ]);