/*
 * Decompiled with CFR 0.152.
 */
package com.wedomo.halo.plugin.testes;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakImage;
import com.wedomo.halo.plugin.PakReader;
import com.wedomo.halo.plugin.PakString;
import com.wedomo.halo.plugin.PakUnknown;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;

public class KnightTalesS60V1Reader
implements PakReader {
    private static final String PLUNIN_NAME = "KnightTales s60v1";
    private static int[] offsets;
    private static byte[] strData;

    public Pak readPak(String filename) throws Exception {
        return this.readPak(new FileInputStream(filename));
    }

    public Pak readPak(InputStream in) throws Exception {
        Pak ret = null;
        ret = new Pak();
        DataInputStream datainputstream = new DataInputStream(in);
        int i = (datainputstream.readByte() & 0xFF) + ((datainputstream.readByte() & 0xFF) << 8) + ((datainputstream.readByte() & 0xFF) << 16) + ((datainputstream.readByte() & 0xFF) << 24);
        i = (datainputstream.readByte() & 0xFF) + ((datainputstream.readByte() & 0xFF) << 8) + ((datainputstream.readByte() & 0xFF) << 16) + ((datainputstream.readByte() & 0xFF) << 24);
        offsets = new int[++i];
        i = 0;
        while (i < offsets.length) {
            KnightTalesS60V1Reader.offsets[i] = (datainputstream.readByte() & 0xFF) + ((datainputstream.readByte() & 0xFF) << 8) + ((datainputstream.readByte() & 0xFF) << 16) + ((datainputstream.readByte() & 0xFF) << 24);
            ++i;
        }
        i = offsets[i - 1] - offsets[0];
        strData = new byte[i];
        int j = 0;
        int k = 0;
        while ((k = datainputstream.read(strData, j, strData.length - j)) != -1 && (j += k) < strData.length) {
        }
        i = 0;
        while (i < offsets.length - 1) {
            byte[] data;
            if (i >= 22 && i <= 68) {
                PakImage pi = new PakImage(KnightTalesS60V1Reader.getData(i), 0);
                ret.addObject((Object)pi);
            } else if (i >= 116 && i <= 156) {
                data = KnightTalesS60V1Reader.getData(i);
                DataInputStream dd = new DataInputStream(new ByteArrayInputStream(data));
                String s = dd.readUTF();
                PakString ps = new PakString(s);
                ps.setDescription(ps.getText());
                ret.addObject((Object)ps);
            } else if (i == 157 || i == 223) {
                PakUnknown pu = new PakUnknown(new byte[0]);
                ret.addObject((Object)pu);
            } else {
                data = KnightTalesS60V1Reader.getData(i);
                PakUnknown pu = new PakUnknown(data);
                ret.addObject((Object)pu);
            }
            ++i;
        }
        datainputstream.close();
        return ret;
    }

    public static byte[] getData(int i) {
        byte[] abyte0 = KnightTalesS60V1Reader.getDataByIndex(i);
        return abyte0;
    }

    private static int getOffset(int i) {
        int j = (offsets[i + 1] != 0 ? offsets[i + 1] : offsets[i + 2]) - offsets[i];
        return j;
    }

    private static byte[] getDataByIndex(int i) {
        byte[] abyte0 = new byte[KnightTalesS60V1Reader.getOffset(i)];
        System.arraycopy(strData, offsets[i] - offsets[0], abyte0, 0, abyte0.length);
        return abyte0;
    }

    public String getName() {
        return PLUNIN_NAME;
    }

    public String getDescription() {
        return null;
    }
}

