/*
 * Decompiled with CFR 0.152.
 */
package com.wedomo.halo.plugin.testes;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakImage;
import com.wedomo.halo.plugin.PakObject;
import com.wedomo.halo.plugin.PakString;
import com.wedomo.halo.plugin.PakUnknown;
import com.wedomo.halo.plugin.PakWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class KnightTalesS60V1Writer
implements PakWriter {
    private static final String PLUNIN_NAME = "KnightTales s60v1";

    public void writePak(Pak pak, String filename) throws Exception {
        this.writePak(pak, new FileOutputStream(filename));
    }

    public void writePak(Pak pak, OutputStream out) throws Exception {
        PakUnknown pu;
        PakImage pi;
        PakString ps;
        PakObject po;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Vector objects = pak.getObjects();
        KnightTalesS60V1Writer.writeInt(dos, 0);
        KnightTalesS60V1Writer.writeInt(dos, 224);
        int count = 908;
        int i = 0;
        while (i < objects.size()) {
            if (i == 157 || i == 223) {
                KnightTalesS60V1Writer.writeInt(dos, 0);
            } else {
                KnightTalesS60V1Writer.writeInt(dos, count);
                po = (PakObject)objects.get(i);
                if (i >= 116 && i <= 156) {
                    ps = (PakString)po;
                    count += this.string2UTF(ps.getText()).length;
                } else if (i >= 22 && i <= 68) {
                    pi = (PakImage)po;
                    count += pi.getImageAsByte().length;
                } else {
                    pu = (PakUnknown)po;
                    count += pu.getData().length;
                }
            }
            ++i;
        }
        KnightTalesS60V1Writer.writeInt(dos, count);
        i = 0;
        while (i < objects.size()) {
            if (i != 157 && i != 223) {
                po = (PakObject)objects.get(i);
                if (i >= 116 && i <= 156) {
                    ps = (PakString)po;
                    dos.write(this.string2UTF(ps.getText()));
                } else if (i >= 22 && i <= 68) {
                    pi = (PakImage)po;
                    dos.write(pi.getImageAsByte());
                } else {
                    pu = (PakUnknown)po;
                    dos.write(pu.getData());
                }
            }
            ++i;
        }
        dos.close();
        baos.writeTo(out);
    }

    private static void writeInt(DataOutputStream dos, int i) throws Exception {
        byte[] data = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        dos.write(data);
    }

    private byte[] string2UTF(String s) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(s);
        dos.close();
        return baos.toByteArray();
    }

    public String getName() {
        return PLUNIN_NAME;
    }

    public String getDescription() {
        return null;
    }
}

