/*
 * Decompiled with CFR 0.152.
 */
package com.wedomo.halo.plugin.xiaoyur.handygames;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakReader;
import com.wedomo.halo.plugin.PakString;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;

public class HandygamesReader
implements PakReader {
    private static final String PLUGIN_NAME = "HandyGames";
    private String _filename;
    private ArrayList<Integer> _indexlist = new ArrayList();
    private int _size = 0;
    private int _lng = 0;
    private int _strcount = 0;

    public Pak readPak(String filename) throws Exception {
        this._filename = filename;
        return this.readPak(new FileInputStream(filename));
    }

    public Pak readPak(InputStream in) throws Exception {
        Pak pak = new Pak();
        if (!this._filename.endsWith(".lng")) {
            return pak;
        }
        DataInputStream is = new DataInputStream(in);
        this._size = is.readUnsignedShort();
        this._lng = is.readByte();
        this._strcount = is.readUnsignedShort();
        int i = 0;
        while (i <= this._strcount) {
            this._indexlist.add(new Integer(is.readUnsignedShort()));
            ++i;
        }
        i = 0;
        while (i < this._strcount) {
            byte[] bts = new byte[this._indexlist.get(i + 1) - this._indexlist.get(i)];
            is.readFully(bts);
            String str = new String(bts, "utf-8");
            PakString pakstr = new PakString(str);
            pak.addObject((Object)pakstr);
            ++i;
        }
        is.close();
        return pak;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getDescription() {
        return "HandyGames Reader";
    }

    public int getLng() {
        return this._lng;
    }

    public int getSize() {
        return this._size;
    }

    public int getStringcount() {
        return this._strcount;
    }
}

