/*
 * Decompiled with CFR 0.152.
 */
package com.nec.graphics;

import javax.microedition.lcdui.Image;

public final class ImageMap {
    private final int DEFAULT_CELL_RANGE = 12;
    private Image[] _images;
    private byte[] h = new byte[128];
    private int d;
    private int e;
    private int g;
    private int c;
    private int a;
    private int b;
    private int j;
    private int i;

    public ImageMap(int cw, int ch, int width, int height, byte[] data, Image[] images) throws IllegalArgumentException, NullPointerException {
        if (cw <= 0 || ch <= 0 || width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        if (images == null || data == null) {
            throw new NullPointerException();
        }
        if (data.length < width * height) {
            throw new IllegalArgumentException();
        }
        this.i = cw;
        this.j = ch;
        this.b = 0;
        this.a = 0;
        this.c = width;
        this.g = height;
        this.h = data;
        this._images = images;
        if (this.e == 0) {
            this.e = width;
        }
        if (this.d == 0) {
            this.d = height;
        }
        if (cw == Integer.MAX_VALUE) {
            this.e = 1;
            this.d = 1;
        }
        if (ch == Integer.MAX_VALUE) {
            this.d = 1;
        }
    }

    public ImageMap(int cw, int ch) throws IllegalArgumentException {
        if (cw <= 0 || ch <= 0) {
            throw new IllegalArgumentException();
        }
        this.i = cw;
        this.j = ch;
        this.b = 0;
        this.a = 0;
        this.c = 0;
        this.g = 0;
        this.e = 0;
        this.d = 0;
        this._images = null;
        if (cw == Integer.MAX_VALUE) {
            this.e = 1;
            this.d = 1;
        }
        if (ch == Integer.MAX_VALUE) {
            this.d = 1;
        }
    }

    public ImageMap() {
        this.i = 12;
        this.j = 12;
        this.b = 0;
        this.a = 0;
        this.c = 0;
        this.g = 0;
        this.e = 0;
        this.d = 0;
        this._images = null;
    }

    final byte[] a() {
        return this.h;
    }

    final Image[] b() {
        return this._images;
    }

    final int[] c() {
        int[] ai = new int[]{this.i, this.j, this.b, this.a, this.c, this.g, this.e, this.d};
        return ai;
    }

    public void scrollWindow(int dx, int dy) throws IllegalArgumentException {
        if (this.b + dx < 0 || this.b + dx + this.e > this.c || this.a + dy < 0 || this.a + dy + this.d > this.g) {
            throw new IllegalArgumentException();
        }
        this.b += dx;
        this.a += dy;
    }

    public void setTransparent(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index > this.h.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.h[index] = -1;
    }

    public void setTransparent(int x, int y) throws IllegalArgumentException {
        if (x < 0 || x > this.c - 1 || y < 0 || y > this.g - 1) {
            throw new IllegalArgumentException();
        }
        this.h[this.c * y + x] = -1;
    }

    public void moveWindow(int x, int y) throws IllegalArgumentException {
        if (x < 0 || x + this.e > this.c || y < 0 || y + this.d > this.g) {
            throw new IllegalArgumentException();
        }
        this.b = x;
        this.a = y;
    }

    public void setWindow(int x, int y, int width, int height) throws IllegalArgumentException {
        if (x + 1 > this.c || y + 1 > this.g || x + width > this.c || y + height > this.g || width == 0 || height == 0 || x < 0 || y < 0 || width < 1 || height < 1) {
            throw new IllegalArgumentException();
        }
        this.b = x;
        this.a = y;
        this.e = width;
        this.d = height;
    }

    public void setImageMap(int width, int height, byte[] data, Image[] images) throws IllegalArgumentException, NullPointerException {
        if (data.length < width * height) {
            throw new IllegalArgumentException();
        }
        if (data == null || images == null) {
            throw new NullPointerException();
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        if (images.length > 127) {
            throw new IllegalArgumentException();
        }
        this.c = width;
        this.g = height;
        this.h = data;
        this._images = images;
        if (this.e == 0) {
            this.e = width;
        }
        if (this.d == 0) {
            this.d = height;
        }
    }
}

