/*
 * Decompiled with CFR 0.152.
 */
package com.nec.graphics;

import com.nec.graphics.Sprite;

public final class SpriteSet {
    protected Sprite[] spriteList;
    protected int numSprites;
    protected static int MAX_SPRITES = 32;
    protected static int MAX_PRIORITY = 31;

    public SpriteSet(int i) throws IllegalArgumentException {
        if (i <= 0 || i > MAX_SPRITES) {
            throw new IllegalArgumentException();
        }
        this.spriteList = new Sprite[i];
        int j = 0;
        while (j < this.spriteList.length) {
            this.spriteList[j] = new Sprite();
            ++j;
        }
        this.numSprites = i;
    }

    public SpriteSet(Sprite[] asprite, int i) throws IllegalArgumentException, NullPointerException {
        if (i <= 0 || i > MAX_SPRITES) {
            throw new IllegalArgumentException();
        }
        if (asprite == null) {
            throw new NullPointerException();
        }
        int j = 0;
        while (j < i) {
            if (asprite[j] == null) {
                throw new NullPointerException();
            }
            ++j;
        }
        this.spriteList = asprite;
        this.numSprites = i;
    }

    private boolean a(int i, int j, int k, int l, int i1, int j1) {
        return i <= i1 && i + k > i1 && j <= j1 && j + l > j1;
    }

    public void setPriority(int i, int j) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (i < 0 || i > this.spriteList.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.spriteList.length < i + 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (j < 0 || j > MAX_PRIORITY) {
            throw new IllegalArgumentException();
        }
        this.spriteList[i].b(j);
    }

    public int getCollisionFlag(int i) throws ArrayIndexOutOfBoundsException {
        if (this.spriteList.length < i + 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.spriteList[i].a();
    }

    public boolean isCollision(int i, int j) throws ArrayIndexOutOfBoundsException {
        if (this.spriteList.length < i + 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.spriteList.length < j + 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (j == Integer.MAX_VALUE || j == Integer.MIN_VALUE) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int k = this.spriteList[i].a();
        return (k & 1 << MAX_SPRITES - j - 1) != 0;
    }

    public void setCollisionOf(int i) throws IllegalArgumentException, NullPointerException {
        if (i < 0 || i > this.spriteList.length - 1) {
            throw new IllegalArgumentException();
        }
        if (this.spriteList == null) {
            throw new NullPointerException();
        }
        if (this.spriteList[i] == null) {
            throw new NullPointerException();
        }
        int j = 0;
        int k = this.spriteList[i].f();
        int l = this.spriteList[i].g();
        int i1 = this.spriteList[i].e();
        int j1 = this.spriteList[i].b();
        int k1 = 0;
        while (k1 < this.spriteList.length) {
            if (k1 != i) {
                int l1 = this.spriteList[k1].f();
                int i2 = this.spriteList[k1].g();
                int j2 = this.spriteList[k1].e();
                int k2 = this.spriteList[k1].b();
                if ((this.a(k, l, i1, j1, l1, i2) || this.a(k, l, i1, j1, l1 + j2, i2) || this.a(k, l, i1, j1, l1, i2 + k2) || this.a(k, l, i1, j1, l1 + j2, i2 + k2)) && this.spriteList[k1].c() != null && this.spriteList[k1].isVisible()) {
                    j |= 1 << k1;
                }
            }
            this.spriteList[i].a(j);
            ++k1;
        }
    }

    public void setCollisionAll() throws NullPointerException {
        int i = 0;
        while (i < this.spriteList.length) {
            this.setCollisionOf(i);
            ++i;
        }
    }

    public Sprite getSprite(int i) throws ArrayIndexOutOfBoundsException {
        if (i < 0 || i >= this.spriteList.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.spriteList[i];
    }

    public Sprite[] getSprites() {
        return this.spriteList;
    }

    public int getCount() {
        return this.spriteList.length;
    }
}

