/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledBackground
extends GraphicObject {
    Image[] pixels;
    byte[] map;
    int widthInTiles;
    int heightInTiles;
    int posx;
    int posy;

    public TiledBackground(byte[] tilePixels, byte[] tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        this(com.siemens.mp.ui.Image.createImageFromBitmap(tilePixels, 8, tilePixels.length), com.siemens.mp.ui.Image.createImageFromBitmap(tileMask, 8, tilePixels.length), map, widthInTiles, heightInTiles);
    }

    public TiledBackground(ExtendedImage tilePixels, ExtendedImage tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        this(tilePixels.getImage(), tileMask.getImage(), map, widthInTiles, heightInTiles);
    }

    public TiledBackground(Image tilePixels, Image tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        System.out.println("public TiledBackground(Image tilePixels, Image tileMask, byte[] map, int " + widthInTiles + ", int " + heightInTiles + ")");
        this.map = map;
        this.heightInTiles = heightInTiles;
        this.widthInTiles = widthInTiles;
        this.pixels = new Image[tilePixels.getHeight() / 8 + 3];
        this.pixels[0] = Image.createImage((int)8, (int)8);
        this.pixels[1] = Image.createImage((int)8, (int)8);
        this.pixels[2] = Image.createImage((int)8, (int)8);
        this.pixels[2].getGraphics().fillRect(0, 0, 8, 8);
        int i = 0;
        while (i < this.pixels.length - 3) {
            Image img = Image.createImage((int)8, (int)8);
            img.getGraphics().drawImage(tilePixels, 0, -i * 8, 0);
            this.pixels[i + 3] = img;
            ++i;
        }
    }

    public void setPositionInMap(int x, int y) {
        this.posx = x;
        this.posy = y;
    }

    protected void paint(Graphics g) {
        int y = this.posy / 8;
        while (y < this.heightInTiles) {
            int x = this.posx / 8;
            while (x < this.widthInTiles) {
                if (-this.posx + x * 8 > g.getClipWidth()) break;
                g.drawImage(this.pixels[this.map[y * this.widthInTiles + x]], -this.posx + x * 8, -this.posy + y * 8, 0);
                ++x;
            }
            if (-this.posy + y * 8 > g.getClipHeight()) break;
            ++y;
        }
    }
}

